/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.connection;

import com.sanrad.nms.client.data.iscsi.connection.ISCSIConnectionNode;
import com.sanrad.nms.client.data.iscsi.connection.SrISCSIConnectionsTableModel;
import com.sanrad.nms.client.data.iscsi.connection.SrSessionConnectionsTableColumns;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.event.iscsi.connection.ISCSIConnectionEvent;
import com.sanrad.nms.client.gui.iscsi.connection.ISCSIConnectionsTableHeader;
import java.util.Vector;

public class SrISCSISessionConnectionsTableModel
extends SrISCSIConnectionsTableModel {
    private ISCSISessionNode m_sessionNode;

    public SrISCSISessionConnectionsTableModel() {
        this((ISCSISessionNode)null);
    }

    public SrISCSISessionConnectionsTableModel(ISCSISessionNode sessionNode) {
        super(new SrSessionConnectionsTableColumns(ISCSIConnectionsTableHeader.getColumnNames(), sessionNode));
        this.m_sessionNode = sessionNode;
        this.initModel();
    }

    public ISCSISessionNode getSessionNode() {
        return this.m_sessionNode;
    }

    private void initModel() {
        this.removeAllRows();
        if (this.m_sessionNode != null) {
            Vector sessionConnections = this.m_sessionNode.getConnections();
            for (int index = 0; index < sessionConnections.size(); ++index) {
                ISCSIConnectionNode connectionNode = (ISCSIConnectionNode)sessionConnections.get(index);
                this.addConnectionNodeToTable(connectionNode, this.m_sessionNode);
            }
            this.fireTableRowsInserted(0, this.getLastRowIndex());
        }
    }

    @Override
    public void iscsiConnectionRemoved(ISCSIConnectionEvent e) {
        if (this.isConnectionExistedInModel(e.getISCSIConnectionNode())) {
            super.iscsiConnectionRemoved(e);
        }
    }

    @Override
    public void iscsiConnectionChanged(ISCSIConnectionEvent e) {
        if (this.isConnectionExistedInModel(e.getISCSIConnectionNode())) {
            this.refreshTableWithConnectionData(e.getISCSIConnectionNode(), e.getValuesMap());
        }
    }
}

