/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.connection;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.iscsi.connection.ISCSIConnectionsManager;
import com.sanrad.nms.client.data.iscsi.connection.SrISCSISessionConnectionsTableModel;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionsManager;
import com.sanrad.nms.client.data.iscsi.session.show.SrISCSISessionsTableModel;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.connection.ISCSIConnectionEvent;
import com.sanrad.nms.client.event.iscsi.connection.ISCSIConnectionsListener;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionEvent;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionsListener;
import com.sanrad.nms.client.gui.iscsi.connection.SrISCSISessionConnectionsTablePanel;
import com.sanrad.nms.client.gui.iscsi.session.show.SrISCSISessionsTablePanel;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import java.util.ArrayList;
import java.util.Vector;

public class SrISCSISessionConnectionsModelsManager
implements ISCSISessionsListener,
ISCSIConnectionsListener {
    private ArrayList m_allConnectionsModels = new ArrayList();
    private int m_dialogView;
    private SrTreeNode m_treeNode;
    private SrISCSISessionsTablePanel m_sessionTablePanel;
    private SrISCSISessionConnectionsTablePanel m_sessionConnectionsTablePanel;

    public SrISCSISessionConnectionsModelsManager(int dialogView, SrTreeNode treeNode, SrISCSISessionsTablePanel sessionsTablePanel) {
        ISCSISessionsManager.getInstance().addISCSISessionsListener(this);
        ISCSIConnectionsManager.getInstance().addISCSIConnectionsListener(this);
        this.m_dialogView = dialogView;
        this.m_treeNode = treeNode;
        this.m_sessionTablePanel = sessionsTablePanel;
    }

    public void removeListeners() {
        ISCSISessionsManager.getInstance().removeISCSISessionsListener(this);
        ISCSIConnectionsManager.getInstance().removeISCSIConnectionsListener(this);
        int i = this.m_allConnectionsModels.size();
        while (i-- > 0) {
            SrISCSISessionConnectionsTableModel model = (SrISCSISessionConnectionsTableModel)this.m_allConnectionsModels.get(i);
            model.removeListeners();
        }
    }

    public void setSessionConnectionsTablePanel(SrISCSISessionConnectionsTablePanel sessionConnectionsTablePanel) {
        this.m_sessionConnectionsTablePanel = sessionConnectionsTablePanel;
    }

    public void createAllSessionsConnectionModels() {
        switch (this.m_dialogView) {
            case 0: {
                this.createAllSessionsConnectionModelsByCluster((ClusterNode)this.m_treeNode);
                break;
            }
            case 1: {
                this.createAllSessionsConnectionModelsByVswitch((VSwitchNode)this.m_treeNode);
                break;
            }
            case 2: {
                this.createAllSessionsConnectionModelsByTarget((TargetNode)this.m_treeNode);
            }
        }
    }

    private void createAllSessionsConnectionModelsByCluster(ClusterNode clusterNode) {
        Vector<VSwitchNode> clusterVswitches = VSwitchManager.getInstance().getAvailableVSwitches(clusterNode);
        for (int index1 = 0; index1 < clusterVswitches.size(); ++index1) {
            Vector vswitchSessions = clusterVswitches.elementAt(index1).getISCSISessionsTableNodes();
            for (int index2 = 0; index2 < vswitchSessions.size(); ++index2) {
                ISCSISessionNode sessionNode = (ISCSISessionNode)vswitchSessions.elementAt(index2);
                SrISCSISessionConnectionsTableModel tableModel = new SrISCSISessionConnectionsTableModel(sessionNode);
                this.m_allConnectionsModels.add(tableModel);
            }
        }
    }

    private void createAllSessionsConnectionModelsByVswitch(VSwitchNode vswitchNode) {
        Vector vswitchSessions = vswitchNode.getISCSISessionsTableNodes();
        for (int index = 0; index < vswitchSessions.size(); ++index) {
            ISCSISessionNode sessionNode = (ISCSISessionNode)vswitchSessions.elementAt(index);
            SrISCSISessionConnectionsTableModel tableModel = new SrISCSISessionConnectionsTableModel(sessionNode);
            this.m_allConnectionsModels.add(tableModel);
        }
    }

    protected void createAllSessionsConnectionModelsByTarget(TargetNode targetNode) {
        ArrayList targetSessions = targetNode.getISCSISessions();
        for (int index = 0; index < targetSessions.size(); ++index) {
            ISCSISessionNode sessionNode = (ISCSISessionNode)targetSessions.get(index);
            SrISCSISessionConnectionsTableModel tableModel = new SrISCSISessionConnectionsTableModel(sessionNode);
            this.m_allConnectionsModels.add(tableModel);
        }
    }

    public SrISCSISessionConnectionsTableModel getModelAt(int index) {
        SrISCSISessionConnectionsTableModel retModel = null;
        retModel = this.m_allConnectionsModels.size() > 0 ? (SrISCSISessionConnectionsTableModel)this.m_allConnectionsModels.get(index) : new SrISCSISessionConnectionsTableModel();
        return retModel;
    }

    @Override
    public void iscsiSessionCreated(ISCSISessionEvent e) {
    }

    private boolean shouldAdd(ISCSISessionNode iscsiSessionNode) {
        switch (this.m_dialogView) {
            case 0: {
                return true;
            }
            case 1: {
                return iscsiSessionNode.getParentStub().equals(((VSwitchNode)this.m_treeNode).getStub());
            }
            case 2: {
                return iscsiSessionNode.getTargetStub().equals(((TargetNode)this.m_treeNode).getStub());
            }
        }
        return false;
    }

    @Override
    public void iscsiSessionRemoved(ISCSISessionEvent e) {
        SrISCSISessionConnectionsTableModel model = this.getSelectedSessionConnectionsModel(e.getISCSISessionNode());
        if (model != null) {
            this.removeSessionConnectionsTableModel(model);
        }
    }

    @Override
    public void iscsiSessionChanged(ISCSISessionEvent e) {
    }

    @Override
    public void iscsiConnectionCreated(ISCSIConnectionEvent e) {
        ISCSISessionNode iscsiSessionNode = e.getConnectionSessionNode();
        boolean isFirstConnectionModel = this.m_allConnectionsModels.size() == 0;
        ((SrISCSISessionsTableModel)this.m_sessionTablePanel.getModel()).iscsiSessionCreated(iscsiSessionNode);
        SrISCSISessionConnectionsTableModel model = this.getSelectedSessionConnectionsModel(iscsiSessionNode);
        if (isFirstConnectionModel) {
            this.m_sessionConnectionsTablePanel.updateTableView(model);
        }
        if (model != null) {
            model.iscsiConnectionCreated(e);
        }
    }

    @Override
    public void iscsiConnectionRemoved(ISCSIConnectionEvent e) {
        SrISCSISessionConnectionsTableModel model = this.getSelectedSessionConnectionsModel(e.getConnectionSessionNode());
        if (model != null) {
            this.m_allConnectionsModels.remove(model);
            model.iscsiConnectionRemoved(e);
            model.removeListeners();
        }
    }

    @Override
    public void iscsiConnectionChanged(ISCSIConnectionEvent e) {
        SrISCSISessionConnectionsTableModel model = this.getSelectedSessionConnectionsModel(e.getConnectionSessionNode());
        if (model != null) {
            model.iscsiConnectionChanged(e);
        }
    }

    public void addSessionConnectionsTableModel(SrISCSISessionConnectionsTableModel model) {
        this.m_allConnectionsModels.add(model);
    }

    public void removeSessionConnectionsTableModel(SrISCSISessionConnectionsTableModel model) {
        this.m_allConnectionsModels.remove(model);
        model.removeListeners();
    }

    public SrISCSISessionConnectionsTableModel getSelectedSessionConnectionsModel(ISCSISessionNode iscsiSessionNode) {
        for (int index = 0; index < this.m_allConnectionsModels.size(); ++index) {
            SrISCSISessionConnectionsTableModel model = (SrISCSISessionConnectionsTableModel)this.m_allConnectionsModels.get(index);
            if (!((ISCSISession)model.getSessionNode().getStub()).equals(iscsiSessionNode.getStub())) continue;
            return model;
        }
        SrISCSISessionConnectionsTableModel model = new SrISCSISessionConnectionsTableModel(iscsiSessionNode);
        this.m_allConnectionsModels.add(model);
        return model;
    }
}

