/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.connection;

import com.sanrad.nms.client.data.iscsi.connection.ISCSIConnectionNode;
import com.sanrad.nms.client.data.iscsi.connection.ISCSIConnectionsManager;
import com.sanrad.nms.client.data.iscsi.connection.SrISCSIConnectionsTableModel;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.event.iscsi.connection.ISCSIConnectionEvent;
import java.util.ArrayList;

public class SrISCSIConnectionsTargetViewTableModel
extends SrISCSIConnectionsTableModel {
    public SrISCSIConnectionsTargetViewTableModel(TargetNode targetNode) {
        this.initModel(targetNode);
    }

    @Override
    public void addListeners() {
        ISCSIConnectionsManager.getInstance().addISCSIConnectionsListener(this);
        super.addListeners();
    }

    @Override
    public void removeListeners() {
        ISCSIConnectionsManager.getInstance().removeISCSIConnectionsListener(this);
        super.removeListeners();
    }

    protected void initModel(TargetNode targetNode) {
        this.removeAllRows();
        ArrayList targetSessions = targetNode.getISCSISessions();
        for (int index = 0; index < targetSessions.size(); ++index) {
            ISCSISessionNode sessionNode = (ISCSISessionNode)targetSessions.get(index);
            this.addSessionConnectionNodesToTable(sessionNode);
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    @Override
    public void iscsiConnectionCreated(ISCSIConnectionEvent e) {
        ISCSIConnectionNode connectionNode = e.getISCSIConnectionNode();
        ISCSISessionNode parentSessionNode = connectionNode.getSessionOfConnection();
        if (!parentSessionNode.isDiscovery()) {
            super.iscsiConnectionCreated(e);
        }
    }
}

