/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.connection;

import com.sanrad.nms.client.data.iscsi.connection.ISCSIConnectionNode;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.connection.ISCSIConnectionEvent;
import com.sanrad.nms.client.event.iscsi.connection.ISCSIConnectionsListener;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionEvent;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionsListener;
import com.sanrad.nms.client.event.vswitch.VSwitchEvent;
import com.sanrad.nms.client.event.vswitch.VSwitchListener;
import com.sanrad.nms.client.gui.iscsi.connection.ISCSIConnectionsTableHeader;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.iscsi.ISCSIConnection;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.util.types.constants.ConnectionStateConstant;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.HashMap;
import java.util.Vector;

public class SrISCSIConnectionsTableModel
extends SrTableModel
implements ISCSIConnectionsListener,
ISCSISessionsListener,
VSwitchListener {
    protected SrISCSIConnectionsTableModel(SrTableColumns columns) {
        super(columns);
    }

    protected SrISCSIConnectionsTableModel() {
        this(new SrDefaultTableColumns(ISCSIConnectionsTableHeader.getColumnNames()));
    }

    @Override
    public void addListeners() {
        VSwitchManager.getInstance().addVSwitchListener(this);
    }

    @Override
    public void removeListeners() {
        VSwitchManager.getInstance().removeVSwitchListener(this);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        int initiatorNameIndex = this.getColumnIndex(ISCSIConnectionsTableHeader.INITIATOR_NAME.getColumnName());
        if (col == initiatorNameIndex) {
            return true;
        }
        return super.isCellEditable(row, col);
    }

    @Override
    public void iscsiSessionCreated(ISCSISessionEvent e) {
    }

    @Override
    public void iscsiSessionRemoved(ISCSISessionEvent e) {
    }

    @Override
    public void iscsiSessionChanged(ISCSISessionEvent e) {
        this.refreshTableWithSessionData(e.getISCSISessionNode(), e.getValuesMap());
    }

    @Override
    public void iscsiConnectionCreated(ISCSIConnectionEvent e) {
        ISCSIConnectionNode connectionNode = e.getISCSIConnectionNode();
        ISCSISessionNode parentSessionNode = connectionNode.getSessionOfConnection();
        this.addConnectionNodeToTable(connectionNode, parentSessionNode);
        this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
    }

    @Override
    public void iscsiConnectionRemoved(ISCSIConnectionEvent e) {
        ISCSIConnectionNode connectionNode = e.getISCSIConnectionNode();
        this.removeFromTable(connectionNode);
    }

    @Override
    public void iscsiConnectionChanged(ISCSIConnectionEvent e) {
        this.refreshTableWithConnectionData(e.getISCSIConnectionNode(), e.getValuesMap());
    }

    protected void addSessionConnectionNodesToTable(ISCSISessionNode sessionNode) {
        Vector sessionConnections = sessionNode.getConnections();
        int lastRowIndex = this.getLastRowIndex();
        for (int index = 0; index < sessionConnections.size(); ++index) {
            ISCSIConnectionNode connectionNode = (ISCSIConnectionNode)sessionConnections.elementAt(index);
            this.addConnectionNodeToTable(connectionNode, sessionNode);
        }
        this.fireTableRowsInserted(lastRowIndex == 0 ? lastRowIndex : lastRowIndex + 1, this.getLastRowIndex());
    }

    protected void addConnectionNodeToTable(ISCSIConnectionNode iscsiConnectionNode, ISCSISessionNode sessionNode) {
        if (!this.isConnectionExistedInModel(iscsiConnectionNode)) {
            Vector<Object> rowData = new Vector<Object>();
            rowData.addElement(iscsiConnectionNode.getStub());
            rowData.addElement(sessionNode.getStub());
            rowData.addElement(sessionNode.getParentStub());
            rowData.addElement(sessionNode.getVswitch());
            rowData.addElement(sessionNode.getInitiatorAlias());
            rowData.addElement(sessionNode.getInitiatorName());
            rowData.addElement(sessionNode.getISID());
            rowData.addElement(sessionNode.getTargetAlias());
            rowData.addElement(sessionNode.getTargetName());
            rowData.addElement(sessionNode.getTSIH());
            rowData.addElement(iscsiConnectionNode.getCID());
            rowData.addElement(iscsiConnectionNode.getState());
            rowData.addElement(iscsiConnectionNode.getInitiatorIP());
            rowData.addElement(iscsiConnectionNode.getInitiatorPort());
            rowData.addElement(iscsiConnectionNode.getTargetIP());
            rowData.addElement(iscsiConnectionNode.getTargetPort());
            rowData.addElement(iscsiConnectionNode.getMaxReceivedPDULength());
            rowData.addElement(iscsiConnectionNode.getMaxTransmittedPDULength());
            rowData.addElement(iscsiConnectionNode.getHeaderIntegrity());
            rowData.addElement(iscsiConnectionNode.getDataIntegrity());
            this.addRowQuetly(rowData.toArray(), -1);
        }
    }

    protected void removeFromTable(ISCSIConnectionNode iscsiConnectionNode) {
        int size = this.getRowCount();
        int connectionStubCol = this.getColumnIndex(ISCSIConnectionsTableHeader.CONNECTION_STUB.getColumnName());
        for (int i = size - 1; i >= 0; --i) {
            Object connectionStub = this.getValueAt(i, connectionStubCol);
            if (!((ISCSIConnection)iscsiConnectionNode.getStub()).equals(connectionStub)) continue;
            this.removeRow(i);
            break;
        }
    }

    private void refreshTableWithSessionData(ISCSISessionNode iscsiSessionNode, HashMap nodeValues) {
        int size = this.getRowCount();
        int sessionStubCol = this.getColumnIndex(ISCSIConnectionsTableHeader.SESSION_STUB.getColumnName());
        int initiatorAliasCol = this.getColumnIndex(ISCSIConnectionsTableHeader.INITIATOR_ALIAS.getColumnName());
        int targetAliasCol = this.getColumnIndex(ISCSIConnectionsTableHeader.INITIATOR_ALIAS.getColumnName());
        for (int i = 0; i < size; ++i) {
            Object sessionStub = this.getValueAt(i, sessionStubCol);
            if (!((ISCSISession)iscsiSessionNode.getStub()).equals(sessionStub)) continue;
            Object val = nodeValues.get(ClientParameterCode.ISCSI_SESSION_INITIATOR_ALIAS);
            if (val != null) {
                String initiatorAlias = (String)val;
                this.setValueAt(initiatorAlias, i, initiatorAliasCol);
            }
            if ((val = nodeValues.get(ClientParameterCode.ISCSI_SESSION_TARGET_ALIAS)) == null) continue;
            String targetAlias = (String)val;
            this.setValueAt(targetAlias, i, targetAliasCol);
        }
    }

    protected void refreshTableWithConnectionData(ISCSIConnectionNode iscsiConnectionNode, HashMap nodeValues) {
        int size = this.getRowCount();
        int connectionStubCol = this.getColumnIndex(ISCSIConnectionsTableHeader.CONNECTION_STUB.getColumnName());
        int connectionStateCol = this.getColumnIndex(ISCSIConnectionsTableHeader.STATE.getColumnName());
        int maxReceivedPDULengthCol = this.getColumnIndex(ISCSIConnectionsTableHeader.MAX_RECEIVED_PDU_LENGTH.getColumnName());
        int maxTransmittedPDULengthCol = this.getColumnIndex(ISCSIConnectionsTableHeader.MAX_TRANSMITTED_PDU_LENGTH.getColumnName());
        int headerIntegrityCol = this.getColumnIndex(ISCSIConnectionsTableHeader.HEADER_INTEGRITY.getColumnName());
        int dataIntegrityCol = this.getColumnIndex(ISCSIConnectionsTableHeader.DATA_INTEGRITY.getColumnName());
        for (int i = 0; i < size; ++i) {
            Object connectionStub = this.getValueAt(i, connectionStubCol);
            if (!((ISCSIConnection)iscsiConnectionNode.getStub()).equals(connectionStub)) continue;
            Object val = nodeValues.get(ClientParameterCode.ISCSI_CONNECTION_STATE);
            if (val != null) {
                ConnectionStateConstant connectionState = (ConnectionStateConstant)val;
                this.setValueAt(connectionState, i, connectionStateCol);
            }
            if ((val = nodeValues.get(ClientParameterCode.ISCSI_CONNECTION_MAX_RECEIVED_PDU_LENGTH)) != null) {
                Integer maxReceivedPDULength = (Integer)val;
                this.setValueAt(maxReceivedPDULength, i, maxReceivedPDULengthCol);
            }
            if ((val = nodeValues.get(ClientParameterCode.ISCSI_CONNECTION_MAX_TRANSMITTED_PDU_LENGTH)) != null) {
                Integer maxTransmittedPDULength = (Integer)val;
                this.setValueAt(maxTransmittedPDULength, i, maxTransmittedPDULengthCol);
            }
            if ((val = nodeValues.get(ClientParameterCode.ISCSI_CONNECTION_HEADER_INTEGRITY)) != null) {
                Integer headerIntegrity = (Integer)val;
                this.setValueAt(headerIntegrity, i, headerIntegrityCol);
            }
            if ((val = nodeValues.get(ClientParameterCode.ISCSI_CONNECTION_DATA_INTEGRITY)) == null) break;
            Integer dataIntegrity = (Integer)val;
            this.setValueAt(dataIntegrity, i, dataIntegrityCol);
            break;
        }
    }

    protected boolean isConnectionExistedInModel(ISCSIConnectionNode iscsiConnectionNode) {
        int size = this.getRowCount();
        int connectionStubCol = this.getColumnIndex(ISCSIConnectionsTableHeader.CONNECTION_STUB.getColumnName());
        for (int i = 0; i < size; ++i) {
            Object connectionStub = this.getValueAt(i, connectionStubCol);
            if (!((ISCSIConnection)iscsiConnectionNode.getStub()).equals(connectionStub)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void vSwitchCreated(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRemoved(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRediscovered(VSwitchEvent e) {
    }

    @Override
    public void resetVSwitchStarted(VSwitchEvent e) {
    }

    @Override
    public void vSwitchPropertiesChanged(VSwitchEvent e) {
        int rows = this.getRowCount();
        int vswitchCol = this.getColumnIndex(ISCSIConnectionsTableHeader.VSWITCH_STUB.getColumnName());
        int vswitchNameCol = this.getColumnIndex(ISCSIConnectionsTableHeader.VSWITCH.getColumnName());
        for (int i = 0; i < rows; ++i) {
            Object vswitchRowStub = this.getValueAt(i, vswitchCol);
            VSwitchNode vSwitchNode = (VSwitchNode)this.getValueAt(i, vswitchNameCol);
            String vswitchName = vSwitchNode.getName();
            if (!vswitchRowStub.equals(e.getStub())) continue;
            String name = e.getName();
            if (name == null || name.equalsIgnoreCase(vswitchName)) break;
            this.setValueAt(name, i, vswitchNameCol);
            break;
        }
    }
}

