/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.connection;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.iscsi.connection.ISCSIConnectionNode;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.event.iscsi.connection.ISCSIConnectionEvent;
import com.sanrad.nms.client.event.iscsi.connection.ISCSIConnectionsListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.iscsi.ISCSIConnection;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.util.types.constants.ConnectionStateConstant;
import com.sanrad.nms.server.util.types.constants.SessionDirectionConstant;
import com.sanrad.util.SrEventListenerManager;
import java.math.BigInteger;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;

public class ISCSIConnectionsManager
extends ElementManager {
    private static ISCSIConnectionsManager m_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer iscsiConnectionCreatedInformer = new SrEventListenerManager.Informer<ISCSIConnectionsListener, ISCSIConnectionEvent>(){

        @Override
        public void inform(ISCSIConnectionsListener listener, ISCSIConnectionEvent event) {
            listener.iscsiConnectionCreated(event);
        }
    };
    SrEventListenerManager.Informer iscsiConnectionRemovedInformer = new SrEventListenerManager.Informer<ISCSIConnectionsListener, ISCSIConnectionEvent>(){

        @Override
        public void inform(ISCSIConnectionsListener listener, ISCSIConnectionEvent event) {
            listener.iscsiConnectionRemoved(event);
        }
    };
    SrEventListenerManager.Informer iscsiConnectionChangedInformer = new SrEventListenerManager.Informer<ISCSIConnectionsListener, ISCSIConnectionEvent>(){

        @Override
        public void inform(ISCSIConnectionsListener listener, ISCSIConnectionEvent event) {
            listener.iscsiConnectionChanged(event);
        }
    };

    private ISCSIConnectionsManager() {
    }

    public static synchronized ISCSIConnectionsManager getInstance() {
        if (m_instance == null) {
            m_instance = new ISCSIConnectionsManager();
        }
        return m_instance;
    }

    public void addISCSIConnectionsListener(ISCSIConnectionsListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeISCSIConnectionsListener(ISCSIConnectionsListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    public void readAllSessionsConnections(Vector sessionsNodes) {
        for (int i = 0; i < sessionsNodes.size(); ++i) {
            try {
                ISCSISessionNode sessionNode = (ISCSISessionNode)sessionsNodes.get(i);
                Vector connections = ((ISCSISession)sessionNode.getStub()).getConnections();
                Vector<ISCSIConnectionNode> iscsiConnectionsNodes = new Vector<ISCSIConnectionNode>();
                if (connections == null || connections.isEmpty()) continue;
                for (int index = 0; index < connections.size(); ++index) {
                    ISCSIConnection row = (ISCSIConnection)connections.get(index);
                    ISCSIConnectionNode iscsiConnectionNode = this.discoverConnection(row);
                    iscsiConnectionsNodes.addElement(iscsiConnectionNode);
                }
                sessionNode.setConnections(iscsiConnectionsNodes);
                continue;
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                ISCSIConnectionsManager.onConnectionError(re.getMessage());
            }
        }
    }

    protected ISCSIConnectionNode discoverConnection(ISCSIConnection connection) {
        ISCSIConnectionNode connectionNode = (ISCSIConnectionNode)SystemRootNode.getInstance().getRefByStub(connection);
        if (connectionNode == null) {
            try {
                connectionNode = new ISCSIConnectionNode(connection, connection.getSessionParent());
                connectionNode.setCid(connection.getCid());
                connectionNode.setState(connection.getState());
                connectionNode.setInitiatorIP(connection.getInitiatorIP());
                connectionNode.setInitiatorPort(connection.getInitiatorPort());
                connectionNode.setTargetIP(connection.getTargetIP());
                connectionNode.setTargetPort(connection.getTargetPort());
                connectionNode.setMaxReceivedPDULength(connection.getMaxReceivedPDULength());
                connectionNode.setMaxTransmittedPDULength(connection.getMaxTransmittedPDULength());
                connectionNode.setHeaderIntegrity(connection.getHeaderIntegrity());
                connectionNode.setDataIntegrity(connection.getDataIntegrity());
                SystemRootNode.getInstance().putRefAndStub(connection, connectionNode);
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                ISCSIConnectionsManager.onConnectionError("Failed to discover connection.");
            }
        }
        return connectionNode;
    }

    protected ISCSIConnectionNode initializeConnectionNode(ISCSIConnection element, HashMap values, boolean isCreate) {
        try {
            ISCSIConnection connection = element;
            ISCSISession sessionParent = (ISCSISession)this.getObjectForParam(values, ClientParameterCode.ISCSI_SESSION_ID, isCreate);
            if (sessionParent == null && (sessionParent = connection.getSessionParent()) == null) {
                return null;
            }
            boolean isSessionInBound = false;
            if (sessionParent.getDirection() != null) {
                isSessionInBound = sessionParent.getDirection().equals(SessionDirectionConstant.IN_BOUND);
            } else {
                theLogger.error(SrLogCategories.LEGACY, "ISCSIConnectionsManager: ISCSIConnection getParent return null");
            }
            ISCSIConnectionNode connectionNode = isCreate ? new ISCSIConnectionNode(element, sessionParent) : (ISCSIConnectionNode)SystemRootNode.getInstance().getRefByStub(element);
            ClientParameterCode initiatorIPCode = isSessionInBound ? ClientParameterCode.ISCSI_CONNECTION_REMOTE_IP : ClientParameterCode.ISCSI_CONNECTION_LOCAL_IP;
            ClientParameterCode initiatorPortCode = isSessionInBound ? ClientParameterCode.ISCSI_CONNECTION_REMOTE_PORT : ClientParameterCode.ISCSI_CONNECTION_LOCAL_PORT;
            ClientParameterCode targetIPCode = isSessionInBound ? ClientParameterCode.ISCSI_CONNECTION_LOCAL_IP : ClientParameterCode.ISCSI_CONNECTION_REMOTE_IP;
            ClientParameterCode targetPortCode = isSessionInBound ? ClientParameterCode.ISCSI_CONNECTION_LOCAL_PORT : ClientParameterCode.ISCSI_CONNECTION_REMOTE_PORT;
            Object initiatorIP = this.getObjectForParam(values, initiatorIPCode, isCreate);
            if (initiatorIP == null && (initiatorIP = connection.getInitiatorIP()) == null) {
                return null;
            }
            Object initiatorPort = this.getObjectForParam(values, initiatorPortCode, isCreate);
            Object targetIP = this.getObjectForParam(values, targetIPCode, isCreate);
            Object targetPort = this.getObjectForParam(values, targetPortCode, isCreate);
            Object cid = this.getObjectForParam(values, ClientParameterCode.ISCSI_CONNECTION_CID, isCreate);
            Object state = this.getObjectForParam(values, ClientParameterCode.ISCSI_CONNECTION_STATE, isCreate);
            Object maxReceivedPDULength = this.getObjectForParam(values, ClientParameterCode.ISCSI_CONNECTION_MAX_RECEIVED_PDU_LENGTH, isCreate);
            Object maxTransmittedPDULength = this.getObjectForParam(values, ClientParameterCode.ISCSI_CONNECTION_MAX_TRANSMITTED_PDU_LENGTH, isCreate);
            Object headerIntegrity = this.getObjectForParam(values, ClientParameterCode.ISCSI_CONNECTION_HEADER_INTEGRITY, isCreate);
            Object dataIntegrity = this.getObjectForParam(values, ClientParameterCode.ISCSI_CONNECTION_DATA_INTEGRITY, isCreate);
            connectionNode.setCid(cid == null ? connection.getCid() : (Integer)cid);
            connectionNode.setState(state == null ? connection.getState() : (ConnectionStateConstant)state);
            connectionNode.setInitiatorIP(initiatorIP == null ? connection.getInitiatorIP() : initiatorIP.toString());
            connectionNode.setInitiatorPort(initiatorPort == null ? connection.getInitiatorPort() : (BigInteger)initiatorPort);
            connectionNode.setTargetIP(targetIP == null ? connection.getTargetIP() : ((InetAddress)targetIP).toString());
            connectionNode.setTargetPort(targetPort == null ? connection.getTargetPort() : (BigInteger)targetPort);
            connectionNode.setMaxReceivedPDULength(maxReceivedPDULength == null ? connection.getMaxReceivedPDULength() : (Integer)maxReceivedPDULength);
            connectionNode.setMaxTransmittedPDULength(maxTransmittedPDULength == null ? connection.getMaxTransmittedPDULength() : (Integer)maxTransmittedPDULength);
            connectionNode.setHeaderIntegrity(headerIntegrity == null ? connection.getHeaderIntegrity() : (Integer)headerIntegrity);
            connectionNode.setDataIntegrity(dataIntegrity == null ? connection.getDataIntegrity() : (Integer)dataIntegrity);
            if (isCreate) {
                SystemRootNode.getInstance().putRefAndStub(element, connectionNode);
            }
            return connectionNode;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ISCSIConnectionsManager.onConnectionError("Failed to create the iscsi connection.");
            return null;
        }
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        ISCSISessionNode connectionSessionNode;
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSIConnectionsManager: ISCSI Connection create");
        ISCSIConnection connection = (ISCSIConnection)element;
        HashMap params = this.getParameterList(e);
        ISCSIConnectionNode connectionNode = this.initializeConnectionNode(connection, params, true);
        if (connectionNode != null && (connectionSessionNode = (ISCSISessionNode)SystemRootNode.getInstance().getRefByStub(connectionNode.getParentStub())) != null) {
            connectionSessionNode.addConnection(connectionNode);
            this.fireISCSIConnectionCreatedEvent(connectionNode, connectionSessionNode);
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        super.elementRemove(e);
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSIConnectionsManager: connection removed");
        ISCSIConnection connection = (ISCSIConnection)element;
        ISCSIConnectionNode iscsiConnectionNode = (ISCSIConnectionNode)SystemRootNode.getInstance().getRefByStub(connection);
        if (iscsiConnectionNode != null) {
            ISCSISessionNode sessionParent = (ISCSISessionNode)SystemRootNode.getInstance().getRefByStub(iscsiConnectionNode.getParentStub());
            sessionParent.removeConnection(iscsiConnectionNode);
            this.fireISCSIConnectionRemovedEvent(iscsiConnectionNode, sessionParent);
            SystemRootNode.getInstance().removeRefAndIdByStub(element);
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        ISCSISessionNode sessionParent;
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSIConnectionsManager: ISCSI Connection changed");
        HashMap params = this.getParameterList(e);
        ISCSIConnection connection = (ISCSIConnection)element;
        ISCSIConnectionNode iscsiConnectionNode = (ISCSIConnectionNode)SystemRootNode.getInstance().getRefByStub(connection);
        iscsiConnectionNode = this.initializeConnectionNode(connection, params, iscsiConnectionNode == null);
        if (iscsiConnectionNode != null && (sessionParent = (ISCSISessionNode)SystemRootNode.getInstance().getRefByStub(iscsiConnectionNode.getParentStub())) != null) {
            this.fireISCSIConnectionChanged(iscsiConnectionNode, sessionParent, params);
        }
    }

    protected void fireISCSIConnectionCreatedEvent(ISCSIConnectionNode iscsiConnectionNode, ISCSISessionNode connectionSessionNode) {
        ISCSIConnectionEvent event = new ISCSIConnectionEvent(this, iscsiConnectionNode, connectionSessionNode, iscsiConnectionNode.getValues());
        this.m_listeners.fireEvent(ISCSIConnectionsListener.class, event, this.iscsiConnectionCreatedInformer);
    }

    protected void fireISCSIConnectionRemovedEvent(ISCSIConnectionNode iscsiConnectionNode, ISCSISessionNode sessionParent) {
        ISCSIConnectionEvent event = new ISCSIConnectionEvent((Object)this, iscsiConnectionNode, sessionParent);
        this.m_listeners.fireEvent(ISCSIConnectionsListener.class, event, this.iscsiConnectionRemovedInformer);
    }

    protected void fireISCSIConnectionChanged(ISCSIConnectionNode iscsiConnectionNode, ISCSISessionNode sessionParent, HashMap map) {
        ISCSIConnectionEvent event = new ISCSIConnectionEvent(this, iscsiConnectionNode, sessionParent, map);
        this.m_listeners.fireEvent(ISCSIConnectionsListener.class, event, this.iscsiConnectionChangedInformer);
    }
}

