/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.connection;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.server.logic.iscsi.ISCSIConnection;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.ConnectionStateConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.HashMap;

public class ISCSIConnectionNode
extends SrTreeNode<ISCSIConnection, CommKeyClassId> {
    private HashMap m_values;
    private Integer m_cid;
    private ConnectionStateConstant m_state;
    private String m_initiatorIP;
    private BigInteger m_initiatorPort;
    private String m_targetIP;
    private BigInteger m_targetPort;
    private Integer m_maxReceivedPDULength;
    private Integer m_maxTransmittedPDULength;
    private Integer m_headerIntegrity;
    private Integer m_dataIntegrity;
    private ISCSISession m_parentStub;

    public ISCSIConnectionNode(ISCSIConnection stub, ISCSISession parentStub) throws RemoteException {
        super(stub, stub.getCommKeyClassId());
        this.m_parentStub = parentStub;
    }

    public ISCSIConnectionNode(ISCSIConnection stub, ISCSISession parentStub, HashMap values) throws RemoteException {
        this(stub, parentStub);
        this.m_values = values;
    }

    @Override
    public String type() {
        return "ISCSI Connection Node";
    }

    public HashMap getValues() {
        return this.m_values;
    }

    public ISCSISessionNode getSessionOfConnection() {
        return (ISCSISessionNode)SystemRootNode.getInstance().getRefByStub(this.getParentStub());
    }

    public void setCid(Integer cid) {
        this.m_cid = cid;
    }

    public Integer getCID() {
        return this.m_cid;
    }

    public void setInitiatorPort(BigInteger initiatorPort) {
        this.m_initiatorPort = initiatorPort;
    }

    public BigInteger getInitiatorPort() {
        return this.m_initiatorPort;
    }

    public void setTargetPort(BigInteger targetPort) {
        this.m_targetPort = targetPort;
    }

    public BigInteger getTargetPort() {
        return this.m_targetPort;
    }

    public void setMaxReceivedPDULength(Integer maxReceivedPDULength) {
        this.m_maxReceivedPDULength = maxReceivedPDULength;
    }

    public Integer getMaxReceivedPDULength() {
        return this.m_maxReceivedPDULength;
    }

    public void setMaxTransmittedPDULength(Integer maxTransmittedPDULength) {
        this.m_maxTransmittedPDULength = maxTransmittedPDULength;
    }

    public Integer getMaxTransmittedPDULength() {
        return this.m_maxTransmittedPDULength;
    }

    public void setHeaderIntegrity(Integer headerIntegrity) {
        this.m_headerIntegrity = headerIntegrity;
    }

    public Integer getHeaderIntegrity() {
        return this.m_headerIntegrity;
    }

    public void setDataIntegrity(Integer dataIntegrity) {
        this.m_dataIntegrity = dataIntegrity;
    }

    public Integer getDataIntegrity() {
        return this.m_dataIntegrity;
    }

    public void setState(ConnectionStateConstant state) {
        this.m_state = state;
    }

    public ConnectionStateConstant getState() {
        return this.m_state;
    }

    public void setInitiatorIP(String initiatorIP) {
        this.m_initiatorIP = initiatorIP;
        if (this.m_initiatorIP.startsWith("/")) {
            this.m_initiatorIP = this.m_initiatorIP.substring(1);
        }
    }

    public String getInitiatorIP() {
        return this.m_initiatorIP;
    }

    public void setTargetIP(String targetIP) {
        this.m_targetIP = targetIP;
        if (this.m_targetIP.startsWith("/")) {
            this.m_targetIP = this.m_targetIP.substring(1);
        }
    }

    public String getTargetIP() {
        return this.m_targetIP;
    }

    @Override
    public String toString() {
        return this.type();
    }

    public ISCSISession getParentStub() {
        return this.m_parentStub;
    }
}

