/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.initiator;

import com.sanrad.nms.client.data.initiator.SrInitiatorManager;
import com.sanrad.nms.client.data.initiator.SrInitiatorNode;
import com.sanrad.nms.client.data.initiator.SrSCSIInitiatorPortNode;
import com.sanrad.nms.client.data.initiator.SrSCSIInitiatorPortsManager;
import com.sanrad.nms.client.data.scsi.SrSCSIPortNode;
import com.sanrad.nms.client.event.initiator.SrInitiatorEvent;
import com.sanrad.nms.client.event.initiator.SrInitiatorsListener;
import com.sanrad.nms.client.event.initiator.SrSCSIInitiatorPortEvent;
import com.sanrad.nms.client.event.initiator.SrSCSIInitiatorPortsListener;
import com.sanrad.nms.client.gui.initiator.SrISCSIInitiatorPortsTableHeader;
import com.sanrad.nms.server.logic.initiator.SCSIInitiatorPort;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.Vector;

public class SrSCSIInitiatorPortsTableModel
extends SrTableModel
implements SrInitiatorsListener,
SrSCSIInitiatorPortsListener {
    protected SrInitiatorNode m_initiatorNode;

    public SrSCSIInitiatorPortsTableModel(SrInitiatorNode initiatorNode) {
        super(new SrDefaultTableColumns(SrISCSIInitiatorPortsTableHeader.getColumnNames()));
        this.m_initiatorNode = initiatorNode;
        this.initModel();
    }

    @Override
    public void addListeners() {
        SrInitiatorManager.getInstance().addInitiatorsListener(this);
        SrSCSIInitiatorPortsManager.getInstance().addInitiatorPortsListener(this);
    }

    @Override
    public void removeListeners() {
        SrInitiatorManager.getInstance().removeInitiatorsListener(this);
        SrSCSIInitiatorPortsManager.getInstance().removeInitiatorPortsListener(this);
    }

    protected void initModel() {
        SrSCSIPortNode[] portNodes = this.m_initiatorNode.getSCSIPorts();
        for (int index = 0; index < portNodes.length; ++index) {
            SrSCSIInitiatorPortNode portNode = (SrSCSIInitiatorPortNode)portNodes[index];
            this.addInitiatorPortEntryToTable(portNode);
        }
    }

    protected void addInitiatorPortEntryToTable(SrSCSIInitiatorPortNode portNode) {
        Vector<Object> rowData = new Vector<Object>();
        rowData.addElement(portNode.getStub());
        rowData.addElement(portNode.getParentStub());
        rowData.addElement(portNode.getInitiatorAlias());
        rowData.addElement(portNode.getISID());
        rowData.addElement(portNode.getOutCommands());
        rowData.addElement(portNode.getWrittenMBs());
        rowData.addElement(portNode.getReadMBs());
        this.addRowQuetly(rowData.toArray(), -1);
    }

    private void updateInitiatorPortEntry(SrSCSIInitiatorPortNode portNode) {
        int rowCount = this.getRowCount();
        int portStubCol = this.getColumnIndex(SrISCSIInitiatorPortsTableHeader.INITIATOR_PORT_STUB.getColumnName());
        int portISIDCol = this.getColumnIndex(SrISCSIInitiatorPortsTableHeader.PORT_ISID.getColumnName());
        int portOutCommandsCol = this.getColumnIndex(SrISCSIInitiatorPortsTableHeader.PORT_OUT_COMMANDS.getColumnName());
        int portWrittenMBsCol = this.getColumnIndex(SrISCSIInitiatorPortsTableHeader.PORT_WRITTEN_MBS.getColumnName());
        int portReadMBsCol = this.getColumnIndex(SrISCSIInitiatorPortsTableHeader.PORT_READ_MBS.getColumnName());
        for (int index = 0; index < rowCount; ++index) {
            SCSIInitiatorPort portStub = (SCSIInitiatorPort)this.getValueAt(index, portStubCol);
            if (!((SCSIInitiatorPort)portNode.getStub()).equals(portStub)) continue;
            this.setValueAt(portNode.getISID(), index, portISIDCol);
            this.setValueAt(portNode.getOutCommands(), index, portOutCommandsCol);
            this.setValueAt(portNode.getWrittenMBs(), index, portWrittenMBsCol);
            this.setValueAt(portNode.getReadMBs(), index, portReadMBsCol);
            break;
        }
    }

    private void updateInitiatorPortEntryWithInitiatorAlias(SrInitiatorNode initiatorNode) {
        int rowCount = this.getRowCount();
        int initiatorAliasCol = this.getColumnIndex(SrISCSIInitiatorPortsTableHeader.PORT_INITIATOR_ALIAS.getColumnName());
        for (int index = 0; index < rowCount; ++index) {
            this.setValueAt(initiatorNode.getAlias(), index, initiatorAliasCol);
        }
    }

    @Override
    public void iscsiInitiatorChanged(SrInitiatorEvent e) {
        SrInitiatorNode initiatorNode = e.getInitiatorNode();
        this.updateInitiatorPortEntryWithInitiatorAlias(initiatorNode);
    }

    @Override
    public void iscsiInitiatorRemoved(SrInitiatorEvent e) {
    }

    @Override
    public void iscsiInitiatorCreated(SrInitiatorEvent e) {
    }

    @Override
    public void scsiInitiatorPortChanged(SrSCSIInitiatorPortEvent e) {
        SrSCSIInitiatorPortNode portNode = e.getSCSIInitiatorPortNode();
        this.updateInitiatorPortEntry(portNode);
    }
}

