/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.initiator;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.initiator.SrInitiatorNode;
import com.sanrad.nms.client.data.initiator.SrSCSIInitiatorPortNode;
import com.sanrad.nms.client.event.initiator.SrSCSIInitiatorPortEvent;
import com.sanrad.nms.client.event.initiator.SrSCSIInitiatorPortsListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.initiator.SCSIInitiatorPort;
import com.sanrad.nms.server.logic.scsi.SCSIPort;
import com.sanrad.util.SrEventListenerManager;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;

public class SrSCSIInitiatorPortsManager
extends ElementManager {
    private static SrSCSIInitiatorPortsManager s_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer scsiInitiatorPortChangedInformer = new SrEventListenerManager.Informer<SrSCSIInitiatorPortsListener, SrSCSIInitiatorPortEvent>(){

        @Override
        public void inform(SrSCSIInitiatorPortsListener listener, SrSCSIInitiatorPortEvent event) {
            listener.scsiInitiatorPortChanged(event);
        }
    };

    private SrSCSIInitiatorPortsManager() {
    }

    public static synchronized SrSCSIInitiatorPortsManager getInstance() {
        if (s_instance == null) {
            s_instance = new SrSCSIInitiatorPortsManager();
        }
        return s_instance;
    }

    public void addInitiatorPortsListener(SrSCSIInitiatorPortsListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeInitiatorPortsListener(SrSCSIInitiatorPortsListener listener) {
        this.m_listeners.remove(listener);
    }

    public ArrayList readAllInitiatorPorts(ISCSIInitiator initiator) {
        ArrayList<SrSCSIInitiatorPortNode> portNodes = new ArrayList<SrSCSIInitiatorPortNode>();
        try {
            SCSIPort[] ports = initiator.getPorts();
            if (ports != null && ports.length > 0) {
                for (int index = 0; index < ports.length; ++index) {
                    SCSIInitiatorPort port = (SCSIInitiatorPort)ports[index];
                    SrSCSIInitiatorPortNode portNode = this.discoverPort(initiator, port);
                    portNodes.add(portNode);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            SrSCSIInitiatorPortsManager.onConnectionError("Failed to get initiators ports table from the Server.");
        }
        return portNodes;
    }

    protected SrSCSIInitiatorPortNode discoverPort(ISCSIInitiator initiator, SCSIInitiatorPort port) {
        SrSCSIInitiatorPortNode portNode = (SrSCSIInitiatorPortNode)SystemRootNode.getInstance().getRefByStub(port);
        if (portNode == null) {
            try {
                portNode = new SrSCSIInitiatorPortNode(port, port.getParentVSwitch(), initiator);
                portNode.setName(port.getName());
                portNode.setISID(port.getISID());
                portNode.setOutCommands(port.getOutCommands());
                portNode.setReadMBs(port.getReadMB());
                portNode.setWrittenMBs(port.getWrittenMB());
                SystemRootNode.getInstance().putRefAndStub(port, portNode);
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                SrSCSIInitiatorPortsManager.onConnectionError("Failed to discover initiator port.");
            }
        }
        return portNode;
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    protected SrSCSIInitiatorPortNode initializeInitiatorPortNode(SCSIInitiatorPort element, HashMap values, boolean isCreate) {
        try {
            Object nameObj = this.getObjectForParam(values, ClientParameterCode.SCSI_INITIATOR_PORT_NAME, isCreate);
            Object isidObj = this.getObjectForParam(values, ClientParameterCode.SCSI_INITIATOR_PORT_ISID, isCreate);
            Object readMBsObj = this.getObjectForParam(values, ClientParameterCode.SCSI_INITIATOR_PORT_READ_MB, isCreate);
            Object writtenMBsObj = this.getObjectForParam(values, ClientParameterCode.SCSI_INITIATOR_PORT_WRITTEN_MB, isCreate);
            Object outCommandsObj = this.getObjectForParam(values, ClientParameterCode.SCSI_INITIATOR_PORT_OUT_COMMANDS, isCreate);
            SCSIInitiatorPort port = element;
            ISCSIInitiator inititorStub = port.getInitiator();
            SrSCSIInitiatorPortNode portNode = isCreate ? new SrSCSIInitiatorPortNode(port, port.getParentVSwitch(), inititorStub) : (SrSCSIInitiatorPortNode)SystemRootNode.getInstance().getRefByStub(element);
            if (portNode != null) {
                portNode.setName(nameObj == null ? port.getName() : (String)nameObj);
                portNode.setISID(isidObj == null ? port.getISID() : (Integer)isidObj);
                portNode.setReadMBs(readMBsObj == null ? port.getReadMB() : (BigInteger)readMBsObj);
                portNode.setWrittenMBs(writtenMBsObj == null ? port.getWrittenMB() : (BigInteger)writtenMBsObj);
                portNode.setOutCommands(outCommandsObj == null ? port.getOutCommands() : (BigInteger)outCommandsObj);
                if (isCreate) {
                    SystemRootNode.getInstance().putRefAndStub(element, portNode);
                    SrTreeNode initiator = SystemRootNode.getInstance().getRefByStub(inititorStub);
                    if (initiator != null) {
                        ((SrInitiatorNode)initiator).addSCSIPort(portNode);
                    }
                }
            }
            return portNode;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, "ISCSISessionsManager: failed to create an ISCSI initiator.");
            SrSCSIInitiatorPortsManager.onConnectionError();
            return null;
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "SCSIInitiatorPortsManager: initiator port");
        HashMap map = this.getParameterList(e);
        SCSIInitiatorPort port = (SCSIInitiatorPort)element;
        SrSCSIInitiatorPortNode portNode = this.initializeInitiatorPortNode(port, map, false);
        if (portNode != null) {
            this.fireInitiatorPortChanged(portNode, map);
        }
    }

    protected void fireInitiatorPortChanged(SrSCSIInitiatorPortNode portNode, HashMap map) {
        SrSCSIInitiatorPortEvent event = new SrSCSIInitiatorPortEvent((Object)this, portNode, map);
        this.m_listeners.fireEvent(SrSCSIInitiatorPortsListener.class, event, this.scsiInitiatorPortChangedInformer);
    }
}

