/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.initiator;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetNode;
import com.sanrad.nms.client.data.scsi.SrDeviceNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class SrInitiatorNode
extends SrDeviceNode<ISCSIInitiator, CommKeyClassId> {
    private String m_chapUserName;
    private String m_srpUserName;
    private VSwitch m_parentVswitch;
    private ArrayList m_iscsiRemoteTargets;
    private ArrayList m_remoteDiscoveryPortals;

    public SrInitiatorNode(ISCSIInitiator stub) throws RemoteException {
        super(stub, stub.getCommKeyClassId());
    }

    public SrInitiatorNode(ISCSIInitiator stub, VSwitch vswitch, String alias) throws RemoteException {
        super(stub, stub.getCommKeyClassId(), alias, ClientImageObject.INITIATOR);
        this.m_parentVswitch = vswitch;
        this.m_iscsiRemoteTargets = new ArrayList();
        this.m_remoteDiscoveryPortals = new ArrayList();
    }

    public VSwitchNode getParentVSwitch() {
        return (VSwitchNode)SystemRootNode.getInstance().getRefByStub(this.m_parentVswitch);
    }

    @Override
    public String type() {
        StringBuffer sb = new StringBuffer("Initiator ");
        sb.append(super.type());
        return sb.toString();
    }

    @Override
    public String getToolTipText() {
        return this.getName();
    }

    @Override
    public int compareTo(Object o) {
        int answer = Integer.MIN_VALUE;
        if (o instanceof SrInitiatorNode) {
            SrInitiatorNode comp2 = (SrInitiatorNode)o;
            String val1 = this.getAlias();
            answer = val1.compareTo(comp2.getAlias());
        }
        return answer;
    }

    public void setCHAPUserName(String chapUserName) {
        if (chapUserName == null) {
            this.m_chapUserName = "sanrad";
            return;
        }
        this.m_chapUserName = chapUserName;
    }

    public String getCHAPUserName() {
        return this.m_chapUserName;
    }

    public void setSRPUserName(String srpUserName) {
        if (srpUserName == null) {
            this.m_srpUserName = "sanrad";
            return;
        }
        this.m_srpUserName = srpUserName;
    }

    public String getSRPUserName() {
        return this.m_srpUserName;
    }

    public void setConnectedTargets(ArrayList iscsiRemoteTargetsNodes) {
        this.m_iscsiRemoteTargets.clear();
        this.m_iscsiRemoteTargets.addAll(iscsiRemoteTargetsNodes);
    }

    public SrISCSIRemoteTargetNode[] getConnectedTargets() {
        SrISCSIRemoteTargetNode[] array = new SrISCSIRemoteTargetNode[this.m_iscsiRemoteTargets.size()];
        return this.m_iscsiRemoteTargets.toArray(array);
    }

    public void addConnectedTarget(SrISCSIRemoteTargetNode targetNode) {
        if (!this.m_iscsiRemoteTargets.contains(targetNode)) {
            this.m_iscsiRemoteTargets.add(targetNode);
        }
    }

    public void removeConnectedTarget(SrISCSIRemoteTargetNode targetNode) {
        this.m_iscsiRemoteTargets.remove(targetNode);
    }

    public void setRemoteDiscoveryPortals(ArrayList remoteDiscoveryPortals) {
        this.m_remoteDiscoveryPortals.clear();
        this.m_remoteDiscoveryPortals.addAll(remoteDiscoveryPortals);
    }

    public SrISCSIRemoteDiscoveryPortalNode[] getRemoteDiscoveryPortals() {
        SrISCSIRemoteDiscoveryPortalNode[] array = new SrISCSIRemoteDiscoveryPortalNode[this.m_remoteDiscoveryPortals.size()];
        return this.m_remoteDiscoveryPortals.toArray(array);
    }

    public void addRemoteDiscoveryPortal(SrISCSIRemoteDiscoveryPortalNode discoveryPortal) {
        if (!this.m_remoteDiscoveryPortals.contains(discoveryPortal)) {
            this.m_remoteDiscoveryPortals.add(discoveryPortal);
        }
    }

    public void removeRemoteDiscoveryPortal(SrISCSIRemoteDiscoveryPortalNode discoveryPortal) {
        this.m_remoteDiscoveryPortals.remove(discoveryPortal);
    }
}

