/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.initiator;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.initiator.SrInitiatorNode;
import com.sanrad.nms.client.data.initiator.SrSCSIInitiatorPortsManager;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalsManager;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetsManager;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionsManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.initiator.SrInitiatorEvent;
import com.sanrad.nms.client.event.initiator.SrInitiatorsListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscovery;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.util.SrEventListenerManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;

public class SrInitiatorManager
extends ElementManager {
    private static SrInitiatorManager s_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer iscsiInitiatorCreatedInformer = new SrEventListenerManager.Informer<SrInitiatorsListener, SrInitiatorEvent>(){

        @Override
        public void inform(SrInitiatorsListener listener, SrInitiatorEvent event) {
            listener.iscsiInitiatorCreated(event);
        }
    };
    SrEventListenerManager.Informer iscsiInitiatorChangedInformer = new SrEventListenerManager.Informer<SrInitiatorsListener, SrInitiatorEvent>(){

        @Override
        public void inform(SrInitiatorsListener listener, SrInitiatorEvent event) {
            listener.iscsiInitiatorChanged(event);
        }
    };
    SrEventListenerManager.Informer iscsiInitiatorRemovedInformer = new SrEventListenerManager.Informer<SrInitiatorsListener, SrInitiatorEvent>(){

        @Override
        public void inform(SrInitiatorsListener listener, SrInitiatorEvent event) {
            listener.iscsiInitiatorRemoved(event);
        }
    };

    private SrInitiatorManager() {
    }

    public static synchronized SrInitiatorManager getInstance() {
        if (s_instance == null) {
            s_instance = new SrInitiatorManager();
        }
        return s_instance;
    }

    public void addInitiatorsListener(SrInitiatorsListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeInitiatorsListener(SrInitiatorsListener listener) {
        this.m_listeners.remove(listener);
    }

    public ArrayList readAllInitiators(VSwitch vSwitch) {
        ArrayList<SrInitiatorNode> initiatorNodes = new ArrayList<SrInitiatorNode>();
        try {
            ISCSIInitiator[] initiators = vSwitch.getISCSIInitiators();
            if (initiators != null && initiators.length > 0) {
                for (int index = 0; index < initiators.length; ++index) {
                    ISCSIInitiator initiator = initiators[index];
                    SrInitiatorNode initiatorNode = this.discoverInitiator(initiator);
                    initiatorNodes.add(initiatorNode);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            SrInitiatorManager.onConnectionError("Failed to get ISCSI Initiators Table from the Server.");
        }
        return initiatorNodes;
    }

    protected SrInitiatorNode discoverInitiator(ISCSIInitiator initiator) {
        SrInitiatorNode initiatorNode = (SrInitiatorNode)SystemRootNode.getInstance().getRefByStub(initiator);
        if (initiatorNode == null) {
            try {
                initiatorNode = new SrInitiatorNode(initiator, initiator.getParentVSwitch(), initiator.getAlias());
                initiatorNode.setName(initiator.getName());
                initiatorNode.setCHAPUserName(initiator.getCHAPUserName());
                initiatorNode.setSRPUserName(initiator.getSRPUserName());
                SystemRootNode.getInstance().putRefAndStub(initiator, initiatorNode);
                ArrayList scsiPortsNodes = SrSCSIInitiatorPortsManager.getInstance().readAllInitiatorPorts(initiator);
                initiatorNode.setSCSIPorts(scsiPortsNodes);
                ArrayList remoteTargetsNodes = SrISCSIRemoteTargetsManager.getInstance().readAllInitiatorRemoteTargets(initiator);
                initiatorNode.setConnectedTargets(remoteTargetsNodes);
                ArrayList remoteDiscoveryPortalsNodes = SrISCSIRemoteDiscoveryPortalsManager.getInstance().readAllInitiatorRemoteDiscoveryPortals(initiator);
                initiatorNode.setRemoteDiscoveryPortals(remoteDiscoveryPortalsNodes);
                ArrayList sessionsNodes = ISCSISessionsManager.getInstance().readAllInitiatorSessions(initiator);
                initiatorNode.setISCSISessions(sessionsNodes);
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                SrInitiatorManager.onConnectionError("Failed to discover iscsi initiator.");
            }
        }
        return initiatorNode;
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    protected SrInitiatorNode initializeInitiatorNode(ISCSIInitiator element, HashMap values, boolean isCreate) throws RemoteException {
        SrTreeNode initiatorVswitchParent;
        Object aliasObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_INITIATOR_ALIAS, isCreate);
        Object nameObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_INITIATOR_NAME, isCreate);
        Object chapUserNameObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_INITIATOR_CHAP_USER_NAME, isCreate);
        Object srpUserNameObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_INITIATOR_SRP_USER_NAME, isCreate);
        Object remoteTargetsObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_INITIATOR_REMOTE_TARGETS, isCreate);
        Object remoteDiscoveryPortalsObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_INITIATOR_REMOTE_DISCOVERY_PORTALS, isCreate);
        ISCSIInitiator initiator = element;
        ISCSIRemoteTarget[] remoteTargets = (ISCSIRemoteTarget[])remoteTargetsObj;
        if (remoteTargets == null) {
            remoteTargets = initiator.getISCSIRemoteTargets();
        }
        ArrayList remoteTargetsNodes = SrISCSIRemoteTargetsManager.getInstance().getRemoteTargetsNodes(initiator, remoteTargets);
        ISCSIRemotePortalDiscovery[] remoteDiscoveryPortals = (ISCSIRemotePortalDiscovery[])remoteDiscoveryPortalsObj;
        if (remoteDiscoveryPortals == null) {
            remoteDiscoveryPortals = initiator.getISCSIRemoteDiscoveryPortals();
        }
        ArrayList remoteDiscoveryPortalsNodes = SrISCSIRemoteDiscoveryPortalsManager.getInstance().getRemoteDiscoveryPortalsNodes(initiator, remoteDiscoveryPortals);
        VSwitch parentStub = initiator.getParentVSwitch();
        SrInitiatorNode initiatorNode = isCreate ? new SrInitiatorNode(initiator, parentStub, initiator.getAlias()) : (SrInitiatorNode)SystemRootNode.getInstance().getRefByStub(element);
        initiatorNode.setAlias(aliasObj == null ? initiator.getAlias() : (String)aliasObj);
        initiatorNode.setName(nameObj == null ? initiator.getName() : (String)nameObj);
        initiatorNode.setCHAPUserName(chapUserNameObj == null ? initiator.getCHAPUserName() : (String)chapUserNameObj);
        initiatorNode.setSRPUserName(srpUserNameObj == null ? initiator.getSRPUserName() : (String)srpUserNameObj);
        initiatorNode.setConnectedTargets(remoteTargetsNodes);
        initiatorNode.setRemoteDiscoveryPortals(remoteDiscoveryPortalsNodes);
        if (isCreate) {
            SystemRootNode.getInstance().putRefAndStub(element, initiatorNode);
        }
        if ((initiatorVswitchParent = SystemRootNode.getInstance().getRefByStub(parentStub)) != null) {
            ((VSwitchNode)initiatorVswitchParent).addISCSIInitiator(initiatorNode);
        }
        return initiatorNode;
    }

    private void removeFromVSwitch(SrInitiatorNode initiatorNode) {
        VSwitchNode vswitchNode = initiatorNode.getParentVSwitch();
        if (vswitchNode != null) {
            vswitchNode.removeISCSIInitiator(initiatorNode);
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        super.elementRemove(e);
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "SrInitiatorManager: iscsi initiator removed");
        ISCSIInitiator initiator = (ISCSIInitiator)element;
        SrInitiatorNode initiatorNode = (SrInitiatorNode)SystemRootNode.getInstance().getRefByStub(initiator);
        if (initiatorNode == null) {
            return;
        }
        this.removeFromVSwitch(initiatorNode);
        this.fireInitiatorRemoved(initiatorNode);
        SystemRootNode.getInstance().removeRefAndIdByStub(initiator);
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        try {
            RemoteObject element = e.getElement();
            if (this.isClusterInDiscovery(element)) {
                return;
            }
            if (this.alreadyExist(element)) {
                return;
            }
            theLogger.trace(SrLogCategories.LEGACY, "SrInitiatorManager: iscsi initiator created");
            HashMap params = this.getParameterList(e);
            ISCSIInitiator initiator = (ISCSIInitiator)element;
            SrInitiatorNode initiatorNode = this.initializeInitiatorNode(initiator, params, true);
            this.fireInitiatorCreated(initiatorNode);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
            SrInitiatorManager.onConnectionError();
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        try {
            RemoteObject element = e.getElement();
            if (this.isClusterInDiscovery(element)) {
                return;
            }
            theLogger.trace(SrLogCategories.LEGACY, "SrInitiatorManager: iscsi initiator changed");
            HashMap map = this.getParameterList(e);
            ISCSIInitiator initiator = (ISCSIInitiator)element;
            SrInitiatorNode initiatorNode = this.initializeInitiatorNode(initiator, map, false);
            this.fireInitiatorChanged(initiatorNode, map);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
            SrInitiatorManager.onConnectionError();
        }
    }

    protected void fireInitiatorCreated(SrInitiatorNode initiatorNode) {
        SrInitiatorEvent event = new SrInitiatorEvent((Object)this, initiatorNode);
        this.m_listeners.fireEvent(SrInitiatorsListener.class, event, this.iscsiInitiatorCreatedInformer);
    }

    protected void fireInitiatorChanged(SrInitiatorNode initiatorNode, HashMap map) {
        SrInitiatorEvent event = new SrInitiatorEvent((Object)this, initiatorNode, map);
        this.m_listeners.fireEvent(SrInitiatorsListener.class, event, this.iscsiInitiatorChangedInformer);
    }

    protected void fireInitiatorRemoved(SrInitiatorNode initiatorNode) {
        SrInitiatorEvent event = new SrInitiatorEvent((Object)this, initiatorNode);
        this.m_listeners.fireEvent(SrInitiatorsListener.class, event, this.iscsiInitiatorRemovedInformer);
    }
}

