/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.identity.auth;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.ElementValidator;
import com.sanrad.util.SrConstantsBundleKeys;

public class CredentialsValidator
extends ElementValidator {
    private String userName;
    private String password;
    private boolean isRadiusEnabled;
    public static final int MIN_PASSWORD_LENGTH = Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.CREDENTIALS_MIN_PASSWORD_LENGTH));
    public static final int MAX_PASSWORD_LENGTH = Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.CREDENTIALS_MAX_PASSWORD_LENGTH));

    public CredentialsValidator(String userName, String password, boolean isRadiusEnabled) {
        this.userName = userName;
        this.password = password;
        this.isRadiusEnabled = isRadiusEnabled;
    }

    @Override
    public boolean isValidForCreation() {
        if (!this.isRadiusEnabled) {
            if (this.userName.equals("")) {
                this.setErrorMessage("You must enter user name.");
                return false;
            }
            int pswdLen = this.password.length();
            if (pswdLen > 0 && (pswdLen < MIN_PASSWORD_LENGTH || pswdLen > MAX_PASSWORD_LENGTH)) {
                StringBuffer msg = new StringBuffer("Password must contain ");
                msg.append(MIN_PASSWORD_LENGTH);
                msg.append("-");
                msg.append(MAX_PASSWORD_LENGTH);
                msg.append(" charachters.");
                this.setErrorMessage(msg.toString());
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValidForRemoval() {
        return true;
    }
}

