/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.identity.auth;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.identity.auth.CHAPCredentialsNode;
import com.sanrad.nms.client.data.identity.auth.CredentialsNode;
import com.sanrad.nms.client.data.identity.auth.SRPCredentialsNode;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.client.event.identity.auth.CredentialsEvent;
import com.sanrad.nms.client.event.identity.auth.CredentialsListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.identity.CHAPCredentials;
import com.sanrad.nms.server.logic.identity.Credentials;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.identity.SRPCredentials;
import com.sanrad.nms.server.util.types.constants.IdentityPurposeConstant;
import com.sanrad.util.SrEventListenerManager;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.Callable;

public class CredentialsManager
extends ElementManager {
    private static CredentialsManager instance;
    public static int CHAP_RADIUS_DISABLED;
    public static int CHAP_RADIUS_ENABLED;
    private static SrLogger theLogger;
    SrEventListenerManager.Informer credentialsCreatedInformer = new SrEventListenerManager.Informer<CredentialsListener, CredentialsEvent>(){

        @Override
        public void inform(CredentialsListener listener, CredentialsEvent event) {
            listener.credentialsCreated(event);
        }
    };
    SrEventListenerManager.Informer credentialsRemovedInformer = new SrEventListenerManager.Informer<CredentialsListener, CredentialsEvent>(){

        @Override
        public void inform(CredentialsListener listener, CredentialsEvent event) {
            listener.credentialsRemoved(event);
        }
    };
    SrEventListenerManager.Informer credentialsChangedInformer = new SrEventListenerManager.Informer<CredentialsListener, CredentialsEvent>(){

        @Override
        public void inform(CredentialsListener listener, CredentialsEvent event) {
            listener.credentialsChanged(event);
        }
    };

    private CredentialsManager() {
    }

    public static synchronized CredentialsManager getInstance() {
        if (instance == null) {
            instance = new CredentialsManager();
        }
        return instance;
    }

    public void addCredentialsListener(CredentialsListener l) {
        this.m_listeners.add(l);
    }

    public void removeCredentialsListener(CredentialsListener l) {
        this.m_listeners.remove(l);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    public void readAllCredentials(Vector identities) {
        for (int i = 0; i < identities.size(); ++i) {
            try {
                IdentityNode identityNode = (IdentityNode)identities.get(i);
                Vector<? extends Credentials> credentials = ((Identity)identityNode.getStub()).getCredentials();
                for (int j = 0; j < credentials.size(); ++j) {
                    this.createCredentialsNode(credentials.get(j), null);
                }
                continue;
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                CredentialsManager.onConnectionError(re.getMessage());
            }
        }
    }

    private CredentialsNode createCredentialsNode(Credentials credentials, HashMap params) throws RemoteException {
        CredentialsNode credNode = null;
        if (credentials instanceof SRPCredentials) {
            credNode = this.createSRPCredentialsNode(credentials, params);
        } else if (credentials instanceof CHAPCredentials) {
            credNode = this.createCHAPCredentialsNode(credentials, params);
        } else {
            theLogger.logAndAssert(SrLogCategories.ERROR, "Unsupported credential type - " + credentials.getClass());
        }
        return credNode;
    }

    protected CredentialsNode createSRPCredentialsNode(Credentials credentials, HashMap params) throws RemoteException {
        Identity idenStub;
        IdentityNode identity;
        Identity identityParent = (Identity)this.getObjectForParam(params, "Missing code - ClientParameterCode.CREDENTIALS_IDENTITY_PARENT", true);
        Object userNameObj = this.getObjectForParam(params, ClientParameterCode.SRP_CREDENTIALS_USER_NAME, true);
        if (identityParent == null) {
            identityParent = credentials.getIdentityParent();
        }
        if (userNameObj == null) {
            userNameObj = credentials.getUserName();
        }
        if ((identity = (IdentityNode)SystemRootNode.getInstance().getRefByStub(identityParent)) == null && IdentityPurposeConstant.LOCAL_TARGET.equals((idenStub = identityParent).getPurpose())) {
            return null;
        }
        SRPCredentialsNode srpCredNode = new SRPCredentialsNode((SRPCredentials)credentials, (String)userNameObj, identityParent);
        identity.addCredentials(srpCredNode);
        SystemRootNode.getInstance().putRefAndStub(credentials, srpCredNode);
        return srpCredNode;
    }

    protected CredentialsNode createCHAPCredentialsNode(Credentials credentials, HashMap params) throws RemoteException {
        Identity idenStub;
        IdentityNode identity;
        Identity identityParent = (Identity)this.getObjectForParam(params, "Missing code - ClientParameterCode.CREDENTIALS_IDENTITY_PARENT", true);
        Object userNameObj = this.getObjectForParam(params, ClientParameterCode.CHAP_CREDENTIALS_USER_NAME, true);
        Object isRadiusEnableObj = this.getObjectForParam(params, ClientParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED, true);
        if (identityParent == null) {
            identityParent = credentials.getIdentityParent();
        }
        if (userNameObj == null) {
            userNameObj = credentials.getUserName();
        }
        if (isRadiusEnableObj == null) {
            boolean radiusEnable = ((CHAPCredentials)credentials).isRadiusEnabled();
            Object object = isRadiusEnableObj = radiusEnable ? new Integer(CHAP_RADIUS_ENABLED) : new Integer(CHAP_RADIUS_DISABLED);
        }
        if ((identity = (IdentityNode)SystemRootNode.getInstance().getRefByStub(identityParent)) == null && IdentityPurposeConstant.LOCAL_TARGET.equals((idenStub = identityParent).getPurpose())) {
            return null;
        }
        boolean isRadiusEnable = CHAP_RADIUS_ENABLED == (Integer)isRadiusEnableObj;
        CHAPCredentialsNode chapCredNode = new CHAPCredentialsNode((CHAPCredentials)credentials, (String)userNameObj, identityParent, isRadiusEnable);
        identity.addCredentials(chapCredNode);
        SystemRootNode.getInstance().putRefAndStub(credentials, chapCredNode);
        return chapCredNode;
    }

    private void removeCredentialsFromIdentityParent(CredentialsNode credNode) {
        Identity parentStub = credNode.getParentStub();
        SrTreeNode identity = SystemRootNode.getInstance().getRefByStub(parentStub);
        if (identity != null) {
            ((IdentityNode)identity).removeCredenrials(credNode);
            theLogger.trace(SrLogCategories.LEGACY, "removed credentials: ", credNode.getUserName(), " from identity parent");
        }
    }

    private void fireCredentialsCreatedEvent(CredentialsNode credNode) {
        CredentialsEvent event = new CredentialsEvent((Object)this, (RemoteObject)credNode.getStub(), credNode.getParentStub());
        this.m_listeners.fireEvent(CredentialsListener.class, event, this.credentialsCreatedInformer);
    }

    private void fireCredentialsRemovedEvent(CredentialsNode credNode) {
        CredentialsEvent event = new CredentialsEvent((Object)this, (RemoteObject)credNode.getStub(), credNode.getParentStub());
        this.m_listeners.fireEvent(CredentialsListener.class, event, this.credentialsRemovedInformer);
    }

    private void fireCredentialsNodeChanged(CredentialsNode credNode) {
        CredentialsEvent event = new CredentialsEvent((Object)this, (RemoteObject)credNode.getStub(), credNode.getParentStub());
        this.m_listeners.fireEvent(CredentialsListener.class, event, this.credentialsChangedInformer);
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        try {
            RemoteObject element = e.getElement();
            if (this.isClusterInDiscovery(element)) {
                return;
            }
            if (this.alreadyExist(element)) {
                return;
            }
            theLogger.trace(SrLogCategories.LEGACY, "CredentialsManager: Credentials created");
            HashMap params = this.getParameterList(e);
            CredentialsNode credentialsNode = this.createCredentialsNode((Credentials)element, params);
            if (credentialsNode != null) {
                theLogger.trace(SrLogCategories.LEGACY, "CredentialsManager: Credentials created - ", credentialsNode.getUserName());
                this.fireCredentialsCreatedEvent(credentialsNode);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
            CredentialsManager.onConnectionError();
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "CredentialsManager: Credentials removed");
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(element);
        if (node != null) {
            theLogger.trace(SrLogCategories.LEGACY, "CredentialsManager: Credentials removed - ", ((CredentialsNode)node).getUserName());
            this.removeCredentialsFromIdentityParent((CredentialsNode)node);
            this.fireCredentialsRemovedEvent((CredentialsNode)node);
            SystemRootNode.getInstance().removeRefAndIdByStub(element);
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "CredentialsManager: Credentials changed");
        HashMap map = this.getParameterList(e);
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(element);
        if (node != null) {
            if (node instanceof CHAPCredentialsNode) {
                Object userName;
                CHAPCredentialsNode credentialsNode = (CHAPCredentialsNode)node;
                Object radiusEnabled = this.getObjectForParam(map, ClientParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED, false);
                if (radiusEnabled != null) {
                    credentialsNode.setRadiusEnabled((Integer)radiusEnabled == CHAP_RADIUS_ENABLED);
                }
                if ((userName = this.getObjectForParam(map, ClientParameterCode.CHAP_CREDENTIALS_USER_NAME, false)) != null) {
                    credentialsNode.setUserName(userName.toString());
                }
                this.fireCredentialsNodeChanged(credentialsNode);
            } else {
                SRPCredentialsNode credentialsNode = (SRPCredentialsNode)node;
                Object userName = this.getObjectForParam(map, ClientParameterCode.SRP_CREDENTIALS_USER_NAME, false);
                if (userName != null) {
                    credentialsNode.setUserName(userName.toString());
                }
                this.fireCredentialsNodeChanged(credentialsNode);
            }
        }
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
    }

    static {
        CHAP_RADIUS_DISABLED = 1;
        CHAP_RADIUS_ENABLED = 2;
        theLogger = SrLogger.getLogger();
    }

    class SRPCredentialsEditor
    implements Callable<Void> {
        private CredentialsNode node;
        private HashMap myParams;

        public SRPCredentialsEditor(CredentialsNode credNode, HashMap params) {
            this.myParams = params;
            this.node = credNode;
        }

        @Override
        public Void call() throws Exception {
            ((SRPCredentials)this.node.getStub()).changeElement(this.myParams);
            return null;
        }
    }

    abstract class CredentialsCreator
    implements Callable<Void> {
        protected String userName;
        protected String password;
        protected IdentityNode identity;

        public CredentialsCreator(IdentityNode identity, String userName, String password) {
            this.password = password;
            this.userName = userName;
            this.identity = identity;
        }
    }
}

