/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.identity;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.identity.IdentityManager;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.identity.SrIdentityAuthenticationTableColumns;
import com.sanrad.nms.client.data.identity.auth.CHAPCredentialsNode;
import com.sanrad.nms.client.data.identity.auth.CredentialsManager;
import com.sanrad.nms.client.data.identity.auth.CredentialsNode;
import com.sanrad.nms.client.data.identity.auth.SRPCredentialsNode;
import com.sanrad.nms.client.event.identity.IdentityEvent;
import com.sanrad.nms.client.event.identity.IdentityListener;
import com.sanrad.nms.client.event.identity.IdentitySelectionEvent;
import com.sanrad.nms.client.event.identity.IdentitySelectionListener;
import com.sanrad.nms.client.event.identity.auth.CredentialsEvent;
import com.sanrad.nms.client.event.identity.auth.CredentialsListener;
import com.sanrad.nms.client.gui.identity.IdentityAuthenticationTableHeader;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.swing.SrTableModel;
import java.util.Vector;

public class SrIdentityAuthenticationTableModel
extends SrTableModel
implements IdentityListener,
IdentitySelectionListener,
CredentialsListener {
    private IdentityNode m_identityOwner;

    public SrIdentityAuthenticationTableModel() {
        super(new SrIdentityAuthenticationTableColumns());
    }

    public SrIdentityAuthenticationTableModel(IdentityNode aIdentity) {
        this();
        this.initModel(aIdentity);
    }

    private void initModel(IdentityNode identityNode) {
        this.m_identityOwner = identityNode;
        this.removeAllRows();
        if (identityNode != null) {
            Vector credentials = this.m_identityOwner.getCredentials();
            for (CredentialsNode node : credentials) {
                this.addCredentialsRow(node);
            }
            this.fireTableRowsInserted(0, this.getLastRowIndex());
        }
    }

    @Override
    public void removeListeners() {
        CredentialsManager.getInstance().removeCredentialsListener(this);
        IdentityManager.getInstance().removeIdentityListener(this);
    }

    @Override
    public void addListeners() {
        CredentialsManager.getInstance().addCredentialsListener(this);
        IdentityManager.getInstance().addIdentityListener(this);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        int radiusCol = this.getColumnIndex(IdentityAuthenticationTableHeader.RADIUS.getColumnName());
        int methodCol = this.getColumnIndex(IdentityAuthenticationTableHeader.METHOD.getColumnName());
        int userCol = this.getColumnIndex(IdentityAuthenticationTableHeader.USER_NAME.getColumnName());
        Object method = this.getValueAt(row, methodCol);
        Object userName = this.getValueAt(row, userCol);
        ClusterNode cluster = null;
        cluster = this.m_identityOwner != null ? SystemRootNode.getInstance().getClusterNodeOfSource(this.m_identityOwner) : SystemRootNode.getInstance().getCurrentClusterNode();
        boolean isRadiusEdiatable = cluster.getRadiusServers().size() > 0;
        isRadiusEdiatable = isRadiusEdiatable && !userName.equals("");
        return col == radiusCol && method instanceof CHAPCredentialsNode && isRadiusEdiatable;
    }

    protected void addCredentialsRow(CredentialsNode node) {
        Vector<Object> rowData = new Vector<Object>(2);
        rowData.addElement(node);
        rowData.addElement(node.getUserName());
        rowData.addElement(new Boolean(node.isRadiusEnabled()));
        this.addRowQuetly(rowData.toArray(), -1);
    }

    protected void removeCredentialsRow(CredentialsNode node) {
        int methodCol = this.getColumnIndex(IdentityAuthenticationTableHeader.METHOD.getColumnName());
        for (int i = 0; i < this.getRowCount(); ++i) {
            CredentialsNode nextCred = (CredentialsNode)this.getValueAt(i, methodCol);
            if (!nextCred.getStub().equals(node.getStub())) continue;
            this.removeRow(i);
            break;
        }
    }

    public CredentialsNode[] getSelectedCredentialsNodes(int[] indices) {
        CredentialsNode[] selected = new CredentialsNode[indices.length];
        int credCol = this.getColumnIndex(IdentityAuthenticationTableHeader.METHOD.getColumnName());
        for (int i = 0; i < indices.length; ++i) {
            selected[i] = (CredentialsNode)this.getValueAt(indices[i], credCol);
        }
        return selected;
    }

    @Override
    public void identitySelected(IdentitySelectionEvent event) {
        IdentityNode node = event.getIdentityNode();
        if (node != null) {
            this.initModel(node);
        }
    }

    @Override
    public void identityCreated(IdentityEvent e) {
    }

    @Override
    public void identityRemoved(IdentityEvent e) {
        if (this.m_identityOwner != null && this.m_identityOwner.getStub() != null && ((Identity)this.m_identityOwner.getStub()).equals(e.getStub())) {
            this.removeAllRows();
        }
    }

    @Override
    public void identityChanged(IdentityEvent e) {
    }

    @Override
    public void identityStatusChanged(IdentityEvent e) {
    }

    @Override
    public void credentialsCreated(CredentialsEvent e) {
        SrTreeNode credNode;
        Object stub = e.getParentStub();
        if (this.m_identityOwner != null && ((Identity)this.m_identityOwner.getStub()).equals(stub) && (credNode = SystemRootNode.getInstance().getRefByStub(e.getStub())) != null) {
            CredentialsNode node = (CredentialsNode)credNode;
            this.addCredentialsRow(node);
            this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
        }
    }

    @Override
    public void credentialsRemoved(CredentialsEvent e) {
        SrTreeNode credNode;
        Object stub = e.getParentStub();
        if (this.m_identityOwner != null && ((Identity)this.m_identityOwner.getStub()).equals(stub) && (credNode = SystemRootNode.getInstance().getRefByStub(e.getStub())) != null) {
            CredentialsNode node = (CredentialsNode)credNode;
            this.removeCredentialsRow(node);
        }
    }

    @Override
    public void credentialsChanged(CredentialsEvent e) {
        RemoteObject stub = e.getStub();
        SrTreeNode credentialsNode = SystemRootNode.getInstance().getRefByStub(stub);
        int credCol = this.getColumnIndex(IdentityAuthenticationTableHeader.METHOD.getColumnName());
        int radiusCol = this.getColumnIndex(IdentityAuthenticationTableHeader.RADIUS.getColumnName());
        int userCol = this.getColumnIndex(IdentityAuthenticationTableHeader.USER_NAME.getColumnName());
        if (credentialsNode != null) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.getValueAt(i, credCol).equals(credentialsNode)) continue;
                if (credentialsNode instanceof CHAPCredentialsNode) {
                    CHAPCredentialsNode chapNode = (CHAPCredentialsNode)credentialsNode;
                    this.setValueAt(new Boolean(chapNode.isRadiusEnabled()), i, radiusCol);
                    this.setValueAt(chapNode.getUserName(), i, userCol);
                } else {
                    SRPCredentialsNode srpNode = (SRPCredentialsNode)credentialsNode;
                    this.setValueAt(srpNode.getUserName(), i, userCol);
                }
                return;
            }
        }
    }

    public void clear() {
        this.removeAllRows();
    }
}

