/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.identity;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.acl.PolicyManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.event.acl.PolicyManagerEvent;
import com.sanrad.nms.client.event.identity.IdentityEvent;
import com.sanrad.nms.client.event.lu.LUEvent;
import com.sanrad.nms.client.gui.identity.IdentitiesTableHeader;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.swing.SrKeyObjectSelectionTableModel;
import com.sanrad.swing.SrTableColumns;
import com.sanrad.swing.table.KeyObject;
import com.sanrad.util.StorageSize;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Vector;

public class SrIdentitiesTableModel
extends SrKeyObjectSelectionTableModel {
    public SrIdentitiesTableModel(SrTableColumns cols) {
        super(cols);
    }

    public void refresh() {
    }

    protected void addNodeToTable(IdentityNode identityNode) {
        Vector<Object> rowData = new Vector<Object>();
        rowData.addElement(identityNode);
        String description = identityNode.getDescription().trim();
        rowData.addElement(new KeyObject(description));
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(identityNode);
        PolicyManager policyMgr = clusterNode.getPolicyManager();
        BigInteger totalReadWrite = policyMgr == null ? new BigInteger("0") : policyMgr.calculateTotalStorageAccess(identityNode, Permission.READ_WRITE);
        BigInteger totalReadOnly = policyMgr == null ? new BigInteger("0") : policyMgr.calculateTotalStorageAccess(identityNode, Permission.READ_ONLY);
        rowData.addElement(StorageSize.getSizeAsString(totalReadWrite));
        rowData.addElement(StorageSize.getSizeAsString(totalReadOnly));
        this.addRowQuetly(rowData.toArray(), -1);
    }

    protected void removeFromTable(IdentityNode identity) {
        int size = this.getRowCount();
        int aliasCol = this.getAliasColumn();
        for (int i = size - 1; i >= 0; --i) {
            IdentityNode identityNode = (IdentityNode)this.getValueAt(i, aliasCol);
            if (!((Identity)identityNode.getStub()).equals(identity.getStub())) continue;
            this.removeRow(i);
            break;
        }
    }

    protected int getAliasColumn() {
        return this.getColumnIndex(IdentitiesTableHeader.ALIAS.getColumnName());
    }

    public void removeIdentities(IdentityNode[] identities) {
        for (int i = 0; i < identities.length; ++i) {
            this.removeFromTable(identities[i]);
        }
    }

    public void addIdentities(Collection<IdentityNode> identities) {
        int currIndex = this.getLastRowIndex();
        for (IdentityNode identityNode : identities) {
            if (!identityNode.isDisplayed()) continue;
            this.addNodeToTable(identityNode);
        }
        this.fireTableRowsInserted(currIndex, this.getLastRowIndex());
    }

    public void updateTableData() {
        int rows = this.getRowCount();
        int totalRWcol = this.getColumnIndex(IdentitiesTableHeader.TOTAL_R_W.getColumnName());
        int totalROcol = this.getColumnIndex(IdentitiesTableHeader.TOTAL_R_O.getColumnName());
        int identityCol = this.getColumnIndex(IdentitiesTableHeader.ALIAS.getColumnName());
        for (int i = 0; i < rows; ++i) {
            IdentityNode identity = (IdentityNode)this.getValueAt(i, identityCol);
            ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(identity);
            PolicyManager policyMgr = clusterNode.getPolicyManager();
            BigInteger totalReadWrite = policyMgr.calculateTotalStorageAccess(identity, Permission.READ_WRITE);
            BigInteger totalReadOnly = policyMgr.calculateTotalStorageAccess(identity, Permission.READ_ONLY);
            this.setValueAt(StorageSize.getSizeAsString(totalReadWrite), i, totalRWcol);
            this.setValueAt(StorageSize.getSizeAsString(totalReadOnly), i, totalROcol);
        }
    }

    private void updateTableData(IdentityNode identityNode) {
        int rows = this.getRowCount();
        int totalRWcol = this.getColumnIndex(IdentitiesTableHeader.TOTAL_R_W.getColumnName());
        int totalROcol = this.getColumnIndex(IdentitiesTableHeader.TOTAL_R_O.getColumnName());
        int identityCol = this.getColumnIndex(IdentitiesTableHeader.ALIAS.getColumnName());
        for (int i = 0; i < rows; ++i) {
            ClusterNode clusterNode;
            PolicyManager policyMgr;
            IdentityNode identity = (IdentityNode)this.getValueAt(i, identityCol);
            if (!identity.equals(identityNode) || (policyMgr = (clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(identity)).getPolicyManager()) == null) continue;
            BigInteger totalReadWrite = policyMgr.calculateTotalStorageAccess(identity, Permission.READ_WRITE);
            BigInteger totalReadOnly = policyMgr.calculateTotalStorageAccess(identity, Permission.READ_ONLY);
            this.setValueAt(StorageSize.getSizeAsString(totalReadWrite), i, totalRWcol);
            this.setValueAt(StorageSize.getSizeAsString(totalReadOnly), i, totalROcol);
        }
    }

    public void identityCreated(IdentityEvent e) {
        RemoteObject stub = e.getStub();
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(stub);
        IdentityNode identityNode = (IdentityNode)node;
        if (identityNode != null && identityNode.isDisplayed()) {
            this.addNodeToTable((IdentityNode)node);
        }
        this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
    }

    public void identityRemoved(IdentityEvent e) {
        RemoteObject stub = e.getStub();
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(stub);
        if (node != null) {
            IdentityNode identityNode = (IdentityNode)node;
            this.removeFromTable(identityNode);
        }
    }

    public void identityChanged(IdentityEvent e) {
        int size = this.getRowCount();
        int aliasCol = this.getColumnIndex(IdentitiesTableHeader.ALIAS.getColumnName());
        int descriptionCol = this.getColumnIndex(IdentitiesTableHeader.DESCRIPTION.getColumnName());
        for (int i = 0; i < size; ++i) {
            Object value = this.getValueAt(i, aliasCol);
            if (!e.getStub().equals(((IdentityNode)value).getStub())) continue;
            this.setValueAt(new KeyObject(e.getDescription()), i, descriptionCol);
            this.fireTableCellUpdated(i, aliasCol);
            break;
        }
    }

    public void identityStatusChanged(IdentityEvent e) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    public void removedLU(LUEvent event) {
        this.updateTableData();
    }

    public void changeLU(LUEvent event) {
    }

    public void createdLU(LUEvent event) {
        this.updateTableData();
    }

    public void statusChanged(LUEvent event) {
    }

    public void aclEntryCreated(PolicyManagerEvent e) {
        IdentityNode identity = e.getAclEntryNode().getIdentity();
        this.updateTableData(identity);
    }

    public void aclEntryRemoved(PolicyManagerEvent e) {
        IdentityNode identity = e.getAclEntryNode().getIdentity();
        this.updateTableData(identity);
    }

    public void aclMapRefreshed(PolicyManagerEvent e) {
    }

    public void aclEntryChanged(PolicyManagerEvent e) {
        IdentityNode identity = e.getAclEntryNode().getIdentity();
        this.updateTableData(identity);
    }

    @Override
    public void removeListeners() {
    }

    @Override
    public void addListeners() {
    }
}

