/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.identity;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.acl.PolicyManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.identity.IdentityManager;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.identity.SrIdentitiesTableModel;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.event.acl.PolicyManagerEvent;
import com.sanrad.nms.client.event.acl.PolicyManagerListener;
import com.sanrad.nms.client.event.identity.IdentityListener;
import com.sanrad.nms.client.gui.identity.AvailableIdentitiesTableHeader;
import com.sanrad.swing.SrTableColumns;
import java.util.Vector;

public class SrAvailableIdentitiesTableModel
extends SrIdentitiesTableModel
implements PolicyManagerListener,
IdentityListener {
    private TargetNode m_targetNode;

    public SrAvailableIdentitiesTableModel(SrTableColumns cols, TargetNode targetNode) {
        super(cols);
        this.m_targetNode = targetNode;
        this.initModel();
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(this.m_targetNode);
        PolicyManager policyMgr = clusterNode.getPolicyManager();
        policyMgr.addPolicyManagerListener(this);
        IdentityManager.getInstance().addIdentityListener(this);
    }

    @Override
    public void removeListeners() {
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(this.m_targetNode);
        PolicyManager policyMgr = clusterNode.getPolicyManager();
        policyMgr.removePolicyManagerListener(this);
        IdentityManager.getInstance().removeIdentityListener(this);
    }

    protected void initModel() {
        this.removeAllRows();
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(this.m_targetNode);
        if (clusterNode == null) {
            return;
        }
        PolicyManager policyMgr = clusterNode.getPolicyManager();
        Vector<IdentityNode> availableIdentities = policyMgr.getAvailableIdentitiesForTarget(this.m_targetNode);
        for (int i = 0; i < availableIdentities.size(); ++i) {
            this.addNodeToTable(availableIdentities.get(i));
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    @Override
    public void refresh() {
        this.initModel();
    }

    @Override
    protected void addNodeToTable(IdentityNode identity) {
        Vector<Object> rowData = new Vector<Object>();
        if (identity.isDisplayed()) {
            rowData.addElement(identity);
            rowData.addElement(identity.getDescription());
            this.addRowQuetly(rowData.toArray(), -1);
        }
    }

    @Override
    protected int getAliasColumn() {
        return this.getColumnIndex(AvailableIdentitiesTableHeader.ALIAS.getColumnName());
    }

    @Override
    public void aclMapRefreshed(PolicyManagerEvent e) {
        this.initModel();
    }

    @Override
    public void aclEntryCreated(PolicyManagerEvent e) {
        this.initModel();
    }

    @Override
    public void aclEntryChanged(PolicyManagerEvent e) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    @Override
    public void aclEntryRemoved(PolicyManagerEvent e) {
        this.initModel();
    }

    public void clear() {
        this.removeAllRows();
    }
}

