/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.identity;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.identity.IdentityNameNode;
import com.sanrad.nms.client.data.identity.auth.CredentialsNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.IdentityPurposeConstant;
import java.rmi.RemoteException;
import java.util.Vector;

public class IdentityNode
extends SrTreeNode<Identity, CommKeyClassId>
implements Comparable {
    private String alias;
    private String description;
    private IdentityPurposeConstant m_purpose;
    private Vector names = new Vector();
    private Vector credentials = new Vector();

    public IdentityNode(Identity stub) throws RemoteException {
        super(stub, stub.getCommKeyClassId());
        this.initNodeIcon();
    }

    public IdentityNode(Identity stub, String alias, String description, IdentityPurposeConstant purpose) throws RemoteException {
        this(stub);
        this.setAlias(alias);
        this.description = description;
        this.m_purpose = purpose;
        this.initNodeIcon();
    }

    private void initNodeIcon() {
        this.setNodeIcon(ClientImageObject.IDENTITIES);
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setPurpose(IdentityPurposeConstant purpose) {
        this.m_purpose = purpose;
    }

    public IdentityPurposeConstant getPurpose() {
        return this.m_purpose;
    }

    public Vector getNames() {
        return this.names;
    }

    public Vector getCredentials() {
        return this.credentials;
    }

    public void addName(IdentityNameNode name) {
        this.names.addElement(name);
    }

    public void removeName(IdentityNameNode identityNameNode) {
        this.names.remove(identityNameNode);
    }

    public void addCredentials(CredentialsNode credNode) {
        this.credentials.addElement(credNode);
    }

    public void removeCredenrials(CredentialsNode credNode) {
        this.credentials.remove(credNode);
    }

    @Override
    public String type() {
        return "Host Group";
    }

    @Override
    public String toString() {
        return this.alias.trim();
    }

    @Override
    public int compareTo(Object o) {
        int answer = Integer.MIN_VALUE;
        if (o instanceof IdentityNode) {
            IdentityNode comp2 = (IdentityNode)o;
            String val1 = this.getAlias();
            answer = val1.compareTo(comp2.getAlias());
        }
        return answer;
    }

    public boolean isDisplayed() {
        return !this.getAlias().equals("DEF_ALL") && !this.getAlias().startsWith("SELF") && !this.getAlias().startsWith("DR") && !this.getPurpose().equals(IdentityPurposeConstant.REMOTE_INITIATOR_DR) && (!this.getPurpose().equals(IdentityPurposeConstant.UNKNOWN) || !this.getAlias().startsWith(IdentityPurposeConstant.REMOTE_INITIATOR_DR.getDescriptionName())) && !this.getPurpose().equals(IdentityPurposeConstant.LOCAL_INITIATOR) && !this.getPurpose().equals(IdentityPurposeConstant.REMOTE_TARGET);
    }
}

