/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.identity;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.identity.IdentityNameManager;
import com.sanrad.nms.client.data.identity.IdentityNameNode;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.event.identity.IdentityNameEvent;
import com.sanrad.nms.client.event.identity.IdentityNameListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;

public class IdentityNamesListModel
extends DefaultListModel
implements IdentityNameListener {
    private IdentityNode identityParent;

    public IdentityNamesListModel(IdentityNode identityParent) {
        this.identityParent = identityParent;
        this.initModel(identityParent);
    }

    protected void initModel(IdentityNode identityParent) {
        if (identityParent != null) {
            Vector names = identityParent.getNames();
            Iterator iter = names.iterator();
            while (iter.hasNext()) {
                this.addElement(iter.next());
            }
        }
    }

    public void removeListeners() {
        IdentityNameManager.getInstance().removeIdentityNameListener(this);
    }

    public void addListeners() {
        IdentityNameManager.getInstance().addIdentityNameListener(this);
    }

    @Override
    public void identityNameCreated(IdentityNameEvent e) {
        SrTreeNode node;
        if (e.getParentStub().equals(this.identityParent.getStub()) && (node = SystemRootNode.getInstance().getRefByStub(e.getStub())) != null) {
            IdentityNameNode identityNameNode = (IdentityNameNode)node;
            this.addElement(identityNameNode);
        }
    }

    @Override
    public void identityNameRemoved(IdentityNameEvent e) {
        SrTreeNode node;
        if (e.getParentStub().equals(this.identityParent.getStub()) && (node = SystemRootNode.getInstance().getRefByStub(e.getStub())) != null) {
            IdentityNameNode identityNameNode = (IdentityNameNode)node;
            this.removeElement(identityNameNode);
        }
    }
}

