/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.identity;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.identity.IdentityNameNode;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.client.event.identity.IdentityNameEvent;
import com.sanrad.nms.client.event.identity.IdentityNameListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.identity.IdentityName;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;

public class IdentityNameManager
extends ElementManager {
    private static IdentityNameManager instance;
    private static SrLogger theLogger;
    SrEventListenerManager.Informer identityNameCreatedInformer = new SrEventListenerManager.Informer<IdentityNameListener, IdentityNameEvent>(){

        @Override
        public void inform(IdentityNameListener listener, IdentityNameEvent event) {
            listener.identityNameCreated(event);
        }
    };
    SrEventListenerManager.Informer identityNameRemovedInformer = new SrEventListenerManager.Informer<IdentityNameListener, IdentityNameEvent>(){

        @Override
        public void inform(IdentityNameListener listener, IdentityNameEvent event) {
            listener.identityNameRemoved(event);
        }
    };

    private IdentityNameManager() {
    }

    public static synchronized IdentityNameManager getInstance() {
        if (instance == null) {
            instance = new IdentityNameManager();
        }
        return instance;
    }

    public void addIdentityNameListener(IdentityNameListener l) {
        this.m_listeners.add(l);
    }

    public void removeIdentityNameListener(IdentityNameListener l) {
        this.m_listeners.remove(l);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    public void readAllIdentitiesNames(Vector identities) {
        for (int i = 0; i < identities.size(); ++i) {
            try {
                IdentityNode identityNode = (IdentityNode)identities.get(i);
                Vector<? extends IdentityName> names = ((Identity)identityNode.getStub()).getIdentityNames();
                for (int j = 0; j < names.size(); ++j) {
                    this.createIdentityNameNode(names.get(j), null);
                }
                continue;
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                IdentityNameManager.onConnectionError(re.getMessage());
            }
        }
    }

    public SrFuture<Void> createIdentityName(IdentityNode identityNode, String name) {
        return ClientAOImpl.getInstance().createIdentityName((CommKeyClassId)identityNode.getIdentifier(), name);
    }

    protected IdentityNameNode createIdentityNameNode(IdentityName stub, HashMap map) throws RemoteException {
        Object nameObj = this.getObjectForParam(map, "Missing code - ClientParameterCode.IDENTITY_NAME", true);
        Identity identityParentObj = (Identity)this.getObjectForParam(map, "Missing code - ClientParameterCode.IDENTITY_PARENT", true);
        if (nameObj == null) {
            nameObj = stub.getName();
        }
        if (identityParentObj == null) {
            identityParentObj = stub.getIdentityParent();
        }
        String name = (String)nameObj;
        IdentityNameNode identityNameNode = new IdentityNameNode(stub, name, identityParentObj);
        StringBuffer sb = new StringBuffer("IdentityNamesManager: created Identity name: ");
        sb.append(name);
        theLogger.trace(SrLogCategories.LEGACY, sb);
        SystemRootNode.getInstance().putRefAndStub(stub, identityNameNode);
        SrTreeNode parentIdentity = SystemRootNode.getInstance().getRefByStub(identityParentObj);
        if (parentIdentity != null) {
            ((IdentityNode)parentIdentity).addName(identityNameNode);
        }
        return identityNameNode;
    }

    protected void fireIdentityNameCreatedEvent(IdentityNameNode identityNameNode) {
        IdentityNameEvent event = new IdentityNameEvent((Object)this, (RemoteObject)identityNameNode.getStub(), identityNameNode.getParentStub());
        this.m_listeners.fireEvent(IdentityNameListener.class, event, this.identityNameCreatedInformer);
    }

    protected void fireIdentityNameRemovedEvent(IdentityNameNode identityNameNode) {
        IdentityNameEvent event = new IdentityNameEvent((Object)this, (RemoteObject)identityNameNode.getStub(), identityNameNode.getParentStub());
        this.m_listeners.fireEvent(IdentityNameListener.class, event, this.identityNameRemovedInformer);
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        try {
            RemoteObject element = e.getElement();
            if (this.isClusterInDiscovery(element)) {
                return;
            }
            if (this.alreadyExist(element)) {
                return;
            }
            theLogger.trace(SrLogCategories.LEGACY, "IdentityNameManager: IdentityName created");
            HashMap map = this.getParameterList(e);
            IdentityNameNode identityNameNode = this.createIdentityNameNode((IdentityName)element, map);
            theLogger.trace(SrLogCategories.LEGACY, "IdentityNameManager: IdentityName created - ", identityNameNode.getName());
            this.fireIdentityNameCreatedEvent(identityNameNode);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
            IdentityNameManager.onConnectionError();
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "IdentityNameManager: identity name removed");
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(element);
        if (node != null) {
            IdentityNameNode identityNameNode = (IdentityNameNode)node;
            theLogger.trace(SrLogCategories.LEGACY, "IdentityNameManager: identity name removed - ", identityNameNode.getName());
            SrTreeNode parent = SystemRootNode.getInstance().getRefByStub(identityNameNode.getParentStub());
            if (parent != null) {
                ((IdentityNode)parent).removeName(identityNameNode);
            }
            this.fireIdentityNameRemovedEvent(identityNameNode);
            SystemRootNode.getInstance().removeRefAndIdByStub(element);
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
    }

    static {
        theLogger = SrLogger.getLogger();
    }
}

