/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.identity;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.identity.IdentitiesTableModelCollection;
import com.sanrad.nms.client.data.identity.IdentityNameManager;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.identity.auth.CredentialsManager;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.client.event.identity.IdentityEvent;
import com.sanrad.nms.client.event.identity.IdentityListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.IdentityPurposeConstant;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class IdentityManager
extends ElementManager {
    private static IdentityManager instance;
    SrEventListenerManager.Informer identityCreatedInformer = new SrEventListenerManager.Informer<IdentityListener, IdentityEvent>(){

        @Override
        public void inform(IdentityListener listener, IdentityEvent event) {
            listener.identityCreated(event);
        }
    };
    SrEventListenerManager.Informer identityChangedInformer = new SrEventListenerManager.Informer<IdentityListener, IdentityEvent>(){

        @Override
        public void inform(IdentityListener listener, IdentityEvent event) {
            listener.identityChanged(event);
        }
    };
    SrEventListenerManager.Informer identityRemovedInformer = new SrEventListenerManager.Informer<IdentityListener, IdentityEvent>(){

        @Override
        public void inform(IdentityListener listener, IdentityEvent event) {
            listener.identityRemoved(event);
        }
    };
    SrEventListenerManager.Informer identityStatusChangedInformer = new SrEventListenerManager.Informer<IdentityListener, IdentityEvent>(){

        @Override
        public void inform(IdentityListener listener, IdentityEvent event) {
            listener.identityStatusChanged(event);
        }
    };
    private Hashtable<Integer, Vector<IdentityNode>> allIdentitiesNodes = new Hashtable();
    private static SrLogger theLogger;
    public static final String DEF_ALL = "DEF_ALL";
    public static final String SELF = "SELF";
    public static final String DR = "DR";

    private IdentityManager() {
    }

    public static synchronized IdentityManager getInstance() {
        if (instance == null) {
            instance = new IdentityManager();
        }
        return instance;
    }

    private Hashtable<Integer, Vector<IdentityNode>> getAllIdentities() {
        return this.allIdentitiesNodes;
    }

    public Vector<IdentityNode> getAllIdentities(ClusterNode clusterNode) {
        Vector<IdentityNode> allIdentities = this.getAllIdentities().get(clusterNode.getVSwitchGroupId());
        if (allIdentities == null) {
            allIdentities = new Vector();
        }
        return allIdentities;
    }

    public void clearIdentities(ClusterNode clusterNode) {
        Vector<IdentityNode> identitiesNodes = this.getAllIdentities(clusterNode);
        for (int i = 0; i < identitiesNodes.size(); ++i) {
            this.fireIdentityRemovedEvent(identitiesNodes.get(i));
        }
        identitiesNodes.clear();
        IdentitiesTableModelCollection.getInstance().clearModelOf(clusterNode);
    }

    public void clearIdentities() {
        Enumeration<ClusterNode> e = SystemRootNode.getInstance().getClusterNodes().elements();
        while (e.hasMoreElements()) {
            ClusterNode clusterNode = e.nextElement();
            this.clearIdentities(clusterNode);
        }
    }

    public void addIdentityListener(IdentityListener l) {
        this.m_listeners.add(l);
    }

    public void removeIdentityListener(IdentityListener l) {
        this.m_listeners.remove(l);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    private Vector getIdentitiesOf(IdentityNode identityNode) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(identityNode);
        return this.getAllIdentities(clusterNode);
    }

    public void readAllIdentities(ClusterNode clusterNode, boolean broadcast) {
        Vector identities = ClusterManager.getInstance().getAllIdentities(clusterNode);
        Vector<IdentityNode> identitiesNodes = new Vector<IdentityNode>(identities.size());
        for (int i = 0; i < identities.size(); ++i) {
            Identity identity = (Identity)identities.get(i);
            IdentityNode identityNode = this.createIdentityNode(identity, null);
            if (identityNode == null || "#forTarget#".equalsIgnoreCase(identityNode.getDescription()) || identityNode.getDescription() == null && identityNode.getAlias() == null && identityNode.getPurpose() == null) continue;
            identitiesNodes.addElement(identityNode);
            if (!broadcast) continue;
            this.fireIdentityCreatedEvent(identityNode);
        }
        IdentityNameManager.getInstance().readAllIdentitiesNames(identitiesNodes);
        CredentialsManager.getInstance().readAllCredentials(identitiesNodes);
        this.getAllIdentities().put(clusterNode.getVSwitchGroupId(), identitiesNodes);
    }

    public void readAllIdentities(boolean broadcast) {
        this.getAllIdentities().clear();
        Enumeration<ClusterNode> e = SystemRootNode.getInstance().getClusterNodes().elements();
        while (e.hasMoreElements()) {
            ClusterNode clusterNode = e.nextElement();
            this.readAllIdentities(clusterNode, broadcast);
        }
    }

    public SrFuture<Void> createIdentity(ClusterNode cluster, String alias, String description) {
        return ClientAOImpl.getInstance().createIdentity((CommKeyClassId)cluster.getIdentifier(), alias, description);
    }

    public SrFuture<Void> editIdentity(IdentityNode identityNode, HashMap parametersMap) {
        return ClientAOImpl.getInstance().changeElements(Collections.singleton(identityNode.getIdentifier()), parametersMap);
    }

    private IdentityNode createIdentityNode(Identity stub, HashMap params) {
        try {
            Object newAlias = this.getObjectForParam(params, ClientParameterCode.IDENTITY_ALIAS, true);
            Object newDescription = this.getObjectForParam(params, ClientParameterCode.IDENTITY_DESCRIPTION, true);
            Object newPurpose = this.getObjectForParam(params, ClientParameterCode.IDENTITY_PURPOSE, true);
            Object propagatedState = this.getObjectForParam(params, "Missing code - ClientParameterCode.PROPAGATED_STATE", true);
            if (newAlias == null) {
                newAlias = stub.getAlias();
            }
            if (newDescription == null) {
                newDescription = stub.getDescription();
            }
            if (newPurpose == null) {
                newPurpose = stub.getPurpose();
            }
            if (propagatedState == null) {
                propagatedState = stub.getPropagatedState();
            }
            if (((IdentityPurposeConstant)newPurpose).equals(IdentityPurposeConstant.LOCAL_TARGET)) {
                return null;
            }
            String alias = (String)newAlias;
            String description = (String)newDescription;
            IdentityNode node = new IdentityNode(stub, alias, description, (IdentityPurposeConstant)newPurpose);
            node.setStatus(IdentityManager.getSeverity((AlarmSeverity)propagatedState));
            StringBuffer sb = new StringBuffer("IdentityManager: created Identity: ");
            sb.append(alias);
            sb.append(", ");
            sb.append(description);
            theLogger.trace(SrLogCategories.LEGACY, sb);
            SystemRootNode.getInstance().putRefAndStub(stub, node);
            return node;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, "IdentityManager: failed to create a proper IdentityNode.");
            IdentityManager.onConnectionError();
            return null;
        }
    }

    private void fireIdentityCreatedEvent(IdentityNode node) {
        IdentityEvent event = new IdentityEvent(this, (RemoteObject)node.getStub(), node.getAlias(), node.getDescription());
        this.m_listeners.fireEvent(IdentityListener.class, event, this.identityCreatedInformer);
    }

    private void fireIdentityNodeChanged(IdentityNode identityNode) {
        IdentityEvent event = new IdentityEvent(this, (RemoteObject)identityNode.getStub(), identityNode.getAlias(), identityNode.getDescription());
        this.m_listeners.fireEvent(IdentityListener.class, event, this.identityChangedInformer);
    }

    private void fireIdentityRemovedEvent(IdentityNode node) {
        IdentityEvent event = new IdentityEvent(this, (RemoteObject)node.getStub(), node.getAlias(), node.getDescription());
        this.m_listeners.fireEvent(IdentityListener.class, event, this.identityRemovedInformer);
    }

    private void fireIdentityStatusChanged(IdentityNode node) {
        IdentityEvent event = new IdentityEvent(this, (RemoteObject)node.getStub(), node.getAlias(), node.getDescription());
        this.m_listeners.fireEvent(IdentityListener.class, event, this.identityStatusChangedInformer);
    }

    public void notifyIdentitiesCreated() {
        Enumeration<ClusterNode> e1 = SystemRootNode.getInstance().getClusterNodes().elements();
        while (e1.hasMoreElements()) {
            ClusterNode clusterNode = e1.nextElement();
            Vector<IdentityNode> identitiesNodes = this.getAllIdentities(clusterNode);
            Enumeration<IdentityNode> e2 = identitiesNodes.elements();
            while (e2.hasMoreElements()) {
                IdentityNode identityNode = e2.nextElement();
                this.fireIdentityCreatedEvent(identityNode);
            }
        }
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        String identityDesc;
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "IdentityManager: Identity created");
        HashMap params = this.getParameterList(e);
        IdentityNode identityNode = this.createIdentityNode((Identity)element, params);
        String string = identityDesc = identityNode != null ? identityNode.getDescription() : null;
        if (identityDesc != null && !"#forTarget#".equalsIgnoreCase(identityDesc)) {
            Vector identitiesNodes = this.getIdentitiesOf(identityNode);
            identitiesNodes.addElement(identityNode);
            theLogger.trace(SrLogCategories.LEGACY, "IdentityManager: Identity created- ", identityNode.getAlias());
            this.fireIdentityCreatedEvent(identityNode);
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "IdentityManager: identity removed");
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(element);
        if (node != null) {
            theLogger.trace(SrLogCategories.LEGACY, "IdentityManager: Identity removed- ", ((IdentityNode)node).getAlias());
            this.fireIdentityRemovedEvent((IdentityNode)node);
            Vector identitiesNodes = this.getIdentitiesOf((IdentityNode)node);
            identitiesNodes.remove(node);
            SystemRootNode.getInstance().removeRefAndIdByStub(element);
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "IdentityManager: identity changed");
        HashMap map = this.getParameterList(e);
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(element);
        if (node != null) {
            Object newPurpose;
            Object newDescription;
            IdentityNode identityNode = (IdentityNode)node;
            Object newAlias = this.getObjectForParam(map, ClientParameterCode.IDENTITY_ALIAS, false);
            if (newAlias != null) {
                theLogger.trace(SrLogCategories.LEGACY, "IdentityManager: identity changed - ", identityNode.getAlias());
                identityNode.setAlias(newAlias.toString());
                theLogger.trace(SrLogCategories.LEGACY, "IdentityManager:  changed the alias to - ", identityNode.getAlias());
            }
            if ((newDescription = this.getObjectForParam(map, ClientParameterCode.IDENTITY_DESCRIPTION, false)) != null) {
                theLogger.trace(SrLogCategories.LEGACY, "IdentityManager: identity changed description - ", identityNode.getDescription());
                identityNode.setDescription(newDescription.toString());
                theLogger.trace(SrLogCategories.LEGACY, "IdentityManager: identity changed the description to - ", identityNode.getDescription());
            }
            if ((newPurpose = this.getObjectForParam(map, ClientParameterCode.IDENTITY_PURPOSE, false)) != null) {
                theLogger.trace(SrLogCategories.LEGACY, "IdentityManager: identity changed purpose - ", identityNode.getPurpose());
                identityNode.setPurpose((IdentityPurposeConstant)newPurpose);
                theLogger.trace(SrLogCategories.LEGACY, "IdentityManager: identity changed the purpose to - ", identityNode.getPurpose());
            }
            this.fireIdentityNodeChanged(identityNode);
        }
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
        RemoteObject element = e.getStub();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (element instanceof Identity) {
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(element);
            if (node == null) {
                theLogger.trace(SrLogCategories.LEGACY, "IdentityManager- propagatedStateChanged() on an unknown element !");
                return;
            }
            theLogger.trace(SrLogCategories.LEGACY, "IdentityManager: propagatedStateChanged().");
            super.propagatedStateChanged(e);
            this.fireIdentityStatusChanged((IdentityNode)node);
        }
    }

    static {
        theLogger = SrLogger.getLogger();
    }
}

