/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.identity;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.LUManager;
import com.sanrad.nms.client.data.ModelCollection;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.acl.AclEntryNode;
import com.sanrad.nms.client.data.acl.PolicyManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.identity.IdentityManager;
import com.sanrad.nms.client.data.identity.SrIdentitiesTableModel;
import com.sanrad.nms.client.event.acl.PolicyManagerEvent;
import com.sanrad.nms.client.event.acl.PolicyManagerListener;
import com.sanrad.nms.client.event.identity.IdentityEvent;
import com.sanrad.nms.client.event.identity.IdentityListener;
import com.sanrad.nms.client.event.lu.LUEvent;
import com.sanrad.nms.client.event.lu.LUListener;
import com.sanrad.nms.client.gui.identity.IdentitiesTableHeader;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.swing.SrDefaultTableColumns;
import java.util.Vector;

public class IdentitiesTableModelCollection
extends ModelCollection
implements IdentityListener,
LUListener,
PolicyManagerListener {
    private static IdentitiesTableModelCollection theInstance = null;
    private static SrLogger theLogger = SrLogger.getLogger();

    private IdentitiesTableModelCollection() {
        IdentityManager.getInstance().addIdentityListener(this);
        LUManager.getInstance().addLUListener(this);
        Vector<ClusterNode> clusters = SystemRootNode.getInstance().getClusterNodes();
        for (int i = 0; i < clusters.size(); ++i) {
            ClusterNode clusterNode = clusters.get(i);
            PolicyManager policyMgr = clusterNode.getPolicyManager();
            if (policyMgr != null) {
                policyMgr.addPolicyManagerListener(this);
                continue;
            }
            theLogger.warn(SrLogCategories.LEGACY, "Policy Manager is null for cluster ", clusterNode.getAlias(), "in IdentitiesTableModelCollection()");
        }
    }

    public static synchronized IdentitiesTableModelCollection getInstance() {
        if (theInstance == null) {
            theInstance = new IdentitiesTableModelCollection();
        }
        return theInstance;
    }

    protected Object creatNewModel(ClusterNode aClusterNode) {
        SrIdentitiesTableModel model = new SrIdentitiesTableModel(new SrDefaultTableColumns(IdentitiesTableHeader.getColumnNames()));
        return model;
    }

    protected void clearModel(Object model) {
    }

    public void recalculateTotalReadWriteData(ClusterNode clusterNode) {
        ((SrIdentitiesTableModel)this.getModel((RemoteObject)clusterNode.getStub())).updateTableData();
    }

    @Override
    public void luCreated(LUEvent event) {
        ((SrIdentitiesTableModel)this.getModel(event)).createdLU(event);
    }

    @Override
    public void luRemoved(LUEvent event) {
        ((SrIdentitiesTableModel)this.getModel(event)).removedLU(event);
    }

    @Override
    public void luChanged(LUEvent event) {
        ((SrIdentitiesTableModel)this.getModel(event)).changeLU(event);
    }

    @Override
    public void luStatusChanged(LUEvent event) {
        ((SrIdentitiesTableModel)this.getModel(event)).statusChanged(event);
    }

    @Override
    public void identityChanged(IdentityEvent event) {
        ((SrIdentitiesTableModel)this.getModel(event)).identityChanged(event);
    }

    @Override
    public void identityCreated(IdentityEvent event) {
        ((SrIdentitiesTableModel)this.getModel(event)).identityCreated(event);
    }

    @Override
    public void identityRemoved(IdentityEvent event) {
        ((SrIdentitiesTableModel)this.getModel(event)).identityRemoved(event);
    }

    @Override
    public void identityStatusChanged(IdentityEvent event) {
        ((SrIdentitiesTableModel)this.getModel(event)).identityStatusChanged(event);
    }

    @Override
    public void aclEntryCreated(PolicyManagerEvent e) {
        ((SrIdentitiesTableModel)this.getModel((RemoteObject)e.getAclEntryNode().getStub())).aclEntryCreated(e);
    }

    @Override
    public void aclEntryRemoved(PolicyManagerEvent e) {
        ((SrIdentitiesTableModel)this.getModel((RemoteObject)e.getAclEntryNode().getStub())).aclEntryRemoved(e);
    }

    @Override
    public void aclMapRefreshed(PolicyManagerEvent e) {
        AclEntryNode aclNode = e.getAclEntryNode();
        if (aclNode != null) {
            ((SrIdentitiesTableModel)this.getModel((RemoteObject)aclNode.getStub())).aclMapRefreshed(e);
        } else {
            ((SrIdentitiesTableModel)this.getModel(SystemRootNode.getInstance().getCurrentClusterNode())).aclMapRefreshed(e);
        }
    }

    @Override
    public void aclEntryChanged(PolicyManagerEvent e) {
        ((SrIdentitiesTableModel)this.getModel((RemoteObject)e.getAclEntryNode().getStub())).aclEntryChanged(e);
    }

    public Object getCurrentModel() {
        return super.getCurrentModel();
    }
}

