/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.hardware;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.hardware.HardwareData;
import com.sanrad.nms.client.event.hardware.HardwareDataEvent;
import com.sanrad.nms.client.event.hardware.HardwareDataListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.util.SrEventListenerManager;
import java.util.HashMap;

public class HardwareManager
extends ElementManager {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static HardwareManager m_instance = null;
    SrEventListenerManager.Informer hardwareDataChangedInformer = new SrEventListenerManager.Informer<HardwareDataListener, HardwareDataEvent>(){

        @Override
        public void inform(HardwareDataListener listener, HardwareDataEvent event) {
            listener.hardwareDataChanged(event);
        }
    };

    private HardwareManager() {
    }

    public static synchronized HardwareManager getInstance() {
        if (m_instance == null) {
            m_instance = new HardwareManager();
        }
        return m_instance;
    }

    public void addHardwareListener(HardwareDataListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeHardwareListener(HardwareDataListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        HashMap map = this.getParameterList(e);
        Object changedPowerSuppliersMaxNumber = this.getObjectForParam(map, ClientParameterCode.HW_POWER_SUPPLIERS_MAX_NUMBER, false);
        Object changedPowerSuppliersCurrentWorkingNumber = this.getObjectForParam(map, ClientParameterCode.HW_POWER_SUPPLIERS_CURRENT_NUMBER_WORKING, false);
        Object changedFANsMaxNumber = this.getObjectForParam(map, ClientParameterCode.HW_FANS_MAX_NUMBER, false);
        Object changedFANsCurrentWorkingNumber = this.getObjectForParam(map, ClientParameterCode.HW_FANS_CURRENT_NUMBER_WORKING, false);
        Object changedOnboardTemperature = this.getObjectForParam(map, ClientParameterCode.HW_ONBOARD_TEMPERATURE, false);
        Object changedCPUTemperature = this.getObjectForParam(map, ClientParameterCode.HW_CPU_TEMPERATURE, false);
        Object changedOnboardFactoryTemperatureThresh = this.getObjectForParam(map, ClientParameterCode.HW_ONBOARD_FACTORY_TEMPERATURE_THRESH, false);
        Object changedCPUFactoryTemperatureThresh = this.getObjectForParam(map, ClientParameterCode.HW_CPU_FACTORY_TEMPERATURE_THRESH, false);
        Object changedOnboardWarningTemperatureThresh = this.getObjectForParam(map, ClientParameterCode.HW_ONBOARD_WARNING_TEMPERATURE_THRESH, false);
        Object changedCPUWarningTemperatureThresh = this.getObjectForParam(map, ClientParameterCode.HW_CPU_WARNING_TEMPERATURE_THRESH, false);
        Object changedOnBoardTemperatureStatus = this.getObjectForParam(map, ClientParameterCode.HW_ON_BOARD_TEMPERATURE_STATUS, false);
        Object changedCPUTemperatureStatus = this.getObjectForParam(map, ClientParameterCode.HW_CPU_TEMPERATURE_STATUS, false);
        SrTreeNode obj = SystemRootNode.getInstance().getRefByStub(element);
        if (obj != null) {
            String temperatureStatus;
            HardwareData node = (HardwareData)obj;
            if (changedPowerSuppliersMaxNumber != null) {
                Integer powerSuppliersMaxNumber = (Integer)changedPowerSuppliersMaxNumber;
                node.setMaxNumOfPowerSuppliers(powerSuppliersMaxNumber);
            }
            if (changedPowerSuppliersCurrentWorkingNumber != null) {
                Integer powerSuppliersCurrentWorkingNumber = (Integer)changedPowerSuppliersCurrentWorkingNumber;
                node.setCurrNumOfWorkingPowerSuppliers(powerSuppliersCurrentWorkingNumber);
            }
            if (changedFANsMaxNumber != null) {
                Integer FANsMaxNumber = (Integer)changedFANsMaxNumber;
                node.setMaxNumOfFANs(FANsMaxNumber);
            }
            if (changedFANsCurrentWorkingNumber != null) {
                Integer FANsCurrentWorkingNumber = (Integer)changedFANsCurrentWorkingNumber;
                node.setCurrNumOfWorkingFANs(FANsCurrentWorkingNumber);
            }
            if (changedOnboardTemperature != null) {
                Integer onboardTemperature = (Integer)changedOnboardTemperature;
                node.setOnboardTemp(onboardTemperature);
            }
            if (changedCPUTemperature != null) {
                Integer CPUTemperature = (Integer)changedCPUTemperature;
                node.setCPUTemp(CPUTemperature);
            }
            if (changedOnboardFactoryTemperatureThresh != null) {
                Integer onboardFactoryTemperatureThresh = (Integer)changedOnboardFactoryTemperatureThresh;
                node.setOnboardFactoryTempThresh(onboardFactoryTemperatureThresh);
            }
            if (changedCPUFactoryTemperatureThresh != null) {
                Integer CPUFactoryTemperatureThresh = (Integer)changedCPUFactoryTemperatureThresh;
                node.setCpuFactoryTempThresh(CPUFactoryTemperatureThresh);
            }
            if (changedOnboardWarningTemperatureThresh != null) {
                Integer onboardWorningTemperatureThresh = (Integer)changedOnboardWarningTemperatureThresh;
                node.setOnboardWarningTempThresh(onboardWorningTemperatureThresh);
            }
            if (changedCPUWarningTemperatureThresh != null) {
                Integer CPUWorningTemperatureThresh = (Integer)changedCPUWarningTemperatureThresh;
                node.setCPUWarningTempThresh(CPUWorningTemperatureThresh);
            }
            if (changedOnBoardTemperatureStatus != null) {
                temperatureStatus = (String)changedOnBoardTemperatureStatus;
                node.setOnboardTempStatus(temperatureStatus);
            }
            if (changedCPUTemperatureStatus != null) {
                temperatureStatus = (String)changedCPUTemperatureStatus;
                node.setCPUTempStatus(temperatureStatus);
            }
            this.fireHardwareDataChanged(node);
        }
    }

    private void fireHardwareDataChanged(HardwareData hardwareData) {
        HardwareDataEvent event = new HardwareDataEvent((Object)this, hardwareData);
        this.m_listeners.fireEvent(HardwareDataListener.class, event, this.hardwareDataChangedInformer);
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
    }
}

