/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr.wizards;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.dr.ConsistencyGroupNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRConsistencyGroupManager;
import com.sanrad.nms.client.data.dr.DRSyncPairManager;
import com.sanrad.nms.client.data.dr.DRSyncPairNode;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.ExtendedPairNode;
import com.sanrad.nms.client.data.dr.wizards.SrWizardCGTableColumns;
import com.sanrad.nms.client.data.dr.wizards.WizardCGTableHeader;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupEvent;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupListener;
import com.sanrad.nms.client.event.dr.DRSyncPairEvent;
import com.sanrad.nms.client.event.dr.DRSyncPairListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.swing.SrTableModel;

public class SrWizardCGTableModel
extends SrTableModel
implements DRConsistencyGroupListener,
DRSyncPairListener {
    private SrTreeNode[] m_drElements;

    public SrWizardCGTableModel(SrTreeNode[] drElements) {
        super(new SrWizardCGTableColumns());
        this.m_drElements = drElements;
        this.init();
    }

    private void init() {
        for (int i = 0; i < this.m_drElements.length; ++i) {
            if (this.m_drElements[i] instanceof ConsistencyGroupNode) {
                this.addRow(this.buildConsistencyGroupRow((ConsistencyGroupNode)this.m_drElements[i]));
                continue;
            }
            if (this.m_drElements[i] instanceof ExtendedPairNode) {
                this.addRow(this.buildExtendedPairNodeRow((ExtendedPairNode)this.m_drElements[i]));
                continue;
            }
            if (!(this.m_drElements[i] instanceof DRSyncPairNode)) continue;
            this.addRow(this.buildSyncPairRow((DRSyncPairNode)this.m_drElements[i]));
        }
    }

    private Object[] buildConsistencyGroupRow(ConsistencyGroupNode cgNode) {
        Object[] row = new Object[WizardCGTableHeader.getColumnNames().size()];
        SiteNode primSite = null;
        SiteNode secSite = null;
        DRASyncPairNode[] pairs = cgNode.getPairs();
        if (pairs.length > 0) {
            primSite = pairs[0].getPairPrimarySite();
            secSite = pairs[0].getPairSecondarySite();
        }
        row[this.getColumnIndex((String)WizardCGTableHeader.NODE.getColumnName())] = cgNode;
        row[this.getColumnIndex((String)WizardCGTableHeader.CG_ALIAS.getColumnName())] = cgNode;
        row[this.getColumnIndex((String)WizardCGTableHeader.PRIM_SITE.getColumnName())] = primSite;
        row[this.getColumnIndex((String)WizardCGTableHeader.SEC_SITE.getColumnName())] = secSite;
        row[this.getColumnIndex((String)WizardCGTableHeader.REPLICATION_METHOD.getColumnName())] = cgNode.getReplicationPolicy();
        return row;
    }

    private Object[] buildExtendedPairNodeRow(ExtendedPairNode exPairNode) {
        Object[] row = new Object[WizardCGTableHeader.getColumnNames().size()];
        SiteNode primSite = null;
        SiteNode secSite = null;
        if (exPairNode.getPair() != null) {
            primSite = exPairNode.getPair().getPairPrimarySite();
            secSite = exPairNode.getPair().getPairSecondarySite();
        }
        row[this.getColumnIndex((String)WizardCGTableHeader.NODE.getColumnName())] = exPairNode;
        row[this.getColumnIndex((String)WizardCGTableHeader.CG_ALIAS.getColumnName())] = exPairNode;
        row[this.getColumnIndex((String)WizardCGTableHeader.PRIM_SITE.getColumnName())] = primSite;
        row[this.getColumnIndex((String)WizardCGTableHeader.SEC_SITE.getColumnName())] = secSite;
        row[this.getColumnIndex((String)WizardCGTableHeader.REPLICATION_METHOD.getColumnName())] = exPairNode.getReplicationPolicy();
        return row;
    }

    private Object[] buildSyncPairRow(DRSyncPairNode node) {
        Object[] row = new Object[WizardCGTableHeader.getColumnNames().size()];
        row[this.getColumnIndex((String)WizardCGTableHeader.NODE.getColumnName())] = node;
        row[this.getColumnIndex((String)WizardCGTableHeader.CG_ALIAS.getColumnName())] = node;
        row[this.getColumnIndex((String)WizardCGTableHeader.PRIM_SITE.getColumnName())] = node.getPairPrimarySite();
        row[this.getColumnIndex((String)WizardCGTableHeader.SEC_SITE.getColumnName())] = node.getPairSecondarySite();
        row[this.getColumnIndex((String)WizardCGTableHeader.REPLICATION_METHOD.getColumnName())] = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_NOT_AVAILABLE_VALUE);
        return row;
    }

    private void removeDRElementRow(SrTreeNode node) {
        int nodeIdx = this.getColumnIndex(WizardCGTableHeader.NODE.getColumnName());
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, nodeIdx) != node) continue;
            this.removeRow(i);
            break;
        }
    }

    @Override
    public void consistencyGroupCreated(DRConsistencyGroupEvent e) {
    }

    @Override
    public void consistencyGroupRemoved(DRConsistencyGroupEvent e) {
        this.removeDRElementRow(e.getExtendedElementNode());
    }

    @Override
    public void consistencyGroupAliasChanged(DRConsistencyGroupEvent e) {
        int nodeIdx = this.getColumnIndex(WizardCGTableHeader.NODE.getColumnName());
        ConsistencyGroupNode node = (ConsistencyGroupNode)e.getExtendedElementNode();
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object currNode = this.getValueAt(i, nodeIdx);
            if (currNode != node) continue;
            Object[] row = this.buildConsistencyGroupRow(node);
            this.editRow(i, row);
            break;
        }
    }

    @Override
    public void consistencyGroupChanged(DRConsistencyGroupEvent e) {
        ExtendedElementNode node = e.getExtendedElementNode();
        int nodeCol = this.getColumnIndex(WizardCGTableHeader.NODE.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            if (!this.getValueAt(i, nodeCol).equals(node)) continue;
            Object[] row = null;
            row = node instanceof ConsistencyGroupNode ? this.buildConsistencyGroupRow((ConsistencyGroupNode)node) : this.buildExtendedPairNodeRow((ExtendedPairNode)node);
            this.editRow(i, row);
        }
    }

    @Override
    public void syncPairChanged(DRSyncPairEvent e) {
        DRSyncPairNode node = e.getPair();
        int nodeCol = this.getColumnIndex(WizardCGTableHeader.NODE.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            if (!this.getValueAt(i, nodeCol).equals(node)) continue;
            Object[] row = this.buildSyncPairRow(e.getPair());
            this.editRow(i, row);
        }
    }

    @Override
    public void syncPairCreated(DRSyncPairEvent e) {
    }

    @Override
    public void syncPairRemoved(DRSyncPairEvent e) {
        this.removeDRElementRow(e.getPair());
    }

    @Override
    public void removeListeners() {
        DRConsistencyGroupManager.getInstance().removeDRConsistencyGroupListener(this);
        DRSyncPairManager.getInstance().removeDRSyncPairListener(this);
    }

    @Override
    public void addListeners() {
        DRConsistencyGroupManager.getInstance().addDRConsistencyGroupListener(this);
        DRSyncPairManager.getInstance().addDRSyncPairListener(this);
    }
}

