/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr.wizards;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.ExposedVolumesTableModelCollection;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.NotExposedVolumeTreeModelCollection;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.SrExposedVolumesTableModel;
import com.sanrad.nms.client.data.volume.SrNotExposedVolumeTreeModel;
import com.sanrad.nms.client.data.volume.TransparentVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.dr.wizards.DRWizardValidation;
import com.sanrad.nms.client.gui.volume.ExposedVolumesTableHeader;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SrResourceTableModel
extends SrTableModel {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private static SrResourceTableModel emptyModel = new SrResourceTableModel();
    protected static final String ISCSI_TRANS_TYPE = PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI.toString();
    private static final String COLUMN_NAME = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_WIZ_SELECT_RESOURCE_TABLE_COLUMN);
    private ClusterNode m_currentCluster;

    protected void setCluster(ClusterNode aCluster) {
        this.m_currentCluster = aCluster;
    }

    protected SrResourceTableModel(ClusterNode cluster) {
        this();
        this.m_currentCluster = cluster;
    }

    private SrResourceTableModel() {
        super(new SrDefaultTableColumns(COLUMN_NAME));
    }

    public static SrResourceTableModel getEmptyModel() {
        return emptyModel;
    }

    public void initModel() {
        if (this.m_currentCluster == null) {
            return;
        }
        this.removeAllRows();
        List<StorageDeviceNode> storageResources = this.getStorageResources();
        ArrayList exposedAndUnExposedResources = this.getExposedAndUnExposedResources();
        storageResources.removeAll(exposedAndUnExposedResources);
        ArrayList resources = this.filter(storageResources, exposedAndUnExposedResources);
        for (int i = 0; i < resources.size(); ++i) {
            Object[] row = new Object[]{resources.get(i)};
            this.addRow(row);
        }
    }

    private List<StorageDeviceNode> getStorageResources() {
        ArrayList<StorageDeviceNode> list = new ArrayList<StorageDeviceNode>();
        for (StorageDeviceNode storageNode : StorageManager.getInstance().getStorages(this.m_currentCluster)) {
            if (storageNode.isNeedSync()) {
                theLogger.info(SrLogCategories.INFORMATIVE, new StorageFilterDebugMgs(storageNode, "it is in needSync state."));
                continue;
            }
            SubDirectAccessDeviceNode[] subDisks = null;
            if (!SrResourceTableModel.isStorageValidForSource(storageNode) || !(storageNode instanceof DirectAccessDeviceNode)) continue;
            subDisks = StorageManager.getInstance().getSubdisksNodes(((DirectAccessDeviceNode)storageNode).getSplits(), (DirectAccessDeviceNode)storageNode);
            if (subDisks != null && subDisks.length > 0) {
                for (int j = 0; j < subDisks.length; ++j) {
                    if (!SrResourceTableModel.isSubDiskValidForSource(subDisks[j])) continue;
                    list.add(subDisks[j]);
                }
                continue;
            }
            if (!SrResourceTableModel.isDiskValidForSource((DirectAccessDeviceNode)storageNode)) continue;
            list.add(storageNode);
        }
        return list;
    }

    public static boolean isStorageValidForSource(StorageDeviceNode stor) {
        if (stor instanceof SubDirectAccessDeviceNode && ((SubDirectAccessDeviceNode)stor).getDirectAccessDeviceParent().isNonFunctional()) {
            DirectAccessDeviceNode disk = ((SubDirectAccessDeviceNode)stor).getDirectAccessDeviceParent();
            theLogger.info(SrLogCategories.INFORMATIVE, new StorageFilterDebugMgs(stor, "the disk parent " + disk + " is not functional."));
            return false;
        }
        if (stor instanceof DirectAccessDeviceNode && ((DirectAccessDeviceNode)stor).isNonFunctional()) {
            theLogger.info(SrLogCategories.INFORMATIVE, new StorageFilterDebugMgs(stor, "it is not functional."));
            return false;
        }
        return stor instanceof SubDirectAccessDeviceNode || stor instanceof DirectAccessDeviceNode;
    }

    public static boolean isSubDiskValidForSource(SubDirectAccessDeviceNode subdisk) {
        if (subdisk.hasVolumeParent()) {
            theLogger.info(SrLogCategories.INFORMATIVE, new StorageFilterDebugMgs(subdisk, "it has a parent volume."));
            return false;
        }
        if (DRPairManager.getPairContainingVolume(subdisk) != null) {
            theLogger.info(SrLogCategories.INFORMATIVE, new StorageFilterDebugMgs(subdisk, "it is part of a GDR pair."));
            return false;
        }
        return true;
    }

    public static boolean isDiskValidForSource(DirectAccessDeviceNode disk) {
        if (AlarmsManager.getInstance().isRemovableDisk(disk)) {
            theLogger.info(SrLogCategories.INFORMATIVE, new StorageFilterDebugMgs(disk, "it is missing or invalid or configured."));
            return false;
        }
        if (disk.hasVolumeParent()) {
            theLogger.info(SrLogCategories.INFORMATIVE, new StorageFilterDebugMgs(disk, "it has a parent volume."));
            return false;
        }
        DRASyncPairManager.getInstance();
        if (DRASyncPairManager.getPairContainingVolume(disk) != null) {
            theLogger.info(SrLogCategories.INFORMATIVE, new StorageFilterDebugMgs(disk, "it is part of a GDR pair."));
            return false;
        }
        if (!disk.isDisk() && !disk.isSubDisk()) {
            theLogger.info(SrLogCategories.INFORMATIVE, new StorageFilterDebugMgs(disk, "it is not a disk nor subdisk."));
            return false;
        }
        return true;
    }

    private ArrayList getExposedAndUnExposedResources() {
        SrNotExposedVolumeTreeModel notExposedVolumesModel = (SrNotExposedVolumeTreeModel)NotExposedVolumeTreeModelCollection.getInstance().getModel((RemoteObject)this.m_currentCluster.getStub());
        ArrayList<VolumeTreeNode> list = new ArrayList<VolumeTreeNode>(notExposedVolumesModel.getAllVolumes());
        SrExposedVolumesTableModel exposedVolumesModel = (SrExposedVolumesTableModel)ExposedVolumesTableModelCollection.getInstance().getModel((RemoteObject)this.m_currentCluster.getStub());
        int volColIndex = exposedVolumesModel.getColumnIndex(ExposedVolumesTableHeader.VOLUME_NAME.getColumnName());
        for (int i = 0; i < exposedVolumesModel.getRowCount(); ++i) {
            list.add((VolumeTreeNode)exposedVolumesModel.getValueAt(i, volColIndex));
        }
        return list;
    }

    private ArrayList filter(List storageResources, List exposedAndUnExposedResources) {
        ArrayList resourceList = new ArrayList();
        resourceList.addAll(storageResources);
        resourceList.addAll(exposedAndUnExposedResources);
        Iterator i = resourceList.iterator();
        while (i.hasNext()) {
            VolumeTreeNode vol = (VolumeTreeNode)i.next();
            if (this.generalVolumeCheck(vol)) continue;
            i.remove();
        }
        return resourceList;
    }

    protected boolean generalVolumeCheck(VolumeTreeNode vol) {
        return this.validateVolume(vol) && this.isVolumeValid(vol);
    }

    protected boolean isVolumeValid(VolumeTreeNode vol) {
        return true;
    }

    private boolean validateVolume(VolumeTreeNode vol) {
        if (vol == null) {
            return false;
        }
        if (!DRWizardValidation.isRedundant(vol)) {
            theLogger.info(SrLogCategories.INFORMATIVE, new StorageFilterDebugMgs(vol, "it is not redundant."));
            return false;
        }
        if (vol.isConfigured()) {
            theLogger.info(SrLogCategories.INFORMATIVE, new StorageFilterDebugMgs(vol, "it is configured."));
            return false;
        }
        if (vol instanceof TransparentVolumeNode || vol instanceof SnapshotVolumeNode || vol instanceof JournalVolumeNode) {
            theLogger.info(SrLogCategories.INFORMATIVE, new StorageFilterDebugMgs(vol, "it is a Transparent/Snapshot/Journal volume."));
            return false;
        }
        if (vol instanceof StorageDeviceNode && !SrResourceTableModel.isStorageValidForSource((StorageDeviceNode)vol)) {
            return false;
        }
        if (vol instanceof SubDirectAccessDeviceNode && !SrResourceTableModel.isSubDiskValidForSource((SubDirectAccessDeviceNode)vol)) {
            return false;
        }
        if (vol instanceof DirectAccessDeviceNode) {
            DirectAccessDeviceNode disk = (DirectAccessDeviceNode)vol;
            if (disk.hasSubdisks()) {
                theLogger.info(SrLogCategories.INFORMATIVE, new StorageFilterDebugMgs(vol, "it has subdisks."));
                return false;
            }
            if (!SrResourceTableModel.isDiskValidForSource(disk)) {
                return false;
            }
        }
        if (vol.isChildOfAnotherVolume()) {
            theLogger.info(SrLogCategories.INFORMATIVE, new StorageFilterDebugMgs(vol, "it is a Child Of Another Volume."));
            return false;
        }
        if (vol.isNeedSync()) {
            theLogger.info(SrLogCategories.INFORMATIVE, new StorageFilterDebugMgs(vol, "it is in needSync state."));
            return false;
        }
        if (DRPairManager.getPairContainingVolume(vol) != null) {
            theLogger.info(SrLogCategories.INFORMATIVE, new StorageFilterDebugMgs(vol, "it is part of a GDR pair."));
            return false;
        }
        return true;
    }

    public void notifyVolumeChanged(VolumeTreeNode volume) {
        ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(volume);
        if (cluster.equals(this.m_currentCluster)) {
            boolean isValid = this.generalVolumeCheck(volume);
            int row = this.indexOfVolume(volume);
            if (row >= 0 && !isValid) {
                this.removeRow(row);
            } else if (row < 0 && isValid) {
                this.addRow(new Object[]{volume});
            } else if (row >= 0 && isValid) {
                int col = this.getColumnIndex(COLUMN_NAME);
                this.fireTableCellUpdated(row, col);
            }
        }
    }

    public void notifyVolumeCreated(VolumeTreeNode volume) {
        ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(volume);
        if (cluster.equals(this.m_currentCluster) && this.generalVolumeCheck(volume)) {
            this.addRow(new Object[]{volume});
        }
    }

    public void notifyVolumeRemoved(VolumeTreeNode volume) {
        int row;
        ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(volume);
        if (cluster.equals(this.m_currentCluster) && (row = this.indexOfVolume(volume)) >= 0) {
            this.removeRow(row);
        }
    }

    private int indexOfVolume(VolumeTreeNode volume) {
        int col = this.getColumnIndex(COLUMN_NAME);
        int i = this.getRowCount();
        while (i-- > 0) {
            Object vol = this.getValueAt(i, col);
            if (!volume.equals(vol)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void removeListeners() {
    }

    @Override
    public void addListeners() {
    }

    public static class StorageFilterDebugMgs {
        SrTreeNode mySrTreeNode;
        String myReason;

        public StorageFilterDebugMgs(SrTreeNode aSrTreeNode, String aReason) {
            if (aSrTreeNode == null) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "The given SrTreeNode should not be null");
            }
            if (aReason == null) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "The given reason should not be null");
            }
            this.mySrTreeNode = aSrTreeNode;
            this.myReason = aReason;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("The ");
            sb.append(this.mySrTreeNode.type());
            sb.append(' ').append('\"');
            sb.append(this.mySrTreeNode).append('\"');
            sb.append(" was filtered from DR wizard selection dialog box because ");
            sb.append(this.myReason);
            return sb.toString();
        }
    }
}

