/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr.wizards;

import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRSyncPairNode;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.wizards.SrPlannedFailoverTargetPairsTableHeader;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;

public class SrPlannedFailoverTargetPairsTableModel
extends SrTableModel {
    private TargetNode m_target;
    private ExtendedElementNode[] m_cgs;
    private DRSyncPairNode[] m_syncPairNodes;

    public SrPlannedFailoverTargetPairsTableModel(TargetNode target, ExtendedElementNode[] cgs, DRSyncPairNode[] syncPairNodes) {
        super(new SrDefaultTableColumns(SrPlannedFailoverTargetPairsTableHeader.getColumnNames()));
        this.m_cgs = cgs;
        this.m_syncPairNodes = syncPairNodes;
        this.m_target = target;
        this.init();
    }

    private void init() {
        for (LUNode luNode : this.m_target.getLuNodes()) {
            int i;
            VolumeTreeNode secondaryVolume = luNode.getVolumeChild();
            if (this.m_cgs != null) {
                for (i = 0; i < this.m_cgs.length; ++i) {
                    VolumeTreeNode cgSecVol = null;
                    DRASyncPairNode[] pairs = this.m_cgs[i].getPairs();
                    int j = pairs.length;
                    while (j-- > 0) {
                        cgSecVol = pairs[j].getPairSecondaryVolume();
                        if (secondaryVolume != cgSecVol) continue;
                        this.addNewPairTargetRow(pairs[j].getPairPrimaryVolume(), cgSecVol, this.m_cgs[i]);
                    }
                }
            }
            if (this.m_syncPairNodes == null) continue;
            for (i = 0; i < this.m_syncPairNodes.length; ++i) {
                VolumeTreeNode secVol = this.m_syncPairNodes[i].getPairSecondaryVolume();
                if (secondaryVolume != secVol) continue;
                this.addNewPairTargetRow(this.m_syncPairNodes[i].getPairPrimaryVolume(), secVol, "---");
            }
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    private void addNewPairTargetRow(VolumeTreeNode primaryVolume, VolumeTreeNode secondaryVolume, Object cg) {
        Object[] row = new Object[SrPlannedFailoverTargetPairsTableHeader.getColumnNames().size()];
        row[this.getColumnIndex((String)SrPlannedFailoverTargetPairsTableHeader.PRIM_VOL.getColumnName())] = primaryVolume;
        row[this.getColumnIndex((String)SrPlannedFailoverTargetPairsTableHeader.SEC_VOL.getColumnName())] = secondaryVolume;
        row[this.getColumnIndex((String)SrPlannedFailoverTargetPairsTableHeader.CG.getColumnName())] = cg;
        this.addRowQuetly(row, -1);
    }

    @Override
    public void removeListeners() {
    }

    @Override
    public void addListeners() {
    }
}

