/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr.pit;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.pit.DRPiTNode;
import com.sanrad.nms.client.data.dr.pit.PiTContainer;
import com.sanrad.nms.client.data.dr.pit.SrPiTTableHeader;
import com.sanrad.nms.client.event.dr.DRPiTEvent;
import com.sanrad.nms.client.event.dr.DRPiTListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRPiTStateConstant;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.Util;

public class SrPiTTableModel
extends SrTableModel
implements DRPiTListener {
    private PiTContainer m_drNodeParent;
    private static String notAvailableValue = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_NOT_AVAILABLE_VALUE);

    public SrPiTTableModel(PiTContainer drPiTParent) {
        super(new SrDefaultTableColumns(SrPiTTableHeader.getColumnNames()));
        this.m_drNodeParent = drPiTParent;
    }

    public void init() {
        DRPiTNode[] pits = this.m_drNodeParent.getPiTs();
        for (int i = 0; i < pits.length; ++i) {
            this.addRow(this.buildRow(pits[i]));
        }
    }

    private Object[] buildRow(DRPiTNode pit) {
        Object[] row = new Object[SrPiTTableHeader.getColumnNames().size()];
        row[this.getColumnIndex((String)SrPiTTableHeader.PIT_NODE.getColumnName())] = pit;
        row[this.getColumnIndex((String)SrPiTTableHeader.PIT_SITE.getColumnName())] = pit.getSite();
        long dateAndTime = pit.getDateAndTime();
        if (dateAndTime > 0L && !DRPiTStateConstant.FORMING.equals(pit.getState())) {
            String date = ClientLoader.BUNDLE.getDateFormatString((BundleKeysInterface)SrClientBundleKeys.CLIENT_DIALOG_DATE_AND_TIME_FORMAT, dateAndTime);
            row[this.getColumnIndex((String)SrPiTTableHeader.DATE_AND_TIME.getColumnName())] = date;
        } else {
            row[this.getColumnIndex((String)SrPiTTableHeader.DATE_AND_TIME.getColumnName())] = notAvailableValue;
        }
        Object stateValue = null;
        if (DRPiTStateConstant.PENDING.equals(pit.getState())) {
            ClusterNode pitCluster = SystemRootNode.getInstance().getClusterNodeOfSource(pit);
            if (pitCluster.equals(this.m_drNodeParent.getLocalCluster()) && DRModeConstant.NORMAL.equals(this.m_drNodeParent.getMode()) || pitCluster.equals(this.m_drNodeParent.getRemoteCluster()) && DRModeConstant.SWITCHED.equals(this.m_drNodeParent.getMode())) {
                stateValue = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PITS_TABLE_VALUE_WAIT_FOR_TRANSFER);
            } else if (pitCluster.equals(this.m_drNodeParent.getRemoteCluster()) && DRModeConstant.NORMAL.equals(this.m_drNodeParent.getMode()) || pitCluster.equals(this.m_drNodeParent.getLocalCluster()) && DRModeConstant.SWITCHED.equals(this.m_drNodeParent.getMode())) {
                stateValue = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PITS_TABLE_VALUE_WAIT_FOR_MERGE);
            }
        } else {
            stateValue = pit.getState();
        }
        row[this.getColumnIndex((String)SrPiTTableHeader.STATE.getColumnName())] = stateValue;
        long dataTransferred = pit.getTotalDataMBytes() - pit.getPendingDataMBytes();
        row[this.getColumnIndex((String)SrPiTTableHeader.TRANSFERRED_DATA.getColumnName())] = new Long(dataTransferred);
        row[this.getColumnIndex((String)SrPiTTableHeader.PENDING_DATA.getColumnName())] = pit.getPendingDataMBytes();
        row[this.getColumnIndex((String)SrPiTTableHeader.TRANSFER_RATE.getColumnName())] = pit.getTransferRate().longValue() >= 0L ? Util.round(pit.getTransferRate(), 2) : notAvailableValue;
        return row;
    }

    public DRPiTNode getPiT(int row) {
        int col = this.getColumnIndex(SrPiTTableHeader.PIT_NODE.getColumnName());
        return (DRPiTNode)this.getValueAt(row, col);
    }

    @Override
    public void drPiTChanged(DRPiTEvent e) {
        int row = this.findRow(e.getDRPiTNode());
        if (row >= 0) {
            this.editRow(row, this.buildRow(e.getDRPiTNode()));
        }
    }

    @Override
    public void drPiTCreated(DRPiTEvent e) {
        DRPiTNode pit = e.getDRPiTNode();
        if (this.m_drNodeParent.equals(pit.getParentNode())) {
            this.addRow(this.buildRow(pit));
        }
    }

    @Override
    public void drPiTRemoved(DRPiTEvent e) {
        int row = this.findRow(e.getDRPiTNode());
        if (row >= 0) {
            this.removeRow(row);
        }
    }

    @Override
    public void drPiTsParentUpdated(DRPiTEvent e) {
    }

    private int findRow(DRPiTNode pit) {
        int nodeCol = this.getColumnIndex(SrPiTTableHeader.PIT_NODE.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            if (!this.getValueAt(i, nodeCol).equals(pit)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void removeListeners() {
    }

    @Override
    public void addListeners() {
    }
}

