/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr.pit;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.pit.DRPiTNode;
import com.sanrad.nms.client.data.dr.pit.PiTContainer;
import com.sanrad.nms.client.data.dr.pit.SrCGPiTChildrenTableHeader;
import com.sanrad.nms.client.data.dr.pit.SrPiTTableHeader;
import com.sanrad.nms.client.event.dr.DRPiTEvent;
import com.sanrad.nms.client.event.dr.DRPiTListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRPiTStateConstant;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import com.sanrad.util.Util;

public class SrCGPiTChildrenTableModel
extends SrTableModel
implements DRPiTListener {
    private static String notAvailableValue = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_NOT_AVAILABLE_VALUE);
    private DRPiTNode m_pitParent;

    public SrCGPiTChildrenTableModel() {
        super(new SrDefaultTableColumns(SrCGPiTChildrenTableHeader.getColumnNames()));
    }

    public void setPiTParent(DRPiTNode pitParent) {
        this.m_pitParent = pitParent;
    }

    public void init() {
        this.removeAllRows();
        ExtendedElementNode cg = (ExtendedElementNode)this.m_pitParent.getParentNode();
        DRASyncPairNode[] pairs = cg.getPairs();
        for (int i = 0; i < pairs.length; ++i) {
            DRPiTNode[] pits = pairs[i].getPiTs();
            int j = pits.length;
            while (j-- > 0) {
                if (!pits[j].getDateAndTime().equals(this.m_pitParent.getDateAndTime())) continue;
                this.addRow(this.buildRow(pits[j]));
            }
        }
    }

    @Override
    public void drPiTChanged(DRPiTEvent e) {
        int row = this.findRow(e.getDRPiTNode());
        if (row >= 0) {
            this.editRow(row, this.buildRow(e.getDRPiTNode()));
        }
    }

    @Override
    public void drPiTCreated(DRPiTEvent e) {
        DRPiTNode pit;
        PiTContainer eventPitParent;
        if (this.m_pitParent != null && (eventPitParent = (pit = e.getDRPiTNode()).getParentNode()) instanceof DRASyncPairNode && this.m_pitParent.getParentNode().equals(((DRASyncPairNode)eventPitParent).getConsistencyGroup()) && this.m_pitParent.getDateAndTime().equals(pit.getDateAndTime())) {
            this.addRow(this.buildRow(pit));
        }
    }

    @Override
    public void drPiTRemoved(DRPiTEvent e) {
        int row = this.findRow(e.getDRPiTNode());
        if (row >= 0) {
            this.removeRow(row);
        }
    }

    @Override
    public void drPiTsParentUpdated(DRPiTEvent e) {
    }

    private int findRow(DRPiTNode pit) {
        int nodeCol = this.getColumnIndex(SrCGPiTChildrenTableHeader.PIT_NODE.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            if (!this.getValueAt(i, nodeCol).equals(pit)) continue;
            return i;
        }
        return -1;
    }

    private Object[] buildRow(DRPiTNode pit) {
        Object[] row = new Object[6];
        row[this.getColumnIndex((String)SrCGPiTChildrenTableHeader.PIT_NODE.getColumnName())] = pit;
        row[this.getColumnIndex((String)SrCGPiTChildrenTableHeader.PAIR_NODE.getColumnName())] = pit.getParentNode();
        Object stateValue = null;
        if (DRPiTStateConstant.PENDING.equals(pit.getState())) {
            PiTContainer m_drNodeParent = pit.getParentNode();
            ClusterNode pitCluster = SystemRootNode.getInstance().getClusterNodeOfSource(pit);
            if (pitCluster.equals(m_drNodeParent.getLocalCluster()) && DRModeConstant.NORMAL.equals(m_drNodeParent.getMode()) || pitCluster.equals(m_drNodeParent.getRemoteCluster()) && DRModeConstant.SWITCHED.equals(m_drNodeParent.getMode())) {
                stateValue = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PITS_TABLE_VALUE_WAIT_FOR_TRANSFER);
            } else if (pitCluster.equals(m_drNodeParent.getRemoteCluster()) && DRModeConstant.NORMAL.equals(m_drNodeParent.getMode()) || pitCluster.equals(m_drNodeParent.getLocalCluster()) && DRModeConstant.SWITCHED.equals(m_drNodeParent.getMode())) {
                stateValue = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PITS_TABLE_VALUE_WAIT_FOR_MERGE);
            }
        } else {
            stateValue = pit.getState();
        }
        row[this.getColumnIndex((String)SrPiTTableHeader.STATE.getColumnName())] = stateValue;
        long dataTransferred = pit.getTotalDataMBytes() - pit.getPendingDataMBytes();
        row[this.getColumnIndex((String)SrCGPiTChildrenTableHeader.TRANSFERRED_DATA.getColumnName())] = new Long(dataTransferred);
        row[this.getColumnIndex((String)SrCGPiTChildrenTableHeader.PENDING_DATA.getColumnName())] = pit.getPendingDataMBytes();
        row[this.getColumnIndex((String)SrCGPiTChildrenTableHeader.TRANSFER_RATE.getColumnName())] = pit.getTransferRate().longValue() >= 0L ? Util.round(pit.getTransferRate(), 2) : notAvailableValue;
        return row;
    }

    @Override
    public void removeListeners() {
    }

    @Override
    public void addListeners() {
    }
}

