/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr.pit;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.pit.DRPiTNode;
import com.sanrad.nms.client.data.dr.pit.PiTContainer;
import com.sanrad.nms.client.event.dr.DRPiTEvent;
import com.sanrad.nms.client.event.dr.DRPiTListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.dr.DRAbstractConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DRAsyncPair;
import com.sanrad.nms.server.logic.dr.DRLogicObject;
import com.sanrad.nms.server.logic.dr.DRPiT;
import com.sanrad.nms.server.util.types.constants.DRPiTStateConstant;
import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.util.SrEventListenerManager;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.HashMap;

public class DRPiTManager
extends ElementManager {
    private static DRPiTManager m_theInstance;
    private static SrLogger theLogger;
    SrEventListenerManager.Informer drPiTCreatedInformer = new SrEventListenerManager.Informer<DRPiTListener, DRPiTEvent>(){

        @Override
        public void inform(DRPiTListener listener, DRPiTEvent event) {
            listener.drPiTCreated(event);
        }
    };
    SrEventListenerManager.Informer drPiTChangedInformer = new SrEventListenerManager.Informer<DRPiTListener, DRPiTEvent>(){

        @Override
        public void inform(DRPiTListener listener, DRPiTEvent event) {
            listener.drPiTChanged(event);
        }
    };
    SrEventListenerManager.Informer drPiTRemovedInformer = new SrEventListenerManager.Informer<DRPiTListener, DRPiTEvent>(){

        @Override
        public void inform(DRPiTListener listener, DRPiTEvent event) {
            listener.drPiTRemoved(event);
        }
    };

    private DRPiTManager() {
    }

    public static synchronized DRPiTManager getInstance() {
        if (m_theInstance == null) {
            m_theInstance = new DRPiTManager();
        }
        return m_theInstance;
    }

    public void addDRPiTListener(DRPiTListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeDRPiTListener(DRPiTListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        try {
            DRPiT stub = (DRPiT)e.getElement();
            if (!DRManager.getInstance().isDRDiscoveryCompleted()) {
                return;
            }
            if (this.alreadyExist(stub)) {
                return;
            }
            DRPiTNode pit = new DRPiTNode(stub);
            SystemRootNode.getInstance().putRefAndStub(stub, pit);
            this.preparePiTNode(pit, this.getParameterList(e));
            this.firePiTCreated(pit);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
            DRPiTManager.onConnectionError();
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject stub = e.getElement();
        if (!DRManager.getInstance().isDRDiscoveryCompleted()) {
            return;
        }
        DRPiTNode pit = (DRPiTNode)SystemRootNode.getInstance().getRefByStub(stub);
        if (pit != null) {
            this.preparePiTNode(pit, this.getParameterList(e));
            this.firePiTChanged(pit);
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject stub = e.getElement();
        if (!DRManager.getInstance().isDRDiscoveryCompleted()) {
            return;
        }
        DRPiTNode pit = (DRPiTNode)SystemRootNode.getInstance().getRefByStub(stub);
        if (pit != null) {
            theLogger.trace(SrLogCategories.LEGACY, "DRPiTManager: PiT removed");
            pit.getParentNode().removePiT(pit);
            this.firePiTRemoved(pit);
            super.elementRemove(e);
            SystemRootNode.getInstance().removeRefAndIdByStub(stub);
        }
    }

    private void preparePiTNode(DRPiTNode node, HashMap clientParams) {
        DRLogicObject parent = (DRLogicObject)this.getObjectForParam(clientParams, ClientParameterCode.DR_PIT_PARENT, false);
        DRPiTStateConstant state = (DRPiTStateConstant)this.getObjectForParam(clientParams, ClientParameterCode.DR_PIT_STATE, false);
        Long date = (Long)this.getObjectForParam(clientParams, ClientParameterCode.DR_PIT_DATE, false);
        BigInteger totalData = (BigInteger)this.getObjectForParam(clientParams, ClientParameterCode.DR_PIT_TOTAL_DATA, false);
        BigInteger pendingData = (BigInteger)this.getObjectForParam(clientParams, ClientParameterCode.DR_PIT_PENDING_DATA, false);
        BigInteger lastUpdate = (BigInteger)this.getObjectForParam(clientParams, ClientParameterCode.DR_PIT_LAST_UPDATE, false);
        Double transferRate = (Double)this.getObjectForParam(clientParams, ClientParameterCode.DR_PIT_TRANSFER_RATE, false);
        Object clusterStub = this.getObjectForParam(clientParams, ClientParameterCode.DR_PIT_CLUSTER, false);
        if (parent != null) {
            PiTContainer parentNode = (PiTContainer)((Object)SystemRootNode.getInstance().getRefByStub(parent));
            node.setDRNodeParent(parentNode);
            parentNode.addPiT(node);
        }
        if (state != null) {
            node.setState(state);
        }
        if (date != null) {
            node.setDateAndTime(new Long(date));
        }
        if (totalData != null) {
            node.setTotalDataMBytes(new Long(totalData.longValue()));
        }
        if (pendingData != null) {
            node.setPendingDataMBytes(new Long(pendingData.longValue()));
        }
        if (lastUpdate != null) {
            node.setLastUpdate(new Long(lastUpdate.longValue()));
        }
        if (transferRate != null) {
            node.setTransferRate(transferRate);
        }
        if (clusterStub != null) {
            node.setClusterStub(clusterStub);
        }
    }

    private void firePiTCreated(DRPiTNode pit) {
        DRPiTEvent event = new DRPiTEvent((Object)this, pit);
        this.m_listeners.fireEvent(DRPiTListener.class, event, this.drPiTCreatedInformer);
    }

    private void firePiTChanged(DRPiTNode pit) {
        DRPiTEvent event = new DRPiTEvent((Object)this, pit);
        this.m_listeners.fireEvent(DRPiTListener.class, event, this.drPiTChangedInformer);
    }

    private void firePiTRemoved(DRPiTNode pit) {
        DRPiTEvent event = new DRPiTEvent((Object)this, pit);
        this.m_listeners.fireEvent(DRPiTListener.class, event, this.drPiTRemovedInformer);
    }

    public void readPiTs(PiTContainer pitParent) {
        try {
            DRPiT[] pits = null;
            if (pitParent instanceof DRASyncPairNode) {
                DRAsyncPair pairStub = (DRAsyncPair)((DRASyncPairNode)pitParent).getStub();
                pits = pairStub.getPiTs();
            } else if (pitParent instanceof ExtendedElementNode) {
                DRAbstractConsistencyGroup cgStub = (DRAbstractConsistencyGroup)((ExtendedElementNode)pitParent).getStub();
                pits = cgStub.getPiTs();
            }
            for (int i = 0; i < pits.length; ++i) {
                final CommunicationEvent evt = new CommunicationEvent(this, pits[i]);
                if (SystemRootNode.getInstance().getRefByStub(pits[i]) != null) continue;
                EventDispatcherTask.submit(new Runnable(){

                    @Override
                    public void run() {
                        DRPiTManager.this.elementCreate(evt);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    static {
        theLogger = SrLogger.getLogger();
    }
}

