/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.cluster.ClusterManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRConsistencyGroupManager;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.DRSyncPairManager;
import com.sanrad.nms.client.data.dr.DRSyncPairNode;
import com.sanrad.nms.client.data.dr.SrPairDetailsTableColumns;
import com.sanrad.nms.client.data.dr.SrPairDetailsTableHeader;
import com.sanrad.nms.client.data.site.SiteManager;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.event.cluster.ClusterAdapter;
import com.sanrad.nms.client.event.cluster.ClusterEvent;
import com.sanrad.nms.client.event.dr.DRAsyncPairEvent;
import com.sanrad.nms.client.event.dr.DRAsyncPairListener;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupEvent;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupListener;
import com.sanrad.nms.client.event.dr.DRSyncPairEvent;
import com.sanrad.nms.client.event.dr.DRSyncPairListener;
import com.sanrad.nms.client.event.site.SiteAdapter;
import com.sanrad.nms.client.event.site.SiteEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRPairTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.swing.EventDispatcherTask;
import com.sanrad.swing.SrTableModel;
import com.sanrad.util.BundleKeysInterface;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Timer;

public class SrPairDetailsTableModel
extends SrTableModel
implements DRAsyncPairListener,
DRSyncPairListener,
DRConsistencyGroupListener {
    private static final int myRefreshPitInterval = Integer.parseInt(ClientLoader.BUNDLE.getString(SrClientBundleKeys.PIT_REFRESH_INTERVAL));
    private static SrPairDetailsTableModel m_instance = null;
    private static String m_notAvailableValue = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_NOT_AVAILABLE_VALUE);
    private static ClientParameterCode[] m_pendingPitsFields = new ClientParameterCode[]{ClientParameterCode.DR_ASYNC_PAIR_PENDING_PITS, ClientParameterCode.DR_ASYNC_PAIR_PENDING_DATA};
    private HashMap m_nodeToTimerMap = new HashMap();
    private PairTableSiteListener m_siteListener = new PairTableSiteListener();
    private PairTableClusterListener m_clusterListener = new PairTableClusterListener();
    private Timer m_initSyncProgressTimer = new Timer(10000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SrPairDetailsTableModel.this.refreshInitialSyncProgress();
        }
    });

    private SrPairDetailsTableModel() {
        super(new SrPairDetailsTableColumns());
        this.m_initSyncProgressTimer.setInitialDelay(1000);
        EventDispatcherTask.submit(new Runnable(){

            @Override
            public void run() {
                SrPairDetailsTableModel.this.checkPairsNeedRefresh();
            }
        });
    }

    @Override
    public void initModelData() {
        this.readAll();
    }

    @Override
    public void removeListeners() {
    }

    @Override
    public void addListeners() {
        DRASyncPairManager.getInstance().addDRAsyncPairListener(this);
        DRSyncPairManager.getInstance().addDRSyncPairListener(this);
        DRConsistencyGroupManager.getInstance().addDRConsistencyGroupListener(this);
        SiteManager.getInstance().addSiteListener(this.m_siteListener);
        ClusterManager.getInstance().addClusterListener(this.m_clusterListener);
    }

    public static synchronized SrPairDetailsTableModel getInstance() {
        if (m_instance == null) {
            m_instance = new SrPairDetailsTableModel();
        }
        return m_instance;
    }

    private void readAll() {
        DRASyncPairManager.getInstance().readAsyncPairsFromServer();
        DRSyncPairManager.getInstance().readSyncPairsFromServer();
    }

    private void clear() {
        DRASyncPairManager.getInstance().clearAll();
        DRSyncPairManager.getInstance().clearAll();
    }

    public void removePair(DRPairNode node) {
        int row = this.findRow(node);
        if (row != -1) {
            this.removeProgressTimer(node);
            this.removeRow(row);
        }
    }

    public void changePair(DRPairNode node) {
        int row = this.findRow(node);
        if (row != -1) {
            this.editRow(row, this.buildRowData(node));
        }
    }

    public void addPairRow(DRPairNode node, boolean fire) {
        Object[] row = this.buildRowData(node);
        if (!fire) {
            this.addRowQuetly(row, -1);
        } else {
            this.addRow(row);
        }
    }

    private Object[] buildRowData(DRPairNode node) {
        DRASyncPairNode asyncPair;
        Object[] row = new Object[SrPairDetailsTableHeader.getColumnNames().size()];
        row[this.getColumnIndex((String)SrPairDetailsTableHeader.NODE.getColumnName())] = node;
        row[this.getColumnIndex((String)SrPairDetailsTableHeader.STATUS.getColumnName())] = node;
        row[this.getColumnIndex((String)SrPairDetailsTableHeader.CONSISTENCY_GROUP.getColumnName())] = node instanceof DRASyncPairNode ? ((DRASyncPairNode)node).getConsistencyGroup() : null;
        SiteNode primarySite = node.getPairPrimarySite();
        row[this.getColumnIndex((String)SrPairDetailsTableHeader.PRIM_SITE.getColumnName())] = primarySite == null ? "" : primarySite.getAlias();
        row[this.getColumnIndex((String)SrPairDetailsTableHeader.PRIM_VOL.getColumnName())] = node.getPairPrimaryVolume();
        SiteNode secondarySite = node.getPairSecondarySite();
        row[this.getColumnIndex((String)SrPairDetailsTableHeader.SECOND_SITE.getColumnName())] = secondarySite == null ? "" : secondarySite.getAlias();
        row[this.getColumnIndex((String)SrPairDetailsTableHeader.SECOND_VOL.getColumnName())] = node.getPairSecondaryVolume();
        if (node.getReplicationState().contains(DRReplicationStateConstant.FALLBACK) || node.getReplicationState().contains(DRReplicationStateConstant.PLANNED_FAILOVER)) {
            this.addProgressTimer(node);
            row[this.getColumnIndex((String)SrPairDetailsTableHeader.MODE.getColumnName())] = null;
        } else {
            this.removeProgressTimer(node);
            row[this.getColumnIndex((String)SrPairDetailsTableHeader.MODE.getColumnName())] = node.getMode();
        }
        row[this.getColumnIndex((String)SrPairDetailsTableHeader.STATE.getColumnName())] = node.getPairState();
        if (DRPairTypeConstant.ASYNC.equals(node.getPairType())) {
            if (!DRReplicationStateConstant.INACTIVE.equals(node.getReplicationState())) {
                Object[] args;
                asyncPair = (DRASyncPairNode)node;
                row[this.getColumnIndex((String)SrPairDetailsTableHeader.PENDING_PITS.getColumnName())] = args = new Object[]{asyncPair.getNotReplicatedPits(), asyncPair.getNotReplicatedData()};
            } else {
                row[this.getColumnIndex((String)SrPairDetailsTableHeader.PENDING_PITS.getColumnName())] = m_notAvailableValue;
            }
        } else {
            row[this.getColumnIndex((String)SrPairDetailsTableHeader.PENDING_PITS.getColumnName())] = null;
        }
        row[this.getColumnIndex((String)SrPairDetailsTableHeader.INIT_SYNC.getColumnName())] = node.getInitialSyncProgress();
        if (node instanceof DRASyncPairNode) {
            Long nextReplication;
            asyncPair = (DRASyncPairNode)node;
            Long lastMerge = asyncPair.getLastMerge();
            if (lastMerge != null) {
                if (lastMerge > 0L) {
                    String date = ClientLoader.BUNDLE.getDateFormatString((BundleKeysInterface)SrClientBundleKeys.CLIENT_DIALOG_DATE_AND_TIME_FORMAT, lastMerge);
                    row[this.getColumnIndex((String)SrPairDetailsTableHeader.LAST_REPLICATION.getColumnName())] = date;
                } else {
                    row[this.getColumnIndex((String)SrPairDetailsTableHeader.LAST_REPLICATION.getColumnName())] = m_notAvailableValue;
                }
            }
            if ((nextReplication = asyncPair.getConsistencyGroup().getNextRelication()) != null) {
                if (nextReplication > 0L) {
                    String date = ClientLoader.BUNDLE.getDateFormatString((BundleKeysInterface)SrClientBundleKeys.CLIENT_DIALOG_DATE_AND_TIME_FORMAT, nextReplication);
                    row[this.getColumnIndex((String)SrPairDetailsTableHeader.NEXT_REPLICATION.getColumnName())] = date;
                } else {
                    row[this.getColumnIndex((String)SrPairDetailsTableHeader.NEXT_REPLICATION.getColumnName())] = m_notAvailableValue;
                }
            }
        }
        return row;
    }

    private void addProgressTimer(DRPairNode node) {
        Timer timer = (Timer)this.m_nodeToTimerMap.get(node);
        if (timer == null) {
            timer = new ModeProgressTimer(node, new ModeProgressAction(node));
            this.m_nodeToTimerMap.put(node, timer);
            timer.start();
        }
    }

    private void removeProgressTimer(DRPairNode node) {
        Timer timer = (Timer)this.m_nodeToTimerMap.get(node);
        if (timer != null) {
            timer.stop();
            this.m_nodeToTimerMap.remove(node);
        }
    }

    public DRPairNode[] getListOfPairs() {
        int nodeCol = this.getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
        DRPairNode[] pairs = new DRPairNode[this.getRowCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            pairs[i] = (DRPairNode)this.getValueAt(i, nodeCol);
        }
        return pairs;
    }

    public DRASyncPairNode[] removeAllAsyncPairRows() {
        int nodeCol = this.getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
        ArrayList<DRPairNode> list = new ArrayList<DRPairNode>();
        int i = this.getRowCount();
        while (i-- > 0) {
            DRPairNode pair = (DRPairNode)this.getValueAt(i, nodeCol);
            this.removeProgressTimer(pair);
            if (!(pair instanceof DRASyncPairNode)) continue;
            list.add(pair);
            this.removeRowQuetly(i);
        }
        this.fireTableDataChanged();
        DRASyncPairNode[] pairs = new DRASyncPairNode[list.size()];
        return list.toArray(pairs);
    }

    public DRSyncPairNode[] removeAllSyncPairRows() {
        int nodeCol = this.getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
        ArrayList<DRPairNode> list = new ArrayList<DRPairNode>();
        int i = this.getRowCount();
        while (i-- > 0) {
            DRPairNode pair = (DRPairNode)this.getValueAt(i, nodeCol);
            this.removeProgressTimer(pair);
            if (!(pair instanceof DRSyncPairNode)) continue;
            list.add(pair);
            this.removeRowQuetly(i);
        }
        this.fireTableDataChanged();
        DRSyncPairNode[] pairs = new DRSyncPairNode[list.size()];
        return list.toArray(pairs);
    }

    private void refreshInitialSyncProgress() {
        int i = this.getRowCount();
        while (i-- > 0) {
            DRPairNode node = (DRPairNode)this.getRow(i).get(this.getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName()));
            if (!DRInitialSyncStateConstant.IN_PROGRESS.equals(node.getInitialSyncState())) continue;
            DRPairManager.refreshInitialSyncProgress(node);
        }
    }

    private void checkPairsNeedRefresh() {
        boolean hasPairsInProgress = false;
        int i = this.getRowCount();
        while (i-- > 0) {
            DRPairNode node = (DRPairNode)this.getRow(i).get(this.getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName()));
            if (!DRInitialSyncStateConstant.IN_PROGRESS.equals(node.getInitialSyncState())) continue;
            hasPairsInProgress = true;
        }
        if (hasPairsInProgress) {
            if (!this.m_initSyncProgressTimer.isRunning()) {
                this.m_initSyncProgressTimer.restart();
            }
        } else {
            this.m_initSyncProgressTimer.stop();
        }
    }

    @Override
    public void asyncPairCreated(DRAsyncPairEvent e) {
        this.addPairRow(e.getPair(), true);
        this.checkPairsNeedRefresh();
    }

    @Override
    public void asyncPairRemoved(DRAsyncPairEvent e) {
        this.removePair(e.getPair());
        this.checkPairsNeedRefresh();
    }

    @Override
    public void asyncPairChanged(DRAsyncPairEvent e) {
        this.changePair(e.getPair());
        this.checkPairsNeedRefresh();
    }

    @Override
    public void syncPairChanged(DRSyncPairEvent e) {
        this.changePair(e.getPair());
        this.checkPairsNeedRefresh();
    }

    @Override
    public void syncPairCreated(DRSyncPairEvent e) {
        this.addPairRow(e.getPair(), true);
        this.checkPairsNeedRefresh();
    }

    @Override
    public void syncPairRemoved(DRSyncPairEvent e) {
        this.removePair(e.getPair());
        this.checkPairsNeedRefresh();
    }

    @Override
    public void consistencyGroupCreated(DRConsistencyGroupEvent e) {
    }

    @Override
    public void consistencyGroupRemoved(DRConsistencyGroupEvent e) {
    }

    @Override
    public void consistencyGroupAliasChanged(DRConsistencyGroupEvent e) {
    }

    @Override
    public void consistencyGroupChanged(DRConsistencyGroupEvent e) {
        DRASyncPairNode[] nodes = e.getExtendedElementNode().getPairs();
        int i = nodes.length;
        while (i-- > 0) {
            this.changePair(nodes[i]);
        }
    }

    public DRPairNode[] getPairsSecondaryOnSite(SiteNode site) {
        int nodeCol = this.getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
        ArrayList<DRPairNode> nodeList = new ArrayList<DRPairNode>();
        int i = this.getRowCount();
        while (i-- > 0) {
            DRPairNode node = (DRPairNode)this.getValueAt(i, nodeCol);
            if (node.getPairSecondarySite() != site) continue;
            nodeList.add(node);
        }
        return nodeList.toArray(new DRPairNode[nodeList.size()]);
    }

    public List<DRSyncPairNode> getSyncPairsPrimaryOnSite(SiteNode aSite) {
        ArrayList<DRSyncPairNode> list = new ArrayList<DRSyncPairNode>();
        int nodeCol = this.getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            DRPairNode pair = (DRPairNode)this.getValueAt(i, nodeCol);
            if (!aSite.equals(pair.getPairPrimarySite()) || !(pair instanceof DRSyncPairNode)) continue;
            list.add((DRSyncPairNode)pair);
        }
        return list;
    }

    public DRPairNode[] getPairsPrimaryOnSite(SiteNode site) {
        int nodeCol = this.getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
        ArrayList<DRPairNode> nodeList = new ArrayList<DRPairNode>();
        int i = this.getRowCount();
        while (i-- > 0) {
            DRPairNode node = (DRPairNode)this.getValueAt(i, nodeCol);
            if (node.getPairPrimarySite() != site) continue;
            nodeList.add(node);
        }
        return nodeList.toArray(new DRPairNode[nodeList.size()]);
    }

    public List<DRPairNode> getPairsOfSiteList(SiteNode site) {
        int nodeCol = this.getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
        ArrayList<DRPairNode> nodeList = new ArrayList<DRPairNode>();
        int i = this.getRowCount();
        while (i-- > 0) {
            DRPairNode node = (DRPairNode)this.getValueAt(i, nodeCol);
            if (node.getPairSecondarySite() != site && node.getPairPrimarySite() != site) continue;
            nodeList.add(node);
        }
        return nodeList;
    }

    public List<DRPairNode> getPairsOfCluster(ClusterNode cluster) {
        int nodeCol = this.getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
        ArrayList<DRPairNode> nodeList = new ArrayList<DRPairNode>();
        int i = this.getRowCount();
        while (i-- > 0) {
            DRPairNode node = (DRPairNode)this.getValueAt(i, nodeCol);
            if (!cluster.equals(node.getLocalCluster()) && !cluster.equals(node.getRemoteCluster())) continue;
            nodeList.add(node);
        }
        return nodeList;
    }

    private class PairTableClusterListener
    extends ClusterAdapter {
        private PairTableClusterListener() {
        }

        @Override
        public void clusterPropertiesChanged(ClusterEvent event) {
            int nodeCol = SrPairDetailsTableModel.this.getColumnIndex(SrPairDetailsTableHeader.NODE.getColumnName());
            ClusterNode cluster = event.getClusterNode();
            int i = SrPairDetailsTableModel.this.getRowCount();
            while (i-- > 0) {
                DRPairNode node = (DRPairNode)SrPairDetailsTableModel.this.getValueAt(i, nodeCol);
                if (cluster.equals(node.getLocalCluster())) {
                    node.setPrimSiteNode((SiteNode)cluster.getParent());
                    SrPairDetailsTableModel.this.changePair(node);
                    continue;
                }
                if (!cluster.equals(node.getRemoteCluster())) continue;
                node.setSecSiteNode((SiteNode)cluster.getParent());
                SrPairDetailsTableModel.this.changePair(node);
            }
        }
    }

    private class PairTableSiteListener
    extends SiteAdapter {
        private PairTableSiteListener() {
        }

        @Override
        public void sitePropertiesChanged(SiteEvent event) {
            List<DRPairNode> pairList = SrPairDetailsTableModel.this.getPairsOfSiteList(event.getSiteNode());
            for (DRPairNode pair : pairList) {
                SrPairDetailsTableModel.this.changePair(pair);
            }
        }
    }

    private class ModeProgressAction
    implements ActionListener {
        private boolean m_isEnabled = true;
        private DRPairNode m_node;
        int counter = 0;

        ModeProgressAction(DRPairNode node) {
            this.m_node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row;
            if (this.m_isEnabled && (row = SrPairDetailsTableModel.this.findRow(this.m_node)) >= 0) {
                int col = SrPairDetailsTableModel.this.getColumnIndex(SrPairDetailsTableHeader.MODE.getColumnName());
                SrPairDetailsTableModel.this.setValueAt(new Object[]{this.m_node.getReplicationState(), new Integer(this.counter)}, row, col);
                ++this.counter;
            }
        }

        void setEnabled(boolean b) {
            this.m_isEnabled = b;
        }
    }

    private class ModeProgressTimer
    extends Timer {
        ModeProgressAction myActionListener;

        ModeProgressTimer(DRPairNode node, ModeProgressAction actionListerner) {
            super(400, actionListerner);
            this.myActionListener = actionListerner;
        }

        @Override
        public void stop() {
            this.myActionListener.setEnabled(false);
            super.stop();
        }
    }
}

