/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.JournalTableHeader;
import com.sanrad.nms.client.data.dr.SrJournalsTableColumns;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.NotExposedVolumeTreeModelCollection;
import com.sanrad.nms.client.data.volume.SrNotExposedVolumeTreeModel;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.cluster.ClusterAdapter;
import com.sanrad.nms.client.event.cluster.ClusterEvent;
import com.sanrad.nms.client.event.volume.VolumeAdapter;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.swing.SrTableModel;
import java.util.Enumeration;
import java.util.List;

public class SrJournalsTableModel
extends SrTableModel {
    private static SrJournalsTableModel m_instance;
    private JournalClusterAdapter myJournalClusterAdapter;
    private JournalTableVolumeListener myJournalVolumeListener;

    private SrJournalsTableModel() {
        super(new SrJournalsTableColumns());
    }

    public static synchronized SrJournalsTableModel getInstance() {
        if (m_instance == null) {
            m_instance = new SrJournalsTableModel();
        }
        return m_instance;
    }

    @Override
    public void initModelData() {
        Enumeration<ClusterNode> e = SystemRootNode.getInstance().getClusterNodes().elements();
        while (e.hasMoreElements()) {
            ClusterNode clusterNode = e.nextElement();
            this.addClusterJournals(clusterNode);
        }
    }

    public void addClusterJournals(ClusterNode cluster) {
        if (cluster != null) {
            SrNotExposedVolumeTreeModel model = (SrNotExposedVolumeTreeModel)NotExposedVolumeTreeModelCollection.getInstance().getModel((RemoteObject)cluster.getStub());
            List<VolumeTreeNode> children = model.getAllVolumes();
            for (VolumeTreeNode node : children) {
                if (!(node instanceof JournalVolumeNode)) continue;
                this.addJournalRow(cluster, (JournalVolumeNode)node);
            }
            this.fireTableRowsInserted(0, this.getLastRowIndex());
        }
    }

    public JournalVolumeNode getJournal(VSwitchNode activeOnVSwitch) {
        int journalCol = this.getColumnIndex(JournalTableHeader.ALIAS.getColumnName());
        for (int i = 0; i < this.getRowCount(); ++i) {
            JournalVolumeNode journal = (JournalVolumeNode)this.getValueAt(i, journalCol);
            VSwitchNode jounalVswitch = journal.getActiveOnVSwitchNode();
            if (jounalVswitch == null || !jounalVswitch.equals(activeOnVSwitch)) continue;
            return journal;
        }
        return null;
    }

    public void removeClusterJournals(ClusterNode cluster) {
        int jourColIndex = this.getColumnIndex(JournalTableHeader.ALIAS.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            JournalVolumeNode journal = (JournalVolumeNode)this.getValueAt(i, jourColIndex);
            ClusterNode jourCluster = SystemRootNode.getInstance().getClusterNodeOfSource(journal);
            if (!cluster.equals(jourCluster)) continue;
            this.removeRow(i);
        }
    }

    private void addJournalRow(ClusterNode cluster, JournalVolumeNode journalNode) {
        Object[] row = new Object[JournalTableHeader.getColumnNames().size()];
        row[this.getColumnIndex((String)JournalTableHeader.STUB.getColumnName())] = journalNode.getStub();
        row[this.getColumnIndex((String)JournalTableHeader.ALIAS.getColumnName())] = journalNode;
        SiteNode site = (SiteNode)cluster.getParent();
        row[this.getColumnIndex((String)JournalTableHeader.SITE.getColumnName())] = site.getAlias();
        row[this.getColumnIndex((String)JournalTableHeader.CLUSTER.getColumnName())] = cluster.getAlias();
        row[this.getColumnIndex((String)JournalTableHeader.ACTIVE_ON_VSWICTH.getColumnName())] = journalNode.getActivateOnVSwitch();
        row[this.getColumnIndex((String)JournalTableHeader.THRESHOLD.getColumnName())] = new Integer(journalNode.getPercentageThreshold());
        row[this.getColumnIndex((String)JournalTableHeader.UTIL_PERCENT.getColumnName())] = new Integer(journalNode.getPercentageUtilization());
        this.addRow(row);
    }

    private int findJournalRow(Object stub) {
        int found = -1;
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object rowStub = this.getRow(i).get(this.getColumnIndex(JournalTableHeader.STUB.getColumnName()));
            if (rowStub != stub) continue;
            found = i;
            break;
        }
        return found;
    }

    private void updateRow(Object stub, String col, Object journaldata) {
        int rowIndex = this.findJournalRow(stub);
        if (rowIndex > -1) {
            this.setValueAt(journaldata, rowIndex, this.getColumnIndex(col));
        }
    }

    @Override
    public void removeListeners() {
    }

    @Override
    public void addListeners() {
        this.myJournalVolumeListener = new JournalTableVolumeListener();
        VolumeManager.getInstance().addVolumeListener(this.myJournalVolumeListener);
        this.myJournalClusterAdapter = new JournalClusterAdapter();
        ClusterManager.getInstance().addClusterListener(this.myJournalClusterAdapter);
    }

    private class JournalTableVolumeListener
    extends VolumeAdapter {
        private JournalTableVolumeListener() {
        }

        @Override
        public void journalVolActivateOnVSwitchChanged(VolumeEvent event) {
            RemoteObject stub = event.getStub();
            JournalVolumeNode journal = (JournalVolumeNode)SystemRootNode.getInstance().getRefByStub(stub);
            SrJournalsTableModel.this.updateRow(stub, JournalTableHeader.ACTIVE_ON_VSWICTH.getColumnName(), journal.getActivateOnVSwitch());
        }

        @Override
        public void journalVolPercentageThresholdChanged(VolumeEvent event) {
            RemoteObject stub = event.getStub();
            JournalVolumeNode journal = (JournalVolumeNode)SystemRootNode.getInstance().getRefByStub(stub);
            SrJournalsTableModel.this.updateRow(stub, JournalTableHeader.THRESHOLD.getColumnName(), new Integer(journal.getPercentageThreshold()));
        }

        @Override
        public void journalVolPercentageUtilizationChanged(VolumeEvent event) {
            RemoteObject stub = event.getStub();
            JournalVolumeNode journal = (JournalVolumeNode)SystemRootNode.getInstance().getRefByStub(stub);
            SrJournalsTableModel.this.updateRow(stub, JournalTableHeader.UTIL_PERCENT.getColumnName(), new Integer(journal.getPercentageUtilization()));
        }

        @Override
        public void volumeAliasChanged(VolumeEvent e) {
            RemoteObject stub = e.getStub();
            VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(stub);
            if (volume instanceof JournalVolumeNode) {
                SrJournalsTableModel.this.updateRow(stub, JournalTableHeader.ALIAS.getColumnName(), (JournalVolumeNode)volume);
            }
        }

        @Override
        public void volumeCreate(VolumeEvent e) {
            RemoteObject stub = e.getStub();
            VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(stub);
            if (volume instanceof JournalVolumeNode) {
                SrJournalsTableModel.this.addJournalRow(SystemRootNode.getInstance().getClusterNodeOfStub(stub), (JournalVolumeNode)volume);
            }
        }

        @Override
        public void volumeRemove(VolumeEvent e) {
            int row;
            RemoteObject stub = e.getStub();
            VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(stub);
            if (volume instanceof JournalVolumeNode && (row = SrJournalsTableModel.this.findJournalRow(e.getStub())) > -1) {
                SrJournalsTableModel.this.removeRow(row);
            }
        }
    }

    private class JournalClusterAdapter
    extends ClusterAdapter {
        private JournalClusterAdapter() {
        }

        @Override
        public void clusterPropertiesChanged(ClusterEvent event) {
            ClusterNode eventCluster = event.getClusterNode();
            int journalCol = SrJournalsTableModel.this.getColumnIndex(JournalTableHeader.ALIAS.getColumnName());
            int siteCol = SrJournalsTableModel.this.getColumnIndex(JournalTableHeader.SITE.getColumnName());
            int i = SrJournalsTableModel.this.getRowCount();
            while (i-- > 0) {
                ClusterNode journalCluster = SystemRootNode.getInstance().getClusterNodeOfSource((SrTreeNode)SrJournalsTableModel.this.getValueAt(i, journalCol));
                if (!journalCluster.equals(eventCluster)) continue;
                SiteNode site = (SiteNode)eventCluster.getParent();
                SrJournalsTableModel.this.setValueAt(site.getAlias(), i, siteCol);
            }
        }
    }
}

