/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.dr.SrJournalSelectionEvent;
import com.sanrad.nms.client.event.dr.SrJournalSelectionListener;
import com.sanrad.nms.client.event.volume.VolumeEvent;
import com.sanrad.nms.client.event.volume.VolumeListener;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.swing.SrTreeModel;
import com.sanrad.swing.StatusPanel;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class SrJournalDetailsTreeModel
extends SrTreeModel
implements SrJournalSelectionListener,
VolumeListener {
    private static SrLogger theLogger = SrLogger.getLogger();

    public SrJournalDetailsTreeModel() {
        super(new DefaultMutableTreeNode("Journals"));
        VolumeManager.getInstance().addVolumeListener(this);
    }

    @Override
    public void onJournalSelection(SrJournalSelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JournalVolumeNode) {
            this.setRoot((JournalVolumeNode)obj);
        } else {
            this.setRoot(null);
        }
    }

    protected void init(DefaultMutableTreeNode root) {
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        theLogger.trace(SrLogCategories.LEGACY, "VolumeTreeModel - valueForPathChanged() ! new alias- ", newValue);
        theLogger.trace(SrLogCategories.LEGACY, "======================================================");
        SrTreeNode aNode = (SrTreeNode)path.getLastPathComponent();
        aNode.setNewAlias(newValue.toString());
        String newAlias = newValue.toString();
        if (newAlias.equals("") || newAlias.equalsIgnoreCase(((VolumeTreeNode)aNode).getAlias())) {
            this.nodeChanged(aNode);
            return;
        }
        HashMap<ClientParameterCode, String> params = new HashMap<ClientParameterCode, String>();
        if (aNode instanceof SubDirectAccessDeviceNode) {
            params.put(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, newAlias);
            SrClientAction.blockActions(Collections.singleton(SubDirectAccessDeviceManager.getInstance().editSubDirectAccessDevice((SubDirectAccessDeviceNode)aNode, params)), StatusPanel.getInstance());
        } else if (aNode instanceof DirectAccessDeviceNode) {
            params.put(ClientParameterCode.PHYSICAL_STORAGE_DEVICE_ALIAS, newAlias);
            SrClientAction.blockActions(Collections.singleton(DirectAccessDeviceManager.getInstance().renameStorageDevice((DirectAccessDeviceNode)aNode, params)), StatusPanel.getInstance());
        } else if (aNode instanceof VolumeTreeNode) {
            params.put(ClientParameterCode.VOLUME_ALIAS, newAlias);
            SrClientAction.blockActions(Collections.singleton(VolumeManager.getInstance().setAlias(aNode, params)), StatusPanel.getInstance());
        }
        this.fireTreeStructureChanged(this, this.getPathToRoot(aNode), null, null);
    }

    @Override
    public void addVolumeNodeToParent(VolumeEvent event, VolumeTreeNode parentNode, VolumeTreeNode childNode) {
    }

    @Override
    public void journalVolActivateOnVSwitchChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolActivityStateChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolDateAndTimeChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageThresholdChanged(VolumeEvent event) {
    }

    @Override
    public void journalVolPercentageUtilizationChanged(VolumeEvent event) {
    }

    @Override
    public void removeVolumeNodeFromParent(VolumeEvent event, VolumeTreeNode childNode) {
    }

    @Override
    public void snapshotSourceChanged(VolumeEvent e) {
    }

    @Override
    public void snapshotVolActiveStateChanged(VolumeEvent event) {
    }

    @Override
    public void volumeAliasChanged(VolumeEvent e) {
        RemoteObject stub = e.getStub();
        VolumeTreeNode volume = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(stub);
        if (volume instanceof JournalVolumeNode) {
            this.fireTreeNodesChanged(this, this.getPathToRoot(volume), null, null);
        }
    }

    @Override
    public void volumeCapacityChanged(VolumeEvent e) {
    }

    @Override
    public void volumeConfigChanged(VolumeEvent e) {
    }

    @Override
    public void volumeCreate(VolumeEvent e) {
    }

    @Override
    public void volumeDeExposed(VolumeEvent e) {
    }

    @Override
    public void volumeExposed(VolumeEvent e) {
    }

    @Override
    public void volumeParametersChanged(VolumeEvent e) {
    }

    @Override
    public void volumeRemove(VolumeEvent e) {
    }

    @Override
    public void volumeStateChanged(VolumeEvent e) {
    }

    @Override
    public void volumeStatusChanged(VolumeEvent e) {
    }

    public void removeListeners() {
        VolumeManager.getInstance().removeVolumeListener(this);
    }

    protected void finalize() throws Throwable {
        this.removeListeners();
        super.finalize();
    }
}

