/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.ConsistencyGroupNode;
import com.sanrad.nms.client.data.dr.DRConsistencyGroupManager;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.ExtendedPairNode;
import com.sanrad.nms.client.data.dr.PolicyNode;
import com.sanrad.nms.client.data.dr.SrConsistencyGroupsTableColumns;
import com.sanrad.nms.client.data.dr.SrConsistencyGroupsTableHeader;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.event.dr.DRAsyncPairEvent;
import com.sanrad.nms.client.event.dr.DRAsyncPairListener;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupEvent;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.swing.SrTableModel;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.concurrent.SrFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class SrConsistencyGroupsTableModel
extends SrTableModel
implements DRConsistencyGroupListener,
DRAsyncPairListener {
    private static final int myRefreshPitInterval = Integer.parseInt(ClientLoader.BUNDLE.getString(SrClientBundleKeys.PIT_REFRESH_INTERVAL));
    private static String m_notAvailableValue = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_DIALOG_NOT_AVAILABLE_VALUE);
    private static SrLogger theLogger = SrLogger.getLogger();
    private static ClientParameterCode[] m_pendingPitsFields = new ClientParameterCode[]{ClientParameterCode.DR_CONSISTENCY_GROUP_PENDING_PITS, ClientParameterCode.DR_CONSISTENCY_GROUP_PENDING_DATA};
    private static SrConsistencyGroupsTableModel m_instance;

    private SrConsistencyGroupsTableModel() {
        super(new SrConsistencyGroupsTableColumns());
    }

    @Override
    public void initModelData() {
        this.readAll();
    }

    public static synchronized SrConsistencyGroupsTableModel getInstance() {
        if (m_instance == null) {
            m_instance = new SrConsistencyGroupsTableModel();
        }
        return m_instance;
    }

    private void readAll() {
        DRConsistencyGroupManager.getInstance().readConsistencyGroupsFromServer();
    }

    public void addExtendedElementRows(ExtendedElementNode[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            this.addConsistencyGroupRow(nodes[i], false);
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    public ExtendedElementNode[] getAllExtendedElementNodes() {
        ArrayList<Object> nodeList = new ArrayList<Object>();
        int col = this.getColumnIndex(SrConsistencyGroupsTableHeader.NODE.getColumnName());
        int row = this.getRowCount();
        while (row-- > 0) {
            nodeList.add(this.getValueAt(row, col));
        }
        ExtendedElementNode[] ret = new ExtendedElementNode[nodeList.size()];
        return nodeList.toArray(ret);
    }

    public void addConsistencyGroupRow(ExtendedElementNode node, boolean fire) {
        Object[] row = this.buildRowData(node);
        if (!fire) {
            this.addRowQuetly(row, -1);
        } else {
            this.addRow(row);
        }
    }

    private String getTimeUnitString(long value, String units) {
        StringBuffer timeUnitString = new StringBuffer();
        if (value > 0L) {
            timeUnitString.append(value);
            timeUnitString.append(" ");
            timeUnitString.append(units);
            timeUnitString.append(value == 1L ? " " : "s ");
        }
        return timeUnitString.toString();
    }

    private String getRunEveryText(long valueInMin) {
        StringBuffer runEvery = new StringBuffer();
        long timeInSeconds = valueInMin * 60L;
        long days = timeInSeconds / 86400L;
        long hours = (timeInSeconds -= days * 3600L * 24L) / 3600L;
        long minutes = (timeInSeconds -= hours * 3600L) / 60L;
        long seconds = timeInSeconds -= minutes * 60L;
        runEvery.append(this.getTimeUnitString(days, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_COLUMN_POLICY_RUN_EVERY_DAY)));
        runEvery.append(this.getTimeUnitString(hours, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_COLUMN_POLICY_RUN_EVERY_HOUR)));
        runEvery.append(this.getTimeUnitString(minutes, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_COLUMN_POLICY_RUN_EVERY_MINUTE)));
        runEvery.append(this.getTimeUnitString(seconds, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_COLUMN_POLICY_RUN_EVERY_SECOND)));
        return runEvery.toString();
    }

    private Object[] buildRowData(ExtendedElementNode node) {
        Object[] row = new Object[SrConsistencyGroupsTableHeader.getColumnNames().size()];
        row[this.getColumnIndex((String)SrConsistencyGroupsTableHeader.NODE.getColumnName())] = node;
        row[this.getColumnIndex((String)SrConsistencyGroupsTableHeader.REPLICATION_POLICY_METHOD.getColumnName())] = node.getReplicationPolicy();
        if (node.getReplicationPolicy() != null) {
            row[this.getColumnIndex((String)SrConsistencyGroupsTableHeader.REPLICATION_POLICY_RUN_EVERY.getColumnName())] = this.getRunEveryText(node.getReplicationPolicy().getRunEvery());
        } else {
            theLogger.error(SrLogCategories.LEGACY, "CG Table Model: ", node, "'s  replication policy is null");
        }
        PolicyNode transferPolicy = node.getTransferPolicy();
        if (transferPolicy == null) {
            transferPolicy = node.getReplicationPolicy();
        }
        row[this.getColumnIndex((String)SrConsistencyGroupsTableHeader.TRANSFER_POLICY_METHOD.getColumnName())] = transferPolicy;
        if (node.getReplicationPolicy() != null) {
            row[this.getColumnIndex((String)SrConsistencyGroupsTableHeader.TRANSFER_POLICY_RUN_EVERY.getColumnName())] = this.getRunEveryText(transferPolicy.getRunEvery());
        } else {
            theLogger.error(SrLogCategories.LEGACY, "CG Table Model: ", node, "'s transfer policy is null");
        }
        row[this.getColumnIndex((String)SrConsistencyGroupsTableHeader.MERGE_POLICY.getColumnName())] = node.getMergePolicy();
        row[this.getColumnIndex((String)SrConsistencyGroupsTableHeader.ACTIVITY.getColumnName())] = node.getState();
        if (!DRReplicationStateConstant.INACTIVE.equals(node.getReplicationState())) {
            String[] args = new String[]{String.valueOf(node.getNotReplicatedPits()), String.valueOf(node.getNotReplicatedData())};
            String pendingPitsStr = ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_COLUMN_PENDING_PITS_VALUE, args);
            row[this.getColumnIndex((String)SrConsistencyGroupsTableHeader.PENDING_PITS.getColumnName())] = pendingPitsStr;
        } else {
            row[this.getColumnIndex((String)SrConsistencyGroupsTableHeader.PENDING_PITS.getColumnName())] = m_notAvailableValue;
        }
        row[this.getColumnIndex((String)SrConsistencyGroupsTableHeader.ALIAS.getColumnName())] = node;
        row[this.getColumnIndex((String)SrConsistencyGroupsTableHeader.NUM_OF_PAIRS.getColumnName())] = new Integer(node.getPairsStubs().length);
        return row;
    }

    public int removeConsistencyGroupRow(ExtendedElementNode removedNode) {
        int nodeIndex = this.getColumnIndex(SrConsistencyGroupsTableHeader.NODE.getColumnName());
        for (int i = 0; i < this.getRowCount(); ++i) {
            ExtendedElementNode node = (ExtendedElementNode)this.getRow(i).get(nodeIndex);
            if (removedNode != node) continue;
            this.removeRow(i);
            return i;
        }
        return -1;
    }

    public void editConsistencyGroupRow(ExtendedElementNode node) {
        int nodeCol = this.getColumnIndex(SrConsistencyGroupsTableHeader.NODE.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            ExtendedElementNode rowNode = (ExtendedElementNode)this.getRow(i).get(nodeCol);
            if (rowNode != node) continue;
            this.editRow(i, this.buildRowData(node));
            break;
        }
    }

    private ArrayList getExtendedElementNodes(boolean getConsistencyGroupNodes, boolean returnEmptyGroups) {
        ArrayList<ExtendedElementNode> cgs = new ArrayList<ExtendedElementNode>(this.getRowCount());
        int nodeIndex = this.getColumnIndex(SrConsistencyGroupsTableHeader.NODE.getColumnName());
        for (int i = 0; i < this.getRowCount(); ++i) {
            int num;
            ExtendedElementNode node = (ExtendedElementNode)this.getValueAt(i, nodeIndex);
            if ((!getConsistencyGroupNodes || !(node instanceof ConsistencyGroupNode)) && (getConsistencyGroupNodes || !(node instanceof ExtendedPairNode)) || node instanceof ConsistencyGroupNode && (num = ((ConsistencyGroupNode)node).getPairs().length) == 0 && !returnEmptyGroups) continue;
            cgs.add(node);
        }
        return cgs;
    }

    public ConsistencyGroupNode[] getLocalCGNodesOfCluster(ClusterNode clusterNode, boolean includeEmptyGroups) {
        ArrayList<ExtendedElementNode> cgs = new ArrayList<ExtendedElementNode>();
        int nodeIndex = this.getColumnIndex(SrConsistencyGroupsTableHeader.NODE.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            ExtendedElementNode node = (ExtendedElementNode)this.getValueAt(i, nodeIndex);
            if (!(node instanceof ConsistencyGroupNode) || !node.isLocalCluster(clusterNode) || ((ConsistencyGroupNode)node).isEmpty() && !includeEmptyGroups) continue;
            cgs.add(node);
        }
        ConsistencyGroupNode[] nodes = new ConsistencyGroupNode[cgs.size()];
        return cgs.toArray(nodes);
    }

    public ConsistencyGroupNode[] getRemoteCGNodesOfCluster(ClusterNode clusterNode, boolean includeEmptyGroups) {
        ArrayList<ExtendedElementNode> cgs = new ArrayList<ExtendedElementNode>();
        int nodeIndex = this.getColumnIndex(SrConsistencyGroupsTableHeader.NODE.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            ExtendedElementNode node = (ExtendedElementNode)this.getValueAt(i, nodeIndex);
            if (!(node instanceof ConsistencyGroupNode) || !node.isRemoteCluster(clusterNode) || ((ConsistencyGroupNode)node).isEmpty() && !includeEmptyGroups) continue;
            cgs.add(node);
        }
        ConsistencyGroupNode[] nodes = new ConsistencyGroupNode[cgs.size()];
        return cgs.toArray(nodes);
    }

    public List<ExtendedElementNode> getAllGroupsPrimaryOnSite(SiteNode siteNode) {
        ArrayList<ExtendedElementNode> cgList = new ArrayList<ExtendedElementNode>();
        int nodeIndex = this.getColumnIndex(SrConsistencyGroupsTableHeader.NODE.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            ExtendedElementNode node = (ExtendedElementNode)this.getValueAt(i, nodeIndex);
            if (node.isEmpty() || !this.isPrimaryOnSite(node, siteNode)) continue;
            cgList.add(node);
        }
        return cgList;
    }

    public ExtendedElementNode[] getNodesPrimaryOnSite(SiteNode siteNode) {
        List<ExtendedElementNode> nodeList = this.getAllGroupsPrimaryOnSite(siteNode);
        return nodeList.toArray(new ExtendedElementNode[nodeList.size()]);
    }

    public ExtendedElementNode[] getNodesSecondaryOnSite(SiteNode siteNode) {
        ArrayList<ExtendedElementNode> cgList = new ArrayList<ExtendedElementNode>();
        int nodeIndex = this.getColumnIndex(SrConsistencyGroupsTableHeader.NODE.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            ExtendedElementNode node = (ExtendedElementNode)this.getValueAt(i, nodeIndex);
            if (node.isEmpty() || node.getRemoteCluster() == null || node.getRemoteCluster().getParent() != siteNode) continue;
            cgList.add(node);
        }
        return cgList.toArray(new ExtendedElementNode[cgList.size()]);
    }

    private boolean isPrimaryOnSite(ExtendedElementNode node, SiteNode siteNode) {
        return node.getPairs()[0].getPairPrimarySite() == siteNode;
    }

    public ArrayList getRemoteExtendedElementNodes(boolean getConsistencyGroupNodes, ClusterNode remoteCluster) {
        ArrayList cgs = this.getExtendedElementNodes(getConsistencyGroupNodes, true);
        Iterator iter = cgs.iterator();
        while (iter.hasNext()) {
            ExtendedElementNode node = (ExtendedElementNode)iter.next();
            if (node.isRemoteCluster(remoteCluster)) continue;
            iter.remove();
        }
        return cgs;
    }

    private Collection<SrFuture<Void>> refreshPendingPITs() {
        Vector<SrFuture<Void>> retVal = new Vector<SrFuture<Void>>(this.getRowCount());
        int i = this.getRowCount();
        while (i-- > 0) {
            ExtendedElementNode node = (ExtendedElementNode)this.getRow(i).get(this.getColumnIndex(SrConsistencyGroupsTableHeader.NODE.getColumnName()));
            if (DRReplicationStateConstant.INACTIVE.equals(node.getReplicationState())) continue;
            retVal.add(ClientAOImpl.getInstance().refreshFields((String)node.getIdentifier(), m_pendingPitsFields));
            break;
        }
        return retVal;
    }

    @Override
    public void consistencyGroupAliasChanged(DRConsistencyGroupEvent e) {
    }

    @Override
    public void consistencyGroupCreated(DRConsistencyGroupEvent e) {
        this.addConsistencyGroupRow(e.getExtendedElementNode(), true);
    }

    @Override
    public void consistencyGroupRemoved(DRConsistencyGroupEvent e) {
        this.removeConsistencyGroupRow(e.getExtendedElementNode());
    }

    @Override
    public void consistencyGroupChanged(DRConsistencyGroupEvent e) {
        this.editConsistencyGroupRow(e.getExtendedElementNode());
    }

    @Override
    public void asyncPairCreated(DRAsyncPairEvent e) {
        this.editConsistencyGroupRow(e.getPair().getConsistencyGroup());
    }

    @Override
    public void asyncPairRemoved(DRAsyncPairEvent e) {
        this.editConsistencyGroupRow(e.getPair().getConsistencyGroup());
    }

    @Override
    public void asyncPairChanged(DRAsyncPairEvent e) {
    }

    @Override
    public void removeListeners() {
    }

    @Override
    public void addListeners() {
        DRConsistencyGroupManager.getInstance().addDRConsistencyGroupListener(this);
    }
}

