/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr;

import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRConsistencyGroupManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.SrCGPairsTableHeader;
import com.sanrad.nms.client.data.site.SiteManager;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.event.dr.DRAsyncPairEvent;
import com.sanrad.nms.client.event.dr.DRAsyncPairListener;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupEvent;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupListener;
import com.sanrad.nms.client.event.site.SiteEvent;
import com.sanrad.nms.client.event.site.SiteListener;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;

public class SrCGPairsTableModel
extends SrTableModel
implements DRConsistencyGroupListener,
DRAsyncPairListener,
SiteListener {
    private static SrCGPairsTableModel m_instance;
    private ExtendedElementNode m_currentCGNode = null;

    private SrCGPairsTableModel() {
        super(new SrDefaultTableColumns(SrCGPairsTableHeader.getColumnNames()));
    }

    public static synchronized SrCGPairsTableModel getInstance() {
        if (m_instance == null) {
            m_instance = new SrCGPairsTableModel();
        }
        return m_instance;
    }

    public void initRows(ExtendedElementNode cg) {
        this.removeAllRows();
        if (cg != null) {
            DRASyncPairNode[] nodes = cg.getPairs();
            this.m_currentCGNode = cg;
            for (int i = 0; i < nodes.length; ++i) {
                this.addPair(nodes[i]);
            }
        } else {
            this.m_currentCGNode = null;
        }
    }

    private void addPair(DRASyncPairNode node) {
        this.addRow(this.createRow(node));
    }

    private void removePair(DRASyncPairNode node) {
        int row = this.getPairRowIndex(node);
        if (row != -1) {
            this.removeRow(row);
        }
    }

    private void editPair(DRASyncPairNode node) {
        int nodeCol = this.getColumnIndex(SrCGPairsTableHeader.NODE.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            if (this.getValueAt(i, nodeCol) != node) continue;
            this.editRow(i, this.createRow(node));
            break;
        }
    }

    private Object[] createRow(DRASyncPairNode node) {
        Object[] row = new Object[SrCGPairsTableHeader.getColumnNames().size()];
        row[this.getColumnIndex((String)SrCGPairsTableHeader.NODE.getColumnName())] = node;
        SiteNode primSite = node.getPairPrimarySite();
        row[this.getColumnIndex((String)SrCGPairsTableHeader.PRIM_SITE.getColumnName())] = primSite == null ? "" : primSite.getAlias();
        row[this.getColumnIndex((String)SrCGPairsTableHeader.PRIM_VOLUME.getColumnName())] = node.getPairPrimaryVolume();
        SiteNode secSite = node.getPairSecondarySite();
        row[this.getColumnIndex((String)SrCGPairsTableHeader.SEC_SITE.getColumnName())] = secSite == null ? "" : secSite.getAlias();
        row[this.getColumnIndex((String)SrCGPairsTableHeader.SEC_VOLUME.getColumnName())] = node.getPairSecondaryVolume();
        return row;
    }

    private int getPairRowIndex(DRPairNode node) {
        int index = -1;
        int nodeCol = this.getColumnIndex(SrCGPairsTableHeader.NODE.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            DRASyncPairNode currNode = (DRASyncPairNode)this.getValueAt(i, nodeCol);
            if (currNode != node) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public void consistencyGroupAliasChanged(DRConsistencyGroupEvent e) {
    }

    @Override
    public void consistencyGroupChanged(DRConsistencyGroupEvent e) {
    }

    @Override
    public void consistencyGroupCreated(DRConsistencyGroupEvent e) {
    }

    @Override
    public void consistencyGroupRemoved(DRConsistencyGroupEvent e) {
        if (e.getExtendedElementNode() == this.m_currentCGNode) {
            this.removeAllRows();
        }
    }

    @Override
    public void asyncPairCreated(DRAsyncPairEvent e) {
        DRASyncPairNode node = e.getPair();
        if (node.getConsistencyGroup().equals(this.m_currentCGNode)) {
            this.addPair(node);
        }
    }

    @Override
    public void asyncPairRemoved(DRAsyncPairEvent e) {
        this.removePair(e.getPair());
    }

    @Override
    public void asyncPairChanged(DRAsyncPairEvent e) {
        DRASyncPairNode node = e.getPair();
        int indexInTable = this.getPairRowIndex(e.getPair());
        if (indexInTable >= 0 && node.getConsistencyGroup().equals(this.m_currentCGNode)) {
            this.editPair(node);
        } else if (indexInTable >= 0 && !node.getConsistencyGroup().equals(this.m_currentCGNode)) {
            this.removePair(node);
        } else if (indexInTable < 0 && node.getConsistencyGroup().equals(this.m_currentCGNode)) {
            this.addPair(node);
        }
    }

    @Override
    public void siteCreated(SiteEvent event) {
    }

    @Override
    public void sitePropertiesChanged(SiteEvent event) {
        SiteNode site = event.getSiteNode();
        int nodeCol = this.getColumnIndex(SrCGPairsTableHeader.NODE.getColumnName());
        int i = this.getRowCount();
        while (i-- > 0) {
            DRASyncPairNode node = (DRASyncPairNode)this.getValueAt(i, nodeCol);
            if (node.getPairSecondarySite() != site && node.getPairPrimarySite() != site) continue;
            this.editPair(node);
        }
    }

    @Override
    public void siteRemoved(SiteEvent event) {
    }

    @Override
    public void siteStatusChanged(SiteEvent event) {
    }

    @Override
    public void removeListeners() {
    }

    @Override
    public void addListeners() {
        DRConsistencyGroupManager.getInstance().addDRConsistencyGroupListener(this);
        DRASyncPairManager.getInstance().addDRAsyncPairListener(this);
        SiteManager.getInstance().addSiteListener(this);
    }
}

