/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr;

import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.MergePolicyNode;
import com.sanrad.nms.client.data.dr.ReplicationPolicyNode;
import com.sanrad.nms.client.data.dr.TransferPolicyNode;
import com.sanrad.nms.client.data.dr.pit.DRPiTNode;
import com.sanrad.nms.client.data.dr.pit.PiTContainer;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.server.logic.dr.DRActivate;
import com.sanrad.nms.server.logic.dr.DRAsyncPair;
import com.sanrad.nms.server.util.types.constants.CFStateConstant;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.nms.server.util.types.constants.VirtualGroupStateConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;

public abstract class ExtendedElementNode
extends SrTreeNode<DRActivate, String>
implements PiTContainer {
    private ReplicationPolicyNode m_replicationPolicyNode;
    private TransferPolicyNode m_transferPolicyNode;
    private MergePolicyNode m_mergePolicyNode;
    private ArrayList m_pairs = new ArrayList();
    private ArrayList m_pits = new ArrayList();
    private ArrayList m_pairsStubs = new ArrayList();
    private ClusterNode m_localCluster;
    private ClusterNode m_remoteCluster;
    private VirtualGroupStateConstant m_state;
    private DRModeConstant m_mode;
    private DRInitialSyncStateConstant m_initialSyncState;
    private SrBITSConstant m_replicationState;
    private Long m_pendingData;
    private Long m_pendingPits;
    private Long m_notReplicatedPits;
    private Long m_notReplicatedData;
    private Long m_notMergedPits;
    private Long m_lastMerge;
    private Long m_nextRelication;
    private CFStateConstant m_cfState;

    protected ExtendedElementNode(DRActivate stub, ReplicationPolicyNode replicationPolicyNode, TransferPolicyNode transferPolicyNode, MergePolicyNode mergePolicyNode, VirtualGroupStateConstant state, ClusterNode localCluster, ClusterNode remoteCluster) throws RemoteException {
        this(stub);
        this.m_replicationPolicyNode = replicationPolicyNode;
        this.m_transferPolicyNode = transferPolicyNode;
        this.m_mergePolicyNode = mergePolicyNode;
        this.m_state = state;
        this.m_localCluster = localCluster;
        this.m_remoteCluster = remoteCluster;
    }

    protected ExtendedElementNode(DRActivate stub) throws RemoteException {
        super(stub, stub.hashKey());
    }

    public ReplicationPolicyNode getReplicationPolicy() {
        return this.m_replicationPolicyNode;
    }

    public TransferPolicyNode getTransferPolicy() {
        return this.m_transferPolicyNode;
    }

    public MergePolicyNode getMergePolicy() {
        return this.m_mergePolicyNode;
    }

    public VirtualGroupStateConstant getState() {
        return this.m_state;
    }

    public void setMergePolicyNode(MergePolicyNode mergePolicyNode) {
        this.m_mergePolicyNode = mergePolicyNode;
    }

    public void setReplicationPolicyNode(ReplicationPolicyNode replicationPolicyNode) {
        this.m_replicationPolicyNode = replicationPolicyNode;
    }

    public void setState(VirtualGroupStateConstant state) {
        this.m_state = state;
    }

    public void setTransferPolicyNode(TransferPolicyNode transferPolicyNode) {
        this.m_transferPolicyNode = transferPolicyNode;
    }

    public void setPairs(DRASyncPairNode[] pairs) {
        this.m_pairs.clear();
        this.m_pairsStubs.clear();
        for (int i = 0; i < pairs.length; ++i) {
            this.m_pairs.add(pairs[i]);
            this.m_pairsStubs.add(pairs[i].getStub());
        }
    }

    public void setPairsStubs(DRAsyncPair[] stubs) {
        this.m_pairsStubs.clear();
        for (int i = 0; i < stubs.length; ++i) {
            this.m_pairsStubs.add(stubs[i]);
        }
    }

    public DRASyncPairNode[] getPairs() {
        DRASyncPairNode[] pairs = new DRASyncPairNode[this.m_pairs.size()];
        return this.m_pairs.toArray(pairs);
    }

    public DRAsyncPair[] getPairsStubs() {
        DRAsyncPair[] stubs = new DRAsyncPair[this.m_pairsStubs.size()];
        return this.m_pairsStubs.toArray(stubs);
    }

    public void addASyncPair(DRASyncPairNode pair) {
        Object stub;
        if (!this.m_pairs.contains(pair)) {
            this.m_pairs.add(pair);
        }
        if (!this.m_pairsStubs.contains(stub = pair.getStub())) {
            this.m_pairsStubs.add(stub);
        }
    }

    public void removeASyncPair(DRASyncPairNode pair) {
        this.m_pairs.remove(pair);
        this.m_pairsStubs.remove(pair.getStub());
    }

    protected void clearAllPairs() {
        this.m_pairs.clear();
        this.m_pairsStubs.clear();
    }

    @Override
    public ClusterNode getLocalCluster() {
        return this.m_localCluster;
    }

    public boolean isLocalCluster(ClusterNode localCluster) {
        if (this.getLocalCluster() != null) {
            return this.getLocalCluster().equals(localCluster);
        }
        return false;
    }

    @Override
    public ClusterNode getRemoteCluster() {
        if (this.m_remoteCluster == null) {
            int i = this.m_pairs.size();
            while (i-- > 0) {
                DRASyncPairNode pair = (DRASyncPairNode)this.m_pairs.get(i);
                if (pair.isPartial()) continue;
                return pair.getRemoteCluster();
            }
        }
        return this.m_remoteCluster;
    }

    public boolean isRemoteCluster(ClusterNode remoteCluster) {
        if (this.getRemoteCluster() != null) {
            return this.getRemoteCluster().equals(remoteCluster);
        }
        return false;
    }

    public void setLocalCluster(ClusterNode cluster) {
        this.m_localCluster = cluster;
    }

    public void setRemoteCluster(ClusterNode cluster) {
        this.m_remoteCluster = cluster;
    }

    public boolean isEmpty() {
        return this.m_pairs.size() == 0;
    }

    public DRInitialSyncStateConstant getInitialSyncState() {
        return this.m_initialSyncState;
    }

    public void setInitialSyncState(DRInitialSyncStateConstant initialSyncState) {
        this.m_initialSyncState = initialSyncState;
    }

    @Override
    public DRModeConstant getMode() {
        return this.m_mode;
    }

    public void setMode(DRModeConstant mode) {
        this.m_mode = mode;
    }

    public Long getPendingData() {
        return this.m_pendingData;
    }

    public void setPendingData(Long pendingData) {
        this.m_pendingData = pendingData;
    }

    public Long getPendingPits() {
        return this.m_pendingPits;
    }

    public void setPendingPits(Long pendingPits) {
        this.m_pendingPits = pendingPits;
    }

    public SrBITSConstant getReplicationState() {
        return this.m_replicationState;
    }

    public void setReplicationState(SrBITSConstant replicationState) {
        this.m_replicationState = replicationState;
    }

    public boolean isPartial() {
        if (this.m_pairs.size() > 0) {
            int i = this.m_pairs.size();
            while (i-- > 0) {
                if (!((DRPairNode)this.m_pairs.get(i)).isPartial()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public Long getNotMergedPits() {
        return this.m_notMergedPits;
    }

    public void setNotMergedPits(Long notMergedPits) {
        this.m_notMergedPits = notMergedPits;
    }

    public Long getNotReplicatedPits() {
        return this.m_notReplicatedPits;
    }

    public void setNotReplicatedPits(Long notReplicatedPits) {
        this.m_notReplicatedPits = notReplicatedPits;
    }

    public Long getNotReplicatedData() {
        return this.m_notReplicatedData;
    }

    public void setNotReplicatedData(Long notReplicatedData) {
        this.m_notReplicatedData = notReplicatedData;
    }

    public VSwitchNode getSecondaryVSwitch() {
        int i = this.m_pairs.size();
        while (i-- > 0) {
            String secTargetVSwitch;
            LUNode secLU;
            DRASyncPairNode samplePair = (DRASyncPairNode)this.m_pairs.get(i);
            VolumeTreeNode secondaryVolume = samplePair.getPairSecondaryVolume();
            if (secondaryVolume == null || (secLU = secondaryVolume.getLUNode()) == null || (secTargetVSwitch = secLU.getTargetParent().getExposedOnVSwitchName()) == null) continue;
            ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(secondaryVolume);
            return cluster.getVSwitchByName(secTargetVSwitch);
        }
        return null;
    }

    public VSwitchNode getPrimaryVSwitch() {
        int i = this.m_pairs.size();
        while (i-- > 0) {
            String primTargetVSwitch;
            LUNode primLU;
            DRASyncPairNode samplePair = (DRASyncPairNode)this.m_pairs.get(i);
            VolumeTreeNode primaryVolume = samplePair.getPairPrimaryVolume();
            if (primaryVolume == null || (primLU = primaryVolume.getLUNode()) == null || (primTargetVSwitch = primLU.getTargetParent().getExposedOnVSwitchName()) == null) continue;
            ClusterNode cluster = SystemRootNode.getInstance().getClusterNodeOfSource(primaryVolume);
            return cluster.getVSwitchByName(primTargetVSwitch);
        }
        return null;
    }

    @Override
    public void addPiT(DRPiTNode pit) {
        if (!this.m_pits.contains(pit)) {
            this.m_pits.add(pit);
        }
    }

    @Override
    public DRPiTNode[] getPiTs() {
        return this.m_pits.toArray(new DRPiTNode[this.m_pits.size()]);
    }

    @Override
    public void removePiT(DRPiTNode pit) {
        this.m_pits.remove(pit);
    }

    public boolean containsPair(DRASyncPairNode pair) {
        return this.m_pairs.contains(pair);
    }

    public Long getLastMerge() {
        return this.m_lastMerge;
    }

    public void setLastMerge(Long lastMerge) {
        this.m_lastMerge = lastMerge;
    }

    public Long getNextRelication() {
        return this.m_nextRelication;
    }

    public void setNextRelication(Long nextRelication) {
        this.m_nextRelication = nextRelication;
    }

    public CFStateConstant getControlFunctionState() {
        return this.m_cfState;
    }

    public void setControlFunctionState(CFStateConstant cfState) {
        this.m_cfState = cfState;
    }

    public boolean isInPlannedFailoverState() {
        if (this.m_replicationState != null) {
            return this.m_replicationState.contains(DRReplicationStateConstant.PLANNED_FAILOVER);
        }
        return false;
    }

    public boolean isInFallbackState() {
        if (this.m_replicationState != null) {
            return this.m_replicationState.contains(DRReplicationStateConstant.FALLBACK);
        }
        return false;
    }
}

