/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.DRSyncPairNode;
import com.sanrad.nms.client.data.dr.SrPairDetailsTableModel;
import com.sanrad.nms.client.data.raid.RaidManager;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.client.event.dr.DRSyncPairEvent;
import com.sanrad.nms.client.event.dr.DRSyncPairListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.dr.DRPair;
import com.sanrad.nms.server.logic.dr.DRRoot;
import com.sanrad.nms.server.logic.dr.DRSyncPair;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;

public class DRSyncPairManager
extends DRPairManager {
    private static DRSyncPairManager m_theInstance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer syncPairChangedInformer = new SrEventListenerManager.Informer<DRSyncPairListener, DRSyncPairEvent>(){

        @Override
        public void inform(DRSyncPairListener listener, DRSyncPairEvent event) {
            listener.syncPairChanged(event);
        }
    };
    SrEventListenerManager.Informer syncPairCreatedInformer = new SrEventListenerManager.Informer<DRSyncPairListener, DRSyncPairEvent>(){

        @Override
        public void inform(DRSyncPairListener listener, DRSyncPairEvent event) {
            listener.syncPairCreated(event);
        }
    };
    SrEventListenerManager.Informer syncPairRemovedInformer = new SrEventListenerManager.Informer<DRSyncPairListener, DRSyncPairEvent>(){

        @Override
        public void inform(DRSyncPairListener listener, DRSyncPairEvent event) {
            listener.syncPairRemoved(event);
        }
    };

    private DRSyncPairManager() {
    }

    public static synchronized DRSyncPairManager getInstance() {
        if (m_theInstance == null) {
            m_theInstance = new DRSyncPairManager();
        }
        return m_theInstance;
    }

    public void addDRSyncPairListener(DRSyncPairListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeDRSyncPairListener(DRSyncPairListener listener) {
        this.m_listeners.remove(listener);
    }

    public void init() {
        this.clearAll();
        this.readSyncPairsFromServer();
    }

    public void clearAll() {
        SystemRootNode sysRoot = SystemRootNode.getInstance();
        DRSyncPairNode[] nodes = SrPairDetailsTableModel.getInstance().removeAllSyncPairRows();
        int i = nodes.length;
        while (i-- > 0) {
            sysRoot.removeRefAndIdByStub((RemoteObject)nodes[i].getStub());
        }
    }

    public void readSyncPairsFromServer() {
        try {
            SystemRootNode sysRootNode = SystemRootNode.getInstance();
            DRRoot drRoot = sysRootNode.getDRRootStub();
            DRSyncPair[] pairs = drRoot.getSyncPairs();
            int i = pairs.length;
            while (i-- > 0) {
                this.createPairNode(pairs[i], pairs[i].getClientParameterList());
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            return;
        }
        catch (IllegalValueException re) {
            theLogger.trace(SrLogCategories.LEGACY, re.getMessage());
        }
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (!DRManager.getInstance().isDRDiscoveryCompleted()) {
            return;
        }
        DRSyncPair pair = (DRSyncPair)element;
        DRSyncPairNode syncPairNode = (DRSyncPairNode)SystemRootNode.getInstance().getRefByStub(pair);
        this.prepareSyncPairNode(syncPairNode, this.getParameterList(e));
        this.fireSyncPairChanged(syncPairNode);
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (!DRManager.getInstance().isDRDiscoveryCompleted()) {
            return;
        }
        DRSyncPairNode node = (DRSyncPairNode)SystemRootNode.getInstance().getRefByStub(element);
        if (node != null) {
            theLogger.trace(SrLogCategories.LEGACY, "DRPairManager: pair removed");
            RaidManager.getInstance().reactToDRPairEvents();
            this.fireSyncPairRemoved(node);
            super.elementRemove(e);
            SystemRootNode.getInstance().removeRefAndIdByStub(element);
        }
    }

    @Override
    protected DRPairNode createPairNode(DRPair pair, HashMap clientParams) throws RemoteException {
        DRSyncPair syncPair = (DRSyncPair)pair;
        DRSyncPairNode node = new DRSyncPairNode(syncPair);
        this.prepareSyncPairNode(node, clientParams);
        SystemRootNode.getInstance().putRefAndStub(syncPair, node);
        node.setStatus(DRSyncPairManager.getSeverity(pair.getPropagatedState()));
        this.fireSyncPairCreated(node);
        RaidManager.getInstance().reactToDRPairEvents();
        return node;
    }

    private void prepareSyncPairNode(DRSyncPairNode node, HashMap clientParams) {
        super.preparePairNode(node, clientParams);
        SrBITSConstant replState = (SrBITSConstant)clientParams.get(ClientParameterCode.DR_SYNC_PAIR_REPLICATION_STATE);
        node.setReplicationState(replState);
    }

    @Override
    protected ClientParameterCode getReplicationStateCode() {
        return ClientParameterCode.DR_SYNC_PAIR_REPLICATION_STATE;
    }

    private void fireSyncPairChanged(DRSyncPairNode node) {
        DRSyncPairEvent event = new DRSyncPairEvent(node);
        this.m_listeners.fireEvent(DRSyncPairListener.class, event, this.syncPairChangedInformer);
    }

    private void fireSyncPairCreated(DRSyncPairNode node) {
        DRSyncPairEvent event = new DRSyncPairEvent(node);
        this.m_listeners.fireEvent(DRSyncPairListener.class, event, this.syncPairCreatedInformer);
    }

    private void fireSyncPairRemoved(DRSyncPairNode node) {
        DRSyncPairEvent event = new DRSyncPairEvent(node);
        this.m_listeners.fireEvent(DRSyncPairListener.class, event, this.syncPairRemovedInformer);
    }

    public SrFuture<Void> createSyncPair(DRPairInitialSyncTypeConstant initialSyncType, VolumeTreeNode<?> primaryVolume, VolumeTreeNode<?> secondaryVolume, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun) {
        return ClientAOImpl.getInstance().createSyncPair(initialSyncType, (CommKeyClassId)primaryVolume.getIdentifier(), (CommKeyClassId)secondaryVolume.getIdentifier(), localTarget, localLun, remoteTarget, remoteLun);
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
        RemoteObject obj = e.getStub();
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(obj);
        if (node != null && node instanceof DRSyncPairNode) {
            node.setStatus(DRSyncPairManager.getSeverity(e.getState()));
            RaidManager.getInstance().reactToDRPairEvents();
            this.fireSyncPairChanged((DRSyncPairNode)node);
        }
    }

    public SrFuture<Void> changeSyncPair(DRSyncPairNode node, HashMap params) {
        return ClientAOImpl.getInstance().changeElements(Collections.singleton(node.getIdentifier()), params);
    }

    public SrFuture<Void> recover(DRSyncPairNode node, VolumeTreeNode<?> volume) {
        return ClientAOImpl.getInstance().recover((String)node.getIdentifier(), (CommKeyClassId)volume.getIdentifier());
    }
}

