/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.volume.copy.CopyOperManager;
import com.sanrad.nms.server.logic.dr.DRPair;
import com.sanrad.nms.server.util.types.constants.CFStateConstant;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.nms.server.util.types.constants.DRStateConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import java.rmi.RemoteException;

public abstract class DRPairNode
extends SrTreeNode<DRPair, String> {
    private DRPairTypeConstant m_pairType;
    private SiteNode m_primSiteNode;
    private VolumeTreeNode m_primVolNode;
    private VolumeTreeNode m_localSecondaryVolume;
    private SiteNode m_secSiteNode;
    private VolumeTreeNode m_secVolNode;
    private VolumeTreeNode m_remotePrimaryVolume;
    private DRPairInitialSyncTypeConstant m_initialSyncType;
    private DRInitialSyncStateConstant m_initialSyncState;
    private Integer m_initialSyncProgress;
    private DRStateConstant m_state;
    private DRModeConstant m_mode;
    private Integer m_dataTransffered;
    private SrBITSConstant m_replicationState;
    private ClusterNode m_localCluster;
    private ClusterNode m_remoteCluster;
    private CFStateConstant m_cfState;

    public DRPairNode(DRPair stub) throws RemoteException {
        super(stub, stub.hashKey());
    }

    public SiteNode getPairPrimarySite() {
        return this.m_primSiteNode;
    }

    public VolumeTreeNode getPairPrimaryVolume() {
        return this.m_primVolNode;
    }

    public SiteNode getPairSecondarySite() {
        return this.m_secSiteNode;
    }

    public VolumeTreeNode getPairSecondaryVolume() {
        return this.m_secVolNode;
    }

    public DRStateConstant getPairState() {
        return this.m_state;
    }

    public Integer getDataTransffered() {
        return this.m_dataTransffered;
    }

    public DRPairInitialSyncTypeConstant getInitialSyncType() {
        return this.m_initialSyncType;
    }

    @Override
    public String type() {
        return DRPairNode.class.toString();
    }

    public void setInitialSyncType(DRPairInitialSyncTypeConstant initialSyncPolicy) {
        this.m_initialSyncType = initialSyncPolicy;
    }

    public void setDataTransffered(Integer pendingData) {
        this.m_dataTransffered = pendingData;
    }

    public void setPrimSiteNode(SiteNode primSiteNode) {
        this.m_primSiteNode = primSiteNode;
    }

    public void setPrimVolNode(VolumeTreeNode primVolNode) {
        this.m_primVolNode = primVolNode;
    }

    public void setSecSiteNode(SiteNode secSiteNode) {
        this.m_secSiteNode = secSiteNode;
    }

    public void setSecVolNode(VolumeTreeNode secVolNode) {
        this.m_secVolNode = secVolNode;
    }

    public void setState(DRStateConstant state) {
        this.m_state = state;
    }

    public DRInitialSyncStateConstant getInitialSyncState() {
        return this.m_initialSyncState;
    }

    public void setInitialSyncState(DRInitialSyncStateConstant syncState) {
        this.m_initialSyncState = syncState;
    }

    public DRModeConstant getMode() {
        return this.m_mode;
    }

    public void setMode(DRModeConstant mode) {
        this.m_mode = mode;
    }

    public boolean isPartial() {
        return this.m_primVolNode == null || this.m_secVolNode == null;
    }

    @Override
    public String toString() {
        StringBuffer string = new StringBuffer();
        string.append("<");
        if (this.m_primSiteNode != null) {
            string.append(this.m_primSiteNode.toString());
        }
        if (this.m_primVolNode != null) {
            string.append("/" + this.m_primVolNode.getAlias());
        }
        string.append(" - ");
        if (this.m_secSiteNode != null) {
            string.append(this.m_secSiteNode.getAlias());
        }
        if (this.m_secVolNode != null) {
            string.append("/" + this.m_secVolNode.toString());
        }
        string.append(">");
        return string.toString();
    }

    public SrBITSConstant getReplicationState() {
        return this.m_replicationState;
    }

    public void setReplicationState(SrBITSConstant replicationState) {
        this.m_replicationState = replicationState;
    }

    public Integer getInitialSyncProgress() {
        return this.m_initialSyncProgress;
    }

    public void setInitialSyncProgress(Integer initialSyncProgress) {
        this.m_initialSyncProgress = initialSyncProgress;
    }

    public String getVolumeDRRole(VolumeTreeNode volume) {
        if (volume == this.m_primVolNode) {
            return "Primary";
        }
        if (volume == this.m_secVolNode) {
            return "Secondary";
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DRPairNode) {
            DRPairNode pairObj = (DRPairNode)obj;
            boolean primEquals = this.m_primVolNode == null && pairObj.m_primVolNode == null || this.m_primVolNode != null && pairObj.m_primVolNode != null && this.m_primVolNode.equals(pairObj.m_primVolNode);
            boolean secEquals = this.m_secVolNode == null && pairObj.m_secVolNode == null || this.m_secVolNode != null && pairObj.m_secVolNode != null && this.m_secVolNode.equals(pairObj.m_secVolNode);
            return primEquals && secEquals;
        }
        return false;
    }

    public DRPairTypeConstant getPairType() {
        return this.m_pairType;
    }

    protected void setPairType(DRPairTypeConstant pairType) {
        this.m_pairType = pairType;
    }

    public VolumeTreeNode getLocalSecondaryVolume() {
        return this.m_localSecondaryVolume;
    }

    public void setLocalSecondaryVolume(VolumeTreeNode localSecondaryVolume) {
        this.m_localSecondaryVolume = localSecondaryVolume;
    }

    public VolumeTreeNode getRemotePrimaryVolume() {
        return this.m_remotePrimaryVolume;
    }

    public void setRemotePrimaryVolume(VolumeTreeNode remotePrimaryVolume) {
        this.m_remotePrimaryVolume = remotePrimaryVolume;
    }

    public ClusterNode getLocalCluster() {
        return this.m_localCluster;
    }

    public ClusterNode getRemoteCluster() {
        return this.m_remoteCluster;
    }

    public void setLocalCluster(ClusterNode cluster) {
        this.m_localCluster = cluster;
    }

    public void setRemoteCluster(ClusterNode cluster) {
        this.m_remoteCluster = cluster;
    }

    public CFStateConstant getControlFunctionState() {
        return this.m_cfState;
    }

    public void setControlFunctionState(CFStateConstant cfState) {
        this.m_cfState = cfState;
    }

    public boolean isInCopy() {
        return this.getPairPrimaryVolume() != null && CopyOperManager.getInstance().isInvolvedInAnyActiveCopyOper(this.getPairPrimaryVolume()) && this.getPairSecondaryVolume() != null && CopyOperManager.getInstance().isInvolvedInAnyActiveCopyOper(this.getPairSecondaryVolume()) && this.getLocalSecondaryVolume() != null && CopyOperManager.getInstance().isInvolvedInAnyActiveCopyOper(this.getLocalSecondaryVolume()) && this.getRemotePrimaryVolume() != null && CopyOperManager.getInstance().isInvolvedInAnyActiveCopyOper(this.getRemotePrimaryVolume());
    }

    public boolean isInPlannedFailoverState() {
        if (this.m_replicationState != null) {
            return this.m_replicationState.contains(DRReplicationStateConstant.PLANNED_FAILOVER);
        }
        return false;
    }

    public boolean isInFallbackState() {
        if (this.m_replicationState != null) {
            return this.m_replicationState.contains(DRReplicationStateConstant.FALLBACK);
        }
        return false;
    }
}

