/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.ConsistencyGroupNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.SrPairDetailsTableModel;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.SrTransientWindowPane;
import com.sanrad.nms.client.gui.alarm.SrAlarmsTablePanel;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.dr.DRPair;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.util.types.constants.CFStateConstant;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.nms.server.util.types.constants.DRStateConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.swing.actions.ConstantView;
import com.sanrad.swing.actions.View;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JFrame;

public abstract class DRPairManager
extends ElementManager {
    private static SrLogger theLogger = SrLogger.getLogger();

    protected DRPairManager() {
    }

    public static SrFuture<Void> abortInitialSync(DRPairNode pair) {
        return ClientAOImpl.getInstance().abortInitialSync(Collections.singleton(pair.getIdentifier()));
    }

    public static SrFuture<Void> refreshInitialSyncProgress(DRPairNode pair) {
        return ClientAOImpl.getInstance().refreshInitialSyncProgress((String)pair.getIdentifier());
    }

    public static DRPairNode getPairContainingVolume(VolumeTreeNode vol) {
        DRPairNode[] pairs = SrPairDetailsTableModel.getInstance().getListOfPairs();
        for (int i = 0; i < pairs.length; ++i) {
            VolumeTreeNode primVol = pairs[i].getPairPrimaryVolume();
            VolumeTreeNode secVol = pairs[i].getPairSecondaryVolume();
            VolumeTreeNode localSecVol = pairs[i].getLocalSecondaryVolume();
            VolumeTreeNode remotePrimVol = pairs[i].getRemotePrimaryVolume();
            VolumeTreeNode localOfflineCopy = null;
            if (pairs[i].getClass().equals(DRASyncPairNode.class)) {
                localOfflineCopy = ((DRASyncPairNode)pairs[i]).getOfflineLocalCopy();
            }
            if (vol != primVol && vol != secVol && vol != localSecVol && vol != remotePrimVol && vol != localOfflineCopy) continue;
            return pairs[i];
        }
        return null;
    }

    public static DRPairNode getJournalVolumeUsedByPair(JournalVolumeNode vol) {
        DRPairNode[] pairs = SrPairDetailsTableModel.getInstance().getListOfPairs();
        for (int i = 0; i < pairs.length; ++i) {
            if (!(pairs[i] instanceof DRASyncPairNode)) continue;
            DRASyncPairNode asyncPair = (DRASyncPairNode)pairs[i];
            JournalVolumeNode primaryJournal = asyncPair.getPrimaryJournal();
            JournalVolumeNode secondaryJournal = asyncPair.getSecondaryJournal();
            if ((primaryJournal == null || vol.getStub() != primaryJournal.getStub()) && (secondaryJournal == null || vol.getStub() != secondaryJournal.getStub())) continue;
            return asyncPair;
        }
        return null;
    }

    protected abstract DRPairNode createPairNode(DRPair var1, HashMap var2) throws RemoteException;

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (!DRManager.getInstance().isDRDiscoveryCompleted()) {
            return;
        }
        try {
            if (this.alreadyExist(element)) {
                return;
            }
            DRPair drPair = (DRPair)element;
            this.createPairNode(drPair, e.getParameterList());
            theLogger.trace(SrLogCategories.LEGACY, "DRPairManager: DR Pair created.");
        }
        catch (RemoteException ex) {
            theLogger.error(SrLogCategories.LEGACY, ex, new Object[0]);
        }
    }

    protected void preparePairNode(DRPairNode node, HashMap clientParams) {
        AlarmSeverity alarm = (AlarmSeverity)clientParams.get(ClientParameterCode.PROPAGATION_STATE);
        DRStateConstant state = (DRStateConstant)clientParams.get(ClientParameterCode.DR_PAIR_STATE);
        Integer dataTransffered = (Integer)clientParams.get(ClientParameterCode.DR_PAIR_ONLINE_INIT_SYNC_DATA_TRANSFFERED);
        DRPairInitialSyncTypeConstant initialSyncType = (DRPairInitialSyncTypeConstant)clientParams.get(ClientParameterCode.DR_PAIR_INITIAL_SYNC_TYPE);
        DRInitialSyncStateConstant initialSyncState = (DRInitialSyncStateConstant)clientParams.get(ClientParameterCode.DR_PAIR_INITIAL_SYNC_STATE);
        DRModeConstant mode = (DRModeConstant)clientParams.get(ClientParameterCode.DR_PAIR_MODE);
        Integer initialSyncProgress = (Integer)clientParams.get(ClientParameterCode.DR_PAIR_ONLINE_INIT_SYNC_DATA_TRANSFFERED);
        VolumeNode primVol = (VolumeNode)clientParams.get(ClientParameterCode.DR_PAIR_PRIMARY_VOLUME);
        VolumeTreeNode primVolNode = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(primVol);
        Cluster primClusterStub = (Cluster)clientParams.get(ClientParameterCode.DR_LOCAL_CLUSTER);
        ClusterNode primClusterNode = null;
        SiteNode primSiteNode = null;
        if (primClusterStub != null) {
            primClusterNode = (ClusterNode)SystemRootNode.getInstance().getRefByStub(primClusterStub);
            primSiteNode = primClusterNode != null ? (SiteNode)primClusterNode.getParent() : null;
        }
        VolumeNode secVol = (VolumeNode)clientParams.get(ClientParameterCode.DR_PAIR_SECONDARY_VOLUME);
        VolumeTreeNode secVolNode = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(secVol);
        Cluster secClusterStub = (Cluster)clientParams.get(ClientParameterCode.DR_REMOTE_CLUSTER);
        ClusterNode secClusterNode = null;
        SiteNode secSiteNode = null;
        if (secClusterStub != null) {
            secClusterNode = (ClusterNode)SystemRootNode.getInstance().getRefByStub(secClusterStub);
            secSiteNode = secClusterNode != null ? (SiteNode)secClusterNode.getParent() : null;
        }
        VolumeNode localSecondaryVolume = (VolumeNode)clientParams.get(ClientParameterCode.DR_PAIR_LOCAL_SECONDARY_VOLUME);
        VolumeTreeNode localSecondaryNode = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(localSecondaryVolume);
        VolumeNode remotePrimaryVolume = (VolumeNode)clientParams.get(ClientParameterCode.DR_PAIR_REMOTE_PRIMARY_VOLUME);
        VolumeTreeNode remotePrimaryNode = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(remotePrimaryVolume);
        CFStateConstant cfState = (CFStateConstant)clientParams.get(ClientParameterCode.DR_CF_STATE);
        node.setStatus(DRPairManager.getSeverity(alarm));
        node.setState(state);
        node.setDataTransffered(dataTransffered);
        node.setInitialSyncType(initialSyncType);
        node.setPrimVolNode(primVolNode);
        node.setPrimSiteNode(primSiteNode);
        node.setSecVolNode(secVolNode);
        node.setSecSiteNode(secSiteNode);
        this.invokeTransientWindowOnDRModeIfChanged(node.getMode(), mode, node);
        node.setMode(mode);
        this.invokeTransientWindowOnInitSyncIfChanged(node.getInitialSyncState(), initialSyncState, node);
        node.setInitialSyncState(initialSyncState);
        node.setInitialSyncProgress(initialSyncProgress);
        node.setLocalSecondaryVolume(localSecondaryNode);
        node.setRemotePrimaryVolume(remotePrimaryNode);
        node.setLocalCluster(primClusterNode);
        node.setRemoteCluster(secClusterNode);
        if (cfState != null) {
            node.setControlFunctionState(cfState);
        }
        SrBITSConstant replState = (SrBITSConstant)clientParams.get(this.getReplicationStateCode());
        this.invokeTransientWindowReplicationStateIfChanged(node.getReplicationState(), replState, node);
    }

    protected abstract ClientParameterCode getReplicationStateCode();

    private void invokeTransientWindowOnDRModeIfChanged(DRModeConstant aOldMode, DRModeConstant aNewMode, DRPairNode aPairNode) {
        if (aOldMode != null && !aOldMode.equals(aNewMode)) {
            String secondaryAlias;
            SrAlarmsTablePanel.SourceAction<DRPairNode> action = new SrAlarmsTablePanel.SourceAction<DRPairNode>((View<DRPairNode>)new ConstantView<DRPairNode>(Collections.singleton(aPairNode)));
            String primaryAlias = aPairNode.getPairPrimaryVolume() == null ? "" : aPairNode.getPairPrimaryVolume().getAlias();
            String string = secondaryAlias = aPairNode.getPairSecondaryVolume() == null ? "" : aPairNode.getPairSecondaryVolume().getAlias();
            if (aOldMode.equals(DRModeConstant.NORMAL) && aNewMode.equals(DRModeConstant.SWITCHED)) {
                if (aPairNode.isPartial() || aPairNode.getLocalCluster() == null || aPairNode.getLocalCluster().getConnectedVSwitches().length == 0) {
                    SrTransientWindowPane.showGDRDisasterFailoverCompleted(ClientLoader.getMainFrame(), primaryAlias, secondaryAlias, action);
                } else {
                    SrBITSConstant replicationState = aPairNode.getReplicationState();
                    if (replicationState != null && !replicationState.contains(DRReplicationStateConstant.INACTIVE)) {
                        SrTransientWindowPane.showGDRPlannedFailoverCompleted(ClientLoader.getMainFrame(), primaryAlias, secondaryAlias, action);
                    }
                }
            } else if (aOldMode.equals(DRModeConstant.SWITCHED) && aNewMode.equals(DRModeConstant.NORMAL)) {
                SrTransientWindowPane.showGDRPlannedFailbackCompleted(ClientLoader.getMainFrame(), primaryAlias, secondaryAlias, action);
            } else if (!aOldMode.equals(DRModeConstant.UNKNOWN) && !aNewMode.equals(DRModeConstant.UNKNOWN)) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "Unxpected aNewMode ", aOldMode, " or ", aNewMode);
            }
        }
    }

    private void invokeTransientWindowOnInitSyncIfChanged(DRInitialSyncStateConstant aOldState, DRInitialSyncStateConstant aNewState, DRPairNode aPairNode) {
        String secondaryAlias;
        SrAlarmsTablePanel.SourceAction<DRPairNode> action = new SrAlarmsTablePanel.SourceAction<DRPairNode>((View<DRPairNode>)new ConstantView<DRPairNode>(Collections.singleton(aPairNode)));
        String primaryAlias = aPairNode.getPairPrimaryVolume() == null ? "" : aPairNode.getPairPrimaryVolume().getAlias();
        String string = secondaryAlias = aPairNode.getPairSecondaryVolume() == null ? "" : aPairNode.getPairSecondaryVolume().getAlias();
        if (aOldState != null && aOldState.equals(DRInitialSyncStateConstant.IN_PROGRESS)) {
            if (aNewState.equals(DRInitialSyncStateConstant.OK)) {
                SrTransientWindowPane.showGDRInitialSyncCompleted(ClientLoader.getMainFrame(), primaryAlias, secondaryAlias, action);
            } else if (aNewState.equals(DRInitialSyncStateConstant.NEED_SYNC)) {
                SrTransientWindowPane.showGDRInitialSyncFailed(ClientLoader.getMainFrame(), primaryAlias, secondaryAlias, action);
            } else if (!aNewState.equals(DRInitialSyncStateConstant.IN_PROGRESS) && !aNewState.equals(DRInitialSyncStateConstant.UNKNOWN)) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "Unexpected aNewState = ", aNewState);
            }
        } else if (!(aOldState == null || aOldState.equals(DRInitialSyncStateConstant.OK) || aOldState.equals(DRInitialSyncStateConstant.NEED_SYNC) || aOldState.equals(DRInitialSyncStateConstant.UNKNOWN))) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "Unexpected aOldState = ", aOldState);
        }
    }

    private void invokeTransientWindowReplicationStateIfChanged(SrBITSConstant aOldState, SrBITSConstant aNewState, DRPairNode aPairNode) {
        if (aOldState != null && aNewState != null && !aOldState.equals(aNewState) && aOldState.contains(DRReplicationStateConstant.INACTIVE) && !aNewState.contains(DRReplicationStateConstant.INACTIVE)) {
            SrAlarmsTablePanel.SourceAction<DRPairNode> action = new SrAlarmsTablePanel.SourceAction<DRPairNode>((View<DRPairNode>)new ConstantView<DRPairNode>(Collections.singleton(aPairNode)));
            String primaryAlias = aPairNode.getPairPrimaryVolume() == null ? "" : aPairNode.getPairPrimaryVolume().getAlias();
            String secondaryAlias = aPairNode.getPairSecondaryVolume() == null ? "" : aPairNode.getPairSecondaryVolume().getAlias();
            SrTransientWindowPane.showGDRReplicateStarted((JFrame)ClientLoader.getMainFrame(), primaryAlias, secondaryAlias, action);
        }
    }

    public static String validatePairStartReplication(DRPairNode aPair) {
        if (aPair instanceof DRASyncPairNode && ((DRASyncPairNode)aPair).getConsistencyGroup() instanceof ConsistencyGroupNode) {
            return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_ASYNC_PAIR_IN_CG_MSG);
        }
        if (aPair.isInCopy()) {
            return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_VOLUME_IN_COPY_OPERATION_MSG);
        }
        if (!DRReplicationStateConstant.INACTIVE.equals(aPair.getReplicationState())) {
            return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_REPLICATION_ACTIVE_MSG);
        }
        if (aPair.isPartial()) {
            return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_MISSING_SITE_MSG);
        }
        if (CFStateConstant.CF_WAIT.equals(aPair.getControlFunctionState())) {
            return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PAIR_DETAILS_TABLE_POPUP_MENU_CF_IN_PROGRESS_MSG);
        }
        return null;
    }
}

