/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.dr.DRASyncPairManager;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRConsistencyGroupManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.DRSyncPairManager;
import com.sanrad.nms.client.data.dr.DRSyncPairNode;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.SrConsistencyGroupsTableModel;
import com.sanrad.nms.client.data.dr.SrPairDetailsTableModel;
import com.sanrad.nms.client.data.site.SiteManager;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupEvent;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupListener;
import com.sanrad.nms.client.event.dr.DREvent;
import com.sanrad.nms.client.event.dr.DRListener;
import com.sanrad.nms.client.event.dr.DRSyncPairEvent;
import com.sanrad.nms.client.event.dr.DRSyncPairListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.dr.wizards.activation.SrReplicationWizardFrame;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.util.types.constants.CFStateConstant;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.nms.server.util.types.constants.DrSiteConstant;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class DRManager {
    private static DRManager instance = new DRManager();
    SrEventListenerManager m_listeners = new SrEventListenerManager();
    ArrayList m_drSyncNotifierList = new ArrayList();
    private boolean m_isDRDiscoveryCompleted = true;
    SrEventListenerManager.Informer drDiscoveryCompletedInformer = new SrEventListenerManager.Informer<DRListener, DREvent>(){

        @Override
        public void inform(DRListener listener, DREvent event) {
            listener.drDiscoveryCompleted(event);
        }
    };
    SrEventListenerManager.Informer drDiscoveryStartedInformer = new SrEventListenerManager.Informer<DRListener, DREvent>(){

        @Override
        public void inform(DRListener listener, DREvent event) {
            listener.drDiscoveryStarted(event);
        }
    };

    private DRManager() {
    }

    public static DRManager getInstance() {
        return instance;
    }

    public void addDRListener(DRListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeDRListener(DRListener listener) {
        this.m_listeners.remove(listener);
    }

    private void fireDRDiscoveryCompleted() {
        DREvent event = new DREvent(this);
        this.m_listeners.fireEvent(DRListener.class, event, this.drDiscoveryCompletedInformer);
    }

    private void fireDRDiscoveryStarted() {
        DREvent event = new DREvent(this);
        this.m_listeners.fireEvent(DRListener.class, event, this.drDiscoveryStartedInformer);
    }

    public void drDiscoveryStarted() {
        this.m_isDRDiscoveryCompleted = false;
        DRConsistencyGroupManager.getInstance().clearAll();
        DRASyncPairManager.getInstance().clearAll();
        DRSyncPairManager.getInstance().clearAll();
        this.fireDRDiscoveryStarted();
    }

    public void drDiscoveryCompleted() {
        this.m_isDRDiscoveryCompleted = true;
        DRConsistencyGroupManager.getInstance().init();
        DRASyncPairManager.getInstance().init();
        DRSyncPairManager.getInstance().init();
        AlarmsManager.getInstance().clearAllAlarms(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue());
        AlarmsManager.getInstance().getAllDrAlarmsFromServer(true);
        this.fireDRDiscoveryCompleted();
    }

    public boolean isDRDiscoveryCompleted() {
        return this.m_isDRDiscoveryCompleted;
    }

    public SrTreeNode[] getElementsForReplicate(SiteNode aSite) {
        ArrayList<SrTreeNode> listForStartReplicate = new ArrayList<SrTreeNode>();
        DRPairNode[] primaryPairs = SrPairDetailsTableModel.getInstance().getPairsPrimaryOnSite(aSite);
        int i = primaryPairs.length;
        while (i-- > 0) {
            if (!(primaryPairs[i] instanceof DRSyncPairNode) || !primaryPairs[i].getReplicationState().equals(DRReplicationStateConstant.INACTIVE) || primaryPairs[i].isInCopy() || !primaryPairs[i].getMode().equals(DRModeConstant.NORMAL) || primaryPairs[i].isPartial() || CFStateConstant.CF_WAIT.equals(primaryPairs[i].getControlFunctionState())) continue;
            listForStartReplicate.add(primaryPairs[i]);
        }
        List<ExtendedElementNode> primaryCGs = SrConsistencyGroupsTableModel.getInstance().getAllGroupsPrimaryOnSite(aSite);
        for (ExtendedElementNode cg : primaryCGs) {
            if (!cg.getReplicationState().equals(DRReplicationStateConstant.INACTIVE) || !cg.getMode().equals(DRModeConstant.NORMAL) || cg.isPartial() || CFStateConstant.CF_WAIT.equals(cg.getControlFunctionState())) continue;
            listForStartReplicate.add(cg);
        }
        DRPairNode[] secondaryPairs = SrPairDetailsTableModel.getInstance().getPairsSecondaryOnSite(aSite);
        int i2 = secondaryPairs.length;
        while (i2-- > 0) {
            if (!(secondaryPairs[i2] instanceof DRSyncPairNode) || !secondaryPairs[i2].getReplicationState().equals(DRReplicationStateConstant.INACTIVE) || secondaryPairs[i2].isInCopy() || !secondaryPairs[i2].getMode().equals(DRModeConstant.SWITCHED) || secondaryPairs[i2].isPartial() || CFStateConstant.CF_WAIT.equals(secondaryPairs[i2].getControlFunctionState())) continue;
            listForStartReplicate.add(secondaryPairs[i2]);
        }
        ExtendedElementNode[] secondaryCGs = SrConsistencyGroupsTableModel.getInstance().getNodesSecondaryOnSite(aSite);
        int i3 = secondaryCGs.length;
        while (i3-- > 0) {
            if (!secondaryCGs[i3].getReplicationState().equals(DRReplicationStateConstant.INACTIVE) || !secondaryCGs[i3].getMode().equals(DRModeConstant.SWITCHED) || secondaryCGs[i3].isPartial() || CFStateConstant.CF_WAIT.equals(secondaryCGs[i3].getControlFunctionState())) continue;
            listForStartReplicate.add(secondaryCGs[i3]);
        }
        return listForStartReplicate.toArray(new SrTreeNode[listForStartReplicate.size()]);
    }

    public Collection<SrFuture<Void>> startReplicate(ExtendedElementNode[] cgs, DRSyncPairNode[] syncPairs) {
        int i;
        boolean isStartReplicationWizardNeeded = false;
        if (cgs != null) {
            i = cgs.length;
            block0: while (i-- > 0) {
                DRASyncPairNode[] pairs = cgs[i].getPairs();
                int j = pairs.length;
                while (j-- > 0) {
                    if (DRInitialSyncStateConstant.OK.equals(pairs[j].getInitialSyncState()) || !DRReplicationStateConstant.INACTIVE.equals(pairs[j].getReplicationState())) continue;
                    if (DRPairInitialSyncTypeConstant.NONE.equals(pairs[j].getInitialSyncType())) {
                        isStartReplicationWizardNeeded = true;
                        continue;
                    }
                    boolean isSnapDefinedOnPair = true;
                    if (DRModeConstant.NORMAL.equals(pairs[j].getMode())) {
                        isSnapDefinedOnPair = pairs[j].getPrimarySnapshot() != null;
                    } else {
                        boolean bl = isSnapDefinedOnPair = pairs[j].getSecondarySnapshot() != null;
                    }
                    if (isSnapDefinedOnPair) continue;
                    isStartReplicationWizardNeeded = true;
                    continue block0;
                }
            }
        }
        if (syncPairs != null) {
            i = syncPairs.length;
            while (i-- > 0) {
                if (!DRPairInitialSyncTypeConstant.NONE.equals(syncPairs[i].getInitialSyncType()) || DRInitialSyncStateConstant.OK.equals(syncPairs[i].getInitialSyncState()) || !DRReplicationStateConstant.INACTIVE.equals(syncPairs[i].getReplicationState())) continue;
                isStartReplicationWizardNeeded = true;
                break;
            }
        }
        ArrayList<SrFuture<Void>> retVal = new ArrayList<SrFuture<Void>>();
        if (isStartReplicationWizardNeeded) {
            new SrReplicationWizardFrame((JFrame)ClientLoader.getMainFrame(), cgs, syncPairs).runWizard();
        } else {
            int i2;
            ArrayList<String> ids = new ArrayList<String>();
            if (cgs != null) {
                i2 = cgs.length;
                while (i2-- > 0) {
                    ids.add((String)cgs[i2].getIdentifier());
                }
            }
            if (syncPairs != null) {
                i2 = syncPairs.length;
                while (i2-- > 0) {
                    ids.add((String)syncPairs[i2].getIdentifier());
                }
            }
            retVal.add(ClientAOImpl.getInstance().startReplicate(ids));
        }
        return retVal;
    }

    public void startFallbackAfterSynchronizing(SrTreeNode[] drElements) {
        DRElementSyncNotifier notifier = new DRElementSyncNotifier(drElements);
        notifier.setSyncListener(new DRElementSyncNotifier.DRSyncListener(){

            @Override
            public void drElementsSynchronized(SrTreeNode[] drElements) {
                int choice = JOptionPane.showConfirmDialog(ClientLoader.getMainFrame(), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_FALLBACK_WIZ_SYNC_FINISHED_DIALOG_MSG), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_FALLBACK_WIZ_SYNC_FINISHED_DIALOG_TITLE), 0);
                if (choice == 0) {
                    SiteManager.getInstance().fallback(drElements, ClientLoader.getMainFrame());
                }
            }
        });
        this.m_drSyncNotifierList.add(notifier);
    }

    public void startPlannedFailoverAfterSynchronizing(SrTreeNode[] drElements) {
        DRElementSyncNotifier notifier = new DRElementSyncNotifier(drElements);
        notifier.setSyncListener(new DRElementSyncNotifier.DRSyncListener(){

            @Override
            public void drElementsSynchronized(SrTreeNode[] drElements) {
                int choice = JOptionPane.showConfirmDialog(ClientLoader.getMainFrame(), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PLANNED_FAILOVER_WIZ_SYNC_FINISHED_DIALOG_MSG), ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PLANNED_FAILOVER_WIZ_SYNC_FINISHED_DIALOG_TITLE), 0);
                if (choice == 0) {
                    SiteManager.getInstance().plannedFailover(drElements, ClientLoader.getMainFrame());
                }
            }
        });
        this.m_drSyncNotifierList.add(notifier);
    }

    public void abortReplicationRequestNotify(SrTreeNode drElement) {
        int i = this.m_drSyncNotifierList.size();
        while (i-- > 0) {
            DRElementSyncNotifier notifier = (DRElementSyncNotifier)this.m_drSyncNotifierList.get(i);
            if (!notifier.containsDRElement(drElement)) continue;
            notifier.terminate();
            this.m_drSyncNotifierList.remove(notifier);
            break;
        }
    }

    public void clusterSync() throws RemoteException, IllegalValueException {
        SystemRootNode.getInstance().getDRRootStub().clusterSync();
    }

    private static class DRElementSyncNotifier
    implements DRConsistencyGroupListener,
    DRSyncPairListener {
        private SrTreeNode[] m_drElements;
        private ArrayList<SrTreeNode> m_elementList = new ArrayList();
        private DRSyncListener m_synchronizationListener;

        DRElementSyncNotifier(SrTreeNode[] drElements) {
            this.m_drElements = drElements;
            this.m_elementList.addAll(Arrays.asList(drElements));
            Iterator<SrTreeNode> i = this.m_elementList.iterator();
            while (i.hasNext()) {
                SrTreeNode drElement = i.next();
                if (drElement instanceof DRSyncPairNode) {
                    DRSyncPairNode pair = (DRSyncPairNode)drElement;
                    if (DRReplicationStateConstant.INACTIVE.equals(pair.getReplicationState())) continue;
                    i.remove();
                    continue;
                }
                ExtendedElementNode cg = (ExtendedElementNode)drElement;
                if (DRReplicationStateConstant.INACTIVE.equals(cg.getReplicationState())) continue;
                i.remove();
            }
            if (this.m_elementList.isEmpty()) {
                throw new IllegalArgumentException("All DR elements are synchronizied");
            }
            DRConsistencyGroupManager.getInstance().addDRConsistencyGroupListener(this);
            DRSyncPairManager.getInstance().addDRSyncPairListener(this);
        }

        void setSyncListener(DRSyncListener listener) {
            this.m_synchronizationListener = listener;
        }

        void notifyDRElementsSync() {
            if (this.m_elementList.isEmpty()) {
                this.m_synchronizationListener.drElementsSynchronized(this.m_drElements);
                this.terminate();
            }
        }

        boolean containsDRElement(SrTreeNode drElement) {
            int i = this.m_drElements.length;
            while (i-- > 0) {
                if (!drElement.equals(this.m_drElements[i])) continue;
                return true;
            }
            return false;
        }

        void terminate() {
            DRConsistencyGroupManager.getInstance().removeDRConsistencyGroupListener(this);
            DRSyncPairManager.getInstance().removeDRSyncPairListener(this);
        }

        @Override
        public void consistencyGroupCreated(DRConsistencyGroupEvent e) {
        }

        @Override
        public void consistencyGroupRemoved(DRConsistencyGroupEvent e) {
        }

        @Override
        public void consistencyGroupChanged(DRConsistencyGroupEvent e) {
            ExtendedElementNode cg = e.getExtendedElementNode();
            if (DRInitialSyncStateConstant.OK.equals(cg.getInitialSyncState())) {
                this.m_elementList.remove(cg);
                this.notifyDRElementsSync();
            }
        }

        @Override
        public void consistencyGroupAliasChanged(DRConsistencyGroupEvent e) {
        }

        @Override
        public void syncPairCreated(DRSyncPairEvent e) {
        }

        @Override
        public void syncPairRemoved(DRSyncPairEvent e) {
        }

        @Override
        public void syncPairChanged(DRSyncPairEvent e) {
            DRSyncPairNode pair = e.getPair();
            if (DRInitialSyncStateConstant.OK.equals(pair.getInitialSyncState())) {
                this.m_elementList.remove(pair);
                this.notifyDRElementsSync();
            }
        }

        static interface DRSyncListener {
            public void drElementsSynchronized(SrTreeNode[] var1);
        }
    }
}

