/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.ConsistencyGroupNode;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.ExtendedPairNode;
import com.sanrad.nms.client.data.dr.MergePolicyNode;
import com.sanrad.nms.client.data.dr.PolicyFactory;
import com.sanrad.nms.client.data.dr.PolicyNode;
import com.sanrad.nms.client.data.dr.ReplicationPolicyNode;
import com.sanrad.nms.client.data.dr.SrCGPairsTableModel;
import com.sanrad.nms.client.data.dr.SrConsistencyGroupsTableModel;
import com.sanrad.nms.client.data.dr.TransferPolicyNode;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupEvent;
import com.sanrad.nms.client.event.dr.DRConsistencyGroupListener;
import com.sanrad.nms.client.event.dr.DRPiTEvent;
import com.sanrad.nms.client.event.dr.DRPiTListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.dr.DRAbstractConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DRAsyncPair;
import com.sanrad.nms.server.logic.dr.DRConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DRExtendedPair;
import com.sanrad.nms.server.logic.dr.DRRoot;
import com.sanrad.nms.server.logic.policies.Policy;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.types.constants.CFStateConstant;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.nms.server.util.types.constants.VirtualGroupStateConstant;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class DRConsistencyGroupManager
extends ElementManager {
    private static DRConsistencyGroupManager m_theInstance;
    private PolicyUtil m_policyUtil = new PolicyUtil();
    private static SrLogger theLogger;
    public static String EXTENDED_PAIR_DISPLAY_STRING;
    SrEventListenerManager.Informer consistencyGroupCreatedInformer = new SrEventListenerManager.Informer<DRConsistencyGroupListener, DRConsistencyGroupEvent>(){

        @Override
        public void inform(DRConsistencyGroupListener listener, DRConsistencyGroupEvent event) {
            listener.consistencyGroupCreated(event);
        }
    };
    SrEventListenerManager.Informer consistencyGroupRemovedInformer = new SrEventListenerManager.Informer<DRConsistencyGroupListener, DRConsistencyGroupEvent>(){

        @Override
        public void inform(DRConsistencyGroupListener listener, DRConsistencyGroupEvent event) {
            listener.consistencyGroupRemoved(event);
        }
    };
    SrEventListenerManager.Informer consistencyGroupAliasChangedInformer = new SrEventListenerManager.Informer<DRConsistencyGroupListener, DRConsistencyGroupEvent>(){

        @Override
        public void inform(DRConsistencyGroupListener listener, DRConsistencyGroupEvent event) {
            listener.consistencyGroupAliasChanged(event);
        }
    };
    SrEventListenerManager.Informer consistencyGroupChangedInformer = new SrEventListenerManager.Informer<DRConsistencyGroupListener, DRConsistencyGroupEvent>(){

        @Override
        public void inform(DRConsistencyGroupListener listener, DRConsistencyGroupEvent event) {
            listener.consistencyGroupChanged(event);
        }
    };
    SrEventListenerManager.Informer drPiTsParentUpdatedInformer = new SrEventListenerManager.Informer<DRPiTListener, DRPiTEvent>(){

        @Override
        public void inform(DRPiTListener listener, DRPiTEvent event) {
            listener.drPiTsParentUpdated(event);
        }
    };

    private DRConsistencyGroupManager() {
    }

    public static DRConsistencyGroupManager getInstance() {
        if (m_theInstance == null) {
            m_theInstance = new DRConsistencyGroupManager();
        }
        return m_theInstance;
    }

    public void addDRConsistencyGroupListener(DRConsistencyGroupListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeDRConsistencyGroupListener(DRConsistencyGroupListener listener) {
        this.m_listeners.remove(listener);
    }

    public void addDRPiTListener(DRPiTListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeDRPiTListener(DRPiTListener listener) {
        this.m_listeners.remove(listener);
    }

    public void readConsistencyGroupsFromServer() {
        try {
            HashMap params;
            int i;
            SystemRootNode sysRootNode = SystemRootNode.getInstance();
            DRRoot drRoot = sysRootNode.getDRRootStub();
            DRConsistencyGroup[] consistencyGroups = drRoot.getConsistencyGroups();
            DRExtendedPair[] extendedPairs = drRoot.getExtendedPairs();
            for (i = 0; i < consistencyGroups.length; ++i) {
                if (sysRootNode.getRefByStub(consistencyGroups[i]) != null) continue;
                params = consistencyGroups[i].getClientParameterList();
                this.createDRConsistencyGroupNode(consistencyGroups[i], params);
            }
            for (i = 0; i < extendedPairs.length; ++i) {
                if (sysRootNode.getRefByStub(extendedPairs[i]) != null) continue;
                params = extendedPairs[i].getClientParameterList();
                this.createDRExtendedPairNode(extendedPairs[i], params);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            return;
        }
        catch (IllegalValueException re) {
            theLogger.trace(SrLogCategories.LEGACY, re.getMessage());
        }
    }

    private void createDRExtendedPairNode(DRExtendedPair stub, HashMap extendedPairParams) throws RemoteException {
        ExtendedPairNode exNode = new ExtendedPairNode(stub);
        SystemRootNode.getInstance().putRefAndStub(stub, exNode);
        this.prepareExtendedPairNode(exNode, extendedPairParams);
        this.fireExtendedElementCreated(exNode);
    }

    private void createDRConsistencyGroupNode(DRConsistencyGroup stub, HashMap consistencyGroupParams) throws RemoteException {
        ConsistencyGroupNode cgNode = new ConsistencyGroupNode(stub);
        SystemRootNode.getInstance().putRefAndStub(stub, cgNode);
        this.prepareCGNode(cgNode, consistencyGroupParams);
        cgNode.setStatus(DRConsistencyGroupManager.getSeverity(stub.getPropagatedState()));
        this.fireExtendedElementCreated(cgNode);
    }

    private void prepareCGNode(ConsistencyGroupNode cgNode, HashMap clientParamsCodes) {
        this.prepareExtendedElementNode(cgNode, clientParamsCodes);
        String alias = (String)clientParamsCodes.get(ClientParameterCode.DR_CONSISTENCY_GROUP_ALIAS);
        cgNode.setAlias(alias);
        DRAsyncPair[] pairs = (DRAsyncPair[])clientParamsCodes.get(ClientParameterCode.DR_CONSISTENCY_GROUP_PAIRS);
        if (pairs != null) {
            cgNode.setPairsStubs(pairs);
        }
    }

    private void prepareExtendedPairNode(ExtendedPairNode exNode, HashMap clientParamsCodes) {
        this.prepareExtendedElementNode(exNode, clientParamsCodes);
        DRAsyncPair pair = (DRAsyncPair)clientParamsCodes.get(ClientParameterCode.DR_EXTENDED_PAIR_PAIR);
        if (pair != null) {
            exNode.setPairsStubs(new DRAsyncPair[]{pair});
        }
    }

    private void prepareExtendedElementNode(ExtendedElementNode node, HashMap clientParamsCodes) {
        Policy replicationPolicy = (Policy)clientParamsCodes.get(ClientParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_POLICY);
        Policy transferPolicy = (Policy)clientParamsCodes.get(ClientParameterCode.DR_CONSISTENCY_GROUP_TRANSFER_POLICY);
        Policy mergePolicy = (Policy)clientParamsCodes.get(ClientParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY);
        Cluster localCluster = (Cluster)clientParamsCodes.get(ClientParameterCode.DR_LOCAL_CLUSTER);
        Cluster remoteCluster = (Cluster)clientParamsCodes.get(ClientParameterCode.DR_REMOTE_CLUSTER);
        ClusterNode localClusterNode = (ClusterNode)SystemRootNode.getInstance().getRefByStub(localCluster);
        ClusterNode remoteClusterNode = (ClusterNode)SystemRootNode.getInstance().getRefByStub(remoteCluster);
        node.setLocalCluster(localClusterNode);
        node.setRemoteCluster(remoteClusterNode);
        ReplicationPolicyNode replicationPolicyNode = null;
        TransferPolicyNode transferPolicyNode = null;
        MergePolicyNode mergePolicyNode = null;
        if (replicationPolicy != null) {
            replicationPolicyNode = (ReplicationPolicyNode)this.m_policyUtil.createReplicatePolicyNode(replicationPolicy);
            node.setReplicationPolicyNode(replicationPolicyNode);
        }
        if (transferPolicy != null) {
            transferPolicyNode = (TransferPolicyNode)this.m_policyUtil.createTransferPolicyNode(transferPolicy);
            node.setTransferPolicyNode(transferPolicyNode);
        }
        if (mergePolicy != null) {
            mergePolicyNode = (MergePolicyNode)this.m_policyUtil.createMergePolicyNode(mergePolicy);
            node.setMergePolicyNode(mergePolicyNode);
        }
        VirtualGroupStateConstant state = (VirtualGroupStateConstant)clientParamsCodes.get(ClientParameterCode.DR_CONSISTENCY_GROUP_STATE);
        DRModeConstant mode = (DRModeConstant)clientParamsCodes.get(ClientParameterCode.DR_CONSISTENCY_GROUP_MODE);
        DRInitialSyncStateConstant initSyncState = (DRInitialSyncStateConstant)clientParamsCodes.get(ClientParameterCode.DR_CONSISTENCY_GROUP_INITIAL_SYNC_STATE);
        SrBITSConstant replState = (SrBITSConstant)clientParamsCodes.get(ClientParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_STATE);
        BigInteger pendingData = (BigInteger)clientParamsCodes.get(ClientParameterCode.DR_CONSISTENCY_GROUP_PENDING_DATA);
        BigInteger pendingPits = (BigInteger)clientParamsCodes.get(ClientParameterCode.DR_CONSISTENCY_GROUP_PENDING_PITS);
        BigInteger notReplicatedPits = (BigInteger)clientParamsCodes.get(ClientParameterCode.DR_CONSISTENCY_GROUP_NOT_REPLICATED_PITS);
        BigInteger notReplicatedData = (BigInteger)clientParamsCodes.get(ClientParameterCode.DR_CONSISTENCY_GROUP_NOT_REPLICATED_DATA);
        BigInteger notMergedPits = (BigInteger)clientParamsCodes.get(ClientParameterCode.DR_CONSISTENCY_GROUP_NOT_MERGED_PITS);
        Long lastMerge = (Long)clientParamsCodes.get(ClientParameterCode.DR_CONSISTENCY_GROUP_LAST_PIT_MERGE);
        Long nextReplication = (Long)clientParamsCodes.get(ClientParameterCode.DR_CONSISTENCY_GROUP_NEXT_REPLICATION_SCHEDULE);
        CFStateConstant cfState = (CFStateConstant)clientParamsCodes.get(ClientParameterCode.DR_CF_STATE);
        node.setState(state);
        node.setMode(mode);
        node.setInitialSyncState(initSyncState);
        Boolean ambiguityState = (Boolean)clientParamsCodes.get(ClientParameterCode.DR_AMBIGUITY);
        if (ambiguityState == null || !ambiguityState.booleanValue() || !node.isInPlannedFailoverState() && !node.isInFallbackState()) {
            node.setReplicationState(replState);
        }
        if (cfState != null) {
            node.setControlFunctionState(cfState);
        }
        if (pendingData == null) {
            pendingData = BigInteger.ZERO;
        }
        if (pendingPits == null) {
            pendingPits = BigInteger.ZERO;
        }
        if (notReplicatedPits == null) {
            notReplicatedPits = BigInteger.ZERO;
        }
        if (notReplicatedData == null) {
            notReplicatedData = BigInteger.ZERO;
        }
        if (notMergedPits == null) {
            notMergedPits = BigInteger.ZERO;
        }
        node.setPendingData(new Long(pendingData.longValue()));
        node.setPendingPits(new Long(pendingPits.longValue()));
        node.setNotReplicatedPits(new Long(notReplicatedPits.longValue()));
        node.setNotReplicatedData(new Long(notReplicatedData.longValue()));
        node.setNotMergedPits(new Long(notMergedPits.longValue()));
        node.setLastMerge(lastMerge);
        node.setNextRelication(nextReplication);
        if (clientParamsCodes.containsKey(ClientParameterCode.DR_PIT_PARENT_LAST_UPDATE)) {
            this.firePiTParentUpdated(node);
        }
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (!DRManager.getInstance().isDRDiscoveryCompleted()) {
            return;
        }
        ExtendedElementNode node = (ExtendedElementNode)SystemRootNode.getInstance().getRefByStub(element);
        if (node != null) {
            theLogger.trace(SrLogCategories.LEGACY, "DRConsistencyGroupManager: Extended Element removed");
            this.fireExtendedElementRemoved(node);
            super.elementRemove(e);
            SystemRootNode.getInstance().removeRefAndIdByStub(element);
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (!DRManager.getInstance().isDRDiscoveryCompleted()) {
            return;
        }
        try {
            DRAbstractConsistencyGroup asyncElement = (DRAbstractConsistencyGroup)element;
            HashMap params = this.getParameterList(e);
            ExtendedElementNode node = (ExtendedElementNode)SystemRootNode.getInstance().getRefByStub(element);
            if (node != null) {
                String alias = (String)params.get(ClientParameterCode.DR_CONSISTENCY_GROUP_ALIAS);
                if (node instanceof ConsistencyGroupNode && alias != null && !alias.equals(((ConsistencyGroupNode)node).getAlias())) {
                    ((ConsistencyGroupNode)node).setAlias(alias);
                    this.fireExtendedElementAliasChanged(node);
                }
                if (asyncElement.getClassId().equals(ClassID.CONSISTENCY_GROUP)) {
                    this.prepareCGNode((ConsistencyGroupNode)node, params);
                } else {
                    this.prepareExtendedPairNode((ExtendedPairNode)node, params);
                }
                theLogger.trace(SrLogCategories.LEGACY, "DRConsistencyGroupManager: Extended Element changed");
                this.fireExtendedElementChanged(node);
            }
        }
        catch (RemoteException ex) {
            theLogger.trace(SrLogCategories.LEGACY, ex);
        }
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (!DRManager.getInstance().isDRDiscoveryCompleted()) {
            return;
        }
        try {
            if (this.alreadyExist(element)) {
                return;
            }
            HashMap params = e.getParameterList();
            if (element instanceof DRExtendedPair) {
                this.createDRExtendedPairNode((DRExtendedPair)element, params);
            } else if (element instanceof DRConsistencyGroup) {
                this.createDRConsistencyGroupNode((DRConsistencyGroup)element, params);
            }
            theLogger.trace(SrLogCategories.LEGACY, "DRConsistencyGroupManager: Async Element created.");
        }
        catch (RemoteException ex) {
            theLogger.error(SrLogCategories.LEGACY, ex, new Object[0]);
        }
    }

    public SrFuture<Void> refreshPiTs(ExtendedElementNode node) {
        return ClientAOImpl.getInstance().refreshPiTs(Collections.singleton(node.getIdentifier()));
    }

    public String validateStartReplication(ExtendedElementNode aCgNode) {
        if (aCgNode.isEmpty()) {
            return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_EMPTY_CG_MSG);
        }
        if (aCgNode.isPartial()) {
            if (aCgNode.getRemoteCluster() == null || aCgNode.getLocalCluster() == null) {
                return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_MISSING_SITE_MSG);
            }
        } else {
            if (!DRReplicationStateConstant.INACTIVE.equals(aCgNode.getReplicationState())) {
                return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_REPLICATION_ACTIVE_MSG);
            }
            if (CFStateConstant.CF_WAIT.equals(aCgNode.getControlFunctionState())) {
                return ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_CG_TABLE_POPUP_MENU_CF_IN_PROGRESS_MSG);
            }
        }
        return null;
    }

    public void clearAll() {
        SystemRootNode sysRoot = SystemRootNode.getInstance();
        ExtendedElementNode[] nodes = SrConsistencyGroupsTableModel.getInstance().getAllExtendedElementNodes();
        int i = nodes.length;
        while (i-- > 0) {
            sysRoot.removeRefAndIdByStub((RemoteObject)nodes[i].getStub());
        }
        SrCGPairsTableModel.getInstance().removeAllRows();
        SrConsistencyGroupsTableModel.getInstance().removeAllRows();
    }

    public void init() {
        this.clearAll();
        this.readConsistencyGroupsFromServer();
    }

    public ExtendedPairNode[] getSiteExtendedPairList(SiteNode siteNode) {
        ArrayList<ExtendedPairNode> arr = new ArrayList<ExtendedPairNode>();
        ExtendedPairNode[] extendedPairs = new ExtendedPairNode[]{};
        for (int i = 0; i < extendedPairs.length; ++i) {
            SiteNode prim = extendedPairs[i].getPair().getPairPrimarySite();
            if (!prim.equals(siteNode)) continue;
            arr.add(extendedPairs[i]);
        }
        ExtendedPairNode[] extendedPairsList = new ExtendedPairNode[arr.size()];
        Object[] returnNodes = arr.toArray();
        if (returnNodes.length > 0) {
            extendedPairsList = (ExtendedPairNode[])returnNodes;
        }
        return extendedPairsList;
    }

    private void fireExtendedElementCreated(ExtendedElementNode node) {
        DRConsistencyGroupEvent event = new DRConsistencyGroupEvent(node);
        this.m_listeners.fireEvent(DRConsistencyGroupListener.class, event, this.consistencyGroupCreatedInformer);
    }

    private void fireExtendedElementRemoved(ExtendedElementNode node) {
        DRConsistencyGroupEvent event = new DRConsistencyGroupEvent(node);
        this.m_listeners.fireEvent(DRConsistencyGroupListener.class, event, this.consistencyGroupRemovedInformer);
    }

    private void fireExtendedElementAliasChanged(ExtendedElementNode node) {
        DRConsistencyGroupEvent event = new DRConsistencyGroupEvent(node);
        this.m_listeners.fireEvent(DRConsistencyGroupListener.class, event, this.consistencyGroupAliasChangedInformer);
    }

    private void fireExtendedElementChanged(ExtendedElementNode node) {
        DRConsistencyGroupEvent event = new DRConsistencyGroupEvent(node);
        this.m_listeners.fireEvent(DRConsistencyGroupListener.class, event, this.consistencyGroupChangedInformer);
    }

    private void firePiTParentUpdated(ExtendedElementNode node) {
        DRPiTEvent event = new DRPiTEvent((Object)this, node);
        this.m_listeners.fireEvent(DRPiTListener.class, event, this.drPiTsParentUpdatedInformer);
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
        RemoteObject obj = e.getStub();
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(obj);
        if (node != null && node instanceof ConsistencyGroupNode) {
            node.setStatus(DRConsistencyGroupManager.getSeverity(e.getState()));
            this.fireExtendedElementChanged((ExtendedElementNode)node);
        }
    }

    static {
        theLogger = SrLogger.getLogger();
        EXTENDED_PAIR_DISPLAY_STRING = "----";
    }

    private class PolicyUtil {
        private static final int REPLICATE = 0;
        private static final int MERGE = 1;
        private static final int TRANSFER = 2;

        private PolicyUtil() {
        }

        public PolicyNode createReplicatePolicyNode(Policy policyElement) {
            return this.createPolicyNode(policyElement, 0);
        }

        public PolicyNode createMergePolicyNode(Policy policyElement) {
            return this.createPolicyNode(policyElement, 1);
        }

        public PolicyNode createTransferPolicyNode(Policy policyElement) {
            return this.createPolicyNode(policyElement, 2);
        }

        private PolicyNode createPolicyNode(Policy policyElement, int policyType) {
            try {
                PolicyNode node = null;
                HashMap params = policyElement.getClientParameterList();
                Object method = params.get(ClientParameterCode.DR_POLICY_METHOD);
                Long runEvery = (Long)params.get(ClientParameterCode.DR_POLICY_RUN_EVERY);
                Long startAtDateAndTime = (Long)params.get(ClientParameterCode.DR_POLICY_START_AT_DATE_AND_TIME);
                if (policyType == 1) {
                    node = PolicyFactory.getInstance().createNewMergePolicyNode(policyElement, method);
                } else if (policyType == 0) {
                    node = PolicyFactory.getInstance().createNewReplicationPolicyNode(policyElement, startAtDateAndTime, runEvery);
                } else if (policyType == 2) {
                    node = PolicyFactory.getInstance().createNewTransferPolicyNode(policyElement, method, startAtDateAndTime, runEvery);
                }
                return node;
            }
            catch (RemoteException e) {
                theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
            }
            catch (IllegalValueException e) {
                theLogger.trace(SrLogCategories.LEGACY, e.getMessage());
            }
            return null;
        }
    }
}

