/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.pit.DRPiTNode;
import com.sanrad.nms.client.data.dr.pit.PiTContainer;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.server.logic.dr.DRPair;
import com.sanrad.nms.server.util.types.constants.DRPairTypeConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class DRASyncPairNode
extends DRPairNode
implements PiTContainer {
    private JournalVolumeNode m_primaryJournal;
    private JournalVolumeNode m_secondaryJournal;
    private SnapshotVolumeNode m_primarySnapshot;
    private SnapshotVolumeNode m_secondarySnapshot;
    private ExtendedElementNode m_cgNode;
    private Long m_pendingData;
    private Long m_pendingPits;
    private Long m_notReplicatedPits;
    private Long m_notReplicatedData;
    private Long m_notMergedPits;
    private VolumeTreeNode m_offlineLocalCopy;
    private Long m_lastMerge;
    private ArrayList m_pits = new ArrayList();

    public DRASyncPairNode(DRPair stub) throws RemoteException {
        super(stub);
        this.setNodeIcon(ClientImageObject.ASYNC_PAIR);
        this.setPairType(DRPairTypeConstant.ASYNC);
    }

    public JournalVolumeNode getPrimaryJournal() {
        return this.m_primaryJournal;
    }

    public void setPrimaryJournal(JournalVolumeNode journal) {
        this.m_primaryJournal = journal;
    }

    public JournalVolumeNode getSecondaryJournal() {
        return this.m_secondaryJournal;
    }

    public void setSecondaryJournal(JournalVolumeNode journal) {
        this.m_secondaryJournal = journal;
    }

    public void setConsistencyGroup(ExtendedElementNode cgNode) {
        this.m_cgNode = cgNode;
    }

    public ExtendedElementNode getConsistencyGroup() {
        return this.m_cgNode;
    }

    public Long getPendingData() {
        return this.m_pendingData;
    }

    public void setPendingData(Long pendingData) {
        this.m_pendingData = pendingData;
    }

    public Long getPendingPits() {
        return this.m_pendingPits;
    }

    public void setPendingPits(Long pendingPits) {
        this.m_pendingPits = pendingPits;
    }

    public SnapshotVolumeNode getPrimarySnapshot() {
        return this.m_primarySnapshot;
    }

    public void setPrimarySnapshot(SnapshotVolumeNode primarySnapshot) {
        this.m_primarySnapshot = primarySnapshot;
    }

    public SnapshotVolumeNode getSecondarySnapshot() {
        return this.m_secondarySnapshot;
    }

    public void setSecondarySnapshot(SnapshotVolumeNode secondarySnapshot) {
        this.m_secondarySnapshot = secondarySnapshot;
    }

    public Long getNotMergedPits() {
        return this.m_notMergedPits;
    }

    public void setNotMergedPits(Long notMergedPits) {
        this.m_notMergedPits = notMergedPits;
    }

    public Long getNotReplicatedPits() {
        return this.m_notReplicatedPits;
    }

    public void setNotReplicatedPits(Long notReplicatedPits) {
        this.m_notReplicatedPits = notReplicatedPits;
    }

    public Long getNotReplicatedData() {
        return this.m_notReplicatedData;
    }

    public void setNotReplicatedData(Long notReplicatedData) {
        this.m_notReplicatedData = notReplicatedData;
    }

    @Override
    public void addPiT(DRPiTNode pit) {
        if (!this.m_pits.contains(pit)) {
            this.m_pits.add(pit);
        }
    }

    @Override
    public DRPiTNode[] getPiTs() {
        return this.m_pits.toArray(new DRPiTNode[this.m_pits.size()]);
    }

    @Override
    public void removePiT(DRPiTNode pit) {
        this.m_pits.remove(pit);
    }

    @Override
    public ClusterNode getLocalCluster() {
        VolumeTreeNode priVol = this.getPairPrimaryVolume();
        if (priVol != null) {
            return SystemRootNode.getInstance().getClusterNodeOfSource(priVol);
        }
        return null;
    }

    @Override
    public ClusterNode getRemoteCluster() {
        VolumeTreeNode secVol = this.getPairSecondaryVolume();
        if (secVol != null) {
            return SystemRootNode.getInstance().getClusterNodeOfSource(secVol);
        }
        return null;
    }

    public VolumeTreeNode getOfflineLocalCopy() {
        return this.m_offlineLocalCopy;
    }

    public void setOfflineLocalCopy(VolumeTreeNode offlineLocalCopy) {
        this.m_offlineLocalCopy = offlineLocalCopy;
    }

    public Long getLastMerge() {
        return this.m_lastMerge;
    }

    public void setLastMerge(Long lastMerge) {
        this.m_lastMerge = lastMerge;
    }
}

