/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.dr.ConsistencyGroupNode;
import com.sanrad.nms.client.data.dr.DRASyncPairNode;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.dr.DRPairManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.SrConsistencyGroupsTableModel;
import com.sanrad.nms.client.data.dr.SrPairDetailsTableModel;
import com.sanrad.nms.client.data.raid.RaidManager;
import com.sanrad.nms.client.data.volume.JournalVolumeNode;
import com.sanrad.nms.client.data.volume.SnapshotVolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.client.event.dr.DRAsyncPairEvent;
import com.sanrad.nms.client.event.dr.DRAsyncPairListener;
import com.sanrad.nms.client.event.dr.DRPiTEvent;
import com.sanrad.nms.client.event.dr.DRPiTListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.dr.DRAbstractConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DRAsyncPair;
import com.sanrad.nms.server.logic.dr.DRPair;
import com.sanrad.nms.server.logic.volume.JournalVolume;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class DRASyncPairManager
extends DRPairManager {
    private static DRASyncPairManager m_theInstance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer asyncPairChangedInformer = new SrEventListenerManager.Informer<DRAsyncPairListener, DRAsyncPairEvent>(){

        @Override
        public void inform(DRAsyncPairListener listener, DRAsyncPairEvent event) {
            listener.asyncPairChanged(event);
        }
    };
    SrEventListenerManager.Informer asyncPairCreatedInformer = new SrEventListenerManager.Informer<DRAsyncPairListener, DRAsyncPairEvent>(){

        @Override
        public void inform(DRAsyncPairListener listener, DRAsyncPairEvent event) {
            listener.asyncPairCreated(event);
        }
    };
    SrEventListenerManager.Informer asyncPairRemovedInformer = new SrEventListenerManager.Informer<DRAsyncPairListener, DRAsyncPairEvent>(){

        @Override
        public void inform(DRAsyncPairListener listener, DRAsyncPairEvent event) {
            listener.asyncPairRemoved(event);
        }
    };
    SrEventListenerManager.Informer drPiTsParentUpdatedInformer = new SrEventListenerManager.Informer<DRPiTListener, DRPiTEvent>(){

        @Override
        public void inform(DRPiTListener listener, DRPiTEvent event) {
            listener.drPiTsParentUpdated(event);
        }
    };

    private DRASyncPairManager() {
    }

    public static synchronized DRASyncPairManager getInstance() {
        if (m_theInstance == null) {
            m_theInstance = new DRASyncPairManager();
        }
        return m_theInstance;
    }

    public void addDRAsyncPairListener(DRAsyncPairListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeDRAsyncPairListener(DRAsyncPairListener listener) {
        this.m_listeners.remove(listener);
    }

    public void addDRPiTListener(DRPiTListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeDRPiTListener(DRPiTListener listener) {
        this.m_listeners.remove(listener);
    }

    public void init() {
        this.clearAll();
        this.readAsyncPairsFromServer();
    }

    public void clearAll() {
        SystemRootNode sysRoot = SystemRootNode.getInstance();
        DRASyncPairNode[] nodes = SrPairDetailsTableModel.getInstance().removeAllAsyncPairRows();
        int i = nodes.length;
        while (i-- > 0) {
            sysRoot.removeRefAndIdByStub((RemoteObject)nodes[i].getStub());
        }
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    public void readAsyncPairsFromServer() {
        try {
            ExtendedElementNode[] cgNodes = SrConsistencyGroupsTableModel.getInstance().getAllExtendedElementNodes();
            int i = cgNodes.length;
            while (i-- > 0) {
                DRAsyncPair[] pairs = cgNodes[i].getPairsStubs();
                int j = pairs.length;
                while (j-- > 0) {
                    HashMap params = pairs[j].getClientParameterList();
                    this.createPairNode(pairs[j], params);
                }
            }
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
        }
        catch (IllegalValueException e) {
            theLogger.trace(SrLogCategories.LEGACY, e.getMessage());
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (!DRManager.getInstance().isDRDiscoveryCompleted()) {
            return;
        }
        DRAsyncPair asyncPair = (DRAsyncPair)element;
        DRASyncPairNode asyncPairNode = (DRASyncPairNode)SystemRootNode.getInstance().getRefByStub(asyncPair);
        this.prepareAsyncPairNode(asyncPairNode, this.getParameterList(e));
        this.fireAsyncPairChanged(asyncPairNode);
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (!DRManager.getInstance().isDRDiscoveryCompleted()) {
            return;
        }
        DRASyncPairNode node = (DRASyncPairNode)SystemRootNode.getInstance().getRefByStub(element);
        if (node != null) {
            theLogger.trace(SrLogCategories.LEGACY, "DRPairManager: pair removed");
            ExtendedElementNode pairCG = node.getConsistencyGroup();
            pairCG.removeASyncPair(node);
            RaidManager.getInstance().reactToDRPairEvents();
            this.fireAsyncPairRemoved(node);
            super.elementRemove(e);
            SystemRootNode.getInstance().removeRefAndIdByStub(element);
        }
    }

    @Override
    protected DRPairNode createPairNode(DRPair pair, HashMap clientParams) throws RemoteException {
        DRAsyncPair asyncPair = (DRAsyncPair)pair;
        DRASyncPairNode node = new DRASyncPairNode(asyncPair);
        this.prepareAsyncPairNode(node, clientParams);
        node.setStatus(DRASyncPairManager.getSeverity(pair.getPropagatedState()));
        SystemRootNode.getInstance().putRefAndStub(asyncPair, node);
        this.fireAsyncPairCreated(node);
        RaidManager.getInstance().reactToDRPairEvents();
        return node;
    }

    protected void prepareAsyncPairNode(DRASyncPairNode node, HashMap clientParams) {
        super.preparePairNode(node, clientParams);
        DRAbstractConsistencyGroup extendedElement = (DRAbstractConsistencyGroup)clientParams.get(ClientParameterCode.DR_ASYNC_PAIR_CONSISTENCY_GROUP);
        ExtendedElementNode exNode = (ExtendedElementNode)SystemRootNode.getInstance().getRefByStub(extendedElement);
        JournalVolume priJournalVol = (JournalVolume)clientParams.get(ClientParameterCode.DR_ASYNC_PAIR_PRIMARY_JOURNAL_VOLUME);
        JournalVolumeNode priJournalNode = (JournalVolumeNode)SystemRootNode.getInstance().getRefByStub(priJournalVol);
        JournalVolume secJournalVol = (JournalVolume)clientParams.get(ClientParameterCode.DR_ASYNC_PAIR_SECONDARY_JOURNAL_VOLUME);
        JournalVolumeNode secJournalNode = (JournalVolumeNode)SystemRootNode.getInstance().getRefByStub(secJournalVol);
        SnapshotVolume priSnapshotVol = (SnapshotVolume)clientParams.get(ClientParameterCode.DR_ASYNC_PAIR_PRIMARY_SNAPSHOT_VOLUME);
        SnapshotVolumeNode priSnapshotNode = (SnapshotVolumeNode)SystemRootNode.getInstance().getRefByStub(priSnapshotVol);
        SnapshotVolume secSnapshotVol = (SnapshotVolume)clientParams.get(ClientParameterCode.DR_ASYNC_PAIR_SECONDARY_SNAPSHOT_VOLUME);
        SnapshotVolumeNode secSnapshotNode = (SnapshotVolumeNode)SystemRootNode.getInstance().getRefByStub(secSnapshotVol);
        RemoteObject offlineLocalCopyVol = (RemoteObject)clientParams.get(ClientParameterCode.DR_ASYNC_PAIR_OFFLINE_LOCAL_COPY);
        VolumeTreeNode offlineLocalCopyNode = (VolumeTreeNode)SystemRootNode.getInstance().getRefByStub(offlineLocalCopyVol);
        BigInteger pendingData = (BigInteger)clientParams.get(ClientParameterCode.DR_ASYNC_PAIR_PENDING_DATA);
        BigInteger pendingPits = (BigInteger)clientParams.get(ClientParameterCode.DR_ASYNC_PAIR_PENDING_PITS);
        BigInteger notReplicatedPits = (BigInteger)clientParams.get(ClientParameterCode.DR_ASYNC_PAIR_NOT_REPLICATED_PITS);
        BigInteger notReplicatedData = (BigInteger)clientParams.get(ClientParameterCode.DR_ASYNC_PAIR_NOT_REPLICATED_DATA);
        BigInteger notMergedPits = (BigInteger)clientParams.get(ClientParameterCode.DR_ASYNC_PAIR_NOT_MERGED_PITS);
        SrBITSConstant replState = (SrBITSConstant)clientParams.get(ClientParameterCode.DR_ASYNC_PAIR_REPLICATION_STATE);
        Long lastMerge = (Long)clientParams.get(ClientParameterCode.DR_ASYNC_PAIR_LAST_PIT_MERGE);
        BigInteger lastPitUpdate = (BigInteger)clientParams.get(ClientParameterCode.DR_PIT_PARENT_LAST_UPDATE);
        if (lastPitUpdate != null) {
            this.firePiTParentUpdated(node);
        }
        node.setPendingData(new Long(pendingData.longValue()));
        node.setPendingPits(new Long(pendingPits.longValue()));
        node.setNotReplicatedPits(notReplicatedPits != null ? new Long(notReplicatedPits.longValue()) : new Long(0L));
        node.setNotReplicatedData(notReplicatedData != null ? new Long(notReplicatedData.longValue()) : new Long(0L));
        node.setNotMergedPits(notMergedPits != null ? new Long(notMergedPits.longValue()) : new Long(0L));
        node.setConsistencyGroup(exNode);
        node.setPrimaryJournal(priJournalNode);
        node.setSecondaryJournal(secJournalNode);
        node.setPrimarySnapshot(priSnapshotNode);
        node.setSecondarySnapshot(secSnapshotNode);
        node.setOfflineLocalCopy(offlineLocalCopyNode);
        node.setLastMerge(lastMerge);
        Boolean ambiguityState = (Boolean)clientParams.get(ClientParameterCode.DR_AMBIGUITY);
        if (ambiguityState == null || !ambiguityState.booleanValue() || !node.isInPlannedFailoverState() && !node.isInFallbackState()) {
            node.setReplicationState(replState);
        }
        exNode.addASyncPair(node);
    }

    @Override
    protected ClientParameterCode getReplicationStateCode() {
        return ClientParameterCode.DR_ASYNC_PAIR_REPLICATION_STATE;
    }

    private void fireAsyncPairChanged(DRASyncPairNode node) {
        DRAsyncPairEvent event = new DRAsyncPairEvent(node);
        this.m_listeners.fireEvent(DRAsyncPairListener.class, event, this.asyncPairChangedInformer);
    }

    private void fireAsyncPairCreated(DRASyncPairNode node) {
        DRAsyncPairEvent event = new DRAsyncPairEvent(node);
        this.m_listeners.fireEvent(DRAsyncPairListener.class, event, this.asyncPairCreatedInformer);
    }

    private void fireAsyncPairRemoved(DRASyncPairNode node) {
        DRAsyncPairEvent event = new DRAsyncPairEvent(node);
        this.m_listeners.fireEvent(DRAsyncPairListener.class, event, this.asyncPairRemovedInformer);
    }

    private void firePiTParentUpdated(DRASyncPairNode node) {
        DRPiTEvent event = new DRPiTEvent((Object)this, node);
        this.m_listeners.fireEvent(DRPiTListener.class, event, this.drPiTsParentUpdatedInformer);
    }

    public SrFuture<Void> createPair(DRPairInitialSyncTypeConstant initialSyncType, VolumeTreeNode primaryVolume, VolumeTreeNode scondaryVolume, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun, SnapshotVolumeNode primarySnapshot, SnapshotVolumeNode secondarySnapshot, HashMap secondarySnapshotParams, JournalVolumeNode primaryJournal, JournalVolumeNode secondaryJournal, ConsistencyGroupNode cgNode) {
        return this.createPair(initialSyncType, primaryVolume, scondaryVolume, localTarget, localLun, remoteTarget, remoteLun, primarySnapshot, secondarySnapshot, secondarySnapshotParams, primaryJournal, secondaryJournal, null, cgNode, null, null, null);
    }

    public SrFuture<Void> createPair(DRPairInitialSyncTypeConstant initialSyncType, VolumeTreeNode primaryVolume, VolumeTreeNode secondaryVolume, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun, SnapshotVolumeNode primarySnapshot, SnapshotVolumeNode secondarySnapshot, HashMap secondarySnapshotParams, JournalVolumeNode primaryJournal, JournalVolumeNode secondaryJournal, String cgAlias, HashMap pitPolicy, HashMap transferPolicy, HashMap mergePolicy) {
        return this.createPair(initialSyncType, primaryVolume, secondaryVolume, localTarget, localLun, remoteTarget, remoteLun, primarySnapshot, secondarySnapshot, secondarySnapshotParams, primaryJournal, secondaryJournal, cgAlias, null, pitPolicy, transferPolicy, mergePolicy);
    }

    public SrFuture<Void> createPair(DRPairInitialSyncTypeConstant initialSyncType, VolumeTreeNode primaryVolume, VolumeTreeNode secondaryVolume, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun, SnapshotVolumeNode primarySnapshot, SnapshotVolumeNode secondarySnapshot, HashMap secondarySnapshotParams, JournalVolumeNode primaryJournal, JournalVolumeNode secondaryJournal, HashMap pitPolicy, HashMap transferPolicy, HashMap mergePolicy) {
        return this.createPair(initialSyncType, primaryVolume, secondaryVolume, localTarget, localLun, remoteTarget, remoteLun, primarySnapshot, secondarySnapshot, secondarySnapshotParams, primaryJournal, secondaryJournal, null, null, pitPolicy, transferPolicy, mergePolicy);
    }

    private SrFuture<Void> createPair(DRPairInitialSyncTypeConstant initialSyncType, VolumeTreeNode<?> primaryVolume, VolumeTreeNode<?> scondaryVolume, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun, SnapshotVolumeNode primarySnapshot, SnapshotVolumeNode secondarySnapshot, HashMap secondarySnapshotParams, JournalVolumeNode primaryJournal, JournalVolumeNode secondaryJournal, String cgAlias, ConsistencyGroupNode cgNode, HashMap pitPolicy, HashMap transferPolicy, HashMap mergePolicy) {
        String cgHashKey = null;
        if (cgNode != null) {
            cgHashKey = (String)cgNode.getIdentifier();
        }
        CommKeyClassId primaryId = (CommKeyClassId)primaryVolume.getIdentifier();
        CommKeyClassId secondaryId = (CommKeyClassId)scondaryVolume.getIdentifier();
        CommKeyClassId primaryJournalId = (CommKeyClassId)primaryJournal.getIdentifier();
        CommKeyClassId secondaryJournalId = (CommKeyClassId)secondaryJournal.getIdentifier();
        CommKeyClassId primarySnapshotId = null;
        if (primarySnapshot != null) {
            primarySnapshotId = (CommKeyClassId)primarySnapshot.getIdentifier();
        }
        CommKeyClassId secondarySnapshotId = null;
        if (secondarySnapshot != null) {
            secondarySnapshotId = (CommKeyClassId)secondarySnapshot.getIdentifier();
        } else if (secondarySnapshotParams != null) {
            VolumeTreeNode snapshotChild = (VolumeTreeNode)secondarySnapshotParams.get(ClientParameterCode.VOLUME_CHILDREN);
            secondarySnapshotParams.put(ClientParameterCode.VOLUME_CHILDREN, new CommKeyClassId[]{(CommKeyClassId)snapshotChild.getIdentifier()});
        }
        if (cgHashKey != null) {
            return ClientAOImpl.getInstance().createAsyncPair(initialSyncType, primaryId, secondaryId, localTarget, localLun, remoteTarget, remoteLun, primarySnapshotId, secondarySnapshotId, secondarySnapshotParams, primaryJournalId, secondaryJournalId, cgHashKey);
        }
        if (cgAlias != null) {
            return ClientAOImpl.getInstance().createAsyncPair(initialSyncType, primaryId, secondaryId, localTarget, localLun, remoteTarget, remoteLun, primarySnapshotId, secondarySnapshotId, secondarySnapshotParams, primaryJournalId, secondaryJournalId, cgAlias, pitPolicy, transferPolicy, mergePolicy);
        }
        return ClientAOImpl.getInstance().createAsyncPair(initialSyncType, primaryId, secondaryId, localTarget, localLun, remoteTarget, remoteLun, primarySnapshotId, secondarySnapshotId, secondarySnapshotParams, primaryJournalId, secondaryJournalId, pitPolicy, transferPolicy, mergePolicy);
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
        RemoteObject obj = e.getStub();
        if (obj == null) {
            return;
        }
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(obj);
        if (node != null && node instanceof DRASyncPairNode) {
            node.setStatus(DRASyncPairManager.getSeverity(e.getState()));
            RaidManager.getInstance().reactToDRPairEvents();
            this.fireAsyncPairChanged((DRASyncPairNode)node);
        }
    }

    public SrFuture<Void> recover(DRASyncPairNode node, VolumeTreeNode<?> aVolume, SnapshotVolumeNode snapshot, JournalVolumeNode journal) {
        return ClientAOImpl.getInstance().recover((String)node.getIdentifier(), (CommKeyClassId)aVolume.getIdentifier(), snapshot != null ? (CommKeyClassId)snapshot.getIdentifier() : null, journal != null ? (CommKeyClassId)journal.getIdentifier() : null);
    }

    public SrFuture<Void> refreshPiTs(Collection<DRASyncPairNode> nodes) {
        ArrayList<String> ids = new ArrayList<String>(nodes.size());
        for (DRASyncPairNode node : nodes) {
            ids.add((String)node.getIdentifier());
        }
        return ClientAOImpl.getInstance().refreshPiTs(ids);
    }
}

