/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.cluster.dialogs;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.vswitch.Neighbor;
import com.sanrad.nms.client.data.vswitch.NeighborManager;
import com.sanrad.nms.client.event.vswitch.NeighborEvent;
import com.sanrad.nms.client.event.vswitch.NeighborListener;
import com.sanrad.nms.client.gui.cluster.dialogs.NeighborsTableHeader;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.Date;
import java.util.Vector;

public class SrNeighborsTableModel
extends SrTableModel
implements NeighborListener {
    protected static SrLogger theLogger = SrLogger.getLogger();

    public SrNeighborsTableModel() {
        super(new SrDefaultTableColumns(NeighborsTableHeader.getColumnNames()));
    }

    @Override
    public void removeListeners() {
        NeighborManager.getInstance().removeNeighborListener(this);
    }

    @Override
    public void addListeners() {
        NeighborManager.getInstance().addNeighborListener(this);
    }

    public void init(Vector neighbors) {
        for (int i = 0; i < neighbors.size(); ++i) {
            Neighbor nbr = (Neighbor)neighbors.get(i);
            if (nbr != null) {
                Vector<Object> rowData = new Vector<Object>();
                rowData.addElement(nbr);
                rowData.addElement(nbr.getIPAddress());
                Long lastKeepAliveRecieved = nbr.getLastKeepAliveReceived();
                Date lkaRecieved = new Date(lastKeepAliveRecieved);
                rowData.addElement(lkaRecieved);
                rowData.addElement(nbr.getNeighborStatus());
                this.addRowQuetly(rowData.toArray(), -1);
                continue;
            }
            theLogger.trace(SrLogCategories.LEGACY, "There is inconsistency: client Neighbor is null !");
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    @Override
    public void neighborRemoved(NeighborEvent e) {
    }

    @Override
    public void neighborCreated(NeighborEvent e) {
    }
}

