/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.cluster;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.Client;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.IdentitiesNode;
import com.sanrad.nms.client.data.ManagersConfigurator;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.StubToReference;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.VSwitchGroupNode;
import com.sanrad.nms.client.data.acl.PolicyManager;
import com.sanrad.nms.client.data.raid.AttachedRaidManager;
import com.sanrad.nms.client.data.raid.RaidManager;
import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.data.srv.ExternalServerNode;
import com.sanrad.nms.client.data.srv.isns.ISNSServerManager;
import com.sanrad.nms.client.data.srv.radius.RadiusServerManager;
import com.sanrad.nms.client.data.storage.StorageNode;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.volume.ExposedVolumesRootNode;
import com.sanrad.nms.client.data.volume.UnExposedVolumeRootNode;
import com.sanrad.nms.client.data.volume.VolumeRootNode;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.types.constants.SDTakeOverStateConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.util.BundleKeysInterface;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;

public class ClusterNode
extends VSwitchGroupNode<Cluster> {
    private BigInteger accessibleSpace;
    private Integer faultyInterval;
    private Integer keepAlive;
    private Integer suspiciousInterval;
    private BigInteger totalCapacity;
    private SrBITSConstant capability;
    private Boolean failoverEnable = Boolean.FALSE;
    private SDTakeOverStateConstant takeoverState = null;
    private ExposedVolumesRootNode exposedVolumesNode = null;
    private UnExposedVolumeRootNode unExposedVolumesNode = null;
    private StorageNode storageNode = null;
    private IdentitiesNode identitiesNode;
    private StubToReference stubToRef = new StubToReference();
    private String alias;
    private boolean myIsInDiscoveryProcess = false;
    private PolicyManager policyMgr = null;
    private Vector<ExternalServerNode> radiusServers = new Vector();
    private Vector<ExternalServerNode> isnsServers = new Vector();
    private HashMap m_cluster2Manager;
    private final String myStorageID;
    private final String myCopyOperManagerID;
    private boolean myIsDBCorrupted;
    private static SrLogger theLogger = SrLogger.getLogger();
    private static final String IN_DISCOVERY_PROCESS = ClientLoader.BUNDLE.getString(SrClientBundleKeys.IN_DISCOVERY_PROCESS);
    private boolean myAttachedRaidDlgPopUpEnableFlag = false;

    public ClusterNode(Cluster stub, String alias, boolean singleVSwitch, Integer groupId) throws RemoteException {
        super(stub, groupId);
        this.myStorageID = stub.getStorage().hashKey();
        this.myCopyOperManagerID = stub.getCopyOperManager().hashKey();
        this.setAlias(alias);
        this.setAttachedRaidDlgPopUpEnableFlag(true);
    }

    public void initPolicyManager() {
        this.policyMgr = new PolicyManager(this);
        this.m_cluster2Manager = new HashMap(2);
        this.m_cluster2Manager.put(ManagersConfigurator.getIntegerForId(ClassID.ACL_ENTRY), this.policyMgr);
        this.m_cluster2Manager.put(ManagersConfigurator.getIntegerForId(ClassID.ACL), this.policyMgr);
    }

    public void setAttachedRaidDlgPopUpEnableFlag(boolean aEnablePopUp) {
        this.myAttachedRaidDlgPopUpEnableFlag = aEnablePopUp;
    }

    public boolean shouldAttachedRaidDlgPopUpAppear() {
        if (!Client.getPopUpAttachRAIDDialogEnable()) {
            return false;
        }
        return this.myAttachedRaidDlgPopUpEnableFlag && this.hasVswitchWithNoRaidAttached() && this.hasNonAttachedRaids();
    }

    public ElementManager getManager4ClassId(ClassID classId) {
        ElementManager mgr = null;
        Integer id = ManagersConfigurator.getIntegerForId(classId);
        if (this.m_cluster2Manager != null && this.m_cluster2Manager.containsKey(id)) {
            mgr = (ElementManager)this.m_cluster2Manager.get(id);
        }
        return mgr;
    }

    public void readRadiusServers(boolean sendEvent) {
        this.radiusServers = RadiusServerManager.getInstance().readAllExternalServers(this, sendEvent);
    }

    public void readISNSServers(boolean sendEvent) {
        this.isnsServers = ISNSServerManager.getInstance().readAllExternalServers(this, sendEvent);
    }

    public void setAccessibleSpace(BigInteger accessibleSpace) {
        this.accessibleSpace = accessibleSpace;
    }

    public BigInteger getAccessibleSpace() {
        return this.accessibleSpace;
    }

    public void setKeepAlive(Integer keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Integer getKeepAlive() {
        return this.keepAlive;
    }

    public void setFaultyInterval(Integer faultyInterval) {
        this.faultyInterval = faultyInterval;
    }

    public Integer getFaultyInterval() {
        return this.faultyInterval;
    }

    public void setSuspiciousInterval(Integer suspiciousInterval) {
        this.suspiciousInterval = suspiciousInterval;
    }

    public Integer getSuspiciousInterval() {
        return this.suspiciousInterval;
    }

    public void setTotalCapacity(BigInteger totalCapacity) {
        this.totalCapacity = totalCapacity;
    }

    public BigInteger getTotalCapacity() {
        return this.totalCapacity;
    }

    public void setCapablity(SrBITSConstant capability) {
        this.capability = capability;
    }

    public SrBITSConstant getCapability() {
        return this.capability;
    }

    @Override
    public String type() {
        return "Cluster";
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public boolean isCurrentCluster() {
        return this.equals(SystemRootNode.getInstance().getCurrentClusterNode());
    }

    @Override
    public String toString() {
        return this.getAlias();
    }

    public VolumeRootNode getExposedVolumesNode() {
        return this.exposedVolumesNode;
    }

    public VolumeRootNode getUnExposedVolumesNode() {
        return this.unExposedVolumesNode;
    }

    public StorageNode getStorageNode() {
        return this.storageNode;
    }

    public IdentitiesNode getIdentitiesNode() {
        return this.identitiesNode;
    }

    public void addChildrenNodes(boolean aIsAddVSwitchData) {
        this.removeAllChildren();
        this.exposedVolumesNode = new ExposedVolumesRootNode();
        this.unExposedVolumesNode = new UnExposedVolumeRootNode();
        this.add(this.exposedVolumesNode);
        this.add(this.unExposedVolumesNode);
        this.storageNode = new StorageNode(this);
        this.add(this.storageNode);
        this.identitiesNode = new IdentitiesNode(this);
        this.add(this.identitiesNode);
        if (aIsAddVSwitchData) {
            List<VSwitchNode> vSwitchNodes = VSwitchManager.getInstance().readVSwitchesFromServer(this);
            List targetNodes = TargetManager.getInstance().readTargetsDataFromServer(this);
            if (targetNodes != null) {
                for (Object curNode : targetNodes) {
                    this.exposedVolumesNode.add((SrTreeNode)curNode);
                }
            }
            if (vSwitchNodes != null && vSwitchNodes.size() > 0) {
                for (VSwitchNode node : vSwitchNodes) {
                    this.add(node);
                }
            }
        }
    }

    public StubToReference getStubToReference() {
        return this.stubToRef;
    }

    public void setDiscoveryProcess(boolean state) {
        this.myIsInDiscoveryProcess = state;
        String value = IN_DISCOVERY_PROCESS;
        ClusterNode node = this;
        if (state) {
            this.addGraphicalIndication(node, value);
            this.setAttachedRaidDlgPopUpEnableFlag(true);
        } else {
            this.myGraphicalIndications.clear();
        }
    }

    public boolean isInDiscoveryProcess() {
        return this.myIsInDiscoveryProcess;
    }

    public String getInDiscoveryTooltip() {
        return this.isInDiscoveryProcess() ? ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_CLUSTER_IN_DISCOVERY, this.toString()) : null;
    }

    public PolicyManager getPolicyManager() {
        return this.policyMgr;
    }

    public boolean hasVSwitch() {
        return this.getChildrenOfType(VSwitchNode.class).size() > 0;
    }

    public boolean hasConnectedVSwitches() {
        return this.getConnectedVSwitches().length > 0;
    }

    public boolean isSingleVSwitchMode() {
        return this.getVswitchesCount() == 1;
    }

    @Override
    public int getVswitchesCount() {
        return this.getVSwitches().length;
    }

    public Vector getRadiusServers() {
        return this.radiusServers;
    }

    public void addRadiusServer(ExternalServerNode node) {
        this.radiusServers.add(node);
    }

    public void removeRadiusServer(ExternalServerNode node) {
        this.radiusServers.remove(node);
    }

    public void setFailoverEnable(Boolean enable) {
        this.failoverEnable = enable;
    }

    public Boolean isFailoverEnable() {
        return this.failoverEnable;
    }

    public void setTakeoverState(SDTakeOverStateConstant state) {
        this.takeoverState = state;
    }

    public SDTakeOverStateConstant getTakeoverState() {
        return this.takeoverState;
    }

    public boolean isUnderTakeover() {
        return SDTakeOverStateConstant.SD_TAKE_OVER_STATE_UNDER_TAKE_OVER.equals(this.takeoverState);
    }

    public boolean isInitializing() {
        return SDTakeOverStateConstant.SD_TAKE_OVER_STATE_STANDING.equals(this.takeoverState);
    }

    public Vector getISNSServers() {
        return this.isnsServers;
    }

    public void addISNSServer(ExternalServerNode node) {
        this.isnsServers.add(node);
    }

    public void removeISNSServer(ExternalServerNode node) {
        this.isnsServers.remove(node);
    }

    public List<VSwitchNode> getClusterVSwitches() {
        return this.getChildrenOfType(VSwitchNode.class);
    }

    public VSwitchNode getVSwitchByName(String name) {
        List<VSwitchNode> vSwitches = this.getClusterVSwitches();
        for (VSwitchNode vs : vSwitches) {
            if (!vs.getName().equals(name)) continue;
            return vs;
        }
        return null;
    }

    public VSwitchNode getVSwitchByIp(String aIp) {
        List<VSwitchNode> vSwitches = this.getClusterVSwitches();
        for (VSwitchNode vs : vSwitches) {
            if (!vs.getIPAddress().equals(aIp)) continue;
            return vs;
        }
        return null;
    }

    public VSwitchNode getOtherVSwitchInCluster(VSwitchNode vswitch) {
        List<VSwitchNode> vSwitches = this.getClusterVSwitches();
        for (VSwitchNode vs : vSwitches) {
            if (vs.getName().equals(vswitch.getName())) continue;
            return vs;
        }
        return null;
    }

    public VSwitchNode[] getVSwitches() {
        List<VSwitchNode> vsList = this.getChildrenOfType(VSwitchNode.class);
        return vsList.toArray(new VSwitchNode[vsList.size()]);
    }

    public boolean hasVswitchTypeVStor() {
        List<VSwitchNode> vSwitches = this.getClusterVSwitches();
        for (VSwitchNode vs : vSwitches) {
            if (!vs.isVStor()) continue;
            return true;
        }
        return false;
    }

    public VSwitchNode[] getConnectedVSwitches() {
        VSwitchNode[] vsList = this.getVSwitches();
        ArrayList<VSwitchNode> returnList = new ArrayList<VSwitchNode>();
        for (VSwitchNode vs : vsList) {
            if (!vs.isConnected()) continue;
            returnList.add(vs);
        }
        return returnList.toArray(new VSwitchNode[returnList.size()]);
    }

    @Override
    public ImageIcon getNodeIcon() {
        return ClientImageObject.CLUSTER.getImageIcon();
    }

    public boolean allAvailableVSwitchesDisconnected() {
        Vector<VSwitchNode> availableVSwitches = VSwitchManager.getInstance().getAvailableVSwitches(this);
        for (int index = 0; index < availableVSwitches.size(); ++index) {
            VSwitchNode vswitchNode = availableVSwitches.elementAt(index);
            if (!vswitchNode.isConnected()) continue;
            return false;
        }
        return true;
    }

    public String getStorageID() {
        return this.myStorageID;
    }

    public String getCopyOperManagerID() {
        return this.myCopyOperManagerID;
    }

    public void setDBCorrupted(boolean aIsDBCorrupted) {
        this.myIsDBCorrupted = aIsDBCorrupted;
    }

    public boolean isDBCorrupted() {
        return this.myIsDBCorrupted;
    }

    private boolean hasVswitchWithNoRaidAttached() {
        for (VSwitchNode vs : this.getVSwitches()) {
            if (!AttachedRaidManager.getInstance().getAttachedRaids(vs).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean hasNonAttachedRaids() {
        for (RaidSystem curRaid : RaidManager.getInstance().getRaids(this)) {
            if (RaidSystem.Type.GDR_UNMANAGED_RAID.equals((Object)curRaid.getType()) || AttachedRaidManager.getInstance().isAttached(curRaid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getProblemOnDeletion() {
        return null;
    }
}

