/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.cluster;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.VSwitchGroupNode;
import com.sanrad.nms.client.data.acl.PolicyManager;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.raid.AttachedRaidManager;
import com.sanrad.nms.client.data.raid.RaidManager;
import com.sanrad.nms.client.data.site.SiteManager;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.target.qos.TargetQosGroupsManager;
import com.sanrad.nms.client.data.volume.VolumeManager;
import com.sanrad.nms.client.data.volume.snapshot.SnapshotSchedulerManager;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.client.event.cluster.ClusterEvent;
import com.sanrad.nms.client.event.cluster.ClusterListener;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.client.gui.SrTransientWindowPane;
import com.sanrad.nms.client.gui.actions.SrClientAction;
import com.sanrad.nms.client.gui.alarm.SrAlarmsTablePanel;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.license.LicenseManager;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.srv.ExternalServer;
import com.sanrad.nms.server.logic.vswitch.Neighbor;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.SDTakeOverStateConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.swing.actions.ConstantView;
import com.sanrad.swing.actions.View;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ClusterManager
extends ElementManager {
    SrEventListenerManager.Informer clusterPropertiesChangedInformer = new SrEventListenerManager.Informer<ClusterListener, ClusterEvent>(){

        @Override
        public void inform(ClusterListener listener, ClusterEvent event) {
            listener.clusterPropertiesChanged(event);
        }
    };
    SrEventListenerManager.Informer discoverCompletedInformer = new SrEventListenerManager.Informer<ClusterListener, ClusterEvent>(){

        @Override
        public void inform(ClusterListener listener, ClusterEvent event) {
            listener.discoverCompleted(event);
        }
    };
    SrEventListenerManager.Informer discoverStartedInformer = new SrEventListenerManager.Informer<ClusterListener, ClusterEvent>(){

        @Override
        public void inform(ClusterListener listener, ClusterEvent event) {
            listener.discoverStarted(event);
        }
    };
    SrEventListenerManager.Informer clusterStatusChangedInformer = new SrEventListenerManager.Informer<ClusterListener, ClusterEvent>(){

        @Override
        public void inform(ClusterListener listener, ClusterEvent event) {
            listener.clusterStatusChanged(event);
        }
    };
    SrEventListenerManager.Informer clusterCreatedInformer = new SrEventListenerManager.Informer<ClusterListener, ClusterEvent>(){

        @Override
        public void inform(ClusterListener listener, ClusterEvent event) {
            listener.clusterCreated(event);
        }
    };
    SrEventListenerManager.Informer clusterRemovedInformer = new SrEventListenerManager.Informer<ClusterListener, ClusterEvent>(){

        @Override
        public void inform(ClusterListener listener, ClusterEvent event) {
            listener.clusterRemoved(event);
        }
    };
    private static ClusterManager theInstance = null;
    private static SrLogger theLogger = SrLogger.getLogger();

    private ClusterManager() {
    }

    public static synchronized ClusterManager getInstance() {
        if (theInstance == null) {
            theInstance = new ClusterManager();
        }
        return theInstance;
    }

    public void addClusterListener(ClusterListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeClusterListener(ClusterListener listener) {
        this.m_listeners.remove(listener);
    }

    public BigInteger getTotalCapacity(ClusterNode clusterNode) {
        try {
            Object stub = clusterNode.getStub();
            return ((Cluster)stub).getTotalCapacity();
        }
        catch (RemoteException re) {
            theLogger.trace(SrLogCategories.LEGACY, re);
            theLogger.trace(SrLogCategories.LEGACY, "Failed to get cluster Total Capacity.");
            ClusterManager.onConnectionError("Failed to get cluster Total Capacity.");
            return new BigInteger("0");
        }
    }

    public BigInteger getAccessibleSpace(ClusterNode clusterNode) {
        try {
            Object stub = clusterNode.getStub();
            return ((Cluster)stub).getAccessibleSpace();
        }
        catch (RemoteException re) {
            theLogger.trace(SrLogCategories.LEGACY, re);
            theLogger.trace(SrLogCategories.LEGACY, "Failed to get cluster Accessible Space.");
            ClusterManager.onConnectionError("Failed to get cluster Accessible Space.");
            return new BigInteger("0");
        }
    }

    public Vector getAllNeighbors(ClusterNode node) {
        try {
            Object stub = node.getStub();
            Cluster cluster = (Cluster)stub;
            List<? extends Neighbor> neighbors = cluster.getNeighbors();
            Vector<SrTreeNode> retVal = new Vector<SrTreeNode>(neighbors.size());
            for (int i = 0; i < neighbors.size(); ++i) {
                Neighbor nstub = neighbors.get(i);
                SrTreeNode nbr = SystemRootNode.getInstance().getRefByStub(nstub);
                this.updateNeighbor(nbr, nstub);
                retVal.addElement(nbr);
            }
            return retVal;
        }
        catch (RemoteException re) {
            theLogger.trace(SrLogCategories.LEGACY, re);
            ClusterManager.onConnectionError("Failed to get Neighbors.");
            return new Vector();
        }
    }

    public Vector getAllIdentities(ClusterNode clusterNode) {
        try {
            Cluster cluster = (Cluster)clusterNode.getStub();
            Vector<? extends Identity> identities = cluster.getAllIdentities();
            return identities;
        }
        catch (RemoteException re) {
            theLogger.trace(SrLogCategories.LEGACY, re);
            ClusterManager.onConnectionError();
            return new Vector();
        }
    }

    public Vector getAllRadiusServers(ClusterNode clusterNode) {
        try {
            Cluster cluster = (Cluster)clusterNode.getStub();
            Vector<? extends ExternalServer> servers = cluster.getAllRadiusServers();
            return servers;
        }
        catch (RemoteException re) {
            theLogger.trace(SrLogCategories.LEGACY, re);
            ClusterManager.onConnectionError();
            return new Vector(0);
        }
    }

    public Vector getAllISNSServers(ClusterNode clusterNode) {
        try {
            Cluster cluster = (Cluster)clusterNode.getStub();
            Vector<? extends ExternalServer> servers = cluster.getAllISNSServers();
            return servers;
        }
        catch (RemoteException re) {
            theLogger.trace(SrLogCategories.LEGACY, re);
            ClusterManager.onConnectionError();
            return new Vector(0);
        }
    }

    private void updateNeighbor(Object nbr, Object stub) {
        try {
            com.sanrad.nms.client.data.vswitch.Neighbor neighbor = (com.sanrad.nms.client.data.vswitch.Neighbor)nbr;
            Neighbor nstub = (Neighbor)stub;
            theLogger.trace(SrLogCategories.LEGACY, "updating the Neighbor ", neighbor.getName(), " details from the server.");
            neighbor.setNeighborStatus(nstub.getStatus());
            theLogger.trace(SrLogCategories.LEGACY, "updating the status - ", neighbor.getNeighborStatus());
            neighbor.setLastKeepAliveReceived(nstub.getLastKeepAliveReceived());
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, "Failed to update the Neighbor details from the server.");
            ClusterManager.onConnectionError("Failed to update the Neighbor details from the server.");
        }
    }

    public SrFuture<Void> createVSwitch(String ip, String mask, int snmpPort, int trapPort, String readCommunity, String writeCommunity, int timeout, int retries, VSwitchGroupNode<?> parent) {
        theLogger.trace(SrLogCategories.LEGACY, "Try to add vSwitch: ", ip);
        return ClientAOImpl.getInstance().addClusterVSwitch((CommKeyClassId)parent.getIdentifier(), ip, mask, snmpPort, trapPort, readCommunity, writeCommunity, timeout, retries, SnmpVersion.V2C);
    }

    public Vector getClusterNodes() {
        return SystemRootNode.getInstance().getClusterNodes();
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        super.elementRemove(e);
        RemoteObject element = e.getElement();
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(element);
        if (node instanceof ClusterNode) {
            theLogger.trace(SrLogCategories.LEGACY, "Cluster removed.");
            ClusterNode clusterNode = (ClusterNode)node;
            VolumeManager.getInstance().clearClusterJournals(clusterNode);
            RaidManager.getInstance().reactToClusterRemoved(clusterNode);
            AlarmsManager.getInstance().clearAllAlarms(clusterNode);
            StorageManager.getInstance().removeStorages(clusterNode);
            TargetQosGroupsManager.getInstance().removeQosGroups(clusterNode);
            AttachedRaidManager.getInstance().removeAttachedRaids(clusterNode);
            SnapshotSchedulerManager.getInstance().removeSnapshotSchedulers(clusterNode);
            this.fireClusterRemovedEvent(clusterNode);
            PolicyManager policyMgr = clusterNode.getPolicyManager();
            if (policyMgr != null) {
                policyMgr.clusterRemoved();
            }
            SystemRootNode.getInstance().removeCluster(clusterNode);
        }
    }

    private void fireClusterPropertiesChanged(ClusterNode cluster) {
        ClusterEvent event = this.createEvent(cluster);
        this.m_listeners.fireEvent(ClusterListener.class, event, this.clusterPropertiesChangedInformer);
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
        RemoteObject element = e.getStub();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (element instanceof Cluster) {
            if (SystemRootNode.getInstance().getRefByStub(element) == null) {
                theLogger.trace(SrLogCategories.LEGACY, "ClusterManager- propagatedStateChanged() on an unknown element !");
                return;
            }
            theLogger.trace(SrLogCategories.LEGACY, "ClusterManager: propagatedStateChanged().");
            super.propagatedStateChanged(e);
            ClusterEvent event = new ClusterEvent(this, element);
            this.fireStatusChanged(event);
        }
    }

    public boolean isDiscoveryCompleted(ClusterNode clusterNode) {
        try {
            boolean isDiscoveryCompleted = ((Cluster)clusterNode.getStub()).isDiscoverCompleted();
            theLogger.trace(SrLogCategories.LEGACY, "ClusterManager: isDiscoveryCompleted() - ", isDiscoveryCompleted);
            return isDiscoveryCompleted;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            theLogger.trace(SrLogCategories.LEGACY, "ClusterManager: isDiscoveryCompleted() - caught exception, return false.");
            return false;
        }
    }

    @Override
    public void discoverCompleted(CommunicationEvent e) {
        super.discoverCompleted(e);
        Cluster cluster = (Cluster)e.getElement();
        ClusterNode clusterNode = (ClusterNode)SystemRootNode.getInstance().getRefByStub(cluster);
        try {
            assert (this.printClusterOnNull(cluster, clusterNode));
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
        }
        SrTransientWindowPane.showClusterRediscoverCompleted(ClientLoader.getMainFrame(), clusterNode, new SrAlarmsTablePanel.SourceAction<ClusterNode>((View<ClusterNode>)new ConstantView<ClusterNode>(Collections.singleton(clusterNode))));
        ClusterEvent event = new ClusterEvent(this, cluster);
        this.m_listeners.fireEvent(ClusterListener.class, event, this.discoverCompletedInformer);
    }

    private boolean printClusterOnNull(Cluster cluster, ClusterNode clusterNode) throws RemoteException {
        theLogger.logAndAssert(SrLogCategories.ERROR, clusterNode != null, new Object[]{"Cluster ", cluster.getAlias(), " discover completed and no node exists"});
        return true;
    }

    @Override
    public void discoverStarted(CommunicationEvent e) {
        RemoteObject obj = e.getElement();
        if (obj instanceof Cluster) {
            Cluster cluster = (Cluster)e.getElement();
            ClusterEvent event = new ClusterEvent(this, cluster);
            theLogger.trace(SrLogCategories.LEGACY, "Discovery Proccesss started.");
            ClusterNode clusterNode = (ClusterNode)SystemRootNode.getInstance().getRefByStub(obj);
            if (clusterNode != null) {
                RaidManager.getInstance().reactToClusterDiscoveryStarted(clusterNode);
                StorageManager.getInstance().removeStorages(clusterNode);
                TargetQosGroupsManager.getInstance().removeQosGroups(clusterNode);
                AttachedRaidManager.getInstance().removeAttachedRaids(clusterNode);
                SnapshotSchedulerManager.getInstance().removeSnapshotSchedulers(clusterNode);
            }
            this.m_listeners.fireEvent(ClusterListener.class, event, this.discoverStartedInformer);
        }
    }

    public SrFuture<Void> setAlias(ClusterNode clusterNode, String newAlias) {
        HashMap<ClientParameterCode, String> params = new HashMap<ClientParameterCode, String>();
        params.put(ClientParameterCode.CLUSTER_ALIAS, newAlias);
        return ClientAOImpl.getInstance().changeElements(Collections.singleton(clusterNode.getIdentifier()), params);
    }

    private void fireStatusChanged(ClusterEvent event) {
        this.m_listeners.fireEvent(ClusterListener.class, event, this.clusterStatusChangedInformer);
    }

    public ClusterNode createClusterNode(Cluster cluster, HashMap params) {
        ClusterNode clusterNode = null;
        try {
            clusterNode = new ClusterNode(cluster, null, false, cluster.getVSwitchGroupId());
            this.initializeNode(params, cluster, clusterNode, true);
            SystemRootNode.getInstance().addCluster(clusterNode);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
        }
        return clusterNode;
    }

    private ClusterEvent createEvent(ClusterNode clusterNode) {
        ClusterEvent event = new ClusterEvent(this, (RemoteObject)clusterNode.getStub());
        return event;
    }

    private void fireClusterCreatedEvent(ClusterNode clusterNode) {
        ClusterEvent event = this.createEvent(clusterNode);
        this.m_listeners.fireEvent(ClusterListener.class, event, this.clusterCreatedInformer);
    }

    private void fireClusterRemovedEvent(ClusterNode vSwitchNode) {
        ClusterEvent event = this.createEvent(vSwitchNode);
        this.m_listeners.fireEvent(ClusterListener.class, event, this.clusterRemovedInformer);
    }

    public void readClusterDataFromServer(ClusterNode clusterNode) {
        try {
            Cluster clusterStub = (Cluster)clusterNode.getStub();
            clusterNode.setAlias(clusterStub.getAlias());
            clusterNode.setCapablity(clusterStub.getCapability());
            this.fireClusterPropertiesChanged(clusterNode);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ClusterManager.onConnectionError();
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        try {
            RemoteObject element = e.getElement();
            if (element instanceof Cluster) {
                HashMap map = this.getParameterList(e);
                SrTreeNode obj = SystemRootNode.getInstance().getRefByStub(element);
                if (obj != null) {
                    ClusterNode node = (ClusterNode)obj;
                    this.initializeNode(map, (Cluster)element, node, false);
                    this.fireClusterPropertiesChanged(node);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ClusterManager.onConnectionError();
        }
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        boolean isCluster = element instanceof Cluster;
        if (isCluster || element instanceof Neighbor) {
            HashMap params = this.getParameterList(e);
            if (isCluster) {
                theLogger.trace(SrLogCategories.LEGACY, "Cluster created. ");
                Cluster cluster = (Cluster)element;
                ClusterNode clusterNode = this.createClusterNode(cluster, params);
                this.fireClusterCreatedEvent(clusterNode);
            } else {
                theLogger.error(SrLogCategories.LEGACY, "Neighbor created. ");
                Neighbor neighbor = (Neighbor)element;
                try {
                    Cluster cluster = SystemRootNode.getCluster(neighbor);
                    Integer faultyInterval = (Integer)this.getObjectForParam(params, ClientParameterCode.CLUSTER_FAULTY_INTERVAL, true);
                    Integer keepAlive = (Integer)this.getObjectForParam(params, ClientParameterCode.CLUSTER_KEEP_ALIVE, true);
                    Integer suspiciousInterval = (Integer)this.getObjectForParam(params, ClientParameterCode.CLUSTER_SUSPICIOUS_INTERVAL, true);
                    SrBITSConstant capability = (SrBITSConstant)this.getObjectForParam(params, ClientParameterCode.CLUSTER_CAPABILITY, true);
                    ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfStub(cluster);
                    clusterNode.setKeepAlive(keepAlive);
                    clusterNode.setFaultyInterval(faultyInterval);
                    clusterNode.setSuspiciousInterval(suspiciousInterval);
                    clusterNode.setCapablity(capability);
                }
                catch (RemoteException re) {
                    theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                    ClusterManager.onConnectionError();
                }
            }
        }
    }

    private void initializeNode(HashMap params, Cluster cluster, SrTreeNode node, boolean isCreate) throws RemoteException {
        Object alias = this.getObjectForParam(params, ClientParameterCode.CLUSTER_ALIAS, isCreate);
        Object totalCapacity = this.getObjectForParam(params, ClientParameterCode.CLUSTER_TOTAL_CAPACITY, isCreate);
        Object accessibleSpace = this.getObjectForParam(params, ClientParameterCode.CLUSTER_ACCESSIBLE_SPACE, isCreate);
        Object capability = this.getObjectForParam(params, ClientParameterCode.CLUSTER_CAPABILITY, isCreate);
        Object faultyInterval = this.getObjectForParam(params, ClientParameterCode.CLUSTER_FAULTY_INTERVAL, isCreate);
        Object keepAlive = this.getObjectForParam(params, ClientParameterCode.CLUSTER_KEEP_ALIVE, isCreate);
        Object suspiciousInterval = this.getObjectForParam(params, ClientParameterCode.CLUSTER_SUSPICIOUS_INTERVAL, isCreate);
        Object takeoverState = this.getObjectForParam(params, ClientParameterCode.CLUSTER_TAKEOVER_STATE, isCreate);
        Object status = this.getObjectForParam(params, ClientParameterCode.PROPAGATION_STATE, isCreate);
        ClusterNode clusterNode = (ClusterNode)node;
        if (isCreate) {
            Object failoverEnable = this.getObjectForParam(params, ClientParameterCode.CLUSTER_FAILOVER_ENABLE, isCreate);
            if (alias == null) {
                alias = cluster.getAlias();
            }
            if (totalCapacity == null) {
                totalCapacity = cluster.getTotalCapacity();
            }
            if (accessibleSpace == null) {
                accessibleSpace = cluster.getAccessibleSpace();
            }
            if (faultyInterval == null) {
                faultyInterval = cluster.getFaultyInterval();
            }
            if (keepAlive == null) {
                keepAlive = cluster.getKeepAlive();
            }
            if (suspiciousInterval == null) {
                suspiciousInterval = cluster.getSuspiciousInterval();
            }
            if (failoverEnable == null) {
                failoverEnable = cluster.isFailoverEnable();
            }
            if (takeoverState == null) {
                takeoverState = cluster.getTakeoverState();
            }
            if (status == null) {
                status = cluster.getPropagatedState();
            }
            clusterNode.setFailoverEnable((Boolean)failoverEnable);
        }
        if (faultyInterval != null) {
            clusterNode.setFaultyInterval((Integer)faultyInterval);
        }
        if (keepAlive != null) {
            clusterNode.setKeepAlive((Integer)keepAlive);
        }
        if (suspiciousInterval != null) {
            clusterNode.setSuspiciousInterval((Integer)suspiciousInterval);
        }
        if (takeoverState != null) {
            clusterNode.setTakeoverState((SDTakeOverStateConstant)takeoverState);
        }
        if (status != null) {
            clusterNode.setStatus(SiteManager.getSeverity((AlarmSeverity)status));
        }
        if (alias != null) {
            clusterNode.setAlias((String)alias);
        }
        if (totalCapacity != null) {
            clusterNode.setTotalCapacity((BigInteger)totalCapacity);
        }
        if (accessibleSpace != null) {
            clusterNode.setAccessibleSpace((BigInteger)accessibleSpace);
        }
        if (capability != null) {
            clusterNode.setCapablity((SrBITSConstant)capability);
        }
        clusterNode.setDBCorrupted(cluster.isDBCorrupted());
    }

    public String validateClustersInSystem() {
        if (SystemRootNode.getInstance().getClusterNodes().size() == 0) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SYSTEM_NO_CLUSTERS);
        }
        boolean hasConnectedCluster = false;
        for (ClusterNode cluster : SystemRootNode.getInstance().getClusterNodes()) {
            if (!cluster.hasConnectedVSwitches()) continue;
            hasConnectedCluster = true;
            break;
        }
        if (!hasConnectedCluster) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SYSTEM_NO_CLUSTERS_AVAILABLE);
        }
        return null;
    }

    public String validateVStorExists() {
        for (Object cluster : this.getClusterNodes()) {
            if (!((ClusterNode)cluster).hasVswitchTypeVStor()) continue;
            return null;
        }
        return ClientLoader.DATA_VALIDATION_BUNDLE.getString(SrDataValidationResourceBundleKeys.SYSTEM_NO_VSTORES);
    }

    public static String validateCreateVirtualizationOnCluster(ClusterNode aCluster) {
        String msg = VSwitchManager.getInstance().validateConnectedVswitchExists(aCluster);
        if (msg == null && !LicenseManager.getInstance().isEnabled(SrLicenseTreePath.VOLUME_PATH, aCluster.getCapability())) {
            msg = SrClientAction.LICENSE_TOOLTIP;
        }
        return msg;
    }
}

