/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.alarm;

import com.sanrad.nms.client.data.alarm.AlarmNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.alarm.SrAlarmsTableColumns;
import com.sanrad.nms.client.data.alarm.SrAlarmsTableModel;
import com.sanrad.nms.client.event.alarm.AlarmsEvent;
import com.sanrad.nms.client.gui.alarm.CurrentAlarmsTableHeader;
import com.sanrad.nms.server.alarm.Alarm;
import java.util.ArrayList;
import java.util.List;

public class SrLimitedAlarmsTableModel
extends SrAlarmsTableModel {
    private static SrLimitedAlarmsTableModel m_instance;
    public static final int LIMIT = 10;

    public static synchronized SrAlarmsTableModel getInstance() {
        if (m_instance == null) {
            m_instance = new SrLimitedAlarmsTableModel();
        }
        return m_instance;
    }

    private SrLimitedAlarmsTableModel() {
        super(new SrAlarmsTableColumns());
    }

    @Override
    public int getRowCount() {
        return Math.min(10, super.getRowCount());
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.m_data.size() > row) {
            return ((ArrayList)this.m_data.get(row)).get(col);
        }
        return null;
    }

    @Override
    public void removeRow(int row) {
        this.m_data.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    @Override
    public void removeRowQuetly(int row) {
        this.m_data.remove(row);
    }

    @Override
    protected void addAlarmRowQuetly(List rowData) {
        int nameCol = this.getColumnIndex(CurrentAlarmsTableHeader.NAME.getColumnName());
        AlarmNode alarm = (AlarmNode)rowData.get(nameCol);
        if (!alarm.isAcknowledged()) {
            this.addRowQuetly(rowData.toArray(), 0);
        }
    }

    @Override
    public void alarmChanged(AlarmsEvent event) {
        Alarm stub = (Alarm)event.getStub();
        Object alarm = AlarmsManager.getInstance().getAlarmByStub(stub);
        if (alarm != null) {
            boolean ack = ((AlarmNode)alarm).isAcknowledged();
            if (ack) {
                this.alarmClosed(event);
                return;
            }
            this.alarmOpened(event);
        }
    }
}

