/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.alarm;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.AliasObject;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.alarm.AlarmNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.alarm.SrAlarmsTableModel;
import com.sanrad.nms.client.event.alarm.AlarmsEvent;
import com.sanrad.nms.client.event.alarm.HistoryAlarmsTableModelEvent;
import com.sanrad.nms.client.event.alarm.HistoryAlarmsTableModelListener;
import com.sanrad.nms.client.gui.alarm.HistoryAlarmsTableHeader;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.util.SrEventListenerManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SrHistoryAlarmsTableModel
extends SrAlarmsTableModel {
    private int m_index = 0;
    private List m_historyAlarms = new ArrayList();
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer<HistoryAlarmsTableModelListener, HistoryAlarmsTableModelEvent> loadingHistoryAlarmsInformer = new SrEventListenerManager.Informer<HistoryAlarmsTableModelListener, HistoryAlarmsTableModelEvent>(){

        @Override
        public void inform(HistoryAlarmsTableModelListener listener, HistoryAlarmsTableModelEvent event) {
            listener.loadingHistoryAlarms(event);
        }
    };
    SrEventListenerManager.Informer<HistoryAlarmsTableModelListener, HistoryAlarmsTableModelEvent> historyAlarmsLoadedInformer = new SrEventListenerManager.Informer<HistoryAlarmsTableModelListener, HistoryAlarmsTableModelEvent>(){

        @Override
        public void inform(HistoryAlarmsTableModelListener listener, HistoryAlarmsTableModelEvent event) {
            listener.historyAlarmsLoaded(event);
        }
    };
    SrEventListenerManager.Informer<HistoryAlarmsTableModelListener, HistoryAlarmsTableModelEvent> historyAlarmsConnectionExceptionInformer = new SrEventListenerManager.Informer<HistoryAlarmsTableModelListener, HistoryAlarmsTableModelEvent>(){

        @Override
        public void inform(HistoryAlarmsTableModelListener listener, HistoryAlarmsTableModelEvent event) {
            listener.serverConnectionError(event);
        }
    };

    public SrHistoryAlarmsTableModel() {
        super(new SrDefaultTableColumns(HistoryAlarmsTableHeader.getColumnNames()));
    }

    @Override
    protected void initModel() {
    }

    public void initialize() {
        this.removeAllRows();
        this.notifyLoadingAlarms();
        new HistoryAlarmsFetcher(true, true).start();
    }

    public List getSelectedAlarms(int[] indices) {
        ArrayList<Object> alarms = new ArrayList<Object>();
        int col = this.getColumnIndex(HistoryAlarmsTableHeader.NAME.getColumnName());
        for (int i = 0; i < indices.length; ++i) {
            List<Object> rowData = this.getRow(indices[i]);
            alarms.add(rowData.get(col));
        }
        return alarms;
    }

    private void notifyLoadingAlarms() {
        HistoryAlarmsTableModelEvent event = new HistoryAlarmsTableModelEvent(this);
        this.m_listeners.fireEvent(HistoryAlarmsTableModelListener.class, event, this.loadingHistoryAlarmsInformer);
    }

    private void notifyAlarmsLoaded() {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
        HistoryAlarmsTableModelEvent event = new HistoryAlarmsTableModelEvent(this);
        this.m_listeners.fireEvent(HistoryAlarmsTableModelListener.class, event, this.historyAlarmsLoadedInformer);
    }

    private void notifyConnectionError() {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
        HistoryAlarmsTableModelEvent event = new HistoryAlarmsTableModelEvent(this);
        this.m_listeners.fireEvent(HistoryAlarmsTableModelListener.class, event, this.historyAlarmsConnectionExceptionInformer);
    }

    public void addHistoryAlarmsTableModelListener(HistoryAlarmsTableModelListener l) {
        this.m_listeners.add(l);
    }

    public void removeHistoryAlarmsTableModelListener(HistoryAlarmsTableModelListener l) {
        this.m_listeners.remove(l);
    }

    public void addAlarms(boolean forward) {
        theLogger.trace(SrLogCategories.LEGACY, "HistoryAlarmsTableModel: addAlarms - forward=", forward);
        this.notifyLoadingAlarms();
        new HistoryAlarmsFetcher(forward, false).start();
    }

    protected void addAlarms(List alarms) {
        theLogger.trace(SrLogCategories.LEGACY, "add vector of alarms: ");
        for (AlarmNode alarm : alarms) {
            theLogger.trace(SrLogCategories.LEGACY, "adding --- ", alarm.logString());
            this.addAlarm(alarm);
        }
        if (alarms.size() > 0) {
            this.fireTableRowsInserted(0, alarms.size() - 1);
        }
    }

    @Override
    protected void addAlarm(AlarmNode alarm) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add(alarm.getSeverity());
        rowData.add(alarm);
        rowData.add(alarm.getClusterPath());
        String sourceString = null;
        if (alarm.getSourceType() != null) {
            SrTreeNode alarmSource = alarm.getSource();
            StringBuilder sb = new StringBuilder();
            sb.append(alarm.getSourceType());
            if (alarmSource != null) {
                sb.append('-');
                sb.append(alarmSource);
            }
            sourceString = sb.toString();
        }
        AliasObject sourceObj = new AliasObject(sourceString, alarm.getSourceType());
        rowData.add(sourceObj);
        rowData.add(alarm.getText());
        rowData.add(alarm.openedAt());
        rowData.add(alarm.closedAt());
        rowData.add(alarm.getClosedBy());
        this.addAlarmRowQuetly(rowData);
    }

    @Override
    public void alarmChanged(AlarmsEvent event) {
        RemoteObject stub = event.getStub();
        Object alarm = AlarmsManager.getInstance().getAlarmByStub((Alarm)stub);
        if (alarm != null) {
            int alarmCol = this.getColumnIndex(HistoryAlarmsTableHeader.NAME.getColumnName());
            for (int i = 0; i < this.getRowCount(); ++i) {
                Object alarmValue = this.getValueAt(i, alarmCol);
                if (alarmValue == null || !alarmValue.equals(alarm)) continue;
                Date closeAt = ((AlarmNode)alarm).closedAt();
                String closedBy = ((AlarmNode)alarm).getClosedBy();
                int closeAtCol = this.getColumnIndex(HistoryAlarmsTableHeader.CLOSED.getColumnName());
                int closedByCol = this.getColumnIndex(HistoryAlarmsTableHeader.CLOSED_BY.getColumnName());
                this.setValueAt(closeAt, i, closeAtCol);
                this.setValueAt(closedBy, i, closedByCol);
                break;
            }
        }
    }

    public boolean hasNext() {
        return AlarmsManager.getInstance().hasNextHistory();
    }

    public boolean hasPrevious() {
        return AlarmsManager.getInstance().hasPreviousHistory();
    }

    @Override
    public void alarmsDeleted(AlarmsEvent event) {
    }

    @Override
    public void alarmsReadFromServer(AlarmsEvent event) {
    }

    @Override
    public void alarmOpened(AlarmsEvent event) {
    }

    @Override
    public void alarmClosed(AlarmsEvent event) {
    }

    class HistoryAlarmsFetcher
    extends Thread {
        boolean forward = true;
        boolean firstTime;

        public HistoryAlarmsFetcher(boolean forward, boolean firstTime) {
            this.forward = forward;
            this.firstTime = firstTime;
        }

        @Override
        public void run() {
            try {
                int currSize = SrHistoryAlarmsTableModel.this.getRowCount();
                SrHistoryAlarmsTableModel.this.removeAllRows();
                SrHistoryAlarmsTableModel.this.m_historyAlarms = AlarmsManager.getInstance().getHistoryAlarms(this.forward, this.firstTime);
                if (SrHistoryAlarmsTableModel.this.m_historyAlarms.isEmpty()) {
                    theLogger.info(SrLogCategories.HISTORY_ALARMS, "HistoryAlarmsModel: no history alarms found.");
                    SrHistoryAlarmsTableModel.this.notifyAlarmsLoaded();
                    return;
                }
                theLogger.info(SrLogCategories.HISTORY_ALARMS, "HistoryAlarmsModel: got history alarms from Server. index=", SrHistoryAlarmsTableModel.this.m_index);
                if (!this.forward) {
                    SrHistoryAlarmsTableModel.this.m_index -= currSize;
                }
                SrHistoryAlarmsTableModel.this.addAlarms(SrHistoryAlarmsTableModel.this.m_historyAlarms);
                SrHistoryAlarmsTableModel.this.notifyAlarmsLoaded();
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, "Could not read alarms history...");
                SrHistoryAlarmsTableModel.this.notifyConnectionError();
            }
        }
    }
}

