/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.alarm;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.alarm.AlarmNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.alarm.SrAlarmsTableColumns;
import com.sanrad.nms.client.data.alarm.SrAlarmsTableModel;
import com.sanrad.nms.client.event.alarm.AlarmsEvent;
import com.sanrad.nms.client.gui.alarm.CurrentAlarmsTableHeader;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class SrFilteredAlarmsTableModel
extends SrAlarmsTableModel {
    private SrTreeNode[] m_nodes;

    public SrFilteredAlarmsTableModel() {
        super(new SrAlarmsTableColumns());
    }

    public void addNodes(SrTreeNode[] nodes) {
        this.m_nodes = nodes;
        this.initModel();
    }

    @Override
    protected void initModel() {
        if (this.m_nodes == null) {
            return;
        }
        for (int i = 0; i < this.m_nodes.length; ++i) {
            List alarms = AlarmsManager.getInstance().getAllAlarmsForNode(this.m_nodes[i]);
            if (alarms == null) continue;
            for (AlarmNode alarm : alarms) {
                if (this.alreadyInTable(alarm)) continue;
                this.addAlarm(alarm);
            }
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    private boolean belongsToFilter(Object sourceStub) {
        for (int i = 0; i < this.m_nodes.length; ++i) {
            if (this.m_nodes[i].getStub() == null || !this.m_nodes[i].getStub().equals(sourceStub)) continue;
            return true;
        }
        return false;
    }

    protected boolean alreadyInTable(AlarmNode alarm) {
        int size = this.getRowCount();
        int col = this.getColumnIndex(CurrentAlarmsTableHeader.NAME.getColumnName());
        for (int i = 0; i < size; ++i) {
            Object alarmObject = this.getValueAt(i, col);
            if (!alarmObject.equals(alarm)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void alarmOpened(AlarmsEvent event) {
        Object alarmObj;
        GeneralLogicObject source = event.getSourceStub();
        if (this.belongsToFilter(source) && (alarmObj = AlarmsManager.getInstance().getAlarmByStub((Alarm)event.getStub())) != null && !this.alreadyInTable((AlarmNode)alarmObj)) {
            super.alarmOpened(event);
        }
    }

    @Override
    public void alarmsReadFromServer(AlarmsEvent event) {
        Hashtable alarms = AlarmsManager.getInstance().getAllAlarms();
        Enumeration values = alarms.elements();
        while (values.hasMoreElements()) {
            Object obj = values.nextElement();
            try {
                List alms = (List)obj;
                for (int i = 0; i < alms.size(); ++i) {
                    AlarmNode alarm = (AlarmNode)alms.get(i);
                    Object stub = alarm.getSource().getStub();
                    if (!this.belongsToFilter(stub) || this.alreadyInTable(alarm)) continue;
                    this.addAlarm(alarm);
                }
                this.fireTableRowsInserted(0, this.getLastRowIndex());
            }
            catch (ClassCastException cce) {}
        }
    }
}

