/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.alarm;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.alarm.AlarmNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.alarm.SrAlarmsTableColumns;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.alarm.AlarmsEvent;
import com.sanrad.nms.client.event.alarm.AlarmsManagerListener;
import com.sanrad.nms.client.gui.alarm.CurrentAlarmsTableHeader;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.license.LicenseManager;
import com.sanrad.nms.server.license.SrLicenseTreePath;
import com.sanrad.nms.server.logic.dr.DRLogicObject;
import com.sanrad.swing.SrTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class SrAlarmsTableModel
extends SrTableModel
implements AlarmsManagerListener {
    protected static SrLogger theLogger = SrLogger.getLogger();
    private static SrAlarmsTableModel m_instance;

    public static synchronized SrAlarmsTableModel getInstance() {
        if (m_instance == null) {
            m_instance = new SrAlarmsTableModel(new SrAlarmsTableColumns());
        }
        return m_instance;
    }

    protected SrAlarmsTableModel(SrTableColumns cols) {
        super(cols);
        this.initModel();
    }

    protected void initModel() {
        Hashtable alarms = AlarmsManager.getInstance().getAllAlarmsFromServer(false);
        Enumeration elements = alarms.elements();
        while (elements.hasMoreElements()) {
            Object next = elements.nextElement();
            if (!(next instanceof List)) continue;
            List alarmsKey = (List)next;
            for (int i = 0; i < alarmsKey.size(); ++i) {
                this.addAlarm((AlarmNode)alarmsKey.get(i));
            }
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    protected void addAlarm(AlarmNode alarm) {
        SrLicenseTreePath path = new SrLicenseTreePath(SrLicenseTreePath.ALARMS_PATH, alarm.getAlarmType());
        ClusterNode cluster = alarm.getCluster();
        if (!LicenseManager.getInstance().isVisible(path, cluster == null ? null : cluster.getCapability())) {
            return;
        }
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add(alarm.getSeverity());
        rowData.add(alarm);
        String clusterPath = alarm.getClusterPath();
        SrTreeNode source = alarm.getSource();
        if (source.getStub() instanceof DRLogicObject) {
            VSwitchNode vsNode = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(alarm.getVSwitch());
            clusterPath = vsNode != null && vsNode.getParent() != null ? vsNode.getParent().toString() : "----";
        }
        rowData.add(clusterPath);
        rowData.add(alarm.getSource());
        rowData.add(alarm.getText());
        rowData.add(alarm.openedAt());
        rowData.add(new Boolean(alarm.isAcknowledged()));
        rowData.add(alarm.getAcknowledgedBy());
        Date ackAt = alarm.getAcknowledgedAt();
        if (ackAt == null) {
            rowData.add("");
        } else {
            rowData.add(ackAt);
        }
        this.addAlarmRowQuetly(rowData);
    }

    protected void addAlarmRowQuetly(List rowData) {
        this.addRowQuetly(rowData.toArray(), 0);
    }

    public AlarmNode getSelectedAlarm(int index) {
        AlarmNode alarm = null;
        int col = this.getColumnIndex(CurrentAlarmsTableHeader.NAME.getColumnName());
        List<Object> rowData = this.getRow(index);
        if (rowData != null && !rowData.isEmpty()) {
            alarm = (AlarmNode)rowData.get(col);
        }
        return alarm;
    }

    protected int getAlarmObjectColumnIndex() {
        return this.getColumnIndex(CurrentAlarmsTableHeader.NAME.getColumnName());
    }

    @Override
    public void alarmClosed(AlarmsEvent event) {
        RemoteObject alarmStub = event.getStub();
        int nameCol = this.getAlarmObjectColumnIndex();
        for (int i = 0; i < this.m_data.size(); ++i) {
            Object alarmNodeStub;
            Object alarm = this.getValueAt(i, nameCol);
            if (alarm == null || (alarmNodeStub = ((AlarmNode)alarm).getStub()) == null || !alarmNodeStub.equals(alarmStub)) continue;
            this.removeRow(i);
            break;
        }
    }

    @Override
    public void alarmChanged(AlarmsEvent event) {
        Alarm stub = (Alarm)event.getStub();
        Object alarm = AlarmsManager.getInstance().getAlarmByStub(stub);
        if (alarm != null) {
            int ackCol = this.getColumnIndex(CurrentAlarmsTableHeader.ACK.getColumnName());
            int alarmCol = this.getColumnIndex(CurrentAlarmsTableHeader.NAME.getColumnName());
            boolean ack = ((AlarmNode)alarm).isAcknowledged();
            for (int i = 0; i < this.getRowCount(); ++i) {
                Object alarmValue = this.getValueAt(i, alarmCol);
                if (alarmValue == null || !alarmValue.equals(alarm)) continue;
                this.setValueAt(new Boolean(ack), i, ackCol);
                int ackByCol = this.getColumnIndex(CurrentAlarmsTableHeader.ACK_BY.getColumnName());
                String ackBy = ((AlarmNode)alarm).getAcknowledgedBy();
                this.setValueAt(ackBy, i, ackByCol);
                int ackAtCol = this.getColumnIndex(CurrentAlarmsTableHeader.ACK_AT.getColumnName());
                if (ack) {
                    Date ackAt = ((AlarmNode)alarm).getAcknowledgedAt();
                    this.setValueAt(ackAt, i, ackAtCol);
                    break;
                }
                this.setValueAt("", i, ackAtCol);
                break;
            }
        }
    }

    @Override
    public void alarmsDeleted(AlarmsEvent event) {
        this.removeAllRows();
    }

    @Override
    public void alarmsReadFromServer(AlarmsEvent event) {
        Hashtable alarms = AlarmsManager.getInstance().getAllAlarms(event.getClusterNode());
        for (Object obj : alarms.values()) {
            if (!(obj instanceof List)) continue;
            List alms = (List)obj;
            for (int i = 0; i < alms.size(); ++i) {
                this.addAlarm((AlarmNode)alms.get(i));
            }
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    @Override
    public void alarmOpened(AlarmsEvent event) {
        theLogger.trace(SrLogCategories.LEGACY, "Current Alarms Table Model: alarm opened.");
        AlarmNode alarm = (AlarmNode)AlarmsManager.getInstance().getAlarmByStub((Alarm)event.getStub());
        if (alarm != null) {
            this.addAlarm(alarm);
            this.fireTableRowsInserted(0, 0);
        }
    }

    @Override
    public void removeListeners() {
        AlarmsManager.getInstance().removeAlarmListener(this);
    }

    @Override
    public void addListeners() {
        AlarmsManager.getInstance().addAlarmListener(this);
    }
}

