/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.alarm;

import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.alarm.SrAlarmsConfigurationTableColumns;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.gui.alarm.AlarmsConfigurationTableHeader;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.swing.SrTableModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SrAlarmsConfigurationTableModel
extends SrTableModel {
    private HashMap m_originalData = new HashMap();

    public SrAlarmsConfigurationTableModel(ClusterNode aClusterNode) {
        super(new SrAlarmsConfigurationTableColumns(AlarmsConfigurationTableHeader.getColumnNames()));
        this.initModel(aClusterNode);
    }

    public void initModel(ClusterNode aClusterNode) {
        this.removeAllRows();
        List mailEnabledAlarmTypes = AlarmsManager.getInstance().getEmailEnabledAlarmTypes(aClusterNode);
        this.addAllAlarmTypes(mailEnabledAlarmTypes);
    }

    private void addAllAlarmTypes(List mailEnabledAlarmTypes) {
        List types = AlarmsManager.getInstance().getAllAlarmTypes();
        for (int i = 0; i < types.size(); ++i) {
            AlarmType alarmType = (AlarmType)types.get(i);
            boolean mailEnabled = this.isMailEnabled(alarmType, mailEnabledAlarmTypes);
            this.addAlarmType(alarmType, mailEnabled);
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    private boolean isMailEnabled(AlarmType alarmType, List mailEnabledAlarmTypes) {
        for (int i = 0; i < mailEnabledAlarmTypes.size(); ++i) {
            AlarmType type = (AlarmType)mailEnabledAlarmTypes.get(i);
            if (!type.equals(alarmType)) continue;
            return true;
        }
        return false;
    }

    protected void addAlarmType(AlarmType alarmType, boolean mailEnabled) {
        ArrayList<Object> rowData = new ArrayList<Object>(AlarmsConfigurationTableHeader.getColumnNames().size());
        rowData.add(alarmType);
        rowData.add(alarmType.getAlarmId());
        Boolean isMailEnabled = new Boolean(mailEnabled);
        rowData.add(isMailEnabled);
        this.addRowQuetly(rowData.toArray(), -1);
        this.m_originalData.put(alarmType, isMailEnabled);
    }

    public List getChangedMailEnabledAlarmTypes(boolean mailEnabled) {
        ArrayList<Object> mailEnabledVec = new ArrayList<Object>();
        int size = this.getRowCount();
        int mailCol = this.getColumnIndex(AlarmsConfigurationTableHeader.MAIL_TRIGGER.getColumnName());
        int alarmTypeCol = this.getColumnIndex(AlarmsConfigurationTableHeader.ALARM_NAME.getColumnName());
        for (int i = 0; i < size; ++i) {
            Object original;
            Object type = this.getValueAt(i, alarmTypeCol);
            Object mail = this.getValueAt(i, mailCol);
            if (mail.equals(original = this.m_originalData.get(type)) || (Boolean)mail != mailEnabled) continue;
            mailEnabledVec.add(type);
        }
        return mailEnabledVec;
    }

    @Override
    public void removeListeners() {
    }

    @Override
    public void addListeners() {
    }
}

