/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.alarm;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.Communication;
import com.sanrad.nms.client.comm.CommunicationEventService;
import com.sanrad.nms.client.data.LUNode;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.ObjectStatus;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.StubToReference;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.VSwitchGroupNode;
import com.sanrad.nms.client.data.alarm.AlarmNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.dr.ConsistencyGroupNode;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.ExtendedPairNode;
import com.sanrad.nms.client.data.identity.IdentityNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetNode;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.data.srv.ExternalServerNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.volume.VolumeNode;
import com.sanrad.nms.client.data.volume.VolumeTreeNode;
import com.sanrad.nms.client.data.vswitch.Neighbor;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionEvent;
import com.sanrad.nms.client.event.alarm.AlarmSourceSelectionListener;
import com.sanrad.nms.client.event.alarm.AlarmsEvent;
import com.sanrad.nms.client.event.alarm.AlarmsListener;
import com.sanrad.nms.client.event.alarm.AlarmsManagerListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmHistoryIterator;
import com.sanrad.nms.server.alarm.AlarmMgr;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.dr.DRLogicObject;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.types.constants.DrSiteConstant;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class AlarmsManager
extends Manager
implements AlarmsListener {
    private static SrLogger theLogger = SrLogger.getLogger();
    public static String DISK_IS_MISSING = AlarmType.DISK_IS_MISSING.toString();
    private static String DISK_IS_INVALID = AlarmType.DISK_IS_INVALID.toString();
    private static String NEIGHBOR_IS_DEAD = AlarmType.NEIGH_DEAD.toString();
    public static String VSWITCH_DISCONNECTED = AlarmType.VSWITCH_DISCONNECTED.toString();
    public static String VOLUME_NEED_SYNC = AlarmType.VOLUME_NEED_SYNC.toString();
    public static String VOLUME_NON_FUNC = AlarmType.VOLUME_NON_FUNC.toString();
    public static String OBJECT_NOT_REDUNDANT = AlarmType.OBJ_NOT_REDUNDANT.toString();
    public static String VOLUME_ILLEGAL = AlarmType.VOLUME_ILLEGAL.toString();
    public static String VOLUME_INCONSISTANT = AlarmType.VOLUME_INCONSISTENT.toString();
    private static AlarmsManager instance = null;
    private Hashtable allLists = new Hashtable();
    private Hashtable allStubs = new Hashtable();
    private AlarmHistoryIterator historyIterator = null;
    private HashMap troubleShotingAlarms;
    SrEventListenerManager.Informer siteSelectedInformer = new SrEventListenerManager.Informer<AlarmSourceSelectionListener, AlarmSourceSelectionEvent>(){

        @Override
        public void inform(AlarmSourceSelectionListener listener, AlarmSourceSelectionEvent event) {
            listener.siteSelected(event);
        }
    };
    SrEventListenerManager.Informer clusterSelectedInformer = new SrEventListenerManager.Informer<AlarmSourceSelectionListener, AlarmSourceSelectionEvent>(){

        @Override
        public void inform(AlarmSourceSelectionListener listener, AlarmSourceSelectionEvent event) {
            listener.clusterSelected(event);
        }
    };
    SrEventListenerManager.Informer vswitchSelectedInformer = new SrEventListenerManager.Informer<AlarmSourceSelectionListener, AlarmSourceSelectionEvent>(){

        @Override
        public void inform(AlarmSourceSelectionListener listener, AlarmSourceSelectionEvent event) {
            listener.vswitchSelected(event);
        }
    };
    SrEventListenerManager.Informer targetSelectedInformer = new SrEventListenerManager.Informer<AlarmSourceSelectionListener, AlarmSourceSelectionEvent>(){

        @Override
        public void inform(AlarmSourceSelectionListener listener, AlarmSourceSelectionEvent event) {
            listener.targetSelected(event);
        }
    };
    SrEventListenerManager.Informer luSelectedInformer = new SrEventListenerManager.Informer<AlarmSourceSelectionListener, AlarmSourceSelectionEvent>(){

        @Override
        public void inform(AlarmSourceSelectionListener listener, AlarmSourceSelectionEvent event) {
            listener.luSelected(event);
        }
    };
    SrEventListenerManager.Informer volumeSelectedInformer = new SrEventListenerManager.Informer<AlarmSourceSelectionListener, AlarmSourceSelectionEvent>(){

        @Override
        public void inform(AlarmSourceSelectionListener listener, AlarmSourceSelectionEvent event) {
            listener.volumeSelected(event);
        }
    };
    SrEventListenerManager.Informer subDirectAccessDeviceSelectedInformer = new SrEventListenerManager.Informer<AlarmSourceSelectionListener, AlarmSourceSelectionEvent>(){

        @Override
        public void inform(AlarmSourceSelectionListener listener, AlarmSourceSelectionEvent event) {
            listener.subDirectAccessDeviceSelected(event);
        }
    };
    SrEventListenerManager.Informer directAccessDeviceSelectedInformer = new SrEventListenerManager.Informer<AlarmSourceSelectionListener, AlarmSourceSelectionEvent>(){

        @Override
        public void inform(AlarmSourceSelectionListener listener, AlarmSourceSelectionEvent event) {
            listener.directAccessDeviceSelected(event);
        }
    };
    SrEventListenerManager.Informer neighborSelectedInformer = new SrEventListenerManager.Informer<AlarmSourceSelectionListener, AlarmSourceSelectionEvent>(){

        @Override
        public void inform(AlarmSourceSelectionListener listener, AlarmSourceSelectionEvent event) {
            listener.neighborSelected(event);
        }
    };
    SrEventListenerManager.Informer identitySelectedInformer = new SrEventListenerManager.Informer<AlarmSourceSelectionListener, AlarmSourceSelectionEvent>(){

        @Override
        public void inform(AlarmSourceSelectionListener listener, AlarmSourceSelectionEvent event) {
            listener.identitySelected(event);
        }
    };
    SrEventListenerManager.Informer externalServerSelectedInformer = new SrEventListenerManager.Informer<AlarmSourceSelectionListener, AlarmSourceSelectionEvent>(){

        @Override
        public void inform(AlarmSourceSelectionListener listener, AlarmSourceSelectionEvent event) {
            listener.externalServerSelected(event);
        }
    };
    SrEventListenerManager.Informer remoteTargetSelectedInformer = new SrEventListenerManager.Informer<AlarmSourceSelectionListener, AlarmSourceSelectionEvent>(){

        @Override
        public void inform(AlarmSourceSelectionListener listener, AlarmSourceSelectionEvent event) {
            listener.remoteTargetSelected(event);
        }
    };
    SrEventListenerManager.Informer drPairSelectedInformer = new SrEventListenerManager.Informer<AlarmSourceSelectionListener, AlarmSourceSelectionEvent>(){

        @Override
        public void inform(AlarmSourceSelectionListener listener, AlarmSourceSelectionEvent event) {
            listener.drPairSelected(event);
        }
    };
    SrEventListenerManager.Informer consistencyGroupSelectedInformer = new SrEventListenerManager.Informer<AlarmSourceSelectionListener, AlarmSourceSelectionEvent>(){

        @Override
        public void inform(AlarmSourceSelectionListener listener, AlarmSourceSelectionEvent event) {
            listener.consistencyGroupSelected(event);
        }
    };
    SrEventListenerManager.Informer extendedPairSelectedInformer = new SrEventListenerManager.Informer<AlarmSourceSelectionListener, AlarmSourceSelectionEvent>(){

        @Override
        public void inform(AlarmSourceSelectionListener listener, AlarmSourceSelectionEvent event) {
            listener.extendedPairSelected(event);
        }
    };
    SrEventListenerManager.Informer alarmsReadFromServerInformer = new SrEventListenerManager.Informer<AlarmsManagerListener, AlarmsEvent>(){

        @Override
        public void inform(AlarmsManagerListener listener, AlarmsEvent event) {
            listener.alarmsReadFromServer(event);
        }
    };
    SrEventListenerManager.Informer alarmOpenedInformer = new SrEventListenerManager.Informer<AlarmsManagerListener, AlarmsEvent>(){

        @Override
        public void inform(AlarmsManagerListener listener, AlarmsEvent event) {
            listener.alarmOpened(event);
        }
    };
    SrEventListenerManager.Informer alarmChangedInformer = new SrEventListenerManager.Informer<AlarmsManagerListener, AlarmsEvent>(){

        @Override
        public void inform(AlarmsManagerListener listener, AlarmsEvent event) {
            listener.alarmChanged(event);
        }
    };
    SrEventListenerManager.Informer alarmClosedInformer = new SrEventListenerManager.Informer<AlarmsManagerListener, AlarmsEvent>(){

        @Override
        public void inform(AlarmsManagerListener listener, AlarmsEvent event) {
            listener.alarmClosed(event);
        }
    };
    SrEventListenerManager.Informer alarmsDeletedInformer = new SrEventListenerManager.Informer<AlarmsManagerListener, AlarmsEvent>(){

        @Override
        public void inform(AlarmsManagerListener listener, AlarmsEvent event) {
            listener.alarmsDeleted(event);
        }
    };

    private AlarmsManager() {
        CommunicationEventService.getInstance().addAlarmsListener(this);
        try {
            this.troubleShotingAlarms = Communication.getInstance().getAlarmManager().getTroubleShootingMap();
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
        }
    }

    public static synchronized AlarmsManager getInstance() {
        if (instance == null) {
            instance = new AlarmsManager();
        }
        return instance;
    }

    public void addAlarmSourceSelectionListener(AlarmSourceSelectionListener l) {
        this.m_listeners.add(l);
    }

    public void removeAlarmSourceSelectionListener(AlarmSourceSelectionListener l) {
        this.m_listeners.remove(l);
    }

    public void notifySourceSelected(AlarmNode selectedAlarm, SrTreeNode node) {
        AlarmSourceSelectionEvent event = new AlarmSourceSelectionEvent(this, selectedAlarm, node);
        if (node instanceof SiteNode) {
            this.m_listeners.fireEvent(AlarmSourceSelectionListener.class, event, this.siteSelectedInformer);
            return;
        }
        if (node instanceof ClusterNode) {
            this.m_listeners.fireEvent(AlarmSourceSelectionListener.class, event, this.clusterSelectedInformer);
            return;
        }
        if (node instanceof VSwitchNode) {
            this.m_listeners.fireEvent(AlarmSourceSelectionListener.class, event, this.vswitchSelectedInformer);
            return;
        }
        if (node instanceof TargetNode) {
            this.m_listeners.fireEvent(AlarmSourceSelectionListener.class, event, this.targetSelectedInformer);
            return;
        }
        if (node instanceof LUNode) {
            this.m_listeners.fireEvent(AlarmSourceSelectionListener.class, event, this.luSelectedInformer);
            return;
        }
        if (node instanceof VolumeNode) {
            this.m_listeners.fireEvent(AlarmSourceSelectionListener.class, event, this.volumeSelectedInformer);
            return;
        }
        if (node instanceof SubDirectAccessDeviceNode) {
            this.m_listeners.fireEvent(AlarmSourceSelectionListener.class, event, this.subDirectAccessDeviceSelectedInformer);
            return;
        }
        if (node instanceof DirectAccessDeviceNode) {
            this.m_listeners.fireEvent(AlarmSourceSelectionListener.class, event, this.directAccessDeviceSelectedInformer);
            return;
        }
        if (node instanceof Neighbor) {
            this.m_listeners.fireEvent(AlarmSourceSelectionListener.class, event, this.neighborSelectedInformer);
            return;
        }
        if (node instanceof IdentityNode) {
            this.m_listeners.fireEvent(AlarmSourceSelectionListener.class, event, this.identitySelectedInformer);
            return;
        }
        if (node instanceof ExternalServerNode) {
            this.m_listeners.fireEvent(AlarmSourceSelectionListener.class, event, this.externalServerSelectedInformer);
            return;
        }
        if (node instanceof SrISCSIRemoteTargetNode) {
            this.m_listeners.fireEvent(AlarmSourceSelectionListener.class, event, this.remoteTargetSelectedInformer);
            return;
        }
        if (node instanceof DRPairNode) {
            this.m_listeners.fireEvent(AlarmSourceSelectionListener.class, event, this.drPairSelectedInformer);
            return;
        }
        if (node instanceof ConsistencyGroupNode) {
            this.m_listeners.fireEvent(AlarmSourceSelectionListener.class, event, this.consistencyGroupSelectedInformer);
            return;
        }
        if (node instanceof ExtendedPairNode) {
            this.m_listeners.fireEvent(AlarmSourceSelectionListener.class, event, this.extendedPairSelectedInformer);
            return;
        }
    }

    public void addAlarmListener(AlarmsManagerListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeAlarmListener(AlarmsManagerListener listener) {
        this.m_listeners.remove(listener);
    }

    protected synchronized AlarmNode createAlarm(AlarmsEvent event) throws RemoteException {
        Alarm stub = (Alarm)event.getStub();
        HashMap params = event.getParameters();
        GeneralLogicObject sourceStub = event.getSourceStub();
        SrTreeNode sourceNode = SystemRootNode.getInstance().getRefByStub(sourceStub);
        Object message = params.get(ClientParameterCode.ALARM_MESSAGE);
        if (sourceNode == null) {
            theLogger.trace(SrLogCategories.LEGACY, "THE SOURCE IS NULL !!!!! Message: ", message);
            theLogger.trace(SrLogCategories.LEGACY, "============================================");
            return null;
        }
        theLogger.trace(SrLogCategories.LEGACY, "AlarmManager: createAlarm() - the source is: ", sourceNode);
        theLogger.trace(SrLogCategories.LEGACY, "AlarmManager: createAlarm() - the message is: ", message);
        Object dateAndTime = params.get(ClientParameterCode.ALARM_DATE_AND_TIME);
        theLogger.trace(SrLogCategories.LEGACY, "AlarmManager: createAlarm() - the dateAndTime is: ", dateAndTime);
        Date date = new Date((Long)dateAndTime);
        Object severity = params.get(ClientParameterCode.ALARM_SEVERITY);
        Object type = params.get(ClientParameterCode.ALARM_TYPE);
        String name = ((AlarmType)type).toString();
        String category = ((AlarmType)type).getCategory();
        String probableCause = ((AlarmType)type).getProbableCause();
        String alarmId = ((AlarmType)type).getAlarmId();
        VSwitch vSwitch = (VSwitch)params.get(ClientParameterCode.ALARM_VSWITCH);
        AlarmNode alarm = new AlarmNode(stub, stub.hashKey(), (AlarmType)type, sourceNode, date, AlarmsManager.getSeverity((AlarmSeverity)severity), message.toString(), vSwitch);
        List alarms = this.getAlarms(sourceNode);
        if (alarms == null) {
            ArrayList<AlarmNode> vAlarms = new ArrayList<AlarmNode>();
            vAlarms.add(alarm);
            this.addAlarm(sourceNode, vAlarms);
        } else {
            alarms.add(alarm);
        }
        theLogger.trace(SrLogCategories.LEGACY, "created : ", alarm.logString());
        theLogger.logAndAssert(SrLogCategories.ERROR, stub.equals(Manager.getStubByRef(alarm)), new Object[]{"Stub is not in the map, reference=", alarm});
        return alarm;
    }

    public List getAllAlarmsForNode(SrTreeNode node) {
        List alarms = this.getAlarms(node);
        return alarms;
    }

    public Object getAlarmByStub(Alarm stub) {
        StubToReference stubToRef = null;
        try {
            Integer vsGroupID = stub.getVSwitchGroupId();
            if (vsGroupID == null) {
                vsGroupID = DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue();
            }
            if ((stubToRef = this.getStubToRef(vsGroupID)) == null) {
                return null;
            }
            return stubToRef.get(stub);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            return null;
        }
    }

    public List<AlarmNode> getHistoryAlarms(boolean forward, boolean firstTime) throws RemoteException {
        if (firstTime) {
            this.historyIterator = this.validateHistoryIterator();
        }
        theLogger.info(SrLogCategories.HISTORY_ALARMS, "AlarmsManager: getHistoryAlarms() - forward=", forward);
        ArrayList<AlarmNode> historyAlarms = new ArrayList<AlarmNode>();
        List<HashMap<ClientParameterCode, Object>> alarmList = null;
        if (forward) {
            if (!this.historyIterator.hasNext()) {
                theLogger.info(SrLogCategories.HISTORY_ALARMS, "AlarmsManager:: server has no NEXT alarms");
                return historyAlarms;
            }
            alarmList = this.historyIterator.next();
        } else {
            if (!this.historyIterator.hasPrevious()) {
                theLogger.info(SrLogCategories.HISTORY_ALARMS, "AlarmsManager:: server has no PREVIOUS alarms");
                return historyAlarms;
            }
            alarmList = this.historyIterator.previous();
        }
        if (alarmList == null) {
            return historyAlarms;
        }
        for (HashMap<ClientParameterCode, Object> curMap : alarmList) {
            AlarmType alarmType = (AlarmType)curMap.get(ClientParameterCode.ALARM_TYPE);
            String closedBy = (String)curMap.get(ClientParameterCode.ALARM_CLOSED_BY);
            Long openedDate = (Long)curMap.get(ClientParameterCode.ALARM_DATE_AND_TIME);
            String msg = (String)curMap.get(ClientParameterCode.ALARM_MESSAGE);
            AlarmSeverity severity = (AlarmSeverity)curMap.get(ClientParameterCode.ALARM_SEVERITY);
            Object sourceType = curMap.get(ClientParameterCode.ALARM_SOURCE_TYPE);
            Object cluster = curMap.get(ClientParameterCode.ALARM_SOURCE_CLUSTER);
            Long closedDate = (Long)curMap.get(ClientParameterCode.ALARM_CLOSED_DATE_AND_TIME);
            long closedDateVal = Calendar.getInstance().getTimeInMillis();
            if (closedDate != null) {
                closedDateVal = closedDate;
            }
            AlarmNode alarm = new AlarmNode(null, "HistoryAlarmNode", alarmType, sourceType, null, new Date(openedDate), new Date(closedDateVal), closedBy, AlarmsManager.getSeverity(severity), msg, null, cluster);
            historyAlarms.add(alarm);
        }
        return historyAlarms;
    }

    public boolean hasNextHistory() {
        try {
            boolean has = this.historyIterator.hasNext();
            theLogger.info(SrLogCategories.HISTORY_ALARMS, "AlarmsManager: hasNextHistory is " + has);
            return has;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
            return false;
        }
    }

    public boolean hasPreviousHistory() {
        try {
            boolean has = this.historyIterator.hasPrevious();
            theLogger.info(SrLogCategories.HISTORY_ALARMS, "AlarmsManager: hasPrevious is " + has);
            return has;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
            return false;
        }
    }

    private AlarmHistoryIterator validateHistoryIterator() {
        try {
            this.historyIterator = Communication.getInstance().getAlarmManager().getAlarmHistoryIterator();
            theLogger.info(SrLogCategories.HISTORY_ALARMS, "An alarm iterator was created.");
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.HISTORY_ALARMS, re, new Object[0]);
        }
        return this.historyIterator;
    }

    private void setAllAlarmsFromServer(Hashtable alarmsTable, boolean brodcast) {
        Enumeration allAlarms = alarmsTable.keys();
        while (allAlarms.hasMoreElements()) {
            RemoteObject key = (RemoteObject)allAlarms.nextElement();
            List alarms = (List)alarmsTable.get(key);
            SrTreeNode source = SystemRootNode.getInstance().getRefByStub(key);
            if (source == null) continue;
            List alarmsForNode = this.createAlarms(alarms, source);
            this.addAlarm(source, alarmsForNode);
        }
    }

    public Hashtable getAllAlarmsFromServer(ClusterNode clusterNode, boolean brodcast) {
        try {
            Hashtable<GeneralLogicObject, List<Alarm>> alarmsTable;
            AlarmMgr alarmMgr = Communication.getInstance().getAlarmManager();
            AlarmMgr DrAlarmMgr = Communication.getInstance().getDrAlarmManager();
            if (clusterNode != null) {
                alarmsTable = alarmMgr.getAllAlarms(clusterNode.getVSwitchGroupId());
            } else {
                alarmsTable = alarmMgr.getAllAlarms();
                Hashtable<GeneralLogicObject, List<Alarm>> map = DrAlarmMgr.getAllAlarms();
                alarmsTable.putAll(map);
            }
            this.setAllAlarmsFromServer(alarmsTable, brodcast);
            if (brodcast) {
                AlarmsEvent event = new AlarmsEvent((Object)this, clusterNode);
                this.m_listeners.fireEvent(AlarmsManagerListener.class, event, this.alarmsReadFromServerInformer);
            }
            return this.getAllAlarms(clusterNode);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, "Failed to get All alarms from server.");
            return null;
        }
    }

    public void getAllDrAlarmsFromServer(boolean brodcast) {
        try {
            AlarmMgr DrAlarmMgr = Communication.getInstance().getDrAlarmManager();
            Hashtable<GeneralLogicObject, List<Alarm>> alarmsTable = DrAlarmMgr.getAllAlarms();
            this.setAllAlarmsFromServer(alarmsTable, brodcast);
            if (brodcast) {
                for (List<Alarm> alarms : alarmsTable.values()) {
                    int j = alarms.size();
                    while (j-- > 0) {
                        AlarmsEvent event = new AlarmsEvent(this, alarms.get(j), null, null){

                            @Override
                            public ClusterNode getClusterNode() {
                                return this.clusterNode;
                            }
                        };
                        this.m_listeners.fireEvent(AlarmsManagerListener.class, event, this.alarmOpenedInformer);
                    }
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, "Failed to get All alarms from server.");
        }
    }

    public List getAllAlarmTypes() {
        try {
            return Communication.getInstance().getAlarmManager().getAllAlarmTypes();
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            AlarmsManager.onConnectionError(re.getMessage());
            return new ArrayList(0);
        }
    }

    public List getEmailEnabledAlarmTypes(ClusterNode clusterNode) {
        try {
            return Communication.getInstance().getAlarmManager().getEmailEnabledAlarmTypes();
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            AlarmsManager.onConnectionError(re.getMessage());
            return new ArrayList(0);
        }
    }

    public SrFuture<Void> setEmailContactParameters(ClusterNode clusterNode, HashMap params) {
        return ClientAOImpl.getInstance().setEmailContactParameters(params);
    }

    public HashMap getEmailContactParameters(ClusterNode clusterNode) {
        try {
            HashMap result = new HashMap(Communication.getInstance().getAlarmManager().getEmailContactParameters());
            result.putAll(Communication.getInstance().getDrAlarmManager().getEmailContactParameters());
            return result;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            AlarmsManager.onConnectionError();
            return null;
        }
    }

    public Hashtable getAllAlarmsFromServer(boolean brodcast) {
        if (!this.allLists.isEmpty()) {
            return this.getAllAlarms();
        }
        return this.getAllAlarmsFromServer(null, brodcast);
    }

    private Hashtable getAllAlarms(Integer vSwitchGroupId) {
        Hashtable list = this.getAlarmsList(vSwitchGroupId);
        return list;
    }

    public Hashtable getAllAlarms(VSwitchGroupNode vSwitchGroupNode) {
        if (vSwitchGroupNode != null) {
            return this.getAlarmsList(vSwitchGroupNode.getVSwitchGroupId());
        }
        return this.getAllAlarms();
    }

    public Hashtable getAllAlarms() {
        Hashtable all = new Hashtable();
        Enumeration e = this.allLists.keys();
        while (e.hasMoreElements()) {
            Hashtable list = this.getAllAlarms((Integer)e.nextElement());
            all.putAll(list);
        }
        return all;
    }

    public int getTotalAlarmsCount() {
        int count = 0;
        Iterator index1 = this.allLists.keySet().iterator();
        while (index1.hasNext()) {
            Hashtable sourceMap = (Hashtable)this.allLists.get(index1.next());
            Iterator index2 = sourceMap.keySet().iterator();
            while (index2.hasNext()) {
                List alarmList = (List)sourceMap.get(index2.next());
                count += alarmList.size();
            }
        }
        return count;
    }

    public String getAlarmTroubleshooting(String alarmId) {
        return (String)this.troubleShotingAlarms.get(alarmId);
    }

    private List createAlarms(List alarms, SrTreeNode source) {
        ArrayList<AlarmNode> al = new ArrayList<AlarmNode>();
        try {
            for (int i = 0; i < alarms.size(); ++i) {
                Alarm alarmStub;
                Alarm stub = alarmStub = (Alarm)alarms.get(i);
                String category = stub.getCategory();
                String cause = stub.getProbableCause();
                AlarmType type = stub.getType();
                ObjectStatus severity = AlarmsManager.getSeverity(stub.getType().getSeverity());
                long time = stub.getDateAndTime();
                Date date = new Date(time);
                String message = stub.getMessage();
                VSwitch vSwitch = stub.getVSwitch();
                String alarmId = stub.getType().getAlarmId();
                theLogger.trace(SrLogCategories.LEGACY, "Read Alarm: ", type, " ", message);
                AlarmNode alarm = new AlarmNode(alarmStub, alarmStub.hashKey(), type, source, date, severity, message, vSwitch);
                boolean acknowledged = stub.isAcknowledged();
                if (acknowledged) {
                    alarm.setAcknowledged(acknowledged);
                    String ackBy = stub.getAcknowledgedBy();
                    Date ackAt = new Date(stub.getAckDateAndTime());
                    alarm.setAcknowledgedAt(ackAt);
                    alarm.setAcknowledgedBy(ackBy);
                }
                theLogger.trace(SrLogCategories.LEGACY, "Read Alarm: ", alarm.logString());
                al.add(alarm);
                this.addAlarmStub(alarmStub, alarm);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, "Failed to create client Alarm.");
        }
        return al;
    }

    public List getDependenciesFor(SrTreeNode node) {
        ArrayList<SrTreeNode> all = new ArrayList<SrTreeNode>();
        Object stub = node.getStub();
        Vector<? extends GeneralLogicObject> dependentElements = null;
        try {
            dependentElements = ((GeneralLogicObject)stub).getPropagationStateDependent();
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, "Failed to get all dependencies from server.");
            return all;
        }
        for (Object e : dependentElements) {
            SrTreeNode dependent = SystemRootNode.getInstance().getRefByStub((RemoteObject)e);
            if (dependent == null) continue;
            all.add(dependent);
        }
        all.add(node);
        return all;
    }

    public SrFuture<Void> closeAlarms(List<String> toClose) {
        return ClientAOImpl.getInstance().silentAlarms(toClose);
    }

    public SrFuture<Void> configureAlarmTypes(ClusterNode clusterNode, List mailEnabled, List mailDisabled) {
        return ClientAOImpl.getInstance().setEmailEnabledAlarmTypes(mailEnabled, mailDisabled);
    }

    public void clearAllAlarms(ClusterNode clusterNode) {
        this.clearAllAlarms(clusterNode.getVSwitchGroupId());
    }

    public void clearAllAlarms(Integer vSwitchGroupId) {
        this.clearAllAlarms(vSwitchGroupId, true);
    }

    public void clearAllAlarms(Integer vSwitchGroupId, boolean broadcast) {
        Hashtable list = this.getAlarmsList(vSwitchGroupId);
        ArrayList<AlarmsEvent> removedAlarmEvents = new ArrayList<AlarmsEvent>();
        Enumeration e = list.keys();
        while (e.hasMoreElements()) {
            List alarms = (List)list.get(e.nextElement());
            for (AlarmNode alarm : alarms) {
                this.removeAlarmStub((String)alarm.getIdentifier());
                if (!broadcast) continue;
                AlarmsEvent event = new AlarmsEvent(this, (Alarm)alarm.getStub(), null, (GeneralLogicObject)alarm.getSource().getStub());
                removedAlarmEvents.add(event);
            }
        }
        list.clear();
        StubToReference stubToRef = this.getStubToRef(vSwitchGroupId);
        stubToRef.clear();
        Iterator i = removedAlarmEvents.iterator();
        while (i.hasNext()) {
            this.fireAlarmClosed((AlarmsEvent)i.next());
        }
    }

    private void removeAlarmStub(String aID) {
        for (Object curObj : this.allStubs.values()) {
            StubToReference curRefMap = (StubToReference)curObj;
            curRefMap.remove(aID);
        }
    }

    public void clearAllAlarms() {
        theLogger.trace(SrLogCategories.LEGACY, "Alarms Manager: deleting all the alarms in the table.");
        Enumeration e = this.allLists.keys();
        while (e.hasMoreElements()) {
            this.clearAllAlarms((Integer)e.nextElement(), false);
        }
        this.clearAllAlarms(null, false);
        AlarmsEvent event = new AlarmsEvent(this, null, null, null);
        this.m_listeners.fireEvent(AlarmsManagerListener.class, event, this.alarmsDeletedInformer);
    }

    public boolean isLegitimateForVolumeCreation(Collection<VolumeTreeNode> nodes) {
        for (VolumeTreeNode node : nodes) {
            if (this.isLegitimateForVolumeCreation(node)) continue;
            return false;
        }
        return true;
    }

    public boolean hasConfiguredAlarmOnly(StorageDeviceNode disk) {
        return false;
    }

    public boolean isRemovableDisk(StorageDeviceNode disk) {
        return this.isMissingInvalidOrConfiguredDisk(disk);
    }

    public boolean isMissingInvalidOrConfiguredDisk(StorageDeviceNode disk) {
        ArrayList<AlarmNode> alarmsFromVSwitch1 = new ArrayList<AlarmNode>();
        ArrayList<AlarmNode> alarmsFromVSwitch2 = new ArrayList<AlarmNode>();
        List alarmsList = this.getAlarms(disk);
        if (alarmsList != null) {
            for (int i = 0; i < alarmsList.size(); ++i) {
                AlarmNode alarm = (AlarmNode)alarmsList.get(i);
                VSwitchNode vswitchNode = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(alarm.getVSwitch());
                if (alarmsFromVSwitch1.size() > 0) {
                    AlarmNode a = (AlarmNode)alarmsFromVSwitch1.get(0);
                    VSwitchNode vswitchNodeOfa = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(a.getVSwitch());
                    if (vswitchNodeOfa == null || vswitchNode == null) continue;
                    if (vswitchNodeOfa.getName().equals(vswitchNode.getName())) {
                        alarmsFromVSwitch1.add(alarm);
                        continue;
                    }
                    alarmsFromVSwitch2.add(alarm);
                    continue;
                }
                if (alarmsFromVSwitch1.size() != 0 || alarm.getVSwitch() == null) continue;
                alarmsFromVSwitch1.add(alarm);
            }
            boolean isMissingInVSwitch1 = this.isAlarmIncludedInList(alarmsFromVSwitch1, DISK_IS_MISSING);
            boolean isInvalidInVSwitch1 = this.isAlarmIncludedInList(alarmsFromVSwitch1, DISK_IS_INVALID);
            if (alarmsFromVSwitch2.size() > 0) {
                boolean isMissingInVSwitch2 = this.isAlarmIncludedInList(alarmsFromVSwitch2, DISK_IS_MISSING);
                boolean isInvalidInVSwitch2 = this.isAlarmIncludedInList(alarmsFromVSwitch2, DISK_IS_INVALID);
                return isMissingInVSwitch1 && isMissingInVSwitch2 || isInvalidInVSwitch1 && isInvalidInVSwitch2 || isMissingInVSwitch1 && isInvalidInVSwitch2 || isInvalidInVSwitch1 && isMissingInVSwitch2;
            }
            return isMissingInVSwitch1 || isInvalidInVSwitch1;
        }
        return false;
    }

    public boolean isAlarmIncludedInList(List vectOfAlarms, String alarmName) {
        for (int i = 0; i < vectOfAlarms.size(); ++i) {
            AlarmNode alarm = (AlarmNode)vectOfAlarms.get(i);
            if (!alarm.getName().equalsIgnoreCase(alarmName)) continue;
            return true;
        }
        return false;
    }

    public boolean isRemovableVSwitch(VSwitchNode vswitch) {
        List<Neighbor> nbrs = vswitch.getNeighbors();
        Neighbor neighbor = null;
        if (nbrs != null) {
            for (int j = 0; j < nbrs.size(); ++j) {
                neighbor = nbrs.get(j);
                List alarmsVector = this.getAlarms(neighbor);
                if (alarmsVector == null) continue;
                for (int i = 0; i < alarmsVector.size(); ++i) {
                    AlarmNode alarm = (AlarmNode)alarmsVector.get(i);
                    if (!alarm.getName().equalsIgnoreCase(NEIGHBOR_IS_DEAD)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isLegitimateForVolumeCreation(SrTreeNode node) {
        if (!(node instanceof DirectAccessDeviceNode)) {
            return true;
        }
        DirectAccessDeviceNode diskNode = (DirectAccessDeviceNode)node;
        if (diskNode instanceof SubDirectAccessDeviceNode) {
            if (((SubDirectAccessDeviceNode)diskNode).isExposed()) {
                return false;
            }
            TreeNode parent = diskNode.getParent();
            if (parent == null || !(parent instanceof SrTreeNode)) {
                DirectAccessDeviceNode parentDisk = ((SubDirectAccessDeviceNode)diskNode).getDirectAccessDeviceParent();
                return this.isLegitimateForVolumeCreation(parentDisk);
            }
            return false;
        }
        return true;
    }

    private ClusterNode getClusterNode(AlarmsEvent event) {
        ClusterNode source = SystemRootNode.getInstance().getClusterNodeOfStub(event.getSourceStub());
        return this.getClusterNode(source);
    }

    private ClusterNode getClusterNode(SrTreeNode source) {
        return SystemRootNode.getInstance().getClusterNodeOfSource(source);
    }

    private void addAlarm(SrTreeNode source, List vAlarms) {
        SrTreeNode node = source;
        Hashtable list = null;
        if (node.getStub() instanceof DRLogicObject) {
            list = this.getAlarmsList(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue());
        } else {
            ClusterNode cluster = this.getClusterNode(source);
            if (cluster == null) {
                theLogger.error(SrLogCategories.ILLEGAL_STATE, "The alarms ", vAlarms, " is being added while in discovery, therefore the cluster node is null.");
                return;
            }
            list = this.getAlarmsList(cluster.getVSwitchGroupId());
        }
        list.put(source, vAlarms);
    }

    private void addAlarmStub(Alarm stubAlarm, AlarmNode alarm) {
        StubToReference stubToRef = null;
        try {
            stubToRef = stubAlarm.getSource() instanceof DRLogicObject ? this.getStubToRef(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue()) : this.getStubToRef(this.getClusterNode(alarm.getSource()));
            stubToRef.put(stubAlarm, alarm);
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
        }
    }

    private List getAlarms(SrTreeNode source) {
        Hashtable list = null;
        if (source != null) {
            if (source.getStub() instanceof Site) {
                return new ArrayList();
            }
            if (source.getStub() instanceof DRLogicObject) {
                list = this.getAlarmsList(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue());
                return (List)list.get(source);
            }
            ClusterNode cluster = this.getClusterNode(source);
            if (cluster != null) {
                list = this.getAlarmsList(cluster.getVSwitchGroupId());
                return (List)list.get(source);
            }
        }
        return new ArrayList();
    }

    public boolean isAlarmExist(Object nodeObject, String alarmName) {
        SrTreeNode node = (SrTreeNode)nodeObject;
        List alarms = this.getAlarms(node);
        if (alarms != null) {
            for (int i = 0; i < alarms.size(); ++i) {
                AlarmNode alarm = (AlarmNode)alarms.get(i);
                if (!alarm.getName().equalsIgnoreCase(alarmName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAllAlarmsSet(Object nodeObject, String[] alarmsToCheck) {
        SrTreeNode node = (SrTreeNode)nodeObject;
        List alarms = this.getAlarms(node);
        if (alarms == null || alarmsToCheck == null) {
            return false;
        }
        for (int j = 0; j < alarmsToCheck.length; ++j) {
            String alarmName = alarmsToCheck[j];
            boolean exist = false;
            for (int i = 0; i < alarms.size(); ++i) {
                AlarmNode currAlarm = (AlarmNode)alarms.get(i);
                if (!currAlarm.getName().equalsIgnoreCase(alarmName)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            return false;
        }
        return true;
    }

    public boolean isOneAlarmsSet(Object nodeObject, String[] alarmsToCheck) {
        SrTreeNode node = (SrTreeNode)nodeObject;
        List alarms = this.getAlarms(node);
        if (alarms == null || alarmsToCheck == null) {
            return false;
        }
        for (int j = 0; j < alarmsToCheck.length; ++j) {
            String alarmName = alarmsToCheck[j];
            for (int i = 0; i < alarms.size(); ++i) {
                AlarmNode currAlarm = (AlarmNode)alarms.get(i);
                if (!currAlarm.getName().equalsIgnoreCase(alarmName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void alarmOpened(AlarmsEvent event) {
        try {
            ClusterNode clusterNode = this.getClusterNode(event);
            if (clusterNode == null || clusterNode.isInDiscoveryProcess()) {
                return;
            }
            theLogger.trace(SrLogCategories.LEGACY, "Alarms Manager: alarm opened.");
            if (this.getAlarmByStub((Alarm)event.getStub()) != null) {
                theLogger.trace(SrLogCategories.LEGACY, "Alarm already exist !!! .");
                return;
            }
            AlarmNode alarm = this.createAlarm(event);
            if (alarm == null) {
                return;
            }
            theLogger.trace(SrLogCategories.LEGACY, "The new Alarm: ", alarm.logString());
            this.addAlarmStub((Alarm)event.getStub(), alarm);
            this.m_listeners.fireEvent(AlarmsManagerListener.class, event, this.alarmOpenedInformer);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.EXCEPTION, re, new Object[0]);
            AlarmsManager.onConnectionError();
        }
    }

    @Override
    public void alarmClosed(AlarmsEvent event) {
        ClusterNode clusterNode = this.getClusterNode(event);
        if (clusterNode != null && clusterNode.isInDiscoveryProcess()) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "Alarms Manager: alarm closed.");
        Object alarm = this.getAlarmByStub((Alarm)event.getStub());
        GeneralLogicObject sourceStub = event.getSourceStub();
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(sourceStub);
        List alarmsVector = this.getAlarms(node);
        if (alarmsVector != null) {
            alarmsVector.remove(alarm);
            this.fireAlarmClosed(event);
            if (alarmsVector.isEmpty()) {
                this.removeAlarmsOnSource(event.getSourceStub());
                Alarm stub = (Alarm)event.getStub();
                try {
                    StubToReference stubToRef = this.getStubToRef(stub.getVSwitchGroupId());
                    stubToRef.remove(stub);
                }
                catch (RemoteException re) {
                    theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                }
            }
        }
        try {
            this.removeAlarmStub(event.getStub().hashKey());
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, "Could not remove the stub " + event.getStub() + " because of a remote exception. This will cause " + "a memory leak in both the client and the server.");
        }
    }

    public void removeAlarmsOnSource(RemoteObject sourceStub) {
        SrTreeNode source = SystemRootNode.getInstance().getRefByStub(sourceStub);
        if (source != null) {
            Hashtable list = null;
            list = sourceStub instanceof DRLogicObject ? this.getAlarmsList(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue()) : this.getAlarmsList(this.getClusterNode(source).getVSwitchGroupId());
            list.remove(source);
        }
    }

    private StubToReference getStubToRef(ClusterNode clusterNode) {
        return this.getStubToRef(clusterNode.getVSwitchGroupId());
    }

    private StubToReference getStubToRef(Integer vSwitchGroupId) {
        StubToReference stubToRef;
        if (vSwitchGroupId == null) {
            vSwitchGroupId = DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue();
        }
        if ((stubToRef = (StubToReference)this.allStubs.get(vSwitchGroupId)) == null) {
            stubToRef = new StubToReference();
            this.allStubs.put(vSwitchGroupId, stubToRef);
        }
        return stubToRef;
    }

    @Deprecated
    public StubToReference getStubToRefForDr() {
        StubToReference stubToRef = (StubToReference)this.allStubs.get(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue());
        if (stubToRef == null) {
            stubToRef = new StubToReference();
            this.allStubs.put(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue(), stubToRef);
        }
        return stubToRef;
    }

    private Hashtable getAlarmsList(Integer vSwitchGroupId) {
        Integer vsGroupID = vSwitchGroupId != null ? vSwitchGroupId : DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue();
        Hashtable list = (Hashtable)this.allLists.get(vsGroupID);
        if (list == null) {
            list = new Hashtable();
            this.allLists.put(vsGroupID, list);
        }
        return list;
    }

    @Override
    public void alarmChanged(AlarmsEvent event) {
        HashMap parameters;
        Object acknowledged;
        ClusterNode clusterNode = this.getClusterNode(event);
        if (clusterNode == null || clusterNode.isInDiscoveryProcess()) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "Alarms Manager: alarm changed.");
        Alarm alarmStub = (Alarm)event.getStub();
        Object alarm = AlarmsManager.getInstance().getAlarmByStub(alarmStub);
        if (alarm != null && (acknowledged = (parameters = event.getParameters()).get(ClientParameterCode.ALARM_ACKNOWLEDGED)) != null) {
            boolean ack = (Boolean)acknowledged;
            ((AlarmNode)alarm).setAcknowledged(ack);
            Object acknowledgedAt = parameters.get(ClientParameterCode.ALARM_ACKNOWLEDGED_AT);
            Object acknowledgedBy = parameters.get(ClientParameterCode.ALARM_ACKNOWLEDGED_BY);
            Date ackAt = new Date((Long)acknowledgedAt);
            String ackBy = (String)acknowledgedBy;
            ((AlarmNode)alarm).setAcknowledgedAt(ackAt);
            ((AlarmNode)alarm).setAcknowledgedBy(ackBy);
            this.m_listeners.fireEvent(AlarmsManagerListener.class, event, this.alarmChangedInformer);
        }
    }

    private void fireAlarmClosed(AlarmsEvent event) {
        this.m_listeners.fireEvent(AlarmsManagerListener.class, event, this.alarmClosedInformer);
    }

    public StubToReference getDrStubToReference() {
        return (StubToReference)this.allStubs.get(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue());
    }
}

