/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.alarm;

import com.sanrad.nms.client.data.ObjectStatus;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.rmi.RemoteException;
import java.util.Date;

public class AlarmNode
extends SrTreeNode<Alarm, String> {
    private SrTreeNode source;
    private ObjectStatus severity;
    private String text;
    private Date openedAt;
    private Date closedAt;
    private String closedBy;
    private boolean ack = false;
    private String ackBy = "";
    private Date ackAt = null;
    private String openedBy;
    private VSwitch vSwitch;
    private Object sourceType;
    private Object cluster = null;
    private AlarmType alarmType;
    private boolean isHistoryAlarm = false;

    public AlarmNode(Alarm stub, String id, AlarmType alarmType, SrTreeNode source, Date openedAt, ObjectStatus severity, String text, VSwitch vSwitch) throws RemoteException {
        super(stub, id);
        this.alarmType = alarmType;
        this.source = source;
        this.openedAt = openedAt;
        this.severity = severity;
        this.text = text;
        this.vSwitch = vSwitch;
        if (source instanceof SrTreeNode) {
            this.cluster = SystemRootNode.getInstance().getClusterNodeOfSource(source);
        }
    }

    public AlarmNode(Alarm stub, String id, AlarmType alarmType, Object sourceType, SrTreeNode source, Date openedAt, Date closedAt, String closedBy, ObjectStatus severity, String text, VSwitch vSwitch, Object cluster) throws RemoteException {
        this(stub, id, alarmType, source, openedAt, severity, text, vSwitch);
        this.closedAt = closedAt;
        this.closedBy = closedBy;
        this.sourceType = sourceType;
        this.cluster = cluster;
    }

    public String getName() {
        return this.alarmType != null ? this.alarmType.toString() : (this.isHistoryAlarm ? "<not defined>" : "");
    }

    public Object getSourceType() {
        return this.sourceType;
    }

    public SrTreeNode getSource() {
        return this.source;
    }

    public ObjectStatus getSeverity() {
        return this.severity;
    }

    public String getText() {
        return this.text;
    }

    public String openedBy() {
        return this.openedBy;
    }

    public Date openedAt() {
        return this.openedAt;
    }

    public Date closedAt() {
        return this.closedAt;
    }

    public String getClosedBy() {
        return this.closedBy;
    }

    public boolean isAcknowledged() {
        return this.ack;
    }

    public void setAcknowledged(boolean ack) {
        this.ack = ack;
    }

    public Date getAcknowledgedAt() {
        return this.ackAt;
    }

    public void setAcknowledgedAt(Date date) {
        this.ackAt = date;
    }

    public String getAcknowledgedBy() {
        return this.ackBy;
    }

    public void setAcknowledgedBy(String ackBy) {
        this.ackBy = ackBy;
    }

    public String getCategory() {
        return this.alarmType != null ? this.alarmType.getCategory() : (this.isHistoryAlarm ? "<not defined>" : "");
    }

    public String getProbableCause() {
        return this.alarmType != null ? this.alarmType.getProbableCause() : (this.isHistoryAlarm ? "<not defined>" : "");
    }

    public VSwitch getVSwitch() {
        return this.vSwitch;
    }

    public String getAlarmId() {
        return this.alarmType != null ? this.alarmType.getAlarmId() : (this.isHistoryAlarm ? "<not defined>" : "");
    }

    public AlarmType getAlarmType() {
        return this.alarmType;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String logString() {
        StringBuffer sb = new StringBuffer("ALARM: ");
        sb.append("[name - ");
        sb.append(this.getName());
        sb.append("][Category-");
        sb.append(this.getCategory());
        sb.append("][severity - ");
        sb.append(this.severity == null ? "<not defined>" : this.severity.toString());
        sb.append("][opened At - ");
        sb.append(this.openedAt.getTime());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String type() {
        return "Alarm";
    }

    public String getClusterPath() {
        return this.cluster != null ? this.cluster.toString() : "";
    }

    public ClusterNode getCluster() {
        VSwitchNode vs = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(this.vSwitch);
        return SystemRootNode.getInstance().getClusterNodeOfSource(vs);
    }
}

